﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/dataexchange/DataExchange_EXPORTS.h>
#include <aws/dataexchange/DataExchangeRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Http
{
    class URI;
} //namespace Http
namespace DataExchange
{
namespace Model
{

  /**
   */
  class AWS_DATAEXCHANGE_API ListEventActionsRequest : public DataExchangeRequest
  {
  public:
    ListEventActionsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "ListEventActions"; }

    Aws::String SerializePayload() const override;

    void AddQueryStringParameters(Aws::Http::URI& uri) const override;


    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline const Aws::String& GetEventSourceId() const{ return m_eventSourceId; }

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline bool EventSourceIdHasBeenSet() const { return m_eventSourceIdHasBeenSet; }

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline void SetEventSourceId(const Aws::String& value) { m_eventSourceIdHasBeenSet = true; m_eventSourceId = value; }

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline void SetEventSourceId(Aws::String&& value) { m_eventSourceIdHasBeenSet = true; m_eventSourceId = std::move(value); }

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline void SetEventSourceId(const char* value) { m_eventSourceIdHasBeenSet = true; m_eventSourceId.assign(value); }

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline ListEventActionsRequest& WithEventSourceId(const Aws::String& value) { SetEventSourceId(value); return *this;}

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline ListEventActionsRequest& WithEventSourceId(Aws::String&& value) { SetEventSourceId(std::move(value)); return *this;}

    /**
     * <p>The unique identifier for the event source.</p>
     */
    inline ListEventActionsRequest& WithEventSourceId(const char* value) { SetEventSourceId(value); return *this;}


    /**
     * <p>The maximum number of results returned by a single call.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }

    /**
     * <p>The maximum number of results returned by a single call.</p>
     */
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }

    /**
     * <p>The maximum number of results returned by a single call.</p>
     */
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }

    /**
     * <p>The maximum number of results returned by a single call.</p>
     */
    inline ListEventActionsRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}


    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline ListEventActionsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline ListEventActionsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token value retrieved from a previous call to access the next page of
     * results.</p>
     */
    inline ListEventActionsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::String m_eventSourceId;
    bool m_eventSourceIdHasBeenSet;

    int m_maxResults;
    bool m_maxResultsHasBeenSet;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet;
  };

} // namespace Model
} // namespace DataExchange
} // namespace Aws
