﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connectcampaigns/model/GetInstanceOnboardingJobStatusResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::ConnectCampaigns::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetInstanceOnboardingJobStatusResult::GetInstanceOnboardingJobStatusResult()
{
}

GetInstanceOnboardingJobStatusResult::GetInstanceOnboardingJobStatusResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

GetInstanceOnboardingJobStatusResult& GetInstanceOnboardingJobStatusResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("connectInstanceOnboardingJobStatus"))
  {
    m_connectInstanceOnboardingJobStatus = jsonValue.GetObject("connectInstanceOnboardingJobStatus");

  }



  return *this;
}
