#!/bin/bash
# This script validates that every files in the install manifest generated by cmake is in an expected location
# We expect to use this script as a validation step in CI for Linux x86_64 platforms.
# This acts also as a driver to make thes list of locations more compact, expect reductions here in the future.

set -e
MANIFEST=install_manifest.txt
TOTAL_FILES=$(wc -l $MANIFEST)
UNEXPECTED_FILES=$( cat $MANIFEST \
                  | grep -v '^/usr/local/include/aws' \
                  | grep -v '^/usr/local/include/s2n.h' \
                  | grep -v '^/usr/local/lib\(64\)\?/cmake' \
                  | grep -v '^/usr/local/lib\(64\)\?/libaws-' \
                  | grep -v '^/usr/local/lib\(64\)\?/pkgconfig/aws-cpp-sdk-' \
                  | grep -v '^/usr/local/lib\(64\)\?/aws-crt-cpp' \
                  | grep -v '^/usr/local/lib\(64\)\?/aws-c' \
                  | grep -v '^/usr/local/lib\(64\)\?/s2n' \
                  | grep -v '^/usr/local/lib\(64\)\?/libs2n' \
                  | grep -v '^/usr/local/lib\(64\)\?/libtesting-resources' \
                  | grep -v '^/usr/local/lib\(64\)\?/pkgconfig/testing-resources.pc' ) \
            || [[ $? == 1 ]] # 1 is grep error code for empty result
if [[ !  -z  $UNEXPECTED_FILES  ]]
then
    TOTAL_UNEXPECTED_FILES=$( echo $UNEXPECTED_FILES | wc -l)
        echo $TOTAL_UNEXPECTED_FILES ' / ' $TOTAL_FILES ' are unexpected to be installed from manifest'
    echo $UNEXPECTED_FILES
    exit 1
fi
