#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
/*
 * ReportConflictingKeys.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// For this test to report properly buggify must be disabled (flow.h) , and failConnection must be disabled in
// (sim2.actor.cpp)
struct ReportConflictingKeysWorkload : TestWorkload {
	static constexpr auto NAME = "ReportConflictingKeys";

	double testDuration, transactionsPerSecond, addReadConflictRangeProb, addWriteConflictRangeProb;
	Key keyPrefix;

	int nodeCount, actorCount, keyBytes, valueBytes, readConflictRangeCount, writeConflictRangeCount;

	PerfIntCounter invalidReports, commits, conflicts, xacts;

	// This workload is not compatible with RandomRangeLock workload because RangeLock transaction triggers conflicts
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	ReportConflictingKeysWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), invalidReports("InvalidReports"), commits("commits"), conflicts("Conflicts"),
	    xacts("Transactions") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		// transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, 1);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, "ReportConflictingKeysWorkload"_sr).toString());
		keyBytes = getOption(options, "keyBytes"_sr, 64);

		readConflictRangeCount = getOption(options, "readConflictRangeCountPerTx"_sr, 1);
		writeConflictRangeCount = getOption(options, "writeConflictRangeCountPerTx"_sr, 1);
		ASSERT(readConflictRangeCount >= 1 && writeConflictRangeCount >= 1);
		// modeled by geometric distribution: (1 - prob) / prob = mean - 1, where we add at least one conflictRange to
		// each tx
		addReadConflictRangeProb = (readConflictRangeCount - 1.0) / readConflictRangeCount;
		addWriteConflictRangeProb = (writeConflictRangeCount - 1.0) / writeConflictRangeCount;
		ASSERT(keyPrefix.size() + 8 <= keyBytes); // make sure the string format is valid
		nodeCount = getOption(options, "nodeCount"_sr, 100);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(const Database& cx) override { return _start(cx->clone(), this); }

																#line 72 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
template <class _startActor>
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
class _startActorState {
															#line 78 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
public:
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	_startActorState(Database const& cx,ReportConflictingKeysWorkload* const& self) 
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		 : cx(cx),
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   self(self)
															#line 87 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->conflictingClient(cx, self), self->testDuration, Void());
															#line 71 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 104 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 109 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 132 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 144 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Database cx;
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	ReportConflictingKeysWorkload* self;
															#line 231 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 236 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16620069951235006208UL, 5988369520076602368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	_startActor(Database const& cx,ReportConflictingKeysWorkload* const& self) 
															#line 253 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ReportConflictingKeysWorkload* const& self ) {
															#line 70 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 285 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
}

#line 74 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"

	Future<bool> check(Database const& cx) override { return invalidReports.getValue() == 0; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Measured Duration", testDuration, Averaged::True);
		m.push_back(xacts.getMetric());
		m.emplace_back("Transactions/sec", xacts.getValue() / testDuration, Averaged::True);
		m.push_back(commits.getMetric());
		m.emplace_back("Commits/sec", commits.getValue() / testDuration, Averaged::True);
		m.push_back(conflicts.getMetric());
		m.emplace_back("Conflicts/sec", conflicts.getValue() / testDuration, Averaged::True);
	}

	// disable the default timeout setting
	double getCheckTimeout() const override { return std::numeric_limits<double>::max(); }

	// Copied from tester.actor.cpp, added parameter to determine the key's length
	Key keyForIndex(int n) {
		double p = (double)n / nodeCount;
		// 8 bytes for Cid_* suffix of each client
		int paddingLen = keyBytes - 8 - keyPrefix.size();
		// left padding by zero, each client has different prefix
		Key prefixWithClientId = StringRef(format("Cid_%04d", clientId)).withPrefix(keyPrefix);
		return StringRef(format("%0*llx", paddingLen, *(uint64_t*)&p)).withPrefix(prefixWithClientId);
	}

	void addRandomReadConflictRange(ReadYourWritesTransaction* tr, std::vector<KeyRange>* readConflictRanges) {
		int startIdx, endIdx;
		Key startKey, endKey;
		do { // add at least one non-empty range
			startIdx = deterministicRandom()->randomInt(0, nodeCount);
			endIdx = deterministicRandom()->randomInt(startIdx + 1, nodeCount + 1);
			startKey = keyForIndex(startIdx);
			endKey = keyForIndex(endIdx);
			ASSERT(startKey < endKey);
			tr->addReadConflictRange(KeyRangeRef(startKey, endKey));
			if (readConflictRanges)
				readConflictRanges->push_back(KeyRangeRef(startKey, endKey));
		} while (deterministicRandom()->random01() < addReadConflictRangeProb);
	}

	void addRandomWriteConflictRange(ReadYourWritesTransaction* tr, std::vector<KeyRange>* writeConflictRanges) {
		int startIdx, endIdx;
		Key startKey, endKey;
		do { // add at least one non-empty range
			startIdx = deterministicRandom()->randomInt(0, nodeCount);
			endIdx = deterministicRandom()->randomInt(startIdx + 1, nodeCount + 1);
			startKey = keyForIndex(startIdx);
			endKey = keyForIndex(endIdx);
			ASSERT(startKey < endKey);
			tr->addWriteConflictRange(KeyRangeRef(startKey, endKey));
			if (writeConflictRanges)
				writeConflictRanges->push_back(KeyRangeRef(startKey, endKey));
		} while (deterministicRandom()->random01() < addWriteConflictRangeProb);
	}

	void emptyConflictingKeysTest(const Reference<ReadYourWritesTransaction>& ryw) {
		// This test is called when you want to make sure there is no conflictingKeys,
		// which means you will get an empty result form getRange(\xff\xff/transaction/conflicting_keys/,
		// \xff\xff/transaction/conflicting_keys0)
		auto resultFuture = ryw->getRange(conflictingKeysRange, CLIENT_KNOBS->TOO_MANY);
		auto result = resultFuture.get();
		ASSERT(!result.more && result.size() == 0);
	}

																#line 354 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
// This generated class is to be used only via conflictingClient()
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
template <class ConflictingClientActor>
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
class ConflictingClientActorState {
															#line 360 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
public:
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	ConflictingClientActorState(Database const& cx,ReportConflictingKeysWorkload* const& self) 
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		 : cx(cx),
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   self(self),
															#line 141 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   tr1(new ReadYourWritesTransaction(cx)),
															#line 142 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   tr2(new ReadYourWritesTransaction(cx)),
															#line 143 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   readConflictRanges(),
															#line 144 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		   writeConflictRanges()
															#line 377 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("conflictingClient", reinterpret_cast<unsigned long>(this));

	}
	~ConflictingClientActorState() 
	{
		fdb_probe_actor_destroy("conflictingClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			;
															#line 392 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConflictingClientActorState();
		static_cast<ConflictingClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 149 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			tr1->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 151 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			self->emptyConflictingKeysTest(tr1);
															#line 153 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			tr2->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 156 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 429 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			{
															#line 157 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				tr1->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 433 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			}
															#line 158 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 437 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			{
															#line 159 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				tr2->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 441 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			}
															#line 163 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr1->getReadVersion();
															#line 163 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 447 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConflictingClientActor*>(this)->actor_wait_state = 1;
															#line 163 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 0, Version >*>(static_cast<ConflictingClientActor*>(this)));
															#line 452 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 296 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		readConflictRanges.clear();
															#line 297 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		writeConflictRanges.clear();
															#line 298 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr1->reset();
															#line 299 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr2->reset();
															#line 473 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 292 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			e2 = e;
															#line 293 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr1->onError(e2);
															#line 293 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 487 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ConflictingClientActor*>(this)->actor_wait_state = 5;
															#line 293 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 4, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 492 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 164 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr2->setVersion(readVersion);
															#line 165 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->addRandomReadConflictRange(tr1.getPtr(), nullptr);
															#line 166 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->addRandomWriteConflictRange(tr1.getPtr(), &writeConflictRanges);
															#line 167 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->commits;
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr1->commit();
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 517 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConflictingClientActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 1, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 522 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 164 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr2->setVersion(readVersion);
															#line 165 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->addRandomReadConflictRange(tr1.getPtr(), nullptr);
															#line 166 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->addRandomWriteConflictRange(tr1.getPtr(), &writeConflictRanges);
															#line 167 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->commits;
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr1->commit();
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 541 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConflictingClientActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 1, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 546 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->xacts;
															#line 171 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->emptyConflictingKeysTest(tr1);
															#line 173 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		foundConflict = false;
															#line 634 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		try {
															#line 175 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			self->addRandomReadConflictRange(tr2.getPtr(), &readConflictRanges);
															#line 176 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			self->addRandomWriteConflictRange(tr2.getPtr(), nullptr);
															#line 177 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			++self->commits;
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr2->commit();
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 646 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConflictingClientActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 2, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 651 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->xacts;
															#line 171 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		self->emptyConflictingKeysTest(tr1);
															#line 173 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		foundConflict = false;
															#line 670 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		try {
															#line 175 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			self->addRandomReadConflictRange(tr2.getPtr(), &readConflictRanges);
															#line 176 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			self->addRandomWriteConflictRange(tr2.getPtr(), nullptr);
															#line 177 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			++self->commits;
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr2->commit();
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 682 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConflictingClientActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 2, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 687 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 187 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(readConflictRanges.size());
															#line 188 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(writeConflictRanges.size());
															#line 190 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (foundConflict)
															#line 781 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ckr = KeyRangeRef(keyAfter(""_sr.withPrefix(conflictingKeysRange.begin)), "\xff\xff"_sr.withPrefix(conflictingKeysRange.begin));
															#line 196 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			conflictingKeyRangesFuture = tr2->getRange(ckr, CLIENT_KNOBS->TOO_MANY);
															#line 197 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(conflictingKeyRangesFuture.isReady());
															#line 199 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = validateSpecialSubrangeRead(tr2.getPtr(), firstGreaterOrEqual(ckr.begin), firstGreaterOrEqual(ckr.end), GetRangeLimits(), Reverse::False, conflictingKeyRangesFuture.get());
															#line 199 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 793 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<ConflictingClientActor*>(this)->actor_wait_state = 4;
															#line 199 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 3, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 798 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 262 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			for( const KeyRange& rCR : readConflictRanges ) {
															#line 263 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				if (std::any_of(writeConflictRanges.begin(), writeConflictRanges.end(), [&rCR](KeyRange wCR) { bool result = wCR.intersects(rCR); if (result) TraceEvent(SevError, "TestFailure") .detail("Reason", "No conflicts returned but it should") .detail("WriteConflictRangeInTr1", wCR.toString()) .detail("ReadConflictRangeInTr2", rCR.toString()); return result; }))
															#line 807 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				{
															#line 272 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					++self->invalidReports;
															#line 273 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					std::string allReadConflictRanges = "";
															#line 274 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					for(int i = 0;i < readConflictRanges.size();i++) {
															#line 275 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
						allReadConflictRanges += "Begin:" + printable(readConflictRanges[i].begin) + ", End:" + printable(readConflictRanges[i].end) + "; ";
															#line 817 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
					}
															#line 278 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					std::string allWriteConflictRanges = "";
															#line 279 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					for(int i = 0;i < writeConflictRanges.size();i++) {
															#line 280 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
						allWriteConflictRanges += "Begin:" + printable(writeConflictRanges[i].begin) + ", End:" + printable(writeConflictRanges[i].end) + "; ";
															#line 825 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
					}
															#line 283 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					TraceEvent(SevError, "TestFailure") .detail("Reason", "No conflicts returned but it should") .detail("ReadConflictRanges", allReadConflictRanges) .detail("WriteConflictRanges", allWriteConflictRanges);
															#line 829 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
					break;
				}
			}
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (e.code() != error_code_not_committed)
															#line 843 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			{
															#line 182 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				return a_body1loopBody1Catch1(e, loopDepth);
															#line 847 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			}
															#line 183 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			foundConflict = true;
															#line 184 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			++self->conflicts;
															#line 853 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->xacts;
															#line 868 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		++self->xacts;
															#line 877 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr2 = makeReference<ReadYourWritesTransaction>(cx);
															#line 208 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		const RangeResult conflictingKeyRanges = conflictingKeyRangesFuture.get();
															#line 209 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() > 0);
															#line 210 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() <= readConflictRanges.size() * 2);
															#line 211 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() % 2 == 0);
															#line 212 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(!conflictingKeyRanges.more);
															#line 213 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		for(int i = 0;i < conflictingKeyRanges.size();i += 2) {
															#line 214 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyValueRef startKeyWithPrefix = conflictingKeyRanges[i];
															#line 215 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(startKeyWithPrefix.key.startsWith(conflictingKeysRange.begin));
															#line 216 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(startKeyWithPrefix.value == conflictingKeysTrue);
															#line 217 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyValueRef endKeyWithPrefix = conflictingKeyRanges[i + 1];
															#line 218 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(endKeyWithPrefix.key.startsWith(conflictingKeysRange.begin));
															#line 219 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(endKeyWithPrefix.value == conflictingKeysFalse);
															#line 221 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			Key startKey = startKeyWithPrefix.key.removePrefix(conflictingKeysRange.begin);
															#line 222 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			Key endKey = endKeyWithPrefix.key.removePrefix(conflictingKeysRange.begin);
															#line 223 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyRangeRef kr = KeyRangeRef(startKey, endKey);
															#line 224 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (!std::any_of(readConflictRanges.begin(), readConflictRanges.end(), [&kr](KeyRange rCR) { return kr.contains(rCR); }))
															#line 1012 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			{
															#line 231 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				++self->invalidReports;
															#line 232 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				std::string allReadConflictRanges = "";
															#line 233 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				for(int i = 0;i < readConflictRanges.size();i++) {
															#line 234 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					allReadConflictRanges += "Begin:" + printable(readConflictRanges[i].begin) + ", End:" + printable(readConflictRanges[i].end) + "; ";
															#line 1022 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				}
															#line 237 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Returned conflicting keys are not original or merged readConflictRanges") .detail("ConflictingKeyRange", kr.toString()) .detail("ReadConflictRanges", allReadConflictRanges);
															#line 1026 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			}
			else
			{
															#line 242 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				if (!std::any_of( writeConflictRanges.begin(), writeConflictRanges.end(), [&kr](KeyRange wCR) { return kr.intersects(wCR); }))
															#line 1032 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				{
															#line 248 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					++self->invalidReports;
															#line 249 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					std::string allWriteConflictRanges = "";
															#line 250 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					for(int i = 0;i < writeConflictRanges.size();i++) {
															#line 251 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
						allWriteConflictRanges += "Begin:" + printable(writeConflictRanges[i].begin) + ", End:" + printable(writeConflictRanges[i].end) + "; ";
															#line 1042 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
					}
															#line 254 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					TraceEvent(SevError, "TestFailure") .detail("Reason", "Returned keyrange is not conflicting with any writeConflictRange") .detail("ConflictingKeyRange", kr.toString()) .detail("WriteConflictRanges", allWriteConflictRanges);
															#line 1046 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				}
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		tr2 = makeReference<ReadYourWritesTransaction>(cx);
															#line 208 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		const RangeResult conflictingKeyRanges = conflictingKeyRangesFuture.get();
															#line 209 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() > 0);
															#line 210 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() <= readConflictRanges.size() * 2);
															#line 211 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(conflictingKeyRanges.size() % 2 == 0);
															#line 212 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		ASSERT(!conflictingKeyRanges.more);
															#line 213 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		for(int i = 0;i < conflictingKeyRanges.size();i += 2) {
															#line 214 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyValueRef startKeyWithPrefix = conflictingKeyRanges[i];
															#line 215 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(startKeyWithPrefix.key.startsWith(conflictingKeysRange.begin));
															#line 216 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(startKeyWithPrefix.value == conflictingKeysTrue);
															#line 217 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyValueRef endKeyWithPrefix = conflictingKeyRanges[i + 1];
															#line 218 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(endKeyWithPrefix.key.startsWith(conflictingKeysRange.begin));
															#line 219 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			ASSERT(endKeyWithPrefix.value == conflictingKeysFalse);
															#line 221 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			Key startKey = startKeyWithPrefix.key.removePrefix(conflictingKeysRange.begin);
															#line 222 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			Key endKey = endKeyWithPrefix.key.removePrefix(conflictingKeysRange.begin);
															#line 223 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			KeyRangeRef kr = KeyRangeRef(startKey, endKey);
															#line 224 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
			if (!std::any_of(readConflictRanges.begin(), readConflictRanges.end(), [&kr](KeyRange rCR) { return kr.contains(rCR); }))
															#line 1090 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			{
															#line 231 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				++self->invalidReports;
															#line 232 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				std::string allReadConflictRanges = "";
															#line 233 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				for(int i = 0;i < readConflictRanges.size();i++) {
															#line 234 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					allReadConflictRanges += "Begin:" + printable(readConflictRanges[i].begin) + ", End:" + printable(readConflictRanges[i].end) + "; ";
															#line 1100 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				}
															#line 237 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Returned conflicting keys are not original or merged readConflictRanges") .detail("ConflictingKeyRange", kr.toString()) .detail("ReadConflictRanges", allReadConflictRanges);
															#line 1104 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
			}
			else
			{
															#line 242 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
				if (!std::any_of( writeConflictRanges.begin(), writeConflictRanges.end(), [&kr](KeyRange wCR) { return kr.intersects(wCR); }))
															#line 1110 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				{
															#line 248 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					++self->invalidReports;
															#line 249 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					std::string allWriteConflictRanges = "";
															#line 250 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					for(int i = 0;i < writeConflictRanges.size();i++) {
															#line 251 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
						allWriteConflictRanges += "Begin:" + printable(writeConflictRanges[i].begin) + ", End:" + printable(writeConflictRanges[i].end) + "; ";
															#line 1120 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
					}
															#line 254 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
					TraceEvent(SevError, "TestFailure") .detail("Reason", "Returned keyrange is not conflicting with any writeConflictRange") .detail("ConflictingKeyRange", kr.toString()) .detail("WriteConflictRanges", allWriteConflictRanges);
															#line 1124 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
				}
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr2->onError(e2);
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1226 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ConflictingClientActor*>(this)->actor_wait_state = 6;
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 5, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 1231 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr2->onError(e2);
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1242 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ConflictingClientActor*>(this)->actor_wait_state = 6;
															#line 294 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConflictingClientActor, 5, Void >*>(static_cast<ConflictingClientActor*>(this)));
															#line 1247 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConflictingClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictingClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictingClientActor*>(this)->ActorCallback< ConflictingClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConflictingClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConflictingClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Database cx;
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	ReportConflictingKeysWorkload* self;
															#line 141 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr1;
															#line 142 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr2;
															#line 143 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	std::vector<KeyRange> readConflictRanges;
															#line 144 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	std::vector<KeyRange> writeConflictRanges;
															#line 173 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	bool foundConflict;
															#line 192 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	KeyRange ckr;
															#line 196 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Future<RangeResult> conflictingKeyRangesFuture;
															#line 292 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	Error e2;
															#line 1434 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
};
// This generated class is to be used only via conflictingClient()
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
class ConflictingClientActor final : public Actor<Void>, public ActorCallback< ConflictingClientActor, 0, Version >, public ActorCallback< ConflictingClientActor, 1, Void >, public ActorCallback< ConflictingClientActor, 2, Void >, public ActorCallback< ConflictingClientActor, 3, Void >, public ActorCallback< ConflictingClientActor, 4, Void >, public ActorCallback< ConflictingClientActor, 5, Void >, public FastAllocated<ConflictingClientActor>, public ConflictingClientActorState<ConflictingClientActor> {
															#line 1439 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConflictingClientActor>::operator new;
	using FastAllocated<ConflictingClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11852725074395119104UL, 14354329034613831424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConflictingClientActor, 0, Version >;
friend struct ActorCallback< ConflictingClientActor, 1, Void >;
friend struct ActorCallback< ConflictingClientActor, 2, Void >;
friend struct ActorCallback< ConflictingClientActor, 3, Void >;
friend struct ActorCallback< ConflictingClientActor, 4, Void >;
friend struct ActorCallback< ConflictingClientActor, 5, Void >;
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	ConflictingClientActor(Database const& cx,ReportConflictingKeysWorkload* const& self) 
															#line 1461 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConflictingClientActorState<ConflictingClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("conflictingClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2171590014360575488UL, 7885239517229352192UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("conflictingClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("conflictingClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConflictingClientActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConflictingClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConflictingClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConflictingClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConflictingClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConflictingClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
[[nodiscard]] Future<Void> conflictingClient( Database const& cx, ReportConflictingKeysWorkload* const& self ) {
															#line 139 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
	return Future<Void>(new ConflictingClientActor(cx, self));
															#line 1498 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReportConflictingKeys.actor.g.cpp.py_gen"
}

#line 302 "/codebuild/output/src733655110/src/github.com/apple/foundationdb/fdbserver/workloads/ReportConflictingKeys.actor.cpp"
};

WorkloadFactory<ReportConflictingKeysWorkload> ReportConflictingKeysWorkload;
