﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/taxsettings/model/ListSupplementalTaxRegistrationsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::TaxSettings::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSupplementalTaxRegistrationsResult::ListSupplementalTaxRegistrationsResult()
{
}

ListSupplementalTaxRegistrationsResult::ListSupplementalTaxRegistrationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListSupplementalTaxRegistrationsResult& ListSupplementalTaxRegistrationsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }

  if(jsonValue.ValueExists("taxRegistrations"))
  {
    Aws::Utils::Array<JsonView> taxRegistrationsJsonList = jsonValue.GetArray("taxRegistrations");
    for(unsigned taxRegistrationsIndex = 0; taxRegistrationsIndex < taxRegistrationsJsonList.GetLength(); ++taxRegistrationsIndex)
    {
      m_taxRegistrations.push_back(taxRegistrationsJsonList[taxRegistrationsIndex].AsObject());
    }
  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
