﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/socialmessaging/SocialMessaging_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/socialmessaging/model/WabaSetupFinalization.h>
#include <aws/socialmessaging/model/WabaPhoneNumberSetupFinalization.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SocialMessaging
{
namespace Model
{

  /**
   * <p>The details of linking a WhatsApp Business Account to your Amazon Web
   * Services account.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/WhatsAppSetupFinalization">AWS
   * API Reference</a></p>
   */
  class WhatsAppSetupFinalization
  {
  public:
    AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization();
    AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An Amazon Web Services access token generated by
     * <code>WhatsAppSignupCallback</code> and used by
     * <code>WhatsAppSetupFinalization</code>.</p>
     */
    inline const Aws::String& GetAssociateInProgressToken() const{ return m_associateInProgressToken; }
    inline bool AssociateInProgressTokenHasBeenSet() const { return m_associateInProgressTokenHasBeenSet; }
    inline void SetAssociateInProgressToken(const Aws::String& value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken = value; }
    inline void SetAssociateInProgressToken(Aws::String&& value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken = std::move(value); }
    inline void SetAssociateInProgressToken(const char* value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken.assign(value); }
    inline WhatsAppSetupFinalization& WithAssociateInProgressToken(const Aws::String& value) { SetAssociateInProgressToken(value); return *this;}
    inline WhatsAppSetupFinalization& WithAssociateInProgressToken(Aws::String&& value) { SetAssociateInProgressToken(std::move(value)); return *this;}
    inline WhatsAppSetupFinalization& WithAssociateInProgressToken(const char* value) { SetAssociateInProgressToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An array of WabaPhoneNumberSetupFinalization objects containing the details
     * of each phone number associated with the WhatsApp Business Account.</p>
     */
    inline const Aws::Vector<WabaPhoneNumberSetupFinalization>& GetPhoneNumbers() const{ return m_phoneNumbers; }
    inline bool PhoneNumbersHasBeenSet() const { return m_phoneNumbersHasBeenSet; }
    inline void SetPhoneNumbers(const Aws::Vector<WabaPhoneNumberSetupFinalization>& value) { m_phoneNumbersHasBeenSet = true; m_phoneNumbers = value; }
    inline void SetPhoneNumbers(Aws::Vector<WabaPhoneNumberSetupFinalization>&& value) { m_phoneNumbersHasBeenSet = true; m_phoneNumbers = std::move(value); }
    inline WhatsAppSetupFinalization& WithPhoneNumbers(const Aws::Vector<WabaPhoneNumberSetupFinalization>& value) { SetPhoneNumbers(value); return *this;}
    inline WhatsAppSetupFinalization& WithPhoneNumbers(Aws::Vector<WabaPhoneNumberSetupFinalization>&& value) { SetPhoneNumbers(std::move(value)); return *this;}
    inline WhatsAppSetupFinalization& AddPhoneNumbers(const WabaPhoneNumberSetupFinalization& value) { m_phoneNumbersHasBeenSet = true; m_phoneNumbers.push_back(value); return *this; }
    inline WhatsAppSetupFinalization& AddPhoneNumbers(WabaPhoneNumberSetupFinalization&& value) { m_phoneNumbersHasBeenSet = true; m_phoneNumbers.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Used to add a new phone number to an existing WhatsApp Business Account. This
     * field can't be used when the <code>waba</code> field is present.</p>
     */
    inline const Aws::String& GetPhoneNumberParent() const{ return m_phoneNumberParent; }
    inline bool PhoneNumberParentHasBeenSet() const { return m_phoneNumberParentHasBeenSet; }
    inline void SetPhoneNumberParent(const Aws::String& value) { m_phoneNumberParentHasBeenSet = true; m_phoneNumberParent = value; }
    inline void SetPhoneNumberParent(Aws::String&& value) { m_phoneNumberParentHasBeenSet = true; m_phoneNumberParent = std::move(value); }
    inline void SetPhoneNumberParent(const char* value) { m_phoneNumberParentHasBeenSet = true; m_phoneNumberParent.assign(value); }
    inline WhatsAppSetupFinalization& WithPhoneNumberParent(const Aws::String& value) { SetPhoneNumberParent(value); return *this;}
    inline WhatsAppSetupFinalization& WithPhoneNumberParent(Aws::String&& value) { SetPhoneNumberParent(std::move(value)); return *this;}
    inline WhatsAppSetupFinalization& WithPhoneNumberParent(const char* value) { SetPhoneNumberParent(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Used to create a new WhatsApp Business Account and add a phone number. This
     * field can't be used when the <code>phoneNumberParent</code> field is
     * present.</p>
     */
    inline const WabaSetupFinalization& GetWaba() const{ return m_waba; }
    inline bool WabaHasBeenSet() const { return m_wabaHasBeenSet; }
    inline void SetWaba(const WabaSetupFinalization& value) { m_wabaHasBeenSet = true; m_waba = value; }
    inline void SetWaba(WabaSetupFinalization&& value) { m_wabaHasBeenSet = true; m_waba = std::move(value); }
    inline WhatsAppSetupFinalization& WithWaba(const WabaSetupFinalization& value) { SetWaba(value); return *this;}
    inline WhatsAppSetupFinalization& WithWaba(WabaSetupFinalization&& value) { SetWaba(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_associateInProgressToken;
    bool m_associateInProgressTokenHasBeenSet = false;

    Aws::Vector<WabaPhoneNumberSetupFinalization> m_phoneNumbers;
    bool m_phoneNumbersHasBeenSet = false;

    Aws::String m_phoneNumberParent;
    bool m_phoneNumberParentHasBeenSet = false;

    WabaSetupFinalization m_waba;
    bool m_wabaHasBeenSet = false;
  };

} // namespace Model
} // namespace SocialMessaging
} // namespace Aws
