﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A placement constraint object to use for tasks.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEcsTaskDefinitionPlacementConstraintsDetails">AWS
   * API Reference</a></p>
   */
  class AwsEcsTaskDefinitionPlacementConstraintsDetails
  {
  public:
    AWS_SECURITYHUB_API AwsEcsTaskDefinitionPlacementConstraintsDetails();
    AWS_SECURITYHUB_API AwsEcsTaskDefinitionPlacementConstraintsDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API AwsEcsTaskDefinitionPlacementConstraintsDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A cluster query language expression to apply to the constraint.</p>
     */
    inline const Aws::String& GetExpression() const{ return m_expression; }
    inline bool ExpressionHasBeenSet() const { return m_expressionHasBeenSet; }
    inline void SetExpression(const Aws::String& value) { m_expressionHasBeenSet = true; m_expression = value; }
    inline void SetExpression(Aws::String&& value) { m_expressionHasBeenSet = true; m_expression = std::move(value); }
    inline void SetExpression(const char* value) { m_expressionHasBeenSet = true; m_expression.assign(value); }
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithExpression(const Aws::String& value) { SetExpression(value); return *this;}
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithExpression(Aws::String&& value) { SetExpression(std::move(value)); return *this;}
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithExpression(const char* value) { SetExpression(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of constraint.</p>
     */
    inline const Aws::String& GetType() const{ return m_type; }
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
    inline void SetType(const Aws::String& value) { m_typeHasBeenSet = true; m_type = value; }
    inline void SetType(Aws::String&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }
    inline void SetType(const char* value) { m_typeHasBeenSet = true; m_type.assign(value); }
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithType(const Aws::String& value) { SetType(value); return *this;}
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithType(Aws::String&& value) { SetType(std::move(value)); return *this;}
    inline AwsEcsTaskDefinitionPlacementConstraintsDetails& WithType(const char* value) { SetType(value); return *this;}
    ///@}
  private:

    Aws::String m_expression;
    bool m_expressionHasBeenSet = false;

    Aws::String m_type;
    bool m_typeHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
