﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/security-ir/model/UpdateCaseCommentRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::SecurityIR::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateCaseCommentRequest::UpdateCaseCommentRequest() : 
    m_caseIdHasBeenSet(false),
    m_commentIdHasBeenSet(false),
    m_requestBodyHasBeenSet(false)
{
}

Aws::String UpdateCaseCommentRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_requestBodyHasBeenSet)
  {
   payload.WithString("body", m_requestBody);

  }

  return payload.View().WriteReadable();
}




