﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/scheduler/model/ScheduleGroupState.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Scheduler
  {
    namespace Model
    {
      namespace ScheduleGroupStateMapper
      {

        static const int ACTIVE_HASH = HashingUtils::HashString("ACTIVE");
        static const int DELETING_HASH = HashingUtils::HashString("DELETING");


        ScheduleGroupState GetScheduleGroupStateForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ACTIVE_HASH)
          {
            return ScheduleGroupState::ACTIVE;
          }
          else if (hashCode == DELETING_HASH)
          {
            return ScheduleGroupState::DELETING;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ScheduleGroupState>(hashCode);
          }

          return ScheduleGroupState::NOT_SET;
        }

        Aws::String GetNameForScheduleGroupState(ScheduleGroupState enumValue)
        {
          switch(enumValue)
          {
          case ScheduleGroupState::NOT_SET:
            return {};
          case ScheduleGroupState::ACTIVE:
            return "ACTIVE";
          case ScheduleGroupState::DELETING:
            return "DELETING";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ScheduleGroupStateMapper
    } // namespace Model
  } // namespace Scheduler
} // namespace Aws
