﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sagemaker/model/StartMlflowTrackingServerRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::SageMaker::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

StartMlflowTrackingServerRequest::StartMlflowTrackingServerRequest() : 
    m_trackingServerNameHasBeenSet(false)
{
}

Aws::String StartMlflowTrackingServerRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_trackingServerNameHasBeenSet)
  {
   payload.WithString("TrackingServerName", m_trackingServerName);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartMlflowTrackingServerRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "SageMaker.StartMlflowTrackingServer"));
  return headers;

}




