﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sagemaker-geospatial/model/LogicalOperator.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SageMakerGeospatial
  {
    namespace Model
    {
      namespace LogicalOperatorMapper
      {

        static const int AND_HASH = HashingUtils::HashString("AND");


        LogicalOperator GetLogicalOperatorForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == AND_HASH)
          {
            return LogicalOperator::AND;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<LogicalOperator>(hashCode);
          }

          return LogicalOperator::NOT_SET;
        }

        Aws::String GetNameForLogicalOperator(LogicalOperator enumValue)
        {
          switch(enumValue)
          {
          case LogicalOperator::NOT_SET:
            return {};
          case LogicalOperator::AND:
            return "AND";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace LogicalOperatorMapper
    } // namespace Model
  } // namespace SageMakerGeospatial
} // namespace Aws
