﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Route53RecoveryReadiness
{
namespace Model
{
  class CreateCellResult
  {
  public:
    AWS_ROUTE53RECOVERYREADINESS_API CreateCellResult();
    AWS_ROUTE53RECOVERYREADINESS_API CreateCellResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ROUTE53RECOVERYREADINESS_API CreateCellResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) for the cell.</p>
     */
    inline const Aws::String& GetCellArn() const{ return m_cellArn; }
    inline void SetCellArn(const Aws::String& value) { m_cellArn = value; }
    inline void SetCellArn(Aws::String&& value) { m_cellArn = std::move(value); }
    inline void SetCellArn(const char* value) { m_cellArn.assign(value); }
    inline CreateCellResult& WithCellArn(const Aws::String& value) { SetCellArn(value); return *this;}
    inline CreateCellResult& WithCellArn(Aws::String&& value) { SetCellArn(std::move(value)); return *this;}
    inline CreateCellResult& WithCellArn(const char* value) { SetCellArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the cell.</p>
     */
    inline const Aws::String& GetCellName() const{ return m_cellName; }
    inline void SetCellName(const Aws::String& value) { m_cellName = value; }
    inline void SetCellName(Aws::String&& value) { m_cellName = std::move(value); }
    inline void SetCellName(const char* value) { m_cellName.assign(value); }
    inline CreateCellResult& WithCellName(const Aws::String& value) { SetCellName(value); return *this;}
    inline CreateCellResult& WithCellName(Aws::String&& value) { SetCellName(std::move(value)); return *this;}
    inline CreateCellResult& WithCellName(const char* value) { SetCellName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of cell ARNs.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCells() const{ return m_cells; }
    inline void SetCells(const Aws::Vector<Aws::String>& value) { m_cells = value; }
    inline void SetCells(Aws::Vector<Aws::String>&& value) { m_cells = std::move(value); }
    inline CreateCellResult& WithCells(const Aws::Vector<Aws::String>& value) { SetCells(value); return *this;}
    inline CreateCellResult& WithCells(Aws::Vector<Aws::String>&& value) { SetCells(std::move(value)); return *this;}
    inline CreateCellResult& AddCells(const Aws::String& value) { m_cells.push_back(value); return *this; }
    inline CreateCellResult& AddCells(Aws::String&& value) { m_cells.push_back(std::move(value)); return *this; }
    inline CreateCellResult& AddCells(const char* value) { m_cells.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The readiness scope for the cell, which can be a cell Amazon Resource Name
     * (ARN) or a recovery group ARN. This is a list but currently can have only one
     * element.</p>
     */
    inline const Aws::Vector<Aws::String>& GetParentReadinessScopes() const{ return m_parentReadinessScopes; }
    inline void SetParentReadinessScopes(const Aws::Vector<Aws::String>& value) { m_parentReadinessScopes = value; }
    inline void SetParentReadinessScopes(Aws::Vector<Aws::String>&& value) { m_parentReadinessScopes = std::move(value); }
    inline CreateCellResult& WithParentReadinessScopes(const Aws::Vector<Aws::String>& value) { SetParentReadinessScopes(value); return *this;}
    inline CreateCellResult& WithParentReadinessScopes(Aws::Vector<Aws::String>&& value) { SetParentReadinessScopes(std::move(value)); return *this;}
    inline CreateCellResult& AddParentReadinessScopes(const Aws::String& value) { m_parentReadinessScopes.push_back(value); return *this; }
    inline CreateCellResult& AddParentReadinessScopes(Aws::String&& value) { m_parentReadinessScopes.push_back(std::move(value)); return *this; }
    inline CreateCellResult& AddParentReadinessScopes(const char* value) { m_parentReadinessScopes.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Tags on the resources.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetTags() const{ return m_tags; }
    inline void SetTags(const Aws::Map<Aws::String, Aws::String>& value) { m_tags = value; }
    inline void SetTags(Aws::Map<Aws::String, Aws::String>&& value) { m_tags = std::move(value); }
    inline CreateCellResult& WithTags(const Aws::Map<Aws::String, Aws::String>& value) { SetTags(value); return *this;}
    inline CreateCellResult& WithTags(Aws::Map<Aws::String, Aws::String>&& value) { SetTags(std::move(value)); return *this;}
    inline CreateCellResult& AddTags(const Aws::String& key, const Aws::String& value) { m_tags.emplace(key, value); return *this; }
    inline CreateCellResult& AddTags(Aws::String&& key, const Aws::String& value) { m_tags.emplace(std::move(key), value); return *this; }
    inline CreateCellResult& AddTags(const Aws::String& key, Aws::String&& value) { m_tags.emplace(key, std::move(value)); return *this; }
    inline CreateCellResult& AddTags(Aws::String&& key, Aws::String&& value) { m_tags.emplace(std::move(key), std::move(value)); return *this; }
    inline CreateCellResult& AddTags(const char* key, Aws::String&& value) { m_tags.emplace(key, std::move(value)); return *this; }
    inline CreateCellResult& AddTags(Aws::String&& key, const char* value) { m_tags.emplace(std::move(key), value); return *this; }
    inline CreateCellResult& AddTags(const char* key, const char* value) { m_tags.emplace(key, value); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline CreateCellResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline CreateCellResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline CreateCellResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_cellArn;

    Aws::String m_cellName;

    Aws::Vector<Aws::String> m_cells;

    Aws::Vector<Aws::String> m_parentReadinessScopes;

    Aws::Map<Aws::String, Aws::String> m_tags;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Route53RecoveryReadiness
} // namespace Aws
