﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/resiliencehub/model/ListResourceGroupingRecommendationsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ResilienceHub::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListResourceGroupingRecommendationsResult::ListResourceGroupingRecommendationsResult()
{
}

ListResourceGroupingRecommendationsResult::ListResourceGroupingRecommendationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListResourceGroupingRecommendationsResult& ListResourceGroupingRecommendationsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("groupingRecommendations"))
  {
    Aws::Utils::Array<JsonView> groupingRecommendationsJsonList = jsonValue.GetArray("groupingRecommendations");
    for(unsigned groupingRecommendationsIndex = 0; groupingRecommendationsIndex < groupingRecommendationsJsonList.GetLength(); ++groupingRecommendationsIndex)
    {
      m_groupingRecommendations.push_back(groupingRecommendationsJsonList[groupingRecommendationsIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
