﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/rekognition/model/VideoJobStatus.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace Rekognition
  {
    namespace Model
    {
      namespace VideoJobStatusMapper
      {

        static const int IN_PROGRESS_HASH = HashingUtils::HashString("IN_PROGRESS");
        static const int SUCCEEDED_HASH = HashingUtils::HashString("SUCCEEDED");
        static const int FAILED_HASH = HashingUtils::HashString("FAILED");


        VideoJobStatus GetVideoJobStatusForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == IN_PROGRESS_HASH)
          {
            return VideoJobStatus::IN_PROGRESS;
          }
          else if (hashCode == SUCCEEDED_HASH)
          {
            return VideoJobStatus::SUCCEEDED;
          }
          else if (hashCode == FAILED_HASH)
          {
            return VideoJobStatus::FAILED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<VideoJobStatus>(hashCode);
          }

          return VideoJobStatus::NOT_SET;
        }

        Aws::String GetNameForVideoJobStatus(VideoJobStatus enumValue)
        {
          switch(enumValue)
          {
          case VideoJobStatus::NOT_SET:
            return {};
          case VideoJobStatus::IN_PROGRESS:
            return "IN_PROGRESS";
          case VideoJobStatus::SUCCEEDED:
            return "SUCCEEDED";
          case VideoJobStatus::FAILED:
            return "FAILED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace VideoJobStatusMapper
    } // namespace Model
  } // namespace Rekognition
} // namespace Aws
