﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/StaticFileUrlSourceOptions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

StaticFileUrlSourceOptions::StaticFileUrlSourceOptions() : 
    m_urlHasBeenSet(false)
{
}

StaticFileUrlSourceOptions::StaticFileUrlSourceOptions(JsonView jsonValue)
  : StaticFileUrlSourceOptions()
{
  *this = jsonValue;
}

StaticFileUrlSourceOptions& StaticFileUrlSourceOptions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Url"))
  {
    m_url = jsonValue.GetString("Url");

    m_urlHasBeenSet = true;
  }

  return *this;
}

JsonValue StaticFileUrlSourceOptions::Jsonize() const
{
  JsonValue payload;

  if(m_urlHasBeenSet)
  {
   payload.WithString("Url", m_url);

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
