﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/ScrollBarOptions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

ScrollBarOptions::ScrollBarOptions() : 
    m_visibility(Visibility::NOT_SET),
    m_visibilityHasBeenSet(false),
    m_visibleRangeHasBeenSet(false)
{
}

ScrollBarOptions::ScrollBarOptions(JsonView jsonValue)
  : ScrollBarOptions()
{
  *this = jsonValue;
}

ScrollBarOptions& ScrollBarOptions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Visibility"))
  {
    m_visibility = VisibilityMapper::GetVisibilityForName(jsonValue.GetString("Visibility"));

    m_visibilityHasBeenSet = true;
  }

  if(jsonValue.ValueExists("VisibleRange"))
  {
    m_visibleRange = jsonValue.GetObject("VisibleRange");

    m_visibleRangeHasBeenSet = true;
  }

  return *this;
}

JsonValue ScrollBarOptions::Jsonize() const
{
  JsonValue payload;

  if(m_visibilityHasBeenSet)
  {
   payload.WithString("Visibility", VisibilityMapper::GetNameForVisibility(m_visibility));
  }

  if(m_visibleRangeHasBeenSet)
  {
   payload.WithObject("VisibleRange", m_visibleRange.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
