﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/OtherCategories.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace QuickSight
  {
    namespace Model
    {
      namespace OtherCategoriesMapper
      {

        static const int INCLUDE_HASH = HashingUtils::HashString("INCLUDE");
        static const int EXCLUDE_HASH = HashingUtils::HashString("EXCLUDE");


        OtherCategories GetOtherCategoriesForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == INCLUDE_HASH)
          {
            return OtherCategories::INCLUDE;
          }
          else if (hashCode == EXCLUDE_HASH)
          {
            return OtherCategories::EXCLUDE;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<OtherCategories>(hashCode);
          }

          return OtherCategories::NOT_SET;
        }

        Aws::String GetNameForOtherCategories(OtherCategories enumValue)
        {
          switch(enumValue)
          {
          case OtherCategories::NOT_SET:
            return {};
          case OtherCategories::INCLUDE:
            return "INCLUDE";
          case OtherCategories::EXCLUDE:
            return "EXCLUDE";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace OtherCategoriesMapper
    } // namespace Model
  } // namespace QuickSight
} // namespace Aws
