﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/DashboardBehavior.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace QuickSight
  {
    namespace Model
    {
      namespace DashboardBehaviorMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        DashboardBehavior GetDashboardBehaviorForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return DashboardBehavior::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return DashboardBehavior::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<DashboardBehavior>(hashCode);
          }

          return DashboardBehavior::NOT_SET;
        }

        Aws::String GetNameForDashboardBehavior(DashboardBehavior enumValue)
        {
          switch(enumValue)
          {
          case DashboardBehavior::NOT_SET:
            return {};
          case DashboardBehavior::ENABLED:
            return "ENABLED";
          case DashboardBehavior::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace DashboardBehaviorMapper
    } // namespace Model
  } // namespace QuickSight
} // namespace Aws
