﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/qldb/QLDB_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qldb/model/LedgerSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace QLDB
{
namespace Model
{
  class ListLedgersResult
  {
  public:
    AWS_QLDB_API ListLedgersResult();
    AWS_QLDB_API ListLedgersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_QLDB_API ListLedgersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The ledgers that are associated with the current Amazon Web Services account
     * and Region.</p>
     */
    inline const Aws::Vector<LedgerSummary>& GetLedgers() const{ return m_ledgers; }
    inline void SetLedgers(const Aws::Vector<LedgerSummary>& value) { m_ledgers = value; }
    inline void SetLedgers(Aws::Vector<LedgerSummary>&& value) { m_ledgers = std::move(value); }
    inline ListLedgersResult& WithLedgers(const Aws::Vector<LedgerSummary>& value) { SetLedgers(value); return *this;}
    inline ListLedgersResult& WithLedgers(Aws::Vector<LedgerSummary>&& value) { SetLedgers(std::move(value)); return *this;}
    inline ListLedgersResult& AddLedgers(const LedgerSummary& value) { m_ledgers.push_back(value); return *this; }
    inline ListLedgersResult& AddLedgers(LedgerSummary&& value) { m_ledgers.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A pagination token, indicating whether there are more results available:</p>
     * <ul> <li> <p>If <code>NextToken</code> is empty, then the last page of results
     * has been processed and there are no more results to be retrieved.</p> </li> <li>
     * <p>If <code>NextToken</code> is <i>not</i> empty, then there are more results
     * available. To retrieve the next page of results, use the value of
     * <code>NextToken</code> in a subsequent <code>ListLedgers</code> call.</p> </li>
     * </ul>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListLedgersResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListLedgersResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListLedgersResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListLedgersResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListLedgersResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListLedgersResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<LedgerSummary> m_ledgers;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace QLDB
} // namespace Aws
