﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/qconnect/model/GetNextMessageRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::QConnect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

GetNextMessageRequest::GetNextMessageRequest() : 
    m_assistantIdHasBeenSet(false),
    m_nextMessageTokenHasBeenSet(false),
    m_sessionIdHasBeenSet(false)
{
}

Aws::String GetNextMessageRequest::SerializePayload() const
{
  return {};
}

void GetNextMessageRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_nextMessageTokenHasBeenSet)
    {
      ss << m_nextMessageToken;
      uri.AddQueryStringParameter("nextMessageToken", ss.str());
      ss.str("");
    }

}



