﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/qbusiness/model/SearchRelevantContentResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

SearchRelevantContentResult::SearchRelevantContentResult()
{
}

SearchRelevantContentResult::SearchRelevantContentResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

SearchRelevantContentResult& SearchRelevantContentResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("relevantContent"))
  {
    Aws::Utils::Array<JsonView> relevantContentJsonList = jsonValue.GetArray("relevantContent");
    for(unsigned relevantContentIndex = 0; relevantContentIndex < relevantContentJsonList.GetLength(); ++relevantContentIndex)
    {
      m_relevantContent.push_back(relevantContentJsonList[relevantContentIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
