﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/pcs/model/GetComputeNodeGroupRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::PCS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

GetComputeNodeGroupRequest::GetComputeNodeGroupRequest() : 
    m_clusterIdentifierHasBeenSet(false),
    m_computeNodeGroupIdentifierHasBeenSet(false)
{
}

Aws::String GetComputeNodeGroupRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_clusterIdentifierHasBeenSet)
  {
   payload.WithString("clusterIdentifier", m_clusterIdentifier);

  }

  if(m_computeNodeGroupIdentifierHasBeenSet)
  {
   payload.WithString("computeNodeGroupIdentifier", m_computeNodeGroupIdentifier);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetComputeNodeGroupRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSParallelComputingService.GetComputeNodeGroup"));
  return headers;

}




