﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/notifications/model/UpdateEventRuleRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Notifications::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateEventRuleRequest::UpdateEventRuleRequest() : 
    m_arnHasBeenSet(false),
    m_eventPatternHasBeenSet(false),
    m_regionsHasBeenSet(false)
{
}

Aws::String UpdateEventRuleRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_eventPatternHasBeenSet)
  {
   payload.WithString("eventPattern", m_eventPattern);

  }

  if(m_regionsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> regionsJsonList(m_regions.size());
   for(unsigned regionsIndex = 0; regionsIndex < regionsJsonList.GetLength(); ++regionsIndex)
   {
     regionsJsonList[regionsIndex].AsString(m_regions[regionsIndex]);
   }
   payload.WithArray("regions", std::move(regionsJsonList));

  }

  return payload.View().WriteReadable();
}




