﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediaconvert/model/M2tsScte35Source.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaConvert
  {
    namespace Model
    {
      namespace M2tsScte35SourceMapper
      {

        static const int PASSTHROUGH_HASH = HashingUtils::HashString("PASSTHROUGH");
        static const int NONE_HASH = HashingUtils::HashString("NONE");


        M2tsScte35Source GetM2tsScte35SourceForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == PASSTHROUGH_HASH)
          {
            return M2tsScte35Source::PASSTHROUGH;
          }
          else if (hashCode == NONE_HASH)
          {
            return M2tsScte35Source::NONE;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<M2tsScte35Source>(hashCode);
          }

          return M2tsScte35Source::NOT_SET;
        }

        Aws::String GetNameForM2tsScte35Source(M2tsScte35Source enumValue)
        {
          switch(enumValue)
          {
          case M2tsScte35Source::NOT_SET:
            return {};
          case M2tsScte35Source::PASSTHROUGH:
            return "PASSTHROUGH";
          case M2tsScte35Source::NONE:
            return "NONE";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace M2tsScte35SourceMapper
    } // namespace Model
  } // namespace MediaConvert
} // namespace Aws
