﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/internetmonitor/model/GetMonitorRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::InternetMonitor::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

GetMonitorRequest::GetMonitorRequest() : 
    m_monitorNameHasBeenSet(false),
    m_linkedAccountIdHasBeenSet(false)
{
}

Aws::String GetMonitorRequest::SerializePayload() const
{
  return {};
}

void GetMonitorRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_linkedAccountIdHasBeenSet)
    {
      ss << m_linkedAccountId;
      uri.AddQueryStringParameter("LinkedAccountId", ss.str());
      ss.str("");
    }

}



