﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionPlanTaggingActionStatus.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace GuardDuty
  {
    namespace Model
    {
      namespace MalwareProtectionPlanTaggingActionStatusMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        MalwareProtectionPlanTaggingActionStatus GetMalwareProtectionPlanTaggingActionStatusForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return MalwareProtectionPlanTaggingActionStatus::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return MalwareProtectionPlanTaggingActionStatus::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<MalwareProtectionPlanTaggingActionStatus>(hashCode);
          }

          return MalwareProtectionPlanTaggingActionStatus::NOT_SET;
        }

        Aws::String GetNameForMalwareProtectionPlanTaggingActionStatus(MalwareProtectionPlanTaggingActionStatus enumValue)
        {
          switch(enumValue)
          {
          case MalwareProtectionPlanTaggingActionStatus::NOT_SET:
            return {};
          case MalwareProtectionPlanTaggingActionStatus::ENABLED:
            return "ENABLED";
          case MalwareProtectionPlanTaggingActionStatus::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace MalwareProtectionPlanTaggingActionStatusMapper
    } // namespace Model
  } // namespace GuardDuty
} // namespace Aws
