﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionPlanSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

MalwareProtectionPlanSummary::MalwareProtectionPlanSummary() : 
    m_malwareProtectionPlanIdHasBeenSet(false)
{
}

MalwareProtectionPlanSummary::MalwareProtectionPlanSummary(JsonView jsonValue)
  : MalwareProtectionPlanSummary()
{
  *this = jsonValue;
}

MalwareProtectionPlanSummary& MalwareProtectionPlanSummary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("malwareProtectionPlanId"))
  {
    m_malwareProtectionPlanId = jsonValue.GetString("malwareProtectionPlanId");

    m_malwareProtectionPlanIdHasBeenSet = true;
  }

  return *this;
}

JsonValue MalwareProtectionPlanSummary::Jsonize() const
{
  JsonValue payload;

  if(m_malwareProtectionPlanIdHasBeenSet)
  {
   payload.WithString("malwareProtectionPlanId", m_malwareProtectionPlanId);

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
