﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/glue/model/CreateIntegrationTablePropertiesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateIntegrationTablePropertiesRequest::CreateIntegrationTablePropertiesRequest() : 
    m_resourceArnHasBeenSet(false),
    m_tableNameHasBeenSet(false),
    m_sourceTableConfigHasBeenSet(false),
    m_targetTableConfigHasBeenSet(false)
{
}

Aws::String CreateIntegrationTablePropertiesRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_resourceArnHasBeenSet)
  {
   payload.WithString("ResourceArn", m_resourceArn);

  }

  if(m_tableNameHasBeenSet)
  {
   payload.WithString("TableName", m_tableName);

  }

  if(m_sourceTableConfigHasBeenSet)
  {
   payload.WithObject("SourceTableConfig", m_sourceTableConfig.Jsonize());

  }

  if(m_targetTableConfigHasBeenSet)
  {
   payload.WithObject("TargetTableConfig", m_targetTableConfig.Jsonize());

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateIntegrationTablePropertiesRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.CreateIntegrationTableProperties"));
  return headers;

}




