﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/glue/model/BatchPutDataQualityStatisticAnnotationResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

BatchPutDataQualityStatisticAnnotationResult::BatchPutDataQualityStatisticAnnotationResult()
{
}

BatchPutDataQualityStatisticAnnotationResult::BatchPutDataQualityStatisticAnnotationResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

BatchPutDataQualityStatisticAnnotationResult& BatchPutDataQualityStatisticAnnotationResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("FailedInclusionAnnotations"))
  {
    Aws::Utils::Array<JsonView> failedInclusionAnnotationsJsonList = jsonValue.GetArray("FailedInclusionAnnotations");
    for(unsigned failedInclusionAnnotationsIndex = 0; failedInclusionAnnotationsIndex < failedInclusionAnnotationsJsonList.GetLength(); ++failedInclusionAnnotationsIndex)
    {
      m_failedInclusionAnnotations.push_back(failedInclusionAnnotationsJsonList[failedInclusionAnnotationsIndex].AsObject());
    }
  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
