﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/directconnect/DirectConnect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/directconnect/model/ConnectionState.h>
#include <aws/core/utils/DateTime.h>
#include <aws/directconnect/model/HasLogicalRedundancy.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/directconnect/model/Tag.h>
#include <aws/directconnect/model/MacSecKey.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace DirectConnect
{
namespace Model
{
  /**
   * <p>Information about an Direct Connect connection.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connection">AWS
   * API Reference</a></p>
   */
  class AssociateConnectionWithLagResult
  {
  public:
    AWS_DIRECTCONNECT_API AssociateConnectionWithLagResult();
    AWS_DIRECTCONNECT_API AssociateConnectionWithLagResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_DIRECTCONNECT_API AssociateConnectionWithLagResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The ID of the Amazon Web Services account that owns the connection.</p>
     */
    inline const Aws::String& GetOwnerAccount() const{ return m_ownerAccount; }
    inline void SetOwnerAccount(const Aws::String& value) { m_ownerAccount = value; }
    inline void SetOwnerAccount(Aws::String&& value) { m_ownerAccount = std::move(value); }
    inline void SetOwnerAccount(const char* value) { m_ownerAccount.assign(value); }
    inline AssociateConnectionWithLagResult& WithOwnerAccount(const Aws::String& value) { SetOwnerAccount(value); return *this;}
    inline AssociateConnectionWithLagResult& WithOwnerAccount(Aws::String&& value) { SetOwnerAccount(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithOwnerAccount(const char* value) { SetOwnerAccount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the connection.</p>
     */
    inline const Aws::String& GetConnectionId() const{ return m_connectionId; }
    inline void SetConnectionId(const Aws::String& value) { m_connectionId = value; }
    inline void SetConnectionId(Aws::String&& value) { m_connectionId = std::move(value); }
    inline void SetConnectionId(const char* value) { m_connectionId.assign(value); }
    inline AssociateConnectionWithLagResult& WithConnectionId(const Aws::String& value) { SetConnectionId(value); return *this;}
    inline AssociateConnectionWithLagResult& WithConnectionId(Aws::String&& value) { SetConnectionId(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithConnectionId(const char* value) { SetConnectionId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the connection.</p>
     */
    inline const Aws::String& GetConnectionName() const{ return m_connectionName; }
    inline void SetConnectionName(const Aws::String& value) { m_connectionName = value; }
    inline void SetConnectionName(Aws::String&& value) { m_connectionName = std::move(value); }
    inline void SetConnectionName(const char* value) { m_connectionName.assign(value); }
    inline AssociateConnectionWithLagResult& WithConnectionName(const Aws::String& value) { SetConnectionName(value); return *this;}
    inline AssociateConnectionWithLagResult& WithConnectionName(Aws::String&& value) { SetConnectionName(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithConnectionName(const char* value) { SetConnectionName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The state of the connection. The following are the possible values:</p> <ul>
     * <li> <p> <code>ordering</code>: The initial state of a hosted connection
     * provisioned on an interconnect. The connection stays in the ordering state until
     * the owner of the hosted connection confirms or declines the connection
     * order.</p> </li> <li> <p> <code>requested</code>: The initial state of a
     * standard connection. The connection stays in the requested state until the
     * Letter of Authorization (LOA) is sent to the customer.</p> </li> <li> <p>
     * <code>pending</code>: The connection has been approved and is being
     * initialized.</p> </li> <li> <p> <code>available</code>: The network link is up
     * and the connection is ready for use.</p> </li> <li> <p> <code>down</code>: The
     * network link is down.</p> </li> <li> <p> <code>deleting</code>: The connection
     * is being deleted.</p> </li> <li> <p> <code>deleted</code>: The connection has
     * been deleted.</p> </li> <li> <p> <code>rejected</code>: A hosted connection in
     * the <code>ordering</code> state enters the <code>rejected</code> state if it is
     * deleted by the customer.</p> </li> <li> <p> <code>unknown</code>: The state of
     * the connection is not available.</p> </li> </ul>
     */
    inline const ConnectionState& GetConnectionState() const{ return m_connectionState; }
    inline void SetConnectionState(const ConnectionState& value) { m_connectionState = value; }
    inline void SetConnectionState(ConnectionState&& value) { m_connectionState = std::move(value); }
    inline AssociateConnectionWithLagResult& WithConnectionState(const ConnectionState& value) { SetConnectionState(value); return *this;}
    inline AssociateConnectionWithLagResult& WithConnectionState(ConnectionState&& value) { SetConnectionState(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Web Services Region where the connection is located.</p>
     */
    inline const Aws::String& GetRegion() const{ return m_region; }
    inline void SetRegion(const Aws::String& value) { m_region = value; }
    inline void SetRegion(Aws::String&& value) { m_region = std::move(value); }
    inline void SetRegion(const char* value) { m_region.assign(value); }
    inline AssociateConnectionWithLagResult& WithRegion(const Aws::String& value) { SetRegion(value); return *this;}
    inline AssociateConnectionWithLagResult& WithRegion(Aws::String&& value) { SetRegion(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithRegion(const char* value) { SetRegion(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The location of the connection.</p>
     */
    inline const Aws::String& GetLocation() const{ return m_location; }
    inline void SetLocation(const Aws::String& value) { m_location = value; }
    inline void SetLocation(Aws::String&& value) { m_location = std::move(value); }
    inline void SetLocation(const char* value) { m_location.assign(value); }
    inline AssociateConnectionWithLagResult& WithLocation(const Aws::String& value) { SetLocation(value); return *this;}
    inline AssociateConnectionWithLagResult& WithLocation(Aws::String&& value) { SetLocation(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithLocation(const char* value) { SetLocation(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The bandwidth of the connection.</p>
     */
    inline const Aws::String& GetBandwidth() const{ return m_bandwidth; }
    inline void SetBandwidth(const Aws::String& value) { m_bandwidth = value; }
    inline void SetBandwidth(Aws::String&& value) { m_bandwidth = std::move(value); }
    inline void SetBandwidth(const char* value) { m_bandwidth.assign(value); }
    inline AssociateConnectionWithLagResult& WithBandwidth(const Aws::String& value) { SetBandwidth(value); return *this;}
    inline AssociateConnectionWithLagResult& WithBandwidth(Aws::String&& value) { SetBandwidth(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithBandwidth(const char* value) { SetBandwidth(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the VLAN.</p>
     */
    inline int GetVlan() const{ return m_vlan; }
    inline void SetVlan(int value) { m_vlan = value; }
    inline AssociateConnectionWithLagResult& WithVlan(int value) { SetVlan(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the Direct Connect service provider associated with the
     * connection.</p>
     */
    inline const Aws::String& GetPartnerName() const{ return m_partnerName; }
    inline void SetPartnerName(const Aws::String& value) { m_partnerName = value; }
    inline void SetPartnerName(Aws::String&& value) { m_partnerName = std::move(value); }
    inline void SetPartnerName(const char* value) { m_partnerName.assign(value); }
    inline AssociateConnectionWithLagResult& WithPartnerName(const Aws::String& value) { SetPartnerName(value); return *this;}
    inline AssociateConnectionWithLagResult& WithPartnerName(Aws::String&& value) { SetPartnerName(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithPartnerName(const char* value) { SetPartnerName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The time of the most recent call to <a>DescribeLoa</a> for this
     * connection.</p>
     */
    inline const Aws::Utils::DateTime& GetLoaIssueTime() const{ return m_loaIssueTime; }
    inline void SetLoaIssueTime(const Aws::Utils::DateTime& value) { m_loaIssueTime = value; }
    inline void SetLoaIssueTime(Aws::Utils::DateTime&& value) { m_loaIssueTime = std::move(value); }
    inline AssociateConnectionWithLagResult& WithLoaIssueTime(const Aws::Utils::DateTime& value) { SetLoaIssueTime(value); return *this;}
    inline AssociateConnectionWithLagResult& WithLoaIssueTime(Aws::Utils::DateTime&& value) { SetLoaIssueTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the LAG.</p>
     */
    inline const Aws::String& GetLagId() const{ return m_lagId; }
    inline void SetLagId(const Aws::String& value) { m_lagId = value; }
    inline void SetLagId(Aws::String&& value) { m_lagId = std::move(value); }
    inline void SetLagId(const char* value) { m_lagId.assign(value); }
    inline AssociateConnectionWithLagResult& WithLagId(const Aws::String& value) { SetLagId(value); return *this;}
    inline AssociateConnectionWithLagResult& WithLagId(Aws::String&& value) { SetLagId(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithLagId(const char* value) { SetLagId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Direct Connect endpoint on which the physical connection terminates.</p>
     */
    inline const Aws::String& GetAwsDevice() const{ return m_awsDevice; }
    inline void SetAwsDevice(const Aws::String& value) { m_awsDevice = value; }
    inline void SetAwsDevice(Aws::String&& value) { m_awsDevice = std::move(value); }
    inline void SetAwsDevice(const char* value) { m_awsDevice.assign(value); }
    inline AssociateConnectionWithLagResult& WithAwsDevice(const Aws::String& value) { SetAwsDevice(value); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsDevice(Aws::String&& value) { SetAwsDevice(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsDevice(const char* value) { SetAwsDevice(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether jumbo frames are supported.</p>
     */
    inline bool GetJumboFrameCapable() const{ return m_jumboFrameCapable; }
    inline void SetJumboFrameCapable(bool value) { m_jumboFrameCapable = value; }
    inline AssociateConnectionWithLagResult& WithJumboFrameCapable(bool value) { SetJumboFrameCapable(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Direct Connect endpoint that terminates the physical connection.</p>
     */
    inline const Aws::String& GetAwsDeviceV2() const{ return m_awsDeviceV2; }
    inline void SetAwsDeviceV2(const Aws::String& value) { m_awsDeviceV2 = value; }
    inline void SetAwsDeviceV2(Aws::String&& value) { m_awsDeviceV2 = std::move(value); }
    inline void SetAwsDeviceV2(const char* value) { m_awsDeviceV2.assign(value); }
    inline AssociateConnectionWithLagResult& WithAwsDeviceV2(const Aws::String& value) { SetAwsDeviceV2(value); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsDeviceV2(Aws::String&& value) { SetAwsDeviceV2(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsDeviceV2(const char* value) { SetAwsDeviceV2(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Direct Connect endpoint that terminates the logical connection. This
     * device might be different than the device that terminates the physical
     * connection.</p>
     */
    inline const Aws::String& GetAwsLogicalDeviceId() const{ return m_awsLogicalDeviceId; }
    inline void SetAwsLogicalDeviceId(const Aws::String& value) { m_awsLogicalDeviceId = value; }
    inline void SetAwsLogicalDeviceId(Aws::String&& value) { m_awsLogicalDeviceId = std::move(value); }
    inline void SetAwsLogicalDeviceId(const char* value) { m_awsLogicalDeviceId.assign(value); }
    inline AssociateConnectionWithLagResult& WithAwsLogicalDeviceId(const Aws::String& value) { SetAwsLogicalDeviceId(value); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsLogicalDeviceId(Aws::String&& value) { SetAwsLogicalDeviceId(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithAwsLogicalDeviceId(const char* value) { SetAwsLogicalDeviceId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether the connection supports a secondary BGP peer in the same
     * address family (IPv4/IPv6).</p>
     */
    inline const HasLogicalRedundancy& GetHasLogicalRedundancy() const{ return m_hasLogicalRedundancy; }
    inline void SetHasLogicalRedundancy(const HasLogicalRedundancy& value) { m_hasLogicalRedundancy = value; }
    inline void SetHasLogicalRedundancy(HasLogicalRedundancy&& value) { m_hasLogicalRedundancy = std::move(value); }
    inline AssociateConnectionWithLagResult& WithHasLogicalRedundancy(const HasLogicalRedundancy& value) { SetHasLogicalRedundancy(value); return *this;}
    inline AssociateConnectionWithLagResult& WithHasLogicalRedundancy(HasLogicalRedundancy&& value) { SetHasLogicalRedundancy(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The tags associated with the connection.</p>
     */
    inline const Aws::Vector<Tag>& GetTags() const{ return m_tags; }
    inline void SetTags(const Aws::Vector<Tag>& value) { m_tags = value; }
    inline void SetTags(Aws::Vector<Tag>&& value) { m_tags = std::move(value); }
    inline AssociateConnectionWithLagResult& WithTags(const Aws::Vector<Tag>& value) { SetTags(value); return *this;}
    inline AssociateConnectionWithLagResult& WithTags(Aws::Vector<Tag>&& value) { SetTags(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& AddTags(const Tag& value) { m_tags.push_back(value); return *this; }
    inline AssociateConnectionWithLagResult& AddTags(Tag&& value) { m_tags.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The name of the service provider associated with the connection.</p>
     */
    inline const Aws::String& GetProviderName() const{ return m_providerName; }
    inline void SetProviderName(const Aws::String& value) { m_providerName = value; }
    inline void SetProviderName(Aws::String&& value) { m_providerName = std::move(value); }
    inline void SetProviderName(const char* value) { m_providerName.assign(value); }
    inline AssociateConnectionWithLagResult& WithProviderName(const Aws::String& value) { SetProviderName(value); return *this;}
    inline AssociateConnectionWithLagResult& WithProviderName(Aws::String&& value) { SetProviderName(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithProviderName(const char* value) { SetProviderName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether the connection supports MAC Security (MACsec).</p>
     */
    inline bool GetMacSecCapable() const{ return m_macSecCapable; }
    inline void SetMacSecCapable(bool value) { m_macSecCapable = value; }
    inline AssociateConnectionWithLagResult& WithMacSecCapable(bool value) { SetMacSecCapable(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The MAC Security (MACsec) port link status of the connection.</p> <p>The
     * valid values are <code>Encryption Up</code>, which means that there is an active
     * Connection Key Name, or <code>Encryption Down</code>.</p>
     */
    inline const Aws::String& GetPortEncryptionStatus() const{ return m_portEncryptionStatus; }
    inline void SetPortEncryptionStatus(const Aws::String& value) { m_portEncryptionStatus = value; }
    inline void SetPortEncryptionStatus(Aws::String&& value) { m_portEncryptionStatus = std::move(value); }
    inline void SetPortEncryptionStatus(const char* value) { m_portEncryptionStatus.assign(value); }
    inline AssociateConnectionWithLagResult& WithPortEncryptionStatus(const Aws::String& value) { SetPortEncryptionStatus(value); return *this;}
    inline AssociateConnectionWithLagResult& WithPortEncryptionStatus(Aws::String&& value) { SetPortEncryptionStatus(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithPortEncryptionStatus(const char* value) { SetPortEncryptionStatus(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The MAC Security (MACsec) connection encryption mode.</p> <p>The valid values
     * are <code>no_encrypt</code>, <code>should_encrypt</code>, and
     * <code>must_encrypt</code>.</p>
     */
    inline const Aws::String& GetEncryptionMode() const{ return m_encryptionMode; }
    inline void SetEncryptionMode(const Aws::String& value) { m_encryptionMode = value; }
    inline void SetEncryptionMode(Aws::String&& value) { m_encryptionMode = std::move(value); }
    inline void SetEncryptionMode(const char* value) { m_encryptionMode.assign(value); }
    inline AssociateConnectionWithLagResult& WithEncryptionMode(const Aws::String& value) { SetEncryptionMode(value); return *this;}
    inline AssociateConnectionWithLagResult& WithEncryptionMode(Aws::String&& value) { SetEncryptionMode(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithEncryptionMode(const char* value) { SetEncryptionMode(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The MAC Security (MACsec) security keys associated with the connection.</p>
     */
    inline const Aws::Vector<MacSecKey>& GetMacSecKeys() const{ return m_macSecKeys; }
    inline void SetMacSecKeys(const Aws::Vector<MacSecKey>& value) { m_macSecKeys = value; }
    inline void SetMacSecKeys(Aws::Vector<MacSecKey>&& value) { m_macSecKeys = std::move(value); }
    inline AssociateConnectionWithLagResult& WithMacSecKeys(const Aws::Vector<MacSecKey>& value) { SetMacSecKeys(value); return *this;}
    inline AssociateConnectionWithLagResult& WithMacSecKeys(Aws::Vector<MacSecKey>&& value) { SetMacSecKeys(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& AddMacSecKeys(const MacSecKey& value) { m_macSecKeys.push_back(value); return *this; }
    inline AssociateConnectionWithLagResult& AddMacSecKeys(MacSecKey&& value) { m_macSecKeys.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline AssociateConnectionWithLagResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline AssociateConnectionWithLagResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline AssociateConnectionWithLagResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_ownerAccount;

    Aws::String m_connectionId;

    Aws::String m_connectionName;

    ConnectionState m_connectionState;

    Aws::String m_region;

    Aws::String m_location;

    Aws::String m_bandwidth;

    int m_vlan;

    Aws::String m_partnerName;

    Aws::Utils::DateTime m_loaIssueTime;

    Aws::String m_lagId;

    Aws::String m_awsDevice;

    bool m_jumboFrameCapable;

    Aws::String m_awsDeviceV2;

    Aws::String m_awsLogicalDeviceId;

    HasLogicalRedundancy m_hasLogicalRedundancy;

    Aws::Vector<Tag> m_tags;

    Aws::String m_providerName;

    bool m_macSecCapable;

    Aws::String m_portEncryptionStatus;

    Aws::String m_encryptionMode;

    Aws::Vector<MacSecKey> m_macSecKeys;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace DirectConnect
} // namespace Aws
