﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/workspaces-web/model/ListDataProtectionSettingsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::WorkSpacesWeb::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDataProtectionSettingsResult::ListDataProtectionSettingsResult()
{
}

ListDataProtectionSettingsResult::ListDataProtectionSettingsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListDataProtectionSettingsResult& ListDataProtectionSettingsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("dataProtectionSettings"))
  {
    Aws::Utils::Array<JsonView> dataProtectionSettingsJsonList = jsonValue.GetArray("dataProtectionSettings");
    for(unsigned dataProtectionSettingsIndex = 0; dataProtectionSettingsIndex < dataProtectionSettingsJsonList.GetLength(); ++dataProtectionSettingsIndex)
    {
      m_dataProtectionSettings.push_back(dataProtectionSettingsJsonList[dataProtectionSettingsIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("nextToken"))
  {
    m_nextToken = jsonValue.GetString("nextToken");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
