﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sms/SMS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sms/model/ReplicationJob.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SMS
{
namespace Model
{
  class GetReplicationJobsResult
  {
  public:
    AWS_SMS_API GetReplicationJobsResult();
    AWS_SMS_API GetReplicationJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SMS_API GetReplicationJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Information about the replication jobs.</p>
     */
    inline const Aws::Vector<ReplicationJob>& GetReplicationJobList() const{ return m_replicationJobList; }
    inline void SetReplicationJobList(const Aws::Vector<ReplicationJob>& value) { m_replicationJobList = value; }
    inline void SetReplicationJobList(Aws::Vector<ReplicationJob>&& value) { m_replicationJobList = std::move(value); }
    inline GetReplicationJobsResult& WithReplicationJobList(const Aws::Vector<ReplicationJob>& value) { SetReplicationJobList(value); return *this;}
    inline GetReplicationJobsResult& WithReplicationJobList(Aws::Vector<ReplicationJob>&& value) { SetReplicationJobList(std::move(value)); return *this;}
    inline GetReplicationJobsResult& AddReplicationJobList(const ReplicationJob& value) { m_replicationJobList.push_back(value); return *this; }
    inline GetReplicationJobsResult& AddReplicationJobList(ReplicationJob&& value) { m_replicationJobList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token required to retrieve the next set of results. This value is null
     * when there are no more results to return.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline GetReplicationJobsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetReplicationJobsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetReplicationJobsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetReplicationJobsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetReplicationJobsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetReplicationJobsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<ReplicationJob> m_replicationJobList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SMS
} // namespace Aws
