﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/VulnerabilityExploitAvailable.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SecurityHub
  {
    namespace Model
    {
      namespace VulnerabilityExploitAvailableMapper
      {

        static const int YES_HASH = HashingUtils::HashString("YES");
        static const int NO_HASH = HashingUtils::HashString("NO");


        VulnerabilityExploitAvailable GetVulnerabilityExploitAvailableForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == YES_HASH)
          {
            return VulnerabilityExploitAvailable::YES;
          }
          else if (hashCode == NO_HASH)
          {
            return VulnerabilityExploitAvailable::NO;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<VulnerabilityExploitAvailable>(hashCode);
          }

          return VulnerabilityExploitAvailable::NOT_SET;
        }

        Aws::String GetNameForVulnerabilityExploitAvailable(VulnerabilityExploitAvailable enumValue)
        {
          switch(enumValue)
          {
          case VulnerabilityExploitAvailable::NOT_SET:
            return {};
          case VulnerabilityExploitAvailable::YES:
            return "YES";
          case VulnerabilityExploitAvailable::NO:
            return "NO";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace VulnerabilityExploitAvailableMapper
    } // namespace Model
  } // namespace SecurityHub
} // namespace Aws
