﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediaconvert/model/H264RepeatPps.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaConvert
  {
    namespace Model
    {
      namespace H264RepeatPpsMapper
      {

        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");
        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");


        H264RepeatPps GetH264RepeatPpsForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == DISABLED_HASH)
          {
            return H264RepeatPps::DISABLED;
          }
          else if (hashCode == ENABLED_HASH)
          {
            return H264RepeatPps::ENABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<H264RepeatPps>(hashCode);
          }

          return H264RepeatPps::NOT_SET;
        }

        Aws::String GetNameForH264RepeatPps(H264RepeatPps enumValue)
        {
          switch(enumValue)
          {
          case H264RepeatPps::NOT_SET:
            return {};
          case H264RepeatPps::DISABLED:
            return "DISABLED";
          case H264RepeatPps::ENABLED:
            return "ENABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace H264RepeatPpsMapper
    } // namespace Model
  } // namespace MediaConvert
} // namespace Aws
