﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/keyspaces/model/UpdateKeyspaceRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Keyspaces::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateKeyspaceRequest::UpdateKeyspaceRequest() : 
    m_keyspaceNameHasBeenSet(false),
    m_replicationSpecificationHasBeenSet(false),
    m_clientSideTimestampsHasBeenSet(false)
{
}

Aws::String UpdateKeyspaceRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_keyspaceNameHasBeenSet)
  {
   payload.WithString("keyspaceName", m_keyspaceName);

  }

  if(m_replicationSpecificationHasBeenSet)
  {
   payload.WithObject("replicationSpecification", m_replicationSpecification.Jsonize());

  }

  if(m_clientSideTimestampsHasBeenSet)
  {
   payload.WithObject("clientSideTimestamps", m_clientSideTimestamps.Jsonize());

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateKeyspaceRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "KeyspacesService.UpdateKeyspace"));
  return headers;

}




