﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ivs-realtime/model/IngestConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ivsrealtime
{
namespace Model
{

IngestConfiguration::IngestConfiguration() : 
    m_nameHasBeenSet(false),
    m_arnHasBeenSet(false),
    m_ingestProtocol(IngestProtocol::NOT_SET),
    m_ingestProtocolHasBeenSet(false),
    m_streamKeyHasBeenSet(false),
    m_stageArnHasBeenSet(false),
    m_participantIdHasBeenSet(false),
    m_state(IngestConfigurationState::NOT_SET),
    m_stateHasBeenSet(false),
    m_userIdHasBeenSet(false),
    m_attributesHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

IngestConfiguration::IngestConfiguration(JsonView jsonValue)
  : IngestConfiguration()
{
  *this = jsonValue;
}

IngestConfiguration& IngestConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("name"))
  {
    m_name = jsonValue.GetString("name");

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("arn"))
  {
    m_arn = jsonValue.GetString("arn");

    m_arnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("ingestProtocol"))
  {
    m_ingestProtocol = IngestProtocolMapper::GetIngestProtocolForName(jsonValue.GetString("ingestProtocol"));

    m_ingestProtocolHasBeenSet = true;
  }

  if(jsonValue.ValueExists("streamKey"))
  {
    m_streamKey = jsonValue.GetString("streamKey");

    m_streamKeyHasBeenSet = true;
  }

  if(jsonValue.ValueExists("stageArn"))
  {
    m_stageArn = jsonValue.GetString("stageArn");

    m_stageArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("participantId"))
  {
    m_participantId = jsonValue.GetString("participantId");

    m_participantIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("state"))
  {
    m_state = IngestConfigurationStateMapper::GetIngestConfigurationStateForName(jsonValue.GetString("state"));

    m_stateHasBeenSet = true;
  }

  if(jsonValue.ValueExists("userId"))
  {
    m_userId = jsonValue.GetString("userId");

    m_userIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("attributes"))
  {
    Aws::Map<Aws::String, JsonView> attributesJsonMap = jsonValue.GetObject("attributes").GetAllObjects();
    for(auto& attributesItem : attributesJsonMap)
    {
      m_attributes[attributesItem.first] = attributesItem.second.AsString();
    }
    m_attributesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("tags"))
  {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for(auto& tagsItem : tagsJsonMap)
    {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }

  return *this;
}

JsonValue IngestConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_arnHasBeenSet)
  {
   payload.WithString("arn", m_arn);

  }

  if(m_ingestProtocolHasBeenSet)
  {
   payload.WithString("ingestProtocol", IngestProtocolMapper::GetNameForIngestProtocol(m_ingestProtocol));
  }

  if(m_streamKeyHasBeenSet)
  {
   payload.WithString("streamKey", m_streamKey);

  }

  if(m_stageArnHasBeenSet)
  {
   payload.WithString("stageArn", m_stageArn);

  }

  if(m_participantIdHasBeenSet)
  {
   payload.WithString("participantId", m_participantId);

  }

  if(m_stateHasBeenSet)
  {
   payload.WithString("state", IngestConfigurationStateMapper::GetNameForIngestConfigurationState(m_state));
  }

  if(m_userIdHasBeenSet)
  {
   payload.WithString("userId", m_userId);

  }

  if(m_attributesHasBeenSet)
  {
   JsonValue attributesJsonMap;
   for(auto& attributesItem : m_attributes)
   {
     attributesJsonMap.WithString(attributesItem.first, attributesItem.second);
   }
   payload.WithObject("attributes", std::move(attributesJsonMap));

  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("tags", std::move(tagsJsonMap));

  }

  return payload;
}

} // namespace Model
} // namespace ivsrealtime
} // namespace Aws
