﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionPlanStatusReason.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

MalwareProtectionPlanStatusReason::MalwareProtectionPlanStatusReason() : 
    m_codeHasBeenSet(false),
    m_messageHasBeenSet(false)
{
}

MalwareProtectionPlanStatusReason::MalwareProtectionPlanStatusReason(JsonView jsonValue)
  : MalwareProtectionPlanStatusReason()
{
  *this = jsonValue;
}

MalwareProtectionPlanStatusReason& MalwareProtectionPlanStatusReason::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("code"))
  {
    m_code = jsonValue.GetString("code");

    m_codeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("message"))
  {
    m_message = jsonValue.GetString("message");

    m_messageHasBeenSet = true;
  }

  return *this;
}

JsonValue MalwareProtectionPlanStatusReason::Jsonize() const
{
  JsonValue payload;

  if(m_codeHasBeenSet)
  {
   payload.WithString("code", m_code);

  }

  if(m_messageHasBeenSet)
  {
   payload.WithString("message", m_message);

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
