﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/model/TaskRun.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{
  class GetMLTaskRunsResult
  {
  public:
    AWS_GLUE_API GetMLTaskRunsResult();
    AWS_GLUE_API GetMLTaskRunsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GLUE_API GetMLTaskRunsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of task runs that are associated with the transform.</p>
     */
    inline const Aws::Vector<TaskRun>& GetTaskRuns() const{ return m_taskRuns; }
    inline void SetTaskRuns(const Aws::Vector<TaskRun>& value) { m_taskRuns = value; }
    inline void SetTaskRuns(Aws::Vector<TaskRun>&& value) { m_taskRuns = std::move(value); }
    inline GetMLTaskRunsResult& WithTaskRuns(const Aws::Vector<TaskRun>& value) { SetTaskRuns(value); return *this;}
    inline GetMLTaskRunsResult& WithTaskRuns(Aws::Vector<TaskRun>&& value) { SetTaskRuns(std::move(value)); return *this;}
    inline GetMLTaskRunsResult& AddTaskRuns(const TaskRun& value) { m_taskRuns.push_back(value); return *this; }
    inline GetMLTaskRunsResult& AddTaskRuns(TaskRun&& value) { m_taskRuns.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A pagination token, if more results are available.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline GetMLTaskRunsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetMLTaskRunsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetMLTaskRunsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetMLTaskRunsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetMLTaskRunsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetMLTaskRunsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<TaskRun> m_taskRuns;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
