﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/model/DataSource.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/model/DataQualityRuleResult.h>
#include <aws/glue/model/DataQualityAnalyzerResult.h>
#include <aws/glue/model/DataQualityObservation.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{
  class GetDataQualityResultResult
  {
  public:
    AWS_GLUE_API GetDataQualityResultResult();
    AWS_GLUE_API GetDataQualityResultResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GLUE_API GetDataQualityResultResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A unique result ID for the data quality result.</p>
     */
    inline const Aws::String& GetResultId() const{ return m_resultId; }
    inline void SetResultId(const Aws::String& value) { m_resultId = value; }
    inline void SetResultId(Aws::String&& value) { m_resultId = std::move(value); }
    inline void SetResultId(const char* value) { m_resultId.assign(value); }
    inline GetDataQualityResultResult& WithResultId(const Aws::String& value) { SetResultId(value); return *this;}
    inline GetDataQualityResultResult& WithResultId(Aws::String&& value) { SetResultId(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithResultId(const char* value) { SetResultId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Profile ID for the data quality result.</p>
     */
    inline const Aws::String& GetProfileId() const{ return m_profileId; }
    inline void SetProfileId(const Aws::String& value) { m_profileId = value; }
    inline void SetProfileId(Aws::String&& value) { m_profileId = std::move(value); }
    inline void SetProfileId(const char* value) { m_profileId.assign(value); }
    inline GetDataQualityResultResult& WithProfileId(const Aws::String& value) { SetProfileId(value); return *this;}
    inline GetDataQualityResultResult& WithProfileId(Aws::String&& value) { SetProfileId(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithProfileId(const char* value) { SetProfileId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An aggregate data quality score. Represents the ratio of rules that passed to
     * the total number of rules.</p>
     */
    inline double GetScore() const{ return m_score; }
    inline void SetScore(double value) { m_score = value; }
    inline GetDataQualityResultResult& WithScore(double value) { SetScore(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The table associated with the data quality result, if any.</p>
     */
    inline const DataSource& GetDataSource() const{ return m_dataSource; }
    inline void SetDataSource(const DataSource& value) { m_dataSource = value; }
    inline void SetDataSource(DataSource&& value) { m_dataSource = std::move(value); }
    inline GetDataQualityResultResult& WithDataSource(const DataSource& value) { SetDataSource(value); return *this;}
    inline GetDataQualityResultResult& WithDataSource(DataSource&& value) { SetDataSource(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the ruleset associated with the data quality result.</p>
     */
    inline const Aws::String& GetRulesetName() const{ return m_rulesetName; }
    inline void SetRulesetName(const Aws::String& value) { m_rulesetName = value; }
    inline void SetRulesetName(Aws::String&& value) { m_rulesetName = std::move(value); }
    inline void SetRulesetName(const char* value) { m_rulesetName.assign(value); }
    inline GetDataQualityResultResult& WithRulesetName(const Aws::String& value) { SetRulesetName(value); return *this;}
    inline GetDataQualityResultResult& WithRulesetName(Aws::String&& value) { SetRulesetName(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithRulesetName(const char* value) { SetRulesetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>In the context of a job in Glue Studio, each node in the canvas is typically
     * assigned some sort of name and data quality nodes will have names. In the case
     * of multiple nodes, the <code>evaluationContext</code> can differentiate the
     * nodes.</p>
     */
    inline const Aws::String& GetEvaluationContext() const{ return m_evaluationContext; }
    inline void SetEvaluationContext(const Aws::String& value) { m_evaluationContext = value; }
    inline void SetEvaluationContext(Aws::String&& value) { m_evaluationContext = std::move(value); }
    inline void SetEvaluationContext(const char* value) { m_evaluationContext.assign(value); }
    inline GetDataQualityResultResult& WithEvaluationContext(const Aws::String& value) { SetEvaluationContext(value); return *this;}
    inline GetDataQualityResultResult& WithEvaluationContext(Aws::String&& value) { SetEvaluationContext(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithEvaluationContext(const char* value) { SetEvaluationContext(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time when the run for this data quality result started.</p>
     */
    inline const Aws::Utils::DateTime& GetStartedOn() const{ return m_startedOn; }
    inline void SetStartedOn(const Aws::Utils::DateTime& value) { m_startedOn = value; }
    inline void SetStartedOn(Aws::Utils::DateTime&& value) { m_startedOn = std::move(value); }
    inline GetDataQualityResultResult& WithStartedOn(const Aws::Utils::DateTime& value) { SetStartedOn(value); return *this;}
    inline GetDataQualityResultResult& WithStartedOn(Aws::Utils::DateTime&& value) { SetStartedOn(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time when the run for this data quality result was
     * completed.</p>
     */
    inline const Aws::Utils::DateTime& GetCompletedOn() const{ return m_completedOn; }
    inline void SetCompletedOn(const Aws::Utils::DateTime& value) { m_completedOn = value; }
    inline void SetCompletedOn(Aws::Utils::DateTime&& value) { m_completedOn = std::move(value); }
    inline GetDataQualityResultResult& WithCompletedOn(const Aws::Utils::DateTime& value) { SetCompletedOn(value); return *this;}
    inline GetDataQualityResultResult& WithCompletedOn(Aws::Utils::DateTime&& value) { SetCompletedOn(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job name associated with the data quality result, if any.</p>
     */
    inline const Aws::String& GetJobName() const{ return m_jobName; }
    inline void SetJobName(const Aws::String& value) { m_jobName = value; }
    inline void SetJobName(Aws::String&& value) { m_jobName = std::move(value); }
    inline void SetJobName(const char* value) { m_jobName.assign(value); }
    inline GetDataQualityResultResult& WithJobName(const Aws::String& value) { SetJobName(value); return *this;}
    inline GetDataQualityResultResult& WithJobName(Aws::String&& value) { SetJobName(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithJobName(const char* value) { SetJobName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job run ID associated with the data quality result, if any.</p>
     */
    inline const Aws::String& GetJobRunId() const{ return m_jobRunId; }
    inline void SetJobRunId(const Aws::String& value) { m_jobRunId = value; }
    inline void SetJobRunId(Aws::String&& value) { m_jobRunId = std::move(value); }
    inline void SetJobRunId(const char* value) { m_jobRunId.assign(value); }
    inline GetDataQualityResultResult& WithJobRunId(const Aws::String& value) { SetJobRunId(value); return *this;}
    inline GetDataQualityResultResult& WithJobRunId(Aws::String&& value) { SetJobRunId(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithJobRunId(const char* value) { SetJobRunId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The unique run ID associated with the ruleset evaluation.</p>
     */
    inline const Aws::String& GetRulesetEvaluationRunId() const{ return m_rulesetEvaluationRunId; }
    inline void SetRulesetEvaluationRunId(const Aws::String& value) { m_rulesetEvaluationRunId = value; }
    inline void SetRulesetEvaluationRunId(Aws::String&& value) { m_rulesetEvaluationRunId = std::move(value); }
    inline void SetRulesetEvaluationRunId(const char* value) { m_rulesetEvaluationRunId.assign(value); }
    inline GetDataQualityResultResult& WithRulesetEvaluationRunId(const Aws::String& value) { SetRulesetEvaluationRunId(value); return *this;}
    inline GetDataQualityResultResult& WithRulesetEvaluationRunId(Aws::String&& value) { SetRulesetEvaluationRunId(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithRulesetEvaluationRunId(const char* value) { SetRulesetEvaluationRunId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of <code>DataQualityRuleResult</code> objects representing the results
     * for each rule. </p>
     */
    inline const Aws::Vector<DataQualityRuleResult>& GetRuleResults() const{ return m_ruleResults; }
    inline void SetRuleResults(const Aws::Vector<DataQualityRuleResult>& value) { m_ruleResults = value; }
    inline void SetRuleResults(Aws::Vector<DataQualityRuleResult>&& value) { m_ruleResults = std::move(value); }
    inline GetDataQualityResultResult& WithRuleResults(const Aws::Vector<DataQualityRuleResult>& value) { SetRuleResults(value); return *this;}
    inline GetDataQualityResultResult& WithRuleResults(Aws::Vector<DataQualityRuleResult>&& value) { SetRuleResults(std::move(value)); return *this;}
    inline GetDataQualityResultResult& AddRuleResults(const DataQualityRuleResult& value) { m_ruleResults.push_back(value); return *this; }
    inline GetDataQualityResultResult& AddRuleResults(DataQualityRuleResult&& value) { m_ruleResults.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of <code>DataQualityAnalyzerResult</code> objects representing the
     * results for each analyzer. </p>
     */
    inline const Aws::Vector<DataQualityAnalyzerResult>& GetAnalyzerResults() const{ return m_analyzerResults; }
    inline void SetAnalyzerResults(const Aws::Vector<DataQualityAnalyzerResult>& value) { m_analyzerResults = value; }
    inline void SetAnalyzerResults(Aws::Vector<DataQualityAnalyzerResult>&& value) { m_analyzerResults = std::move(value); }
    inline GetDataQualityResultResult& WithAnalyzerResults(const Aws::Vector<DataQualityAnalyzerResult>& value) { SetAnalyzerResults(value); return *this;}
    inline GetDataQualityResultResult& WithAnalyzerResults(Aws::Vector<DataQualityAnalyzerResult>&& value) { SetAnalyzerResults(std::move(value)); return *this;}
    inline GetDataQualityResultResult& AddAnalyzerResults(const DataQualityAnalyzerResult& value) { m_analyzerResults.push_back(value); return *this; }
    inline GetDataQualityResultResult& AddAnalyzerResults(DataQualityAnalyzerResult&& value) { m_analyzerResults.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of <code>DataQualityObservation</code> objects representing the
     * observations generated after evaluating the rules and analyzers. </p>
     */
    inline const Aws::Vector<DataQualityObservation>& GetObservations() const{ return m_observations; }
    inline void SetObservations(const Aws::Vector<DataQualityObservation>& value) { m_observations = value; }
    inline void SetObservations(Aws::Vector<DataQualityObservation>&& value) { m_observations = std::move(value); }
    inline GetDataQualityResultResult& WithObservations(const Aws::Vector<DataQualityObservation>& value) { SetObservations(value); return *this;}
    inline GetDataQualityResultResult& WithObservations(Aws::Vector<DataQualityObservation>&& value) { SetObservations(std::move(value)); return *this;}
    inline GetDataQualityResultResult& AddObservations(const DataQualityObservation& value) { m_observations.push_back(value); return *this; }
    inline GetDataQualityResultResult& AddObservations(DataQualityObservation&& value) { m_observations.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetDataQualityResultResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetDataQualityResultResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetDataQualityResultResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_resultId;

    Aws::String m_profileId;

    double m_score;

    DataSource m_dataSource;

    Aws::String m_rulesetName;

    Aws::String m_evaluationContext;

    Aws::Utils::DateTime m_startedOn;

    Aws::Utils::DateTime m_completedOn;

    Aws::String m_jobName;

    Aws::String m_jobRunId;

    Aws::String m_rulesetEvaluationRunId;

    Aws::Vector<DataQualityRuleResult> m_ruleResults;

    Aws::Vector<DataQualityAnalyzerResult> m_analyzerResults;

    Aws::Vector<DataQualityObservation> m_observations;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
