﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/DomainUnitTarget.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace DataZone
{
namespace Model
{

DomainUnitTarget::DomainUnitTarget() : 
    m_domainUnitIdHasBeenSet(false),
    m_includeChildDomainUnits(false),
    m_includeChildDomainUnitsHasBeenSet(false)
{
}

DomainUnitTarget::DomainUnitTarget(JsonView jsonValue)
  : DomainUnitTarget()
{
  *this = jsonValue;
}

DomainUnitTarget& DomainUnitTarget::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("domainUnitId"))
  {
    m_domainUnitId = jsonValue.GetString("domainUnitId");

    m_domainUnitIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("includeChildDomainUnits"))
  {
    m_includeChildDomainUnits = jsonValue.GetBool("includeChildDomainUnits");

    m_includeChildDomainUnitsHasBeenSet = true;
  }

  return *this;
}

JsonValue DomainUnitTarget::Jsonize() const
{
  JsonValue payload;

  if(m_domainUnitIdHasBeenSet)
  {
   payload.WithString("domainUnitId", m_domainUnitId);

  }

  if(m_includeChildDomainUnitsHasBeenSet)
  {
   payload.WithBool("includeChildDomainUnits", m_includeChildDomainUnits);

  }

  return payload;
}

} // namespace Model
} // namespace DataZone
} // namespace Aws
