﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/TextToSqlKnowledgeBaseConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockAgentRuntime
{
namespace Model
{

TextToSqlKnowledgeBaseConfiguration::TextToSqlKnowledgeBaseConfiguration() : 
    m_knowledgeBaseArnHasBeenSet(false)
{
}

TextToSqlKnowledgeBaseConfiguration::TextToSqlKnowledgeBaseConfiguration(JsonView jsonValue)
  : TextToSqlKnowledgeBaseConfiguration()
{
  *this = jsonValue;
}

TextToSqlKnowledgeBaseConfiguration& TextToSqlKnowledgeBaseConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("knowledgeBaseArn"))
  {
    m_knowledgeBaseArn = jsonValue.GetString("knowledgeBaseArn");

    m_knowledgeBaseArnHasBeenSet = true;
  }

  return *this;
}

JsonValue TextToSqlKnowledgeBaseConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_knowledgeBaseArnHasBeenSet)
  {
   payload.WithString("knowledgeBaseArn", m_knowledgeBaseArn);

  }

  return payload;
}

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
