﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/b2bi/model/CreateTransformerRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::B2BI::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateTransformerRequest::CreateTransformerRequest() : 
    m_nameHasBeenSet(false),
    m_clientToken(Aws::Utils::UUID::PseudoRandomUUID()),
    m_clientTokenHasBeenSet(true),
    m_tagsHasBeenSet(false),
    m_inputConversionHasBeenSet(false),
    m_mappingHasBeenSet(false),
    m_outputConversionHasBeenSet(false),
    m_sampleDocumentsHasBeenSet(false)
{
}

Aws::String CreateTransformerRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_clientTokenHasBeenSet)
  {
   payload.WithString("clientToken", m_clientToken);

  }

  if(m_tagsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
   for(unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex)
   {
     tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
   }
   payload.WithArray("tags", std::move(tagsJsonList));

  }

  if(m_inputConversionHasBeenSet)
  {
   payload.WithObject("inputConversion", m_inputConversion.Jsonize());

  }

  if(m_mappingHasBeenSet)
  {
   payload.WithObject("mapping", m_mapping.Jsonize());

  }

  if(m_outputConversionHasBeenSet)
  {
   payload.WithObject("outputConversion", m_outputConversion.Jsonize());

  }

  if(m_sampleDocumentsHasBeenSet)
  {
   payload.WithObject("sampleDocuments", m_sampleDocuments.Jsonize());

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateTransformerRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "B2BI.CreateTransformer"));
  return headers;

}




