#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
/*
 * genericactors.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#include "flow/FastRef.h"
#include "flow/network.h"
#include <utility>
#include <functional>
#include <unordered_set>
#if defined(NO_INTELLISENSE) && !defined(FLOW_GENERICACTORS_ACTOR_G_H)
#define FLOW_GENERICACTORS_ACTOR_G_H
#include "flow/genericactors.actor.g.h"
#elif !defined(GENERICACTORS_ACTOR_H)
#define GENERICACTORS_ACTOR_H

#include <list>
#include <utility>

#include "flow/flow.h"
#include "flow/Knobs.h"
#include "flow/Util.h"
#include "flow/IndexedSet.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#ifdef _MSC_VER
#pragma warning(disable : 4355) // 'this' : used in base member initializer list
#endif

															#line 51 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via traceAfter()
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class TraceAfterActor>
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterActorState {
															#line 58 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterActorState(Future<T> const& what,const char* const& type,const char* const& key,X const& value,bool const& traceErrors = false) 
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   type(type),
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   traceErrors(traceErrors)
															#line 73 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("traceAfter", reinterpret_cast<unsigned long>(this));

	}
	~TraceAfterActorState() 
	{
		fdb_probe_actor_destroy("traceAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 52 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 52 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TraceAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 91 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TraceAfterActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceAfterActor, 0, T >*>(static_cast<TraceAfterActor*>(this)));
															#line 96 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (traceErrors)
															#line 126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 57 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(type).errorUnsuppressed(e).detail(key, value);
															#line 130 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 58 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 134 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		TraceEvent(type).detail(key, value);
															#line 54 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterActorState(); static_cast<TraceAfterActor*>(this)->destroy(); return 0; }
															#line 150 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterActor*>(this)->SAV< T >::value()) T(val);
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		TraceEvent(type).detail(key, value);
															#line 54 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterActorState(); static_cast<TraceAfterActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterActor*>(this)->SAV< T >::value()) T(val);
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceAfterActor*>(this)->actor_wait_state > 0) static_cast<TraceAfterActor*>(this)->actor_wait_state = 0;
		static_cast<TraceAfterActor*>(this)->ActorCallback< TraceAfterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TraceAfterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceAfterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceAfterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* type;
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* key;
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X value;
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool traceErrors;
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via traceAfter()
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterActor final : public Actor<T>, public ActorCallback< TraceAfterActor<T, X>, 0, T >, public FastAllocated<TraceAfterActor<T, X>>, public TraceAfterActorState<T, X, TraceAfterActor<T, X>> {
															#line 252 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TraceAfterActor<T, X>>::operator new;
	using FastAllocated<TraceAfterActor<T, X>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceAfterActor<T, X>, 0, T >;
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterActor(Future<T> const& what,const char* const& type,const char* const& key,X const& value,bool const& traceErrors = false) 
															#line 263 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TraceAfterActorState<T, X, TraceAfterActor<T, X>>(what, type, key, value, traceErrors)
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceAfterActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> traceAfter( Future<T> const& what, const char* const& type, const char* const& key, X const& value, bool const& traceErrors = false ) {
															#line 49 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TraceAfterActor<T, X>(what, type, key, value, traceErrors));
															#line 293 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 61 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 298 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via traceAfterCall()
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class TraceAfterCallActor>
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterCallActorState {
															#line 305 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterCallActorState(Future<T> const& what,const char* const& type,const char* const& key,X const& func,bool const& traceErrors = false) 
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   type(type),
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func),
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   traceErrors(traceErrors)
															#line 320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("traceAfterCall", reinterpret_cast<unsigned long>(this));

	}
	~TraceAfterCallActorState() 
	{
		fdb_probe_actor_destroy("traceAfterCall", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 65 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 65 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TraceAfterCallActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 338 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TraceAfterCallActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceAfterCallActor, 0, T >*>(static_cast<TraceAfterCallActor*>(this)));
															#line 343 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceAfterCallActorState();
		static_cast<TraceAfterCallActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (traceErrors)
															#line 373 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 74 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(type).errorUnsuppressed(e);
															#line 377 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 75 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 67 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(type).detail(key, func(val));
															#line 396 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(T const& __val,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = __val;
															#line 411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceAfterCallActor*>(this)->actor_wait_state > 0) static_cast<TraceAfterCallActor*>(this)->actor_wait_state = 0;
		static_cast<TraceAfterCallActor*>(this)->ActorCallback< TraceAfterCallActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TraceAfterCallActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceAfterCallActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceAfterCallActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 71 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterCallActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterCallActorState(); static_cast<TraceAfterCallActor*>(this)->destroy(); return 0; }
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterCallActor*>(this)->SAV< T >::value()) T(std::move(val)); // state_var_RVO
		this->~TraceAfterCallActorState();
		static_cast<TraceAfterCallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevError, "TraceAfterCallError").error(e);
															#line 491 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* type;
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* key;
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X func;
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool traceErrors;
															#line 65 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 527 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via traceAfterCall()
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterCallActor final : public Actor<T>, public ActorCallback< TraceAfterCallActor<T, X>, 0, T >, public FastAllocated<TraceAfterCallActor<T, X>>, public TraceAfterCallActorState<T, X, TraceAfterCallActor<T, X>> {
															#line 534 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TraceAfterCallActor<T, X>>::operator new;
	using FastAllocated<TraceAfterCallActor<T, X>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceAfterCallActor<T, X>, 0, T >;
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterCallActor(Future<T> const& what,const char* const& type,const char* const& key,X const& func,bool const& traceErrors = false) 
															#line 545 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TraceAfterCallActorState<T, X, TraceAfterCallActor<T, X>>(what, type, key, func, traceErrors)
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceAfterCall");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceAfterCallActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> traceAfterCall( Future<T> const& what, const char* const& type, const char* const& key, X const& func, bool const& traceErrors = false ) {
															#line 62 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TraceAfterCallActor<T, X>(what, type, key, func, traceErrors));
															#line 575 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 78 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 580 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via stopAfter()
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class StopAfterActor>
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StopAfterActorState {
															#line 587 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StopAfterActorState(Future<T> const& what) 
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 81 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   ret(T())
															#line 596 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("stopAfter", reinterpret_cast<unsigned long>(this));

	}
	~StopAfterActorState() 
	{
		fdb_probe_actor_destroy("stopAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 83 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 83 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<StopAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 614 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StopAfterActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopAfterActor, 0, T >*>(static_cast<StopAfterActor*>(this)));
															#line 619 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopAfterActorState();
		static_cast<StopAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 94 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		g_network->stop();
															#line 95 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<StopAfterActor*>(this)->SAV<Optional<T>>::futures) { (void)(ret); this->~StopAfterActorState(); static_cast<StopAfterActor*>(this)->destroy(); return 0; }
															#line 650 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<StopAfterActor*>(this)->SAV< Optional<T> >::value()) Optional<T>(std::move(ret)); // state_var_RVO
		this->~StopAfterActorState();
		static_cast<StopAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete || e.code() == error_code_actor_cancelled || e.code() == error_code_local_config_changed;
															#line 88 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(ok ? SevInfo : SevError, "StopAfterError").error(e);
															#line 89 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!ok)
															#line 667 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 90 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				fprintf(stderr, "Fatal Error: %s\n", e.what());
															#line 91 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				ret = Optional<T>();
															#line 673 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ret = Optional<T>(_);
															#line 689 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ret = Optional<T>(_);
															#line 698 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopAfterActor*>(this)->actor_wait_state > 0) static_cast<StopAfterActor*>(this)->actor_wait_state = 0;
		static_cast<StopAfterActor*>(this)->ActorCallback< StopAfterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< StopAfterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopAfterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopAfterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 81 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Optional<T> ret;
															#line 783 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via stopAfter()
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StopAfterActor final : public Actor<Optional<T>>, public ActorCallback< StopAfterActor<T>, 0, T >, public FastAllocated<StopAfterActor<T>>, public StopAfterActorState<T, StopAfterActor<T>> {
															#line 790 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<StopAfterActor<T>>::operator new;
	using FastAllocated<StopAfterActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Optional<T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< StopAfterActor<T>, 0, T >;
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StopAfterActor(Future<T> const& what) 
															#line 801 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Optional<T>>(),
		   StopAfterActorState<T, StopAfterActor<T>>(what)
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopAfterActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Optional<T>> stopAfter( Future<T> const& what ) {
															#line 79 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Optional<T>>(new StopAfterActor<T>(what));
															#line 831 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 97 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
T sorted(T range) {
	std::sort(range.begin(), range.end());
	return range;
}

template <class T>
std::vector<T> parseStringToVector(std::string str, char delim) {
	std::vector<T> result;
	std::stringstream stream(str);
	std::string token;
	while (stream.good()) {
		getline(stream, token, delim);
		std::istringstream tokenStream(token);
		T item;
		tokenStream >> item;
		result.push_back(item);
	}
	return result;
}

template <class T>
std::unordered_set<T> parseStringToUnorderedSet(std::string str, char delim) {
	std::unordered_set<T> result;
	std::stringstream stream(str);
	std::string token;
	while (stream.good()) {
		getline(stream, token, delim);
		std::istringstream tokenStream(token);
		T item;
		tokenStream >> item;
		result.emplace(item);
	}
	return result;
}

template <class T>
ErrorOr<T> errorOr(T t) {
	return ErrorOr<T>(t);
}

															#line 877 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via errorOr()
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ErrorOrActor>
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ErrorOrActorState {
															#line 884 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ErrorOrActorState(Future<T> const& f) 
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 891 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("errorOr", reinterpret_cast<unsigned long>(this));

	}
	~ErrorOrActorState() 
	{
		fdb_probe_actor_destroy("errorOr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 142 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 142 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ErrorOrActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 909 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ErrorOrActor*>(this)->actor_wait_state = 1;
															#line 142 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ErrorOrActor, 0, T >*>(static_cast<ErrorOrActor*>(this)));
															#line 914 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(e)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(e));
			this->~ErrorOrActorState();
			static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(t)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 962 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(t));
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(t)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 974 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(t));
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ErrorOrActor*>(this)->actor_wait_state > 0) static_cast<ErrorOrActor*>(this)->actor_wait_state = 0;
		static_cast<ErrorOrActor*>(this)->ActorCallback< ErrorOrActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ErrorOrActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ErrorOrActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ErrorOrActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1047 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via errorOr()
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ErrorOrActor final : public Actor<ErrorOr<T>>, public ActorCallback< ErrorOrActor<T>, 0, T >, public FastAllocated<ErrorOrActor<T>>, public ErrorOrActorState<T, ErrorOrActor<T>> {
															#line 1054 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ErrorOrActor<T>>::operator new;
	using FastAllocated<ErrorOrActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<ErrorOr<T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ErrorOrActor<T>, 0, T >;
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ErrorOrActor(Future<T> const& f) 
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<ErrorOr<T>>(),
		   ErrorOrActorState<T, ErrorOrActor<T>>(f)
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("errorOr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ErrorOrActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<ErrorOr<T>> errorOr( Future<T> const& f ) {
															#line 139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<ErrorOr<T>>(new ErrorOrActor<T>(f));
															#line 1095 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 148 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1100 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via throwErrorOr()
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ThrowErrorOrActor>
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ThrowErrorOrActorState {
															#line 1107 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ThrowErrorOrActorState(Future<ErrorOr<T>> const& f) 
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 1114 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("throwErrorOr", reinterpret_cast<unsigned long>(this));

	}
	~ThrowErrorOrActorState() 
	{
		fdb_probe_actor_destroy("throwErrorOr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<ErrorOr<T>> __when_expr_0 = f;
															#line 151 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<ThrowErrorOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1131 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ThrowErrorOrActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*>(static_cast<ThrowErrorOrActor*>(this)));
															#line 1136 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<T> const& t,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t.isError())
															#line 1159 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(t.getError(), loopDepth);
															#line 1163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 154 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ThrowErrorOrActor*>(this)->SAV<T>::futures) { (void)(t.get()); this->~ThrowErrorOrActorState(); static_cast<ThrowErrorOrActor*>(this)->destroy(); return 0; }
															#line 1167 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ThrowErrorOrActor*>(this)->SAV< T >::value()) T(t.get());
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<T> && t,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t.isError())
															#line 1179 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(t.getError(), loopDepth);
															#line 1183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 154 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ThrowErrorOrActor*>(this)->SAV<T>::futures) { (void)(t.get()); this->~ThrowErrorOrActorState(); static_cast<ThrowErrorOrActor*>(this)->destroy(); return 0; }
															#line 1187 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ThrowErrorOrActor*>(this)->SAV< T >::value()) T(t.get());
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<T> const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<T> && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThrowErrorOrActor*>(this)->actor_wait_state > 0) static_cast<ThrowErrorOrActor*>(this)->actor_wait_state = 0;
		static_cast<ThrowErrorOrActor*>(this)->ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >::remove();

	}
	void a_callback_fire(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,ErrorOr<T> const& value) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,ErrorOr<T> && value) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,Error err) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<ErrorOr<T>> f;
															#line 1260 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via throwErrorOr()
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ThrowErrorOrActor final : public Actor<T>, public ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >, public FastAllocated<ThrowErrorOrActor<T>>, public ThrowErrorOrActorState<T, ThrowErrorOrActor<T>> {
															#line 1267 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ThrowErrorOrActor<T>>::operator new;
	using FastAllocated<ThrowErrorOrActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >;
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ThrowErrorOrActor(Future<ErrorOr<T>> const& f) 
															#line 1278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ThrowErrorOrActorState<T, ThrowErrorOrActor<T>>(f)
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throwErrorOr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> throwErrorOr( Future<ErrorOr<T>> const& f ) {
															#line 149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ThrowErrorOrActor<T>(f));
															#line 1308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 156 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1313 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via transformErrors()
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TransformErrorsActor>
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorsActorState {
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorsActorState(Future<T> const& f,Error const& err) 
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   err(err)
															#line 1329 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("transformErrors", reinterpret_cast<unsigned long>(this));

	}
	~TransformErrorsActorState() 
	{
		fdb_probe_actor_destroy("transformErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TransformErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1347 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TransformErrorsActor*>(this)->actor_wait_state = 1;
															#line 160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransformErrorsActor, 0, T >*>(static_cast<TransformErrorsActor*>(this)));
															#line 1352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 1382 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 1386 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 165 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(err, loopDepth);
															#line 1390 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorsActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorsActorState(); static_cast<TransformErrorsActor*>(this)->destroy(); return 0; }
															#line 1404 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorsActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorsActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorsActorState(); static_cast<TransformErrorsActor*>(this)->destroy(); return 0; }
															#line 1416 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorsActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransformErrorsActor*>(this)->actor_wait_state > 0) static_cast<TransformErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TransformErrorsActor*>(this)->ActorCallback< TransformErrorsActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TransformErrorsActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransformErrorsActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransformErrorsActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error err;
															#line 1491 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via transformErrors()
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorsActor final : public Actor<T>, public ActorCallback< TransformErrorsActor<T>, 0, T >, public FastAllocated<TransformErrorsActor<T>>, public TransformErrorsActorState<T, TransformErrorsActor<T>> {
															#line 1498 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TransformErrorsActor<T>>::operator new;
	using FastAllocated<TransformErrorsActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TransformErrorsActor<T>, 0, T >;
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorsActor(Future<T> const& f,Error const& err) 
															#line 1509 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TransformErrorsActorState<T, TransformErrorsActor<T>>(f, err)
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transformErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransformErrorsActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> transformErrors( Future<T> const& f, Error const& err ) {
															#line 157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TransformErrorsActor<T>(f, err));
															#line 1539 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 168 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1544 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via transformError()
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TransformErrorActor>
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorActorState {
															#line 1551 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorActorState(Future<T> const& f,Error const& inErr,Error const& outErr) 
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   inErr(inErr),
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   outErr(outErr)
															#line 1562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("transformError", reinterpret_cast<unsigned long>(this));

	}
	~TransformErrorActorState() 
	{
		fdb_probe_actor_destroy("transformError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TransformErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1580 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TransformErrorActor*>(this)->actor_wait_state = 1;
															#line 172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransformErrorActor, 0, T >*>(static_cast<TransformErrorActor*>(this)));
															#line 1585 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == inErr.code())
															#line 1615 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(outErr, loopDepth);
															#line 1619 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 177 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 1623 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorActorState(); static_cast<TransformErrorActor*>(this)->destroy(); return 0; }
															#line 1637 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorActorState(); static_cast<TransformErrorActor*>(this)->destroy(); return 0; }
															#line 1649 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransformErrorActor*>(this)->actor_wait_state > 0) static_cast<TransformErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TransformErrorActor*>(this)->ActorCallback< TransformErrorActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TransformErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransformErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransformErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error inErr;
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error outErr;
															#line 1726 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via transformError()
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorActor final : public Actor<T>, public ActorCallback< TransformErrorActor<T>, 0, T >, public FastAllocated<TransformErrorActor<T>>, public TransformErrorActorState<T, TransformErrorActor<T>> {
															#line 1733 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TransformErrorActor<T>>::operator new;
	using FastAllocated<TransformErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TransformErrorActor<T>, 0, T >;
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorActor(Future<T> const& f,Error const& inErr,Error const& outErr) 
															#line 1744 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TransformErrorActorState<T, TransformErrorActor<T>>(f, inErr, outErr)
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transformError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransformErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> transformError( Future<T> const& f, Error const& inErr, Error const& outErr ) {
															#line 169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TransformErrorActor<T>(f, inErr, outErr));
															#line 1774 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 180 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Note that the RequestStream<T> version of forwardPromise doesn't exist, because what to do with errors?

															#line 1781 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardEvent()
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardEventActor>
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActorState {
															#line 1788 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActorState(Event* const& ev,Future<T> const& input) 
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : ev(ev),
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 1797 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	~ForwardEventActorState() 
	{
		fdb_probe_actor_destroy("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 186 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 186 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1815 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<ForwardEventActor*>(this)->actor_wait_state = 1;
															#line 186 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardEventActor, 0, T >*>(static_cast<ForwardEventActor*>(this)));
															#line 1819 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardEventActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 1847 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardEventActor*>(this)->actor_wait_state > 0) static_cast<ForwardEventActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardEventActor*>(this)->ActorCallback< ForwardEventActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardEventActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardEventActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardEventActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardEventActor*>(this);
															#line 1957 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Event* ev;
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> input;
															#line 1966 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardEvent()
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor final : public Actor<void>, public ActorCallback< ForwardEventActor<T>, 0, T >, public FastAllocated<ForwardEventActor<T>>, public ForwardEventActorState<T, ForwardEventActor<T>> {
															#line 1973 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardEventActor<T>>::operator new;
	using FastAllocated<ForwardEventActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardEventActor<T>, 0, T >;
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor(Event* const& ev,Future<T> const& input) 
															#line 1984 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardEventActorState<T, ForwardEventActor<T>>(ev, input)
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardEvent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardEvent( Event* const& ev, Future<T> const& input ) {
															#line 183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardEventActor<T>(ev, input);
															#line 2005 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 191 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2010 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardEvent()
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardEventActor1>
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor1State {
															#line 2017 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor1State(Event* const& ev,T* const& t,Error* const& err,FutureStream<T> const& input) 
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : ev(ev),
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   t(t),
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   err(err),
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 2030 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	~ForwardEventActor1State() 
	{
		fdb_probe_actor_destroy("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				FutureStream<T> __when_expr_0 = input;
															#line 195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
															#line 2048 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<ForwardEventActor1*>(this)->actor_wait_state = 1;
															#line 195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ForwardEventActor1, 0, T >*>(static_cast<ForwardEventActor1*>(this)));
															#line 2052 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardEventActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			*err = e;
															#line 200 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			ev->set();
															#line 2089 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 196 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*t = std::move(value);
															#line 197 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 2106 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 196 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*t = std::move(value);
															#line 197 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 2117 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardEventActor1*>(this)->actor_wait_state > 0) static_cast<ForwardEventActor1*>(this)->actor_wait_state = 0;
		static_cast<ForwardEventActor1*>(this)->ActorSingleCallback< ForwardEventActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ForwardEventActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ForwardEventActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ForwardEventActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardEventActor1*>(this);
															#line 2202 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Event* ev;
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T* t;
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error* err;
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 2215 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardEvent()
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor1 final : public Actor<void>, public ActorSingleCallback< ForwardEventActor1<T>, 0, T >, public FastAllocated<ForwardEventActor1<T>>, public ForwardEventActor1State<T, ForwardEventActor1<T>> {
															#line 2222 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardEventActor1<T>>::operator new;
	using FastAllocated<ForwardEventActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ForwardEventActor1<T>, 0, T >;
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor1(Event* const& ev,T* const& t,Error* const& err,FutureStream<T> const& input) 
															#line 2233 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardEventActor1State<T, ForwardEventActor1<T>>(ev, t, err, input)
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardEvent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardEvent( Event* const& ev, T* const& t, Error* const& err, FutureStream<T> const& input ) {
															#line 192 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardEventActor1<T>(ev, t, err, input);
															#line 2254 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2259 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitForAllReady()
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitForAllReadyActor>
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForAllReadyActorState {
															#line 2266 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForAllReadyActorState(std::vector<Future<T>> const& results) 
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : results(results),
															#line 206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   i(0)
															#line 2275 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitForAllReady", reinterpret_cast<unsigned long>(this));

	}
	~WaitForAllReadyActorState() 
	{
		fdb_probe_actor_destroy("waitForAllReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 2290 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForAllReadyActorState();
		static_cast<WaitForAllReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (i == results.size())
															#line 2320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 209 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<WaitForAllReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllReadyActorState(); static_cast<WaitForAllReadyActor*>(this)->destroy(); return 0; }
															#line 2324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<WaitForAllReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllReadyActorState();
			static_cast<WaitForAllReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = results[i];
															#line 211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitForAllReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2335 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForAllReadyActor*>(this)->actor_wait_state = 1;
															#line 211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForAllReadyActor, 0, T >*>(static_cast<WaitForAllReadyActor*>(this)));
															#line 2340 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 215 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		i++;
															#line 2355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(T const& t,int loopDepth) 
	{
															#line 212 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 2377 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(T && t,int loopDepth) 
	{
															#line 212 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 2386 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(t, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForAllReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllReadyActor*>(this)->ActorCallback< WaitForAllReadyActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllReadyActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForAllReadyActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForAllReadyActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> results;
															#line 206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int i;
															#line 2471 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitForAllReady()
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForAllReadyActor final : public Actor<Void>, public ActorCallback< WaitForAllReadyActor<T>, 0, T >, public FastAllocated<WaitForAllReadyActor<T>>, public WaitForAllReadyActorState<T, WaitForAllReadyActor<T>> {
															#line 2478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitForAllReadyActor<T>>::operator new;
	using FastAllocated<WaitForAllReadyActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForAllReadyActor<T>, 0, T >;
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForAllReadyActor(std::vector<Future<T>> const& results) 
															#line 2489 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   WaitForAllReadyActorState<T, WaitForAllReadyActor<T>>(results)
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForAllReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForAllReadyActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> waitForAllReady( std::vector<Future<T>> const& results ) {
															#line 204 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new WaitForAllReadyActor<T>(results));
															#line 2519 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 218 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2524 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeout()
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutActor>
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActorState {
															#line 2531 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActorState(Future<T> const& what,double const& time,T const& timedoutValue,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   timedoutValue(timedoutValue),
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 2544 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeout", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutActorState() 
	{
		fdb_probe_actor_destroy("timeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 221 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time, taskID);
															#line 223 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 222 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2563 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 226 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 2567 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor, 0, T >*>(static_cast<TimeoutActor*>(this)));
															#line 226 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor, 1, Void >*>(static_cast<TimeoutActor*>(this)));
															#line 2574 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2597 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2609 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(timedoutValue); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2621 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(std::move(timedoutValue)); // state_var_RVO
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(timedoutValue); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(std::move(timedoutValue)); // state_var_RVO
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutActor*>(this)->actor_wait_state > 0) static_cast<TimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutActor*>(this)->ActorCallback< TimeoutActor, 0, T >::remove();
		static_cast<TimeoutActor*>(this)->ActorCallback< TimeoutActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T timedoutValue;
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 2746 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeout()
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor final : public Actor<T>, public ActorCallback< TimeoutActor<T>, 0, T >, public ActorCallback< TimeoutActor<T>, 1, Void >, public FastAllocated<TimeoutActor<T>>, public TimeoutActorState<T, TimeoutActor<T>> {
															#line 2753 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutActor<T>>::operator new;
	using FastAllocated<TimeoutActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutActor<T>, 0, T >;
friend struct ActorCallback< TimeoutActor<T>, 1, Void >;
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor(Future<T> const& what,double const& time,T const& timedoutValue,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 2765 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TimeoutActorState<T, TimeoutActor<T>>(what, time, timedoutValue, taskID)
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> timeout( Future<T> const& what, double const& time, T const& timedoutValue, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TimeoutActor<T>(what, time, timedoutValue, taskID));
															#line 2795 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeout()
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutActor1>
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor1State {
															#line 2807 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor1State(Future<T> const& what,double const& time) 
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time)
															#line 2816 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeout", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutActor1State() 
	{
		fdb_probe_actor_destroy("timeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time);
															#line 236 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 235 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2835 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 239 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 2839 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutActor1*>(this)->actor_wait_state = 1;
															#line 236 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor1, 0, T >*>(static_cast<TimeoutActor1*>(this)));
															#line 239 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor1, 1, Void >*>(static_cast<TimeoutActor1*>(this)));
															#line 2846 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 237 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(t); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 2869 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(t);
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 237 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(t); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 2881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(t);
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(Optional<T>()); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 2893 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(Optional<T>());
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(Optional<T>()); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 2905 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(Optional<T>());
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutActor1*>(this)->actor_wait_state > 0) static_cast<TimeoutActor1*>(this)->actor_wait_state = 0;
		static_cast<TimeoutActor1*>(this)->ActorCallback< TimeoutActor1, 0, T >::remove();
		static_cast<TimeoutActor1*>(this)->ActorCallback< TimeoutActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 3014 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeout()
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor1 final : public Actor<Optional<T>>, public ActorCallback< TimeoutActor1<T>, 0, T >, public ActorCallback< TimeoutActor1<T>, 1, Void >, public FastAllocated<TimeoutActor1<T>>, public TimeoutActor1State<T, TimeoutActor1<T>> {
															#line 3021 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutActor1<T>>::operator new;
	using FastAllocated<TimeoutActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Optional<T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutActor1<T>, 0, T >;
friend struct ActorCallback< TimeoutActor1<T>, 1, Void >;
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor1(Future<T> const& what,double const& time) 
															#line 3033 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Optional<T>>(),
		   TimeoutActor1State<T, TimeoutActor1<T>>(what, time)
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutActor1<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Optional<T>> timeout( Future<T> const& what, double const& time ) {
															#line 232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Optional<T>>(new TimeoutActor1<T>(what, time));
															#line 3063 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3068 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeoutError()
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutErrorActor>
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorActorState {
															#line 3075 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorActorState(Future<T> const& what,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 3086 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeoutError", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutErrorActorState() 
	{
		fdb_probe_actor_destroy("timeoutError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time, taskID);
															#line 249 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 248 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3105 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 252 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 3109 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutErrorActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorActor, 0, T >*>(static_cast<TimeoutErrorActor*>(this)));
															#line 252 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorActor, 1, Void >*>(static_cast<TimeoutErrorActor*>(this)));
															#line 3116 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 250 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorActorState(); static_cast<TimeoutErrorActor*>(this)->destroy(); return 0; }
															#line 3139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 250 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorActorState(); static_cast<TimeoutErrorActor*>(this)->destroy(); return 0; }
															#line 3151 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 3163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 3171 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutErrorActor*>(this)->actor_wait_state > 0) static_cast<TimeoutErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutErrorActor*>(this)->ActorCallback< TimeoutErrorActor, 0, T >::remove();
		static_cast<TimeoutErrorActor*>(this)->ActorCallback< TimeoutErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 3278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeoutError()
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorActor final : public Actor<T>, public ActorCallback< TimeoutErrorActor<T>, 0, T >, public ActorCallback< TimeoutErrorActor<T>, 1, Void >, public FastAllocated<TimeoutErrorActor<T>>, public TimeoutErrorActorState<T, TimeoutErrorActor<T>> {
															#line 3285 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutErrorActor<T>>::operator new;
	using FastAllocated<TimeoutErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutErrorActor<T>, 0, T >;
friend struct ActorCallback< TimeoutErrorActor<T>, 1, Void >;
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorActor(Future<T> const& what,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 3297 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TimeoutErrorActorState<T, TimeoutErrorActor<T>>(what, time, taskID)
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeoutError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> timeoutError( Future<T> const& what, double const& time, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TimeoutErrorActor<T>(what, time, taskID));
															#line 3327 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 257 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3332 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via delayed()
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DelayedActor>
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedActorState {
															#line 3339 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedActorState(Future<T> const& what,double const& time = 0.0,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 3350 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("delayed", reinterpret_cast<unsigned long>(this));

	}
	~DelayedActorState() 
	{
		fdb_probe_actor_destroy("delayed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 261 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 261 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3368 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DelayedActor*>(this)->actor_wait_state = 1;
															#line 261 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 0, T >*>(static_cast<DelayedActor*>(this)));
															#line 3373 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			err = e;
															#line 266 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delay(time, taskID);
															#line 266 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DelayedActor*>(this)->actor_wait_state = 3;
															#line 266 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 2, Void >*>(static_cast<DelayedActor*>(this)));
															#line 3412 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 262 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = delay(time, taskID);
															#line 262 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3429 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedActor*>(this)->actor_wait_state = 2;
															#line 262 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 1, Void >*>(static_cast<DelayedActor*>(this)));
															#line 3434 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& __t,int loopDepth) 
	{
															#line 261 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		t = __t;
															#line 3443 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __t,int loopDepth) 
	{
		t = std::move(__t);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayedActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayedActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayedActorState(); static_cast<DelayedActor*>(this)->destroy(); return 0; }
															#line 3510 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayedActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayedActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayedActorState(); static_cast<DelayedActor*>(this)->destroy(); return 0; }
															#line 3522 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayedActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(err, loopDepth);
															#line 3597 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(err, loopDepth);
															#line 3605 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DelayedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 261 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T t;
															#line 265 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error err;
															#line 3682 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via delayed()
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedActor final : public Actor<T>, public ActorCallback< DelayedActor<T>, 0, T >, public ActorCallback< DelayedActor<T>, 1, Void >, public ActorCallback< DelayedActor<T>, 2, Void >, public FastAllocated<DelayedActor<T>>, public DelayedActorState<T, DelayedActor<T>> {
															#line 3689 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DelayedActor<T>>::operator new;
	using FastAllocated<DelayedActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayedActor<T>, 0, T >;
friend struct ActorCallback< DelayedActor<T>, 1, Void >;
friend struct ActorCallback< DelayedActor<T>, 2, Void >;
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedActor(Future<T> const& what,double const& time = 0.0,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 3702 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   DelayedActorState<T, DelayedActor<T>>(what, time, taskID)
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayedActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DelayedActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DelayedActor<T>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> delayed( Future<T> const& what, double const& time = 0.0, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 258 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new DelayedActor<T>(what, time, taskID));
															#line 3734 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 270 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3739 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via trigger()
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class TriggerActor>
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerActorState {
															#line 3746 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerActorState(Func const& what,Future<Void> const& signal) 
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 3755 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("trigger", reinterpret_cast<unsigned long>(this));

	}
	~TriggerActorState() 
	{
		fdb_probe_actor_destroy("trigger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 273 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TriggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3772 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TriggerActor*>(this)->actor_wait_state = 1;
															#line 273 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerActor, 0, Void >*>(static_cast<TriggerActor*>(this)));
															#line 3777 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 275 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerActorState(); static_cast<TriggerActor*>(this)->destroy(); return 0; }
															#line 3802 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 275 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerActorState(); static_cast<TriggerActor*>(this)->destroy(); return 0; }
															#line 3816 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerActor*>(this)->actor_wait_state > 0) static_cast<TriggerActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerActor*>(this)->ActorCallback< TriggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 3891 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via trigger()
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerActor final : public Actor<Void>, public ActorCallback< TriggerActor<Func>, 0, Void >, public FastAllocated<TriggerActor<Func>>, public TriggerActorState<Func, TriggerActor<Func>> {
															#line 3898 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TriggerActor<Func>>::operator new;
	using FastAllocated<TriggerActor<Func>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerActor<Func>, 0, Void >;
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerActor(Func const& what,Future<Void> const& signal) 
															#line 3909 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TriggerActorState<Func, TriggerActor<Func>>(what, signal)
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trigger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> trigger( Func const& what, Future<Void> const& signal ) {
															#line 271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TriggerActor<Func>(what, signal));
															#line 3939 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 277 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via triggerOnError()
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class TriggerOnErrorActor>
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerOnErrorActorState {
															#line 3951 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerOnErrorActorState(Func const& what,Future<Void> const& signal) 
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 3960 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("triggerOnError", reinterpret_cast<unsigned long>(this));

	}
	~TriggerOnErrorActorState() 
	{
		fdb_probe_actor_destroy("triggerOnError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 281 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = signal;
															#line 281 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TriggerOnErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3978 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TriggerOnErrorActor*>(this)->actor_wait_state = 1;
															#line 281 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerOnErrorActor, 0, Void >*>(static_cast<TriggerOnErrorActor*>(this)));
															#line 3983 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerOnErrorActorState();
		static_cast<TriggerOnErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 286 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerOnErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerOnErrorActorState(); static_cast<TriggerOnErrorActor*>(this)->destroy(); return 0; }
															#line 4012 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerOnErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerOnErrorActorState();
		static_cast<TriggerOnErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 283 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			what();
															#line 4025 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerOnErrorActor*>(this)->actor_wait_state > 0) static_cast<TriggerOnErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerOnErrorActor*>(this)->ActorCallback< TriggerOnErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerOnErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerOnErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerOnErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 4128 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via triggerOnError()
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerOnErrorActor final : public Actor<Void>, public ActorCallback< TriggerOnErrorActor<Func>, 0, Void >, public FastAllocated<TriggerOnErrorActor<Func>>, public TriggerOnErrorActorState<Func, TriggerOnErrorActor<Func>> {
															#line 4135 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TriggerOnErrorActor<Func>>::operator new;
	using FastAllocated<TriggerOnErrorActor<Func>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerOnErrorActor<Func>, 0, Void >;
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerOnErrorActor(Func const& what,Future<Void> const& signal) 
															#line 4146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TriggerOnErrorActorState<Func, TriggerOnErrorActor<Func>>(what, signal)
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerOnError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerOnErrorActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> triggerOnError( Func const& what, Future<Void> const& signal ) {
															#line 278 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TriggerOnErrorActor<Func>(what, signal));
															#line 4176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 288 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to complete and cannot be cancelled
// Most situations will use the overload below, which does not require a promise
															#line 4183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via uncancellable()
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class UncancellableActor>
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActorState {
															#line 4190 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActorState(Future<T> const& what,Promise<T> const& result) 
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   result(result)
															#line 4199 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	~UncancellableActorState() 
	{
		fdb_probe_actor_destroy("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 294 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 294 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 4217 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<UncancellableActor*>(this)->actor_wait_state = 1;
															#line 294 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UncancellableActor, 0, T >*>(static_cast<UncancellableActor*>(this)));
															#line 4221 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<UncancellableActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			result.sendError(e);
															#line 4256 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 295 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		result.send(val);
															#line 4271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 295 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		result.send(val);
															#line 4280 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UncancellableActor*>(this)->actor_wait_state > 0) static_cast<UncancellableActor*>(this)->actor_wait_state = 0;
		static_cast<UncancellableActor*>(this)->ActorCallback< UncancellableActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< UncancellableActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UncancellableActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UncancellableActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<UncancellableActor*>(this);
															#line 4365 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> result;
															#line 4374 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via uncancellable()
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor final : public Actor<void>, public ActorCallback< UncancellableActor<T>, 0, T >, public FastAllocated<UncancellableActor<T>>, public UncancellableActorState<T, UncancellableActor<T>> {
															#line 4381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<UncancellableActor<T>>::operator new;
	using FastAllocated<UncancellableActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< UncancellableActor<T>, 0, T >;
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor(Future<T> const& what,Promise<T> const& result) 
															#line 4392 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   UncancellableActorState<T, UncancellableActor<T>>(what, result)
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uncancellable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void uncancellable( Future<T> const& what, Promise<T> const& result ) {
															#line 291 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new UncancellableActor<T>(what, result);
															#line 4413 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 300 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to complete and cannot be cancelled
															#line 4419 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via uncancellable()
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class UncancellableActor1>
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor1State {
															#line 4426 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor1State(Future<T> const& what) 
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what)
															#line 4433 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	~UncancellableActor1State() 
	{
		fdb_probe_actor_destroy("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 304 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Promise<T> resultPromise;
															#line 305 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<T> result = resultPromise.getFuture();
															#line 307 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			uncancellable(what, resultPromise);
															#line 308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = result;
															#line 308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<UncancellableActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4456 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UncancellableActor1*>(this)->actor_wait_state = 1;
															#line 308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UncancellableActor1, 0, T >*>(static_cast<UncancellableActor1*>(this)));
															#line 4461 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<UncancellableActor1*>(this)->SAV<T>::futures) { (void)(val); this->~UncancellableActor1State(); static_cast<UncancellableActor1*>(this)->destroy(); return 0; }
															#line 4484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<UncancellableActor1*>(this)->SAV< T >::value()) T(val);
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<UncancellableActor1*>(this)->SAV<T>::futures) { (void)(val); this->~UncancellableActor1State(); static_cast<UncancellableActor1*>(this)->destroy(); return 0; }
															#line 4496 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<UncancellableActor1*>(this)->SAV< T >::value()) T(val);
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UncancellableActor1*>(this)->actor_wait_state > 0) static_cast<UncancellableActor1*>(this)->actor_wait_state = 0;
		static_cast<UncancellableActor1*>(this)->ActorCallback< UncancellableActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< UncancellableActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UncancellableActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UncancellableActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 4569 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via uncancellable()
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor1 final : public Actor<T>, public ActorCallback< UncancellableActor1<T>, 0, T >, public FastAllocated<UncancellableActor1<T>>, public UncancellableActor1State<T, UncancellableActor1<T>> {
															#line 4576 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<UncancellableActor1<T>>::operator new;
	using FastAllocated<UncancellableActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< UncancellableActor1<T>, 0, T >;
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor1(Future<T> const& what) 
															#line 4587 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   UncancellableActor1State<T, UncancellableActor1<T>>(what)
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uncancellable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UncancellableActor1<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
Future<T> uncancellable( Future<T> const& what ) {
															#line 302 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new UncancellableActor1<T>(what));
															#line 4617 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Holds onto an object until a future either completes or is cancelled
// Used to prevent the object from being reclaimed
//
// NOTE: the order of the arguments is important. The arguments will be destructed in
// reverse order, and we need the object to be destructed last.
															#line 4627 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via holdWhile()
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class HoldWhileActor>
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileActorState {
															#line 4634 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileActorState(X const& object,Future<T> const& what) 
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : object(object),
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 4643 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("holdWhile", reinterpret_cast<unsigned long>(this));

	}
	~HoldWhileActorState() 
	{
		fdb_probe_actor_destroy("holdWhile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<HoldWhileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4660 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldWhileActor*>(this)->actor_wait_state = 1;
															#line 320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldWhileActor, 0, T >*>(static_cast<HoldWhileActor*>(this)));
															#line 4665 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 321 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileActor*>(this)->SAV<T>::futures) { (void)(val); this->~HoldWhileActorState(); static_cast<HoldWhileActor*>(this)->destroy(); return 0; }
															#line 4688 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileActor*>(this)->SAV< T >::value()) T(val);
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 321 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileActor*>(this)->SAV<T>::futures) { (void)(val); this->~HoldWhileActorState(); static_cast<HoldWhileActor*>(this)->destroy(); return 0; }
															#line 4700 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileActor*>(this)->SAV< T >::value()) T(val);
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldWhileActor*>(this)->actor_wait_state > 0) static_cast<HoldWhileActor*>(this)->actor_wait_state = 0;
		static_cast<HoldWhileActor*>(this)->ActorCallback< HoldWhileActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< HoldWhileActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldWhileActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldWhileActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X object;
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 4775 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via holdWhile()
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileActor final : public Actor<T>, public ActorCallback< HoldWhileActor<T, X>, 0, T >, public FastAllocated<HoldWhileActor<T, X>>, public HoldWhileActorState<T, X, HoldWhileActor<T, X>> {
															#line 4782 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<HoldWhileActor<T, X>>::operator new;
	using FastAllocated<HoldWhileActor<T, X>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldWhileActor<T, X>, 0, T >;
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileActor(X const& object,Future<T> const& what) 
															#line 4793 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   HoldWhileActorState<T, X, HoldWhileActor<T, X>>(object, what)
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdWhile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldWhileActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> holdWhile( X const& object, Future<T> const& what ) {
															#line 318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new HoldWhileActor<T, X>(object, what));
															#line 4823 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 323 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 4828 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via holdWhileVoid()
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class HoldWhileVoidActor>
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileVoidActorState {
															#line 4835 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileVoidActorState(X const& object,Future<T> const& what) 
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : object(object),
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 4844 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("holdWhileVoid", reinterpret_cast<unsigned long>(this));

	}
	~HoldWhileVoidActorState() 
	{
		fdb_probe_actor_destroy("holdWhileVoid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 326 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<HoldWhileVoidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldWhileVoidActor*>(this)->actor_wait_state = 1;
															#line 326 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldWhileVoidActor, 0, T >*>(static_cast<HoldWhileVoidActor*>(this)));
															#line 4866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldWhileVoidActorState(); static_cast<HoldWhileVoidActor*>(this)->destroy(); return 0; }
															#line 4889 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldWhileVoidActorState(); static_cast<HoldWhileVoidActor*>(this)->destroy(); return 0; }
															#line 4901 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldWhileVoidActor*>(this)->actor_wait_state > 0) static_cast<HoldWhileVoidActor*>(this)->actor_wait_state = 0;
		static_cast<HoldWhileVoidActor*>(this)->ActorCallback< HoldWhileVoidActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< HoldWhileVoidActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldWhileVoidActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldWhileVoidActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X object;
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 4976 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via holdWhileVoid()
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileVoidActor final : public Actor<Void>, public ActorCallback< HoldWhileVoidActor<T, X>, 0, T >, public FastAllocated<HoldWhileVoidActor<T, X>>, public HoldWhileVoidActorState<T, X, HoldWhileVoidActor<T, X>> {
															#line 4983 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<HoldWhileVoidActor<T, X>>::operator new;
	using FastAllocated<HoldWhileVoidActor<T, X>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldWhileVoidActor<T, X>, 0, T >;
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileVoidActor(X const& object,Future<T> const& what) 
															#line 4994 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   HoldWhileVoidActorState<T, X, HoldWhileVoidActor<T, X>>(object, what)
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdWhileVoid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldWhileVoidActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> holdWhileVoid( X const& object, Future<T> const& what ) {
															#line 324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new HoldWhileVoidActor<T, X>(object, what));
															#line 5024 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 329 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Assign the future value of what to out
template <class T, class X>
Future<Void> store(X& out, Future<T> what) {
	return map(what, [&out](T const& v) {
		out = v;
		return Void();
	});
}

#if false
// NOTE: Think twice whether create a new struct for a complex return type is better before using tuple.
// If we just use the return type once, is it worth to create a new struct?
// And enable the unit test in genericactors.actor.cpp
template <class A, class... Bs>
Future<Void> storeTuple(Future<std::tuple<A, Bs...>> what, A& a, Bs&... b) {
	return map(what, [&](std::tuple<A, Bs...> const& v) {
		std::tie(a, b...) = v;
		return Void();
	});
}
#endif

template <class T>
Future<Void> storeOrThrow(T& out, Future<Optional<T>> what, Error e = key_not_found()) {
	return map(what, [&out, e](Optional<T> const& o) {
		if (!o.present())
			throw e;
		out = o.get();
		return Void();
	});
}

// Waits for a future to be ready, and then applies an asynchronous function to it.
															#line 5062 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via mapAsync()
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapAsyncActor>
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActorState {
															#line 5069 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActorState(Future<T> const& what,F const& actorFunc) 
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorFunc(actorFunc)
															#line 5078 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	~MapAsyncActorState() 
	{
		fdb_probe_actor_destroy("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 365 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 365 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5095 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MapAsyncActor*>(this)->actor_wait_state = 1;
															#line 365 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 0, T >*>(static_cast<MapAsyncActor*>(this)));
															#line 5100 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<decltype(std::declval<F>()(std::declval<T>()).getValue())> __when_expr_1 = actorFunc(val);
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5125 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MapAsyncActor*>(this)->actor_wait_state = 2;
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*>(static_cast<MapAsyncActor*>(this)));
															#line 5130 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<decltype(std::declval<F>()(std::declval<T>()).getValue())> __when_expr_1 = actorFunc(val);
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5141 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MapAsyncActor*>(this)->actor_wait_state = 2;
															#line 366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*>(static_cast<MapAsyncActor*>(this)));
															#line 5146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor*>(this)->ActorCallback< MapAsyncActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MapAsyncActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(decltype(std::declval<F>()(std::declval<T>()).getValue()) const& ret,int loopDepth) 
	{
															#line 367 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor*>(this)->SAV<decltype(std::declval<F>()(std::declval<T>()).getValue())>::futures) { (void)(ret); this->~MapAsyncActorState(); static_cast<MapAsyncActor*>(this)->destroy(); return 0; }
															#line 5218 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor*>(this)->SAV< decltype(std::declval<F>()(std::declval<T>()).getValue()) >::value()) decltype(std::declval<F>()(std::declval<T>()).getValue())(ret);
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(decltype(std::declval<F>()(std::declval<T>()).getValue()) && ret,int loopDepth) 
	{
															#line 367 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor*>(this)->SAV<decltype(std::declval<F>()(std::declval<T>()).getValue())>::futures) { (void)(ret); this->~MapAsyncActorState(); static_cast<MapAsyncActor*>(this)->destroy(); return 0; }
															#line 5230 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor*>(this)->SAV< decltype(std::declval<F>()(std::declval<T>()).getValue()) >::value()) decltype(std::declval<F>()(std::declval<T>()).getValue())(ret);
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(decltype(std::declval<F>()(std::declval<T>()).getValue()) const& ret,int loopDepth) 
	{
		loopDepth = a_body1cont2(ret, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(decltype(std::declval<F>()(std::declval<T>()).getValue()) && ret,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(ret), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor*>(this)->ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,decltype(std::declval<F>()(std::declval<T>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,decltype(std::declval<F>()(std::declval<T>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 5305 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via mapAsync()
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor final : public Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>, public ActorCallback< MapAsyncActor<T, F>, 0, T >, public ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >, public FastAllocated<MapAsyncActor<T, F>>, public MapAsyncActorState<T, F, MapAsyncActor<T, F>> {
															#line 5312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapAsyncActor<T, F>>::operator new;
	using FastAllocated<MapAsyncActor<T, F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< MapAsyncActor<T, F>, 0, T >;
friend struct ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >;
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor(Future<T> const& what,F const& actorFunc) 
															#line 5324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>(),
		   MapAsyncActorState<T, F, MapAsyncActor<T, F>>(what, actorFunc)
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mapAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MapAsyncActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<decltype(std::declval<F>()(std::declval<T>()).getValue())> mapAsync( Future<T> const& what, F const& actorFunc ) {
															#line 363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<decltype(std::declval<F>()(std::declval<T>()).getValue())>(new MapAsyncActor<T, F>(what, actorFunc));
															#line 5355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 369 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// maps a vector of futures with an asynchronous function
template <class T, class F>
auto mapAsync(std::vector<Future<T>> const& what, F const& actorFunc) {
	std::vector<std::invoke_result_t<F, T>> ret;
	ret.reserve(what.size());
	for (const auto& f : what)
		ret.push_back(mapAsync(f, actorFunc));
	return ret;
}

// maps a stream with an asynchronous function
															#line 5371 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via mapAsync()
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U, class MapAsyncActor1>
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor1State {
															#line 5378 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor1State(FutureStream<T> const& input,F const& actorFunc,PromiseStream<U> const& output) 
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorFunc(actorFunc),
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 383 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   futures()
															#line 5391 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	~MapAsyncActor1State() 
	{
		fdb_probe_actor_destroy("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 5406 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapAsyncActor1State();
		static_cast<MapAsyncActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 406 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 5429 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 388 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 387 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapAsyncActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5448 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 391 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<U> __when_expr_1 = futures.size() == 0 ? Never() : futures.front();
															#line 5452 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<MapAsyncActor1*>(this)->actor_wait_state = 1;
															#line 388 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< MapAsyncActor1, 0, T >*>(static_cast<MapAsyncActor1*>(this)));
															#line 391 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor1, 1, U >*>(static_cast<MapAsyncActor1*>(this)));
															#line 5459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 397 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 5494 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				output.sendError(e);
															#line 401 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5504 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.push_back(actorFunc(nextInput));
															#line 5525 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.push_back(actorFunc(nextInput));
															#line 5534 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(U const& nextOutput,int loopDepth) 
	{
															#line 392 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 393 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 5545 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(U && nextOutput,int loopDepth) 
	{
															#line 392 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 393 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 5556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor1*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor1*>(this)->ActorSingleCallback< MapAsyncActor1, 0, T >::remove();
		static_cast<MapAsyncActor1*>(this)->ActorCallback< MapAsyncActor1, 1, U >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MapAsyncActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< MapAsyncActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< MapAsyncActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 1, U >*,U const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 1, U >*,U && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MapAsyncActor1, 1, U >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 412 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 414 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MapAsyncActor1State(); static_cast<MapAsyncActor1*>(this)->destroy(); return 0; }
															#line 5677 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MapAsyncActor1State();
		static_cast<MapAsyncActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 406 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!(futures.size()))
															#line 5696 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<U> __when_expr_2 = futures.front();
															#line 407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5704 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<MapAsyncActor1*>(this)->actor_wait_state = 2;
															#line 407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor1, 2, U >*>(static_cast<MapAsyncActor1*>(this)));
															#line 5709 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(U const& nextOutput,int loopDepth) 
	{
															#line 408 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 409 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 5733 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(U && nextOutput,int loopDepth) 
	{
															#line 408 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 409 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 5744 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(U const& nextOutput,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(nextOutput, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(U && nextOutput,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(nextOutput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor1*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor1*>(this)->ActorCallback< MapAsyncActor1, 2, U >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 2, U >*,U const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 2, U >*,U && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MapAsyncActor1, 2, U >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<U> output;
															#line 383 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Deque<Future<U>> futures;
															#line 5820 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via mapAsync()
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U>
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor1 final : public Actor<Void>, public ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >, public ActorCallback< MapAsyncActor1<T, F, U>, 1, U >, public ActorCallback< MapAsyncActor1<T, F, U>, 2, U >, public FastAllocated<MapAsyncActor1<T, F, U>>, public MapAsyncActor1State<T, F, U, MapAsyncActor1<T, F, U>> {
															#line 5827 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapAsyncActor1<T, F, U>>::operator new;
	using FastAllocated<MapAsyncActor1<T, F, U>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >;
friend struct ActorCallback< MapAsyncActor1<T, F, U>, 1, U >;
friend struct ActorCallback< MapAsyncActor1<T, F, U>, 2, U >;
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor1(FutureStream<T> const& input,F const& actorFunc,PromiseStream<U> const& output) 
															#line 5840 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   MapAsyncActor1State<T, F, U, MapAsyncActor1<T, F, U>>(input, actorFunc, output)
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mapAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MapAsyncActor1<T, F, U>, 2, U >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U>
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> mapAsync( FutureStream<T> const& input, F const& actorFunc, PromiseStream<U> const& output ) {
															#line 381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new MapAsyncActor1<T, F, U>(input, actorFunc, output));
															#line 5871 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 416 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to be ready, and then applies a function to it.
															#line 5877 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via map()
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapActor>
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActorState {
															#line 5884 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActorState(Future<T> const& what,F const& func) 
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func)
															#line 5893 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("map", reinterpret_cast<unsigned long>(this));

	}
	~MapActorState() 
	{
		fdb_probe_actor_destroy("map", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5910 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MapActor*>(this)->actor_wait_state = 1;
															#line 420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MapActor, 0, T >*>(static_cast<MapActor*>(this)));
															#line 5915 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapActorState();
		static_cast<MapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor*>(this)->SAV<std::invoke_result_t<F, T>>::futures) { (void)(func(val)); this->~MapActorState(); static_cast<MapActor*>(this)->destroy(); return 0; }
															#line 5938 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor*>(this)->SAV< std::invoke_result_t<F, T> >::value()) std::invoke_result_t<F, T>(func(val));
		this->~MapActorState();
		static_cast<MapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor*>(this)->SAV<std::invoke_result_t<F, T>>::futures) { (void)(func(val)); this->~MapActorState(); static_cast<MapActor*>(this)->destroy(); return 0; }
															#line 5950 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor*>(this)->SAV< std::invoke_result_t<F, T> >::value()) std::invoke_result_t<F, T>(func(val));
		this->~MapActorState();
		static_cast<MapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapActor*>(this)->actor_wait_state > 0) static_cast<MapActor*>(this)->actor_wait_state = 0;
		static_cast<MapActor*>(this)->ActorCallback< MapActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< MapActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MapActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F func;
															#line 6025 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via map()
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor final : public Actor<std::invoke_result_t<F, T>>, public ActorCallback< MapActor<T, F>, 0, T >, public FastAllocated<MapActor<T, F>>, public MapActorState<T, F, MapActor<T, F>> {
															#line 6032 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapActor<T, F>>::operator new;
	using FastAllocated<MapActor<T, F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<std::invoke_result_t<F, T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< MapActor<T, F>, 0, T >;
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor(Future<T> const& what,F const& func) 
															#line 6043 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::invoke_result_t<F, T>>(),
		   MapActorState<T, F, MapActor<T, F>>(what, func)
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("map");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MapActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::invoke_result_t<F, T>> map( Future<T> const& what, F const& func ) {
															#line 418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::invoke_result_t<F, T>>(new MapActor<T, F>(what, func));
															#line 6073 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 423 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// maps a vector of futures
template <class T, class F>
auto map(std::vector<Future<T>> const& what, F const& func) {
	std::vector<Future<std::invoke_result_t<F, T>>> ret;
	ret.reserve(what.size());
	for (const auto& f : what)
		ret.push_back(map(f, func));
	return ret;
}

// maps a stream
															#line 6089 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via map()
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapActor1>
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor1State {
															#line 6096 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor1State(FutureStream<T> const& input,F const& func,PromiseStream<std::invoke_result_t<F, T>> const& output) 
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func),
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 6107 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("map", reinterpret_cast<unsigned long>(this));

	}
	~MapActor1State() 
	{
		fdb_probe_actor_destroy("map", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 437 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 6122 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapActor1State();
		static_cast<MapActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 449 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 451 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MapActor1State(); static_cast<MapActor1*>(this)->destroy(); return 0; }
															#line 6147 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MapActor1State();
		static_cast<MapActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 439 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 439 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<MapActor1*>(this)->actor_wait_state = 1;
															#line 439 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< MapActor1, 0, T >*>(static_cast<MapActor1*>(this)));
															#line 6174 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 6209 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 445 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6217 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(T const& nextInput,int loopDepth) 
	{
															#line 440 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(func(nextInput));
															#line 6232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(T && nextInput,int loopDepth) 
	{
															#line 440 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(func(nextInput));
															#line 6241 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(nextInput, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(nextInput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapActor1*>(this)->actor_wait_state > 0) static_cast<MapActor1*>(this)->actor_wait_state = 0;
		static_cast<MapActor1*>(this)->ActorSingleCallback< MapActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MapActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< MapActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< MapActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F func;
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<std::invoke_result_t<F, T>> output;
															#line 6328 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via map()
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor1 final : public Actor<Void>, public ActorSingleCallback< MapActor1<T, F>, 0, T >, public FastAllocated<MapActor1<T, F>>, public MapActor1State<T, F, MapActor1<T, F>> {
															#line 6335 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapActor1<T, F>>::operator new;
	using FastAllocated<MapActor1<T, F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< MapActor1<T, F>, 0, T >;
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor1(FutureStream<T> const& input,F const& func,PromiseStream<std::invoke_result_t<F, T>> const& output) 
															#line 6346 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   MapActor1State<T, F, MapActor1<T, F>>(input, func, output)
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("map");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< MapActor1<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> map( FutureStream<T> const& input, F const& func, PromiseStream<std::invoke_result_t<F, T>> const& output ) {
															#line 435 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new MapActor1<T, F>(input, func, output));
															#line 6376 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 453 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// X + Y will wait for X, then wait for and return the result of Y
															#line 6382 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via operatorPlus()
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B, class OperatorPlusActor>
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OperatorPlusActorState {
															#line 6389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OperatorPlusActorState(Future<A> const& a,Future<B> const& b) 
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : a(a),
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   b(b)
															#line 6398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("operatorPlus", reinterpret_cast<unsigned long>(this));

	}
	~OperatorPlusActorState() 
	{
		fdb_probe_actor_destroy("operatorPlus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 457 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<A> __when_expr_0 = a;
															#line 457 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6415 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OperatorPlusActor*>(this)->actor_wait_state = 1;
															#line 457 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 0, A >*>(static_cast<OperatorPlusActor*>(this)));
															#line 6420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(A const& resultA,int loopDepth) 
	{
															#line 458 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)resultA;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<B> __when_expr_1 = b;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6447 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OperatorPlusActor*>(this)->actor_wait_state = 2;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 1, B >*>(static_cast<OperatorPlusActor*>(this)));
															#line 6452 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(A && resultA,int loopDepth) 
	{
															#line 458 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)resultA;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<B> __when_expr_1 = b;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6465 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OperatorPlusActor*>(this)->actor_wait_state = 2;
															#line 459 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 1, B >*>(static_cast<OperatorPlusActor*>(this)));
															#line 6470 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(A const& resultA,int loopDepth) 
	{
		loopDepth = a_body1cont1(resultA, loopDepth);

		return loopDepth;
	}
	int a_body1when1(A && resultA,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resultA), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state > 0) static_cast<OperatorPlusActor*>(this)->actor_wait_state = 0;
		static_cast<OperatorPlusActor*>(this)->ActorCallback< OperatorPlusActor, 0, A >::remove();

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 0, A >*,A const& value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 0, A >*,A && value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OperatorPlusActor, 0, A >*,Error err) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(B const& resultB,int loopDepth) 
	{
															#line 460 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<OperatorPlusActor*>(this)->SAV<B>::futures) { (void)(resultB); this->~OperatorPlusActorState(); static_cast<OperatorPlusActor*>(this)->destroy(); return 0; }
															#line 6542 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<OperatorPlusActor*>(this)->SAV< B >::value()) B(resultB);
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(B && resultB,int loopDepth) 
	{
															#line 460 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<OperatorPlusActor*>(this)->SAV<B>::futures) { (void)(resultB); this->~OperatorPlusActorState(); static_cast<OperatorPlusActor*>(this)->destroy(); return 0; }
															#line 6554 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<OperatorPlusActor*>(this)->SAV< B >::value()) B(resultB);
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(B const& resultB,int loopDepth) 
	{
		loopDepth = a_body1cont2(resultB, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(B && resultB,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(resultB), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state > 0) static_cast<OperatorPlusActor*>(this)->actor_wait_state = 0;
		static_cast<OperatorPlusActor*>(this)->ActorCallback< OperatorPlusActor, 1, B >::remove();

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 1, B >*,B const& value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 1, B >*,B && value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OperatorPlusActor, 1, B >*,Error err) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<A> a;
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<B> b;
															#line 6629 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via operatorPlus()
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B>
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OperatorPlusActor final : public Actor<B>, public ActorCallback< OperatorPlusActor<A, B>, 0, A >, public ActorCallback< OperatorPlusActor<A, B>, 1, B >, public FastAllocated<OperatorPlusActor<A, B>>, public OperatorPlusActorState<A, B, OperatorPlusActor<A, B>> {
															#line 6636 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<OperatorPlusActor<A, B>>::operator new;
	using FastAllocated<OperatorPlusActor<A, B>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<B>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< OperatorPlusActor<A, B>, 0, A >;
friend struct ActorCallback< OperatorPlusActor<A, B>, 1, B >;
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OperatorPlusActor(Future<A> const& a,Future<B> const& b) 
															#line 6648 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<B>(),
		   OperatorPlusActorState<A, B, OperatorPlusActor<A, B>>(a, b)
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("operatorPlus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OperatorPlusActor<A, B>, 0, A >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OperatorPlusActor<A, B>, 1, B >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B>
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<B> operatorPlus( Future<A> const& a, Future<B> const& b ) {
															#line 455 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<B>(new OperatorPlusActor<A, B>(a, b));
															#line 6679 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 462 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class A, class B>
Future<B> operator+(Future<A> a, Future<B> b) {
	return operatorPlus(a, b);
}

// Returns if the future returns true, otherwise waits forever.
															#line 6690 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> returnIfTrue( Future<bool> const& f );

#line 470 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Returns if the future, when waited on and then evaluated with the predicate, returns true, otherwise waits forever
template <class T, class F>
Future<Void> returnIfTrue(Future<T> what, F pred) {
	return returnIfTrue(map(what, pred));
}

// filters a stream
															#line 6702 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via filter()
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class FilterActor>
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class FilterActorState {
															#line 6709 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FilterActorState(FutureStream<T> const& input,F const& pred,PromiseStream<T> const& output) 
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   pred(pred),
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 6720 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("filter", reinterpret_cast<unsigned long>(this));

	}
	~FilterActorState() 
	{
		fdb_probe_actor_destroy("filter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 480 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 6735 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FilterActorState();
		static_cast<FilterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 493 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 495 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<FilterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FilterActorState(); static_cast<FilterActor*>(this)->destroy(); return 0; }
															#line 6760 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<FilterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FilterActorState();
		static_cast<FilterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 482 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 482 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<FilterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6782 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FilterActor*>(this)->actor_wait_state = 1;
															#line 482 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FilterActor, 0, T >*>(static_cast<FilterActor*>(this)));
															#line 6787 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 486 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 6822 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 489 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6830 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(T const& nextInput,int loopDepth) 
	{
															#line 483 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pred(nextInput))
															#line 6845 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(nextInput);
															#line 6849 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(T && nextInput,int loopDepth) 
	{
															#line 483 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pred(nextInput))
															#line 6859 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(nextInput);
															#line 6863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(nextInput, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(nextInput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FilterActor*>(this)->actor_wait_state > 0) static_cast<FilterActor*>(this)->actor_wait_state = 0;
		static_cast<FilterActor*>(this)->ActorSingleCallback< FilterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FilterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FilterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FilterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F pred;
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 6951 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via filter()
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class FilterActor final : public Actor<Void>, public ActorSingleCallback< FilterActor<T, F>, 0, T >, public FastAllocated<FilterActor<T, F>>, public FilterActorState<T, F, FilterActor<T, F>> {
															#line 6958 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<FilterActor<T, F>>::operator new;
	using FastAllocated<FilterActor<T, F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FilterActor<T, F>, 0, T >;
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FilterActor(FutureStream<T> const& input,F const& pred,PromiseStream<T> const& output) 
															#line 6969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   FilterActorState<T, F, FilterActor<T, F>>(input, pred, output)
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("filter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FilterActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> filter( FutureStream<T> const& input, F const& pred, PromiseStream<T> const& output ) {
															#line 478 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new FilterActor<T, F>(input, pred, output));
															#line 6999 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 497 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// filters a stream asynchronously
															#line 7005 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via asyncFilter()
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class AsyncFilterActor>
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncFilterActorState {
															#line 7012 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncFilterActorState(FutureStream<T> const& input,F const& actorPred,PromiseStream<T> const& output) 
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorPred(actorPred),
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 501 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   futures(),
															#line 502 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   p()
															#line 7027 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("asyncFilter", reinterpret_cast<unsigned long>(this));

	}
	~AsyncFilterActorState() 
	{
		fdb_probe_actor_destroy("asyncFilter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 504 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 7042 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AsyncFilterActorState();
		static_cast<AsyncFilterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 525 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 7065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 507 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 506 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<AsyncFilterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7084 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 510 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<bool> __when_expr_1 = futures.size() == 0 ? Never() : futures.front().second;
															#line 7088 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<AsyncFilterActor*>(this)->actor_wait_state = 1;
															#line 507 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< AsyncFilterActor, 0, T >*>(static_cast<AsyncFilterActor*>(this)));
															#line 510 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AsyncFilterActor, 1, bool >*>(static_cast<AsyncFilterActor*>(this)));
															#line 7095 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 517 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 7130 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 520 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7138 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.emplace_back(nextInput, actorPred(nextInput));
															#line 7159 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.emplace_back(nextInput, actorPred(nextInput));
															#line 7168 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool const& pass,int loopDepth) 
	{
															#line 511 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7177 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 512 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(futures.front().first);
															#line 7181 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 513 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7185 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool && pass,int loopDepth) 
	{
															#line 511 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7194 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 512 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(futures.front().first);
															#line 7198 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 513 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7202 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state > 0) static_cast<AsyncFilterActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncFilterActor*>(this)->ActorSingleCallback< AsyncFilterActor, 0, T >::remove();
		static_cast<AsyncFilterActor*>(this)->ActorCallback< AsyncFilterActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorSingleCallback< AsyncFilterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< AsyncFilterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< AsyncFilterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AsyncFilterActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 533 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 535 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AsyncFilterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AsyncFilterActorState(); static_cast<AsyncFilterActor*>(this)->destroy(); return 0; }
															#line 7323 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AsyncFilterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AsyncFilterActorState();
		static_cast<AsyncFilterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 525 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!(futures.size()))
															#line 7342 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 526 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		p = futures.front();
															#line 527 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<bool> __when_expr_2 = p.second;
															#line 527 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<AsyncFilterActor*>(this)->actor_wait_state = 2;
															#line 527 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AsyncFilterActor, 2, bool >*>(static_cast<AsyncFilterActor*>(this)));
															#line 7357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool const& pass,int loopDepth) 
	{
															#line 528 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7379 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 529 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(p.first);
															#line 7383 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 530 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7387 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool && pass,int loopDepth) 
	{
															#line 528 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7396 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 529 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(p.first);
															#line 7400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 530 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7404 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool const& pass,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(pass, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool && pass,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(pass), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state > 0) static_cast<AsyncFilterActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncFilterActor*>(this)->ActorCallback< AsyncFilterActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AsyncFilterActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorPred;
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 501 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Deque<std::pair<T, Future<bool>>> futures;
															#line 502 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::pair<T, Future<bool>> p;
															#line 7482 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via asyncFilter()
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncFilterActor final : public Actor<Void>, public ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >, public ActorCallback< AsyncFilterActor<T, F>, 1, bool >, public ActorCallback< AsyncFilterActor<T, F>, 2, bool >, public FastAllocated<AsyncFilterActor<T, F>>, public AsyncFilterActorState<T, F, AsyncFilterActor<T, F>> {
															#line 7489 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AsyncFilterActor<T, F>>::operator new;
	using FastAllocated<AsyncFilterActor<T, F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >;
friend struct ActorCallback< AsyncFilterActor<T, F>, 1, bool >;
friend struct ActorCallback< AsyncFilterActor<T, F>, 2, bool >;
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncFilterActor(FutureStream<T> const& input,F const& actorPred,PromiseStream<T> const& output) 
															#line 7502 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   AsyncFilterActorState<T, F, AsyncFilterActor<T, F>>(input, actorPred, output)
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("asyncFilter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AsyncFilterActor<T, F>, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> asyncFilter( FutureStream<T> const& input, F const& actorPred, PromiseStream<T> const& output ) {
															#line 499 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new AsyncFilterActor<T, F>(input, actorPred, output));
															#line 7533 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 537 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
struct WorkerCache {
	// SOMEDAY: Would we do better to use "unreliable" (at most once) transport for the initialize requests and get rid
	// of this? It doesn't provide true at most once behavior because things are removed from the cache after they have
	// terminated.
	bool exists(UID id) { return id_interface.count(id) != 0; }
	void set(UID id, const Future<T>& onReady) {
		ASSERT(!exists(id));
		id_interface[id] = onReady;
	}
	Future<T> get(UID id) {
		ASSERT(exists(id));
		return id_interface[id];
	}

	Future<Void> removeOnReady(UID id, Future<Void> const& ready) { return removeOnReady(this, id, ready); }

private:
																#line 7556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via removeOnReady()
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class RemoveOnReadyActor>
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RemoveOnReadyActorState {
															#line 7562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RemoveOnReadyActorState(WorkerCache* const& self,UID const& id,Future<Void> const& ready) 
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   id(id),
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   ready(ready)
															#line 7573 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("removeOnReady", reinterpret_cast<unsigned long>(this));

	}
	~RemoveOnReadyActorState() 
	{
		fdb_probe_actor_destroy("removeOnReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 558 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = ready;
															#line 558 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RemoveOnReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7591 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RemoveOnReadyActor*>(this)->actor_wait_state = 1;
															#line 558 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveOnReadyActor, 0, Void >*>(static_cast<RemoveOnReadyActor*>(this)));
															#line 7596 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			self->id_interface.erase(id);
															#line 563 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 7628 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 559 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->id_interface.erase(id);
															#line 560 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<RemoveOnReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveOnReadyActorState(); static_cast<RemoveOnReadyActor*>(this)->destroy(); return 0; }
															#line 7644 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<RemoveOnReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 559 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->id_interface.erase(id);
															#line 560 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<RemoveOnReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveOnReadyActorState(); static_cast<RemoveOnReadyActor*>(this)->destroy(); return 0; }
															#line 7658 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<RemoveOnReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveOnReadyActor*>(this)->actor_wait_state > 0) static_cast<RemoveOnReadyActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveOnReadyActor*>(this)->ActorCallback< RemoveOnReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveOnReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveOnReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveOnReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WorkerCache* self;
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UID id;
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> ready;
															#line 7735 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via removeOnReady()
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RemoveOnReadyActor final : public Actor<Void>, public ActorCallback< RemoveOnReadyActor, 0, Void >, public FastAllocated<RemoveOnReadyActor>, public RemoveOnReadyActorState<RemoveOnReadyActor> {
															#line 7740 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RemoveOnReadyActor>::operator new;
	using FastAllocated<RemoveOnReadyActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveOnReadyActor, 0, Void >;
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RemoveOnReadyActor(WorkerCache* const& self,UID const& id,Future<Void> const& ready) 
															#line 7751 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RemoveOnReadyActorState<RemoveOnReadyActor>(self, id, ready)
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeOnReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveOnReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> removeOnReady( WorkerCache* const& self, UID const& id, Future<Void> const& ready ) {
															#line 556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RemoveOnReadyActor(self, id, ready));
															#line 7778 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 566 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

	std::map<UID, Future<T>> id_interface;
};

template <class K, class V>
class AsyncMap : NonCopyable {
public:
	// Represents a complete function from keys to values (K -> V)
	// All values not explicitly inserted map to V()
	// If this isn't appropriate, use V=Optional<X>

	AsyncMap() : defaultValue(), destructing(false) {}

	virtual ~AsyncMap() {
		destructing = true;
		items.clear();
	}

	void set(K const& k, V const& v) {
		auto& i = items[k];
		if (i.value != v)
			setUnconditional(k, v, i);
	}
	void setUnconditional(K const& k, V const& v) { setUnconditional(k, v, items[k]); }

	void sendError(K const& begin, K const& end, Error const& e) {
		if (begin >= end)
			return;
		std::vector<Promise<Void>> ps = swapRangePromises(items.lower_bound(begin), items.lower_bound(end));
		sendError(ps, e);
	}

	void triggerAll() {
		std::vector<Promise<Void>> ps = swapRangePromises(items.begin(), items.end());
		send(ps);
	}

	void triggerRange(K const& begin, K const& end) {
		if (begin >= end)
			return;
		std::vector<Promise<Void>> ps = swapRangePromises(items.lower_bound(begin), items.lower_bound(end));
		send(ps);
	}

	void trigger(K const& key) {
		if (items.count(key) != 0) {
			auto& i = items[key];
			Promise<Void> trigger;
			i.change.swap(trigger);
			Promise<Void> noDestroy = trigger; // See explanation of noDestroy in setUnconditional()

			if (i.value == defaultValue)
				items.erase(key);

			trigger.send(Void());
		}
	}
	void clear(K const& k) { set(k, V()); }
	V const& get(K const& k) const {
		auto it = items.find(k);
		if (it != items.end())
			return it->second.value;
		else
			return defaultValue;
	}
	int count(K const& k) const {
		auto it = items.find(k);
		if (it != items.end())
			return 1;
		return 0;
	}
	virtual Future<Void> onChange(K const& k) { // throws broken_promise if this is destroyed
		auto& item = items[k];
		if (item.value == defaultValue)
			return destroyOnCancel(this, k, item.change.getFuture());
		return item.change.getFuture();
	}
	std::vector<K> getKeys() const {
		std::vector<K> keys;
		keys.reserve(items.size());
		for (auto i = items.begin(); i != items.end(); ++i)
			keys.push_back(i->first);
		return keys;
	}
	void resetNoWaiting() {
		for (auto i = items.begin(); i != items.end(); ++i)
			ASSERT(i->second.change.getFuture().getFutureReferenceCount() == 1);
		items.clear();
	}

protected:
	// Invariant: Every item in the map either has value!=defaultValue xor a destroyOnCancel actor waiting on
	// change.getFuture()
	struct P {
		V value;
		Promise<Void> change;
		P() : value() {}
	};
	std::map<K, P> items;
	const V defaultValue;
	bool destructing;

	template <typename Iterator>
	std::vector<Promise<Void>> swapRangePromises(Iterator begin, Iterator end) {
		std::vector<Promise<Void>> ps;
		for (auto it = begin; it != end; ++it) {
			ps.resize(ps.size() + 1);
			ps.back().swap(it->second.change);
		}
		return ps;
	}

	// ps can't be a reference. See explanation of noDestroy in setUnconditional()
	void send(std::vector<Promise<Void>> ps) {
		for (auto& p : ps) {
			p.send(Void());
		}
	}

	// ps can't be a reference. See explanation of noDestroy in setUnconditional()
	void sendError(std::vector<Promise<Void>> ps, Error const& e) {
		for (auto& p : ps) {
			p.sendError(e);
		}
	}

	void setUnconditional(K const& k, V const& v, P& i) {
		Promise<Void> trigger;
		i.change.swap(trigger);
		Promise<Void> noDestroy =
		    trigger; // The send(Void()) or even V::operator= could cause destroyOnCancel,
		             // which could undo the change to i.value here.  Keeping the promise reference count >= 2
		             // prevents destroyOnCancel from erasing anything from the map.
		if (v == defaultValue) {
			items.erase(k);
		} else {
			i.value = v;
		}

		trigger.send(Void());
	}

																#line 7924 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via destroyOnCancel()
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class DestroyOnCancelActor>
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelActorState {
															#line 7930 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelActorState(AsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   change(change)
															#line 7941 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("destroyOnCancel", reinterpret_cast<unsigned long>(this));

	}
	~DestroyOnCancelActorState() 
	{
		fdb_probe_actor_destroy("destroyOnCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 710 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = change;
															#line 710 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<DestroyOnCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7959 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DestroyOnCancelActor*>(this)->actor_wait_state = 1;
															#line 710 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyOnCancelActor, 0, Void >*>(static_cast<DestroyOnCancelActor*>(this)));
															#line 7964 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 713 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled && !self->destructing && change.getFutureReferenceCount() == 1 && change.getPromiseReferenceCount() == 1)
															#line 7994 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 715 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (EXPENSIVE_VALIDATION)
															#line 7998 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				{
															#line 716 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					auto& p = self->items[key];
															#line 717 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					ASSERT(p.change.getFuture() == change);
															#line 8004 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				}
															#line 719 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				self->items.erase(key);
															#line 8008 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 721 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 8012 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 711 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelActorState(); static_cast<DestroyOnCancelActor*>(this)->destroy(); return 0; }
															#line 8026 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 711 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelActorState(); static_cast<DestroyOnCancelActor*>(this)->destroy(); return 0; }
															#line 8038 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyOnCancelActor*>(this)->actor_wait_state > 0) static_cast<DestroyOnCancelActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyOnCancelActor*>(this)->ActorCallback< DestroyOnCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyOnCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncMap* self;
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	K key;
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> change;
															#line 8115 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via destroyOnCancel()
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelActor final : public Actor<Void>, public ActorCallback< DestroyOnCancelActor, 0, Void >, public FastAllocated<DestroyOnCancelActor>, public DestroyOnCancelActorState<DestroyOnCancelActor> {
															#line 8120 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DestroyOnCancelActor>::operator new;
	using FastAllocated<DestroyOnCancelActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyOnCancelActor, 0, Void >;
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelActor(AsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 8131 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DestroyOnCancelActorState<DestroyOnCancelActor>(self, key, change)
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroyOnCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DestroyOnCancelActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> destroyOnCancel( AsyncMap* const& self, K const& key, Future<Void> const& change ) {
															#line 708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DestroyOnCancelActor(self, key, change));
															#line 8158 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 724 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

template <class V>
class ReferencedObject : NonCopyable, public ReferenceCounted<ReferencedObject<V>> {
public:
	ReferencedObject() : value() {}
	ReferencedObject(V const& v) : value(v) {}
	ReferencedObject(V&& v) : value(std::move(v)) {}
	ReferencedObject(ReferencedObject&& r) : value(std::move(r.value)) {}

	void operator=(ReferencedObject&& r) { value = std::move(r.value); }

	V const& get() const { return value; }

	V& mutate() { return value; }

	void set(V const& v) { value = v; }

	void set(V&& v) { value = std::move(v); }

	static Reference<ReferencedObject<V>> from(V const& v) { return makeReference<ReferencedObject<V>>(v); }

	static Reference<ReferencedObject<V>> from(V&& v) { return makeReference<ReferencedObject<V>>(std::move(v)); }

private:
	V value;
};

template <class V>
class AsyncVar : NonCopyable, public ReferenceCounted<AsyncVar<V>> {
public:
	AsyncVar() : value() {}
	AsyncVar(V const& v) : value(v) {}
	AsyncVar(AsyncVar&& av) : value(std::move(av.value)), nextChange(std::move(av.nextChange)) {}
	void operator=(AsyncVar&& av) {
		value = std::move(av.value);
		nextChange = std::move(av.nextChange);
	}

	V const& get() const { return value; }
	Future<Void> onChange() const { return nextChange.getFuture(); }
	void set(V const& v) {
		if (v != value)
			setUnconditional(v);
	}
	void setUnconditional(V const& v) {
		Promise<Void> t;
		this->nextChange.swap(t);
		this->value = v;
		t.send(Void());
	}
	void trigger() {
		Promise<Void> t;
		this->nextChange.swap(t);
		t.send(Void());
	}

private:
	V value;
	Promise<Void> nextChange;
};

class AsyncTrigger : NonCopyable {
public:
	AsyncTrigger() {}
	AsyncTrigger(AsyncTrigger&& at) : v(std::move(at.v)) {}
	void operator=(AsyncTrigger&& at) { v = std::move(at.v); }
	Future<Void> onTrigger() const { return v.onChange(); }
	void trigger() { v.trigger(); }

private:
	AsyncVar<Void> v;
};

// Binds an AsyncTrigger object to an AsyncVar, so when the AsyncVar changes
// the AsyncTrigger is triggered.
															#line 8238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forward()
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardActor>
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardActorState {
															#line 8245 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardActorState(Reference<AsyncVar<T> const> const& from,AsyncTrigger* const& to) 
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : from(from),
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   to(to)
															#line 8254 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forward", reinterpret_cast<unsigned long>(this));

	}
	~ForwardActorState() 
	{
		fdb_probe_actor_destroy("forward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 802 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 8269 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardActorState();
		static_cast<ForwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 803 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = from->onChange();
															#line 803 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<ForwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8301 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ForwardActor*>(this)->actor_wait_state = 1;
															#line 803 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardActor, 0, Void >*>(static_cast<ForwardActor*>(this)));
															#line 8306 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 804 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		to->trigger();
															#line 8315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 804 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		to->trigger();
															#line 8324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardActor*>(this)->actor_wait_state > 0) static_cast<ForwardActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardActor*>(this)->ActorCallback< ForwardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T> const> from;
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncTrigger* to;
															#line 8396 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forward()
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardActor final : public Actor<Void>, public ActorCallback< ForwardActor<T>, 0, Void >, public FastAllocated<ForwardActor<T>>, public ForwardActorState<T, ForwardActor<T>> {
															#line 8403 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardActor<T>>::operator new;
	using FastAllocated<ForwardActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardActor<T>, 0, Void >;
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardActor(Reference<AsyncVar<T> const> const& from,AsyncTrigger* const& to) 
															#line 8414 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ForwardActorState<T, ForwardActor<T>>(from, to)
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> forward( Reference<AsyncVar<T> const> const& from, AsyncTrigger* const& to ) {
															#line 800 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ForwardActor<T>(from, to));
															#line 8444 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 807 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

class Debouncer : NonCopyable {
public:
	explicit Debouncer(double delay) { worker = debounceWorker(this, delay); }
	Debouncer(Debouncer&& at) = default;
	Debouncer& operator=(Debouncer&& at) = default;
	Future<Void> onTrigger() { return output.onChange(); }
	void trigger() { input.setUnconditional(Void()); }

private:
	AsyncVar<Void> input;
	AsyncVar<Void> output;
	Future<Void> worker;

																#line 8462 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via debounceWorker()
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class DebounceWorkerActor>
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DebounceWorkerActorState {
															#line 8468 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DebounceWorkerActorState(Debouncer* const& self,double const& bounceTime) 
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   bounceTime(bounceTime)
															#line 8477 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("debounceWorker", reinterpret_cast<unsigned long>(this));

	}
	~DebounceWorkerActorState() 
	{
		fdb_probe_actor_destroy("debounceWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 822 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 8492 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DebounceWorkerActorState();
		static_cast<DebounceWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 823 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = self->input.onChange();
															#line 823 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8524 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 1;
															#line 823 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 0, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 8529 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 824 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 8538 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 824 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 8547 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 832 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->output.setUnconditional(Void());
															#line 8619 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 826 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = self->input.onChange();
															#line 825 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8637 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 827 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(bounceTime);
															#line 8641 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 2;
															#line 826 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 1, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 827 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 2, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 8648 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 1, Void >::remove();
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Debouncer* self;
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double bounceTime;
															#line 8797 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via debounceWorker()
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DebounceWorkerActor final : public Actor<Void>, public ActorCallback< DebounceWorkerActor, 0, Void >, public ActorCallback< DebounceWorkerActor, 1, Void >, public ActorCallback< DebounceWorkerActor, 2, Void >, public FastAllocated<DebounceWorkerActor>, public DebounceWorkerActorState<DebounceWorkerActor> {
															#line 8802 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DebounceWorkerActor>::operator new;
	using FastAllocated<DebounceWorkerActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DebounceWorkerActor, 0, Void >;
friend struct ActorCallback< DebounceWorkerActor, 1, Void >;
friend struct ActorCallback< DebounceWorkerActor, 2, Void >;
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DebounceWorkerActor(Debouncer* const& self,double const& bounceTime) 
															#line 8815 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DebounceWorkerActorState<DebounceWorkerActor>(self, bounceTime)
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("debounceWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DebounceWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DebounceWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> debounceWorker( Debouncer* const& self, double const& bounceTime ) {
															#line 821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DebounceWorkerActor(self, bounceTime));
															#line 8843 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 835 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

															#line 8849 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via asyncDeserialize()
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class AsyncDeserializeActor>
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncDeserializeActorState {
															#line 8856 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncDeserializeActorState(Reference<AsyncVar<Standalone<StringRef>>> const& input,Reference<AsyncVar<Optional<T>>> const& output) 
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 8865 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("asyncDeserialize", reinterpret_cast<unsigned long>(this));

	}
	~AsyncDeserializeActorState() 
	{
		fdb_probe_actor_destroy("asyncDeserialize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 840 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 8880 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AsyncDeserializeActorState();
		static_cast<AsyncDeserializeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 841 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (input->get().size())
															#line 8910 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 842 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			ObjectReader reader(input->get().begin(), IncludeVersion());
															#line 843 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			T res;
															#line 844 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			reader.deserialize(res);
															#line 845 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output->set(res);
															#line 8920 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		else
		{
															#line 847 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output->set(Optional<T>());
															#line 8926 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 848 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = input->onChange();
															#line 848 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<AsyncDeserializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8932 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AsyncDeserializeActor*>(this)->actor_wait_state = 1;
															#line 848 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AsyncDeserializeActor, 0, Void >*>(static_cast<AsyncDeserializeActor*>(this)));
															#line 8937 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AsyncDeserializeActor*>(this)->actor_wait_state > 0) static_cast<AsyncDeserializeActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncDeserializeActor*>(this)->ActorCallback< AsyncDeserializeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AsyncDeserializeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AsyncDeserializeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AsyncDeserializeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<Standalone<StringRef>>> input;
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<Optional<T>>> output;
															#line 9021 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via asyncDeserialize()
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncDeserializeActor final : public Actor<Void>, public ActorCallback< AsyncDeserializeActor<T>, 0, Void >, public FastAllocated<AsyncDeserializeActor<T>>, public AsyncDeserializeActorState<T, AsyncDeserializeActor<T>> {
															#line 9028 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AsyncDeserializeActor<T>>::operator new;
	using FastAllocated<AsyncDeserializeActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< AsyncDeserializeActor<T>, 0, Void >;
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncDeserializeActor(Reference<AsyncVar<Standalone<StringRef>>> const& input,Reference<AsyncVar<Optional<T>>> const& output) 
															#line 9039 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   AsyncDeserializeActorState<T, AsyncDeserializeActor<T>>(input, output)
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("asyncDeserialize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AsyncDeserializeActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> asyncDeserialize( Reference<AsyncVar<Standalone<StringRef>>> const& input, Reference<AsyncVar<Optional<T>>> const& output ) {
															#line 837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new AsyncDeserializeActor<T>(input, output));
															#line 9069 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 851 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 9074 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardVector()
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T, class ForwardVectorActor>
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardVectorActorState {
															#line 9081 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardVectorActorState(Future<V> const& values,std::vector<Promise<T>> const& out) 
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : values(values),
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(out)
															#line 9090 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardVector", reinterpret_cast<unsigned long>(this));

	}
	~ForwardVectorActorState() 
	{
		fdb_probe_actor_destroy("forwardVector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 854 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<V> __when_expr_0 = values;
															#line 854 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 9107 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<ForwardVectorActor*>(this)->actor_wait_state = 1;
															#line 854 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardVectorActor, 0, V >*>(static_cast<ForwardVectorActor*>(this)));
															#line 9111 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardVectorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(V const& in,int loopDepth) 
	{
															#line 855 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(in.size() == out.size());
															#line 856 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < out.size();i++) {
															#line 857 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out[i].send(in[i]);
															#line 9137 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(V && in,int loopDepth) 
	{
															#line 855 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(in.size() == out.size());
															#line 856 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < out.size();i++) {
															#line 857 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out[i].send(in[i]);
															#line 9151 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(V const& in,int loopDepth) 
	{
		loopDepth = a_body1cont1(in, loopDepth);

		return loopDepth;
	}
	int a_body1when1(V && in,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(in), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardVectorActor*>(this)->actor_wait_state > 0) static_cast<ForwardVectorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardVectorActor*>(this)->ActorCallback< ForwardVectorActor, 0, V >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardVectorActor, 0, V >*,V const& value) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardVectorActor, 0, V >*,V && value) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardVectorActor, 0, V >*,Error err) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardVectorActor*>(this);
															#line 9224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<V> values;
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Promise<T>> out;
															#line 9233 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardVector()
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T>
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardVectorActor final : public Actor<void>, public ActorCallback< ForwardVectorActor<V, T>, 0, V >, public FastAllocated<ForwardVectorActor<V, T>>, public ForwardVectorActorState<V, T, ForwardVectorActor<V, T>> {
															#line 9240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardVectorActor<V, T>>::operator new;
	using FastAllocated<ForwardVectorActor<V, T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardVectorActor<V, T>, 0, V >;
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardVectorActor(Future<V> const& values,std::vector<Promise<T>> const& out) 
															#line 9251 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardVectorActorState<V, T, ForwardVectorActor<V, T>>(values, out)
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardVector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T>
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardVector( Future<V> const& values, std::vector<Promise<T>> const& out ) {
															#line 852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardVectorActor<V, T>(values, out);
															#line 9272 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 859 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 9277 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via delayedAsyncVar()
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DelayedAsyncVarActor>
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedAsyncVarActorState {
															#line 9284 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedAsyncVarActorState(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out,double const& time) 
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(out),
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time)
															#line 9295 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("delayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	~DelayedAsyncVarActorState() 
	{
		fdb_probe_actor_destroy("delayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				;
															#line 9311 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayedAsyncVarActorState();
		static_cast<DelayedAsyncVarActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 869 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out->set(in->get());
															#line 870 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 9343 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = delay(time);
															#line 864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 1;
															#line 864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 0, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 9371 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 865 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out->set(in->get());
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9384 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 1, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 9389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 865 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out->set(in->get());
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9402 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 1, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 9407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedAsyncVarActor*>(this)->ActorCallback< DelayedAsyncVarActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedAsyncVarActor*>(this)->ActorCallback< DelayedAsyncVarActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> in;
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> out;
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 9556 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via delayedAsyncVar()
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedAsyncVarActor final : public Actor<Void>, public ActorCallback< DelayedAsyncVarActor<T>, 0, Void >, public ActorCallback< DelayedAsyncVarActor<T>, 1, Void >, public FastAllocated<DelayedAsyncVarActor<T>>, public DelayedAsyncVarActorState<T, DelayedAsyncVarActor<T>> {
															#line 9563 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DelayedAsyncVarActor<T>>::operator new;
	using FastAllocated<DelayedAsyncVarActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayedAsyncVarActor<T>, 0, Void >;
friend struct ActorCallback< DelayedAsyncVarActor<T>, 1, Void >;
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedAsyncVarActor(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out,double const& time) 
															#line 9575 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DelayedAsyncVarActorState<T, DelayedAsyncVarActor<T>>(in, out, time)
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayedAsyncVar");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayedAsyncVarActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DelayedAsyncVarActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> delayedAsyncVar( Reference<AsyncVar<T>> const& in, Reference<AsyncVar<T>> const& out, double const& time ) {
															#line 860 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DelayedAsyncVarActor<T>(in, out, time));
															#line 9606 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 873 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 9611 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via setAfter()
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SetAfterActor>
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetAfterActorState {
															#line 9618 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetAfterActorState(Reference<AsyncVar<T>> const& var,double const& time,T const& val) 
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : var(var),
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val)
															#line 9629 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("setAfter", reinterpret_cast<unsigned long>(this));

	}
	~SetAfterActorState() 
	{
		fdb_probe_actor_destroy("setAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 876 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = delay(time);
															#line 876 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SetAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9646 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetAfterActor*>(this)->actor_wait_state = 1;
															#line 876 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetAfterActor, 0, Void >*>(static_cast<SetAfterActor*>(this)));
															#line 9651 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 877 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 878 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetAfterActorState(); static_cast<SetAfterActor*>(this)->destroy(); return 0; }
															#line 9676 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 877 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 878 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetAfterActorState(); static_cast<SetAfterActor*>(this)->destroy(); return 0; }
															#line 9690 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetAfterActor*>(this)->actor_wait_state > 0) static_cast<SetAfterActor*>(this)->actor_wait_state = 0;
		static_cast<SetAfterActor*>(this)->ActorCallback< SetAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 9767 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via setAfter()
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetAfterActor final : public Actor<Void>, public ActorCallback< SetAfterActor<T>, 0, Void >, public FastAllocated<SetAfterActor<T>>, public SetAfterActorState<T, SetAfterActor<T>> {
															#line 9774 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SetAfterActor<T>>::operator new;
	using FastAllocated<SetAfterActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< SetAfterActor<T>, 0, Void >;
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetAfterActor(Reference<AsyncVar<T>> const& var,double const& time,T const& val) 
															#line 9785 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SetAfterActorState<T, SetAfterActor<T>>(var, time, val)
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetAfterActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> setAfter( Reference<AsyncVar<T>> const& var, double const& time, T const& val ) {
															#line 874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SetAfterActor<T>(var, time, val));
															#line 9815 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 880 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 9820 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via resetAfter()
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ResetAfterActor>
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ResetAfterActorState {
															#line 9827 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ResetAfterActorState(Reference<AsyncVar<T>> const& var,double const& time,T const& val,int const& warningLimit = -1,double const& warningResetDelay = 0,const char* const& context = nullptr) 
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : var(var),
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val),
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   warningLimit(warningLimit),
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   warningResetDelay(warningResetDelay),
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   context(context),
															#line 888 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   isEqual(var->get() == val),
															#line 889 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resetDelay(isEqual ? Never() : delay(time)),
															#line 890 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resetCount(0),
															#line 891 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   lastReset(now())
															#line 9852 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("resetAfter", reinterpret_cast<unsigned long>(this));

	}
	~ResetAfterActorState() 
	{
		fdb_probe_actor_destroy("resetAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 892 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 9867 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetAfterActorState();
		static_cast<ResetAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 894 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = resetDelay;
															#line 893 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<ResetAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9899 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 909 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = var->onChange();
															#line 9903 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ResetAfterActor*>(this)->actor_wait_state = 1;
															#line 894 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetAfterActor, 0, Void >*>(static_cast<ResetAfterActor*>(this)));
															#line 909 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResetAfterActor, 1, Void >*>(static_cast<ResetAfterActor*>(this)));
															#line 9910 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 911 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (isEqual && var->get() != val)
															#line 9919 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 912 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			isEqual = false;
															#line 913 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetDelay = delay(time);
															#line 9925 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 915 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!isEqual && var->get() == val)
															#line 9929 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 916 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			isEqual = true;
															#line 917 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetDelay = Never();
															#line 9935 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 896 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (now() - lastReset > warningResetDelay)
															#line 9947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 897 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetCount = 0;
															#line 9951 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 899 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetCount++;
															#line 900 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (context && warningLimit >= 0 && resetCount > warningLimit)
															#line 9957 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 901 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevWarnAlways, context) .detail("ResetCount", resetCount) .detail("LastReset", now() - lastReset);
															#line 9961 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 905 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lastReset = now();
															#line 906 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		isEqual = true;
															#line 907 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetDelay = Never();
															#line 9969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 896 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (now() - lastReset > warningResetDelay)
															#line 9980 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 897 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetCount = 0;
															#line 9984 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 899 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetCount++;
															#line 900 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (context && warningLimit >= 0 && resetCount > warningLimit)
															#line 9990 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 901 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevWarnAlways, context) .detail("ResetCount", resetCount) .detail("LastReset", now() - lastReset);
															#line 9994 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 905 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lastReset = now();
															#line 906 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		isEqual = true;
															#line 907 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetDelay = Never();
															#line 10002 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetAfterActor*>(this)->actor_wait_state > 0) static_cast<ResetAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ResetAfterActor*>(this)->ActorCallback< ResetAfterActor, 0, Void >::remove();
		static_cast<ResetAfterActor*>(this)->ActorCallback< ResetAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResetAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int warningLimit;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double warningResetDelay;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* context;
															#line 888 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool isEqual;
															#line 889 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> resetDelay;
															#line 890 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int resetCount;
															#line 891 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double lastReset;
															#line 10136 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via resetAfter()
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ResetAfterActor final : public Actor<Void>, public ActorCallback< ResetAfterActor<T>, 0, Void >, public ActorCallback< ResetAfterActor<T>, 1, Void >, public FastAllocated<ResetAfterActor<T>>, public ResetAfterActorState<T, ResetAfterActor<T>> {
															#line 10143 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ResetAfterActor<T>>::operator new;
	using FastAllocated<ResetAfterActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetAfterActor<T>, 0, Void >;
friend struct ActorCallback< ResetAfterActor<T>, 1, Void >;
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ResetAfterActor(Reference<AsyncVar<T>> const& var,double const& time,T const& val,int const& warningLimit = -1,double const& warningResetDelay = 0,const char* const& context = nullptr) 
															#line 10155 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ResetAfterActorState<T, ResetAfterActor<T>>(var, time, val, warningLimit, warningResetDelay, context)
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetAfterActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> resetAfter( Reference<AsyncVar<T>> const& var, double const& time, T const& val, int const& warningLimit = -1, double const& warningResetDelay = 0, const char* const& context = nullptr ) {
															#line 881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ResetAfterActor<T>(var, time, val, warningLimit, warningResetDelay, context));
															#line 10185 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 921 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 10190 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via setWhenDoneOrError()
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SetWhenDoneOrErrorActor>
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetWhenDoneOrErrorActorState {
															#line 10197 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetWhenDoneOrErrorActorState(Future<Void> const& condition,Reference<AsyncVar<T>> const& var,T const& val) 
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : condition(condition),
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   var(var),
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val)
															#line 10208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("setWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	~SetWhenDoneOrErrorActorState() 
	{
		fdb_probe_actor_destroy("setWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 925 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = condition;
															#line 925 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10226 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state = 1;
															#line 925 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*>(static_cast<SetWhenDoneOrErrorActor*>(this)));
															#line 10231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetWhenDoneOrErrorActorState();
		static_cast<SetWhenDoneOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 930 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 931 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetWhenDoneOrErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetWhenDoneOrErrorActorState(); static_cast<SetWhenDoneOrErrorActor*>(this)->destroy(); return 0; }
															#line 10262 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetWhenDoneOrErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetWhenDoneOrErrorActorState();
		static_cast<SetWhenDoneOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 927 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 10275 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 928 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 10279 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state > 0) static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<SetWhenDoneOrErrorActor*>(this)->ActorCallback< SetWhenDoneOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> condition;
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 10385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via setWhenDoneOrError()
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetWhenDoneOrErrorActor final : public Actor<Void>, public ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >, public FastAllocated<SetWhenDoneOrErrorActor<T>>, public SetWhenDoneOrErrorActorState<T, SetWhenDoneOrErrorActor<T>> {
															#line 10392 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SetWhenDoneOrErrorActor<T>>::operator new;
	using FastAllocated<SetWhenDoneOrErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >;
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetWhenDoneOrErrorActor(Future<Void> const& condition,Reference<AsyncVar<T>> const& var,T const& val) 
															#line 10403 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SetWhenDoneOrErrorActorState<T, SetWhenDoneOrErrorActor<T>>(condition, var, val)
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setWhenDoneOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> setWhenDoneOrError( Future<Void> const& condition, Reference<AsyncVar<T>> const& var, T const& val ) {
															#line 922 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SetWhenDoneOrErrorActor<T>(condition, var, val));
															#line 10433 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 933 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

Future<bool> allTrue(const std::vector<Future<bool>>& all);
Future<Void> anyTrue(std::vector<Reference<AsyncVar<bool>>> const& input, Reference<AsyncVar<bool>> const& output);
Future<Void> cancelOnly(std::vector<Future<Void>> const& futures);
Future<Void> timeoutWarningCollector(FutureStream<Void> const& input,
                                     double const& logDelay,
                                     const char* const& context,
                                     UID const& id);
															#line 10445 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<bool> quorumEqualsTrue( std::vector<Future<bool>> const& futures, int const& required );

#line 942 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
Future<Void> lowPriorityDelay(double const& waitTime);

															#line 10451 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via streamHelper()
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class StreamHelperActor>
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StreamHelperActorState {
															#line 10458 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StreamHelperActorState(PromiseStream<T> const& output,PromiseStream<Error> const& errors,Future<T> const& input) 
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : output(output),
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errors(errors),
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 10469 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("streamHelper", reinterpret_cast<unsigned long>(this));

	}
	~StreamHelperActorState() 
	{
		fdb_probe_actor_destroy("streamHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<StreamHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10487 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StreamHelperActor*>(this)->actor_wait_state = 1;
															#line 947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StreamHelperActor, 0, T >*>(static_cast<StreamHelperActor*>(this)));
															#line 10492 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StreamHelperActorState();
		static_cast<StreamHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 954 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<StreamHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StreamHelperActorState(); static_cast<StreamHelperActor*>(this)->destroy(); return 0; }
															#line 10521 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<StreamHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StreamHelperActorState();
		static_cast<StreamHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 950 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 10534 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 951 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 10538 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 952 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			errors.send(e);
															#line 10542 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 948 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(value);
															#line 10557 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 948 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(value);
															#line 10566 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StreamHelperActor*>(this)->actor_wait_state > 0) static_cast<StreamHelperActor*>(this)->actor_wait_state = 0;
		static_cast<StreamHelperActor*>(this)->ActorCallback< StreamHelperActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< StreamHelperActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StreamHelperActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StreamHelperActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<Error> errors;
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> input;
															#line 10653 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via streamHelper()
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StreamHelperActor final : public Actor<Void>, public ActorCallback< StreamHelperActor<T>, 0, T >, public FastAllocated<StreamHelperActor<T>>, public StreamHelperActorState<T, StreamHelperActor<T>> {
															#line 10660 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<StreamHelperActor<T>>::operator new;
	using FastAllocated<StreamHelperActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< StreamHelperActor<T>, 0, T >;
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StreamHelperActor(PromiseStream<T> const& output,PromiseStream<Error> const& errors,Future<T> const& input) 
															#line 10671 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   StreamHelperActorState<T, StreamHelperActor<T>>(output, errors, input)
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("streamHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StreamHelperActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> streamHelper( PromiseStream<T> const& output, PromiseStream<Error> const& errors, Future<T> const& input ) {
															#line 944 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new StreamHelperActor<T>(output, errors, input));
															#line 10701 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 956 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<Void> makeStream(const std::vector<Future<T>>& futures, PromiseStream<T>& stream, PromiseStream<Error>& errors) {
	std::vector<Future<Void>> forwarders;
	forwarders.reserve(futures.size());
	for (int f = 0; f < futures.size(); f++)
		forwarders.push_back(streamHelper(stream, errors, futures[f]));
	return cancelOnly(forwarders);
}

template <class T>
class QuorumCallback;

template <class T>
struct Quorum final : SAV<Void> {
	int antiQuorum;
	int count;

	static inline int sizeFor(int count) { return sizeof(Quorum<T>) + sizeof(QuorumCallback<T>) * count; }

	void destroy() override {
		int size = sizeFor(this->count);
		this->~Quorum();
		freeFast(size, this);
	}
	void cancel() override {
		int cancelled_callbacks = 0;
		for (int i = 0; i < count; i++)
			if (callbacks()[i].next) {
				callbacks()[i].remove();
				callbacks()[i].next = 0;
				++cancelled_callbacks;
			}
		if (canBeSet())
			sendError(actor_cancelled());
		for (int i = 0; i < cancelled_callbacks; i++)
			delPromiseRef();
	}
	explicit Quorum(int quorum, int count) : SAV<Void>(1, count), antiQuorum(count - quorum + 1), count(count) {
		if (!quorum)
			this->send(Void());
	}
	void oneSuccess() {
		if (getPromiseReferenceCount() == antiQuorum && canBeSet())
			this->sendAndDelPromiseRef(Void());
		else
			delPromiseRef();
	}
	void oneError(Error err) {
		if (canBeSet())
			this->sendErrorAndDelPromiseRef(err);
		else
			delPromiseRef();
	}

	QuorumCallback<T>* callbacks() { return (QuorumCallback<T>*)(this + 1); }
};

template <class T>
class QuorumCallback : public Callback<T> {
public:
	void fire(const T& value) override {
		Callback<T>::remove();
		Callback<T>::next = 0;
		head->oneSuccess();
	}
	void error(Error error) override {
		Callback<T>::remove();
		Callback<T>::next = 0;
		head->oneError(error);
	}

private:
	template <class U>
	friend Future<Void> quorum(const Future<U>* pItems, int itemCount, int n);
	Quorum<T>* head;
	QuorumCallback() = default;
	QuorumCallback(Future<T> future, Quorum<T>* head) : head(head) { future.addCallbackAndClear(this); }
};

template <class T>
Future<Void> quorum(const Future<T>* pItems, int itemCount, int n) {
	ASSERT(n >= 0 && n <= itemCount);

	int size = Quorum<T>::sizeFor(itemCount);
	Quorum<T>* q = new (allocateFast(size)) Quorum<T>(n, itemCount);

	QuorumCallback<T>* nextCallback = q->callbacks();
	for (int i = 0; i < itemCount; ++i) {
		auto& r = pItems[i];
		if (r.isReady()) {
			new (nextCallback) QuorumCallback<T>();
			nextCallback->next = 0;
			if (r.isError())
				q->oneError(r.getError());
			else
				q->oneSuccess();
		} else
			new (nextCallback) QuorumCallback<T>(r, q);
		++nextCallback;
	}
	return Future<Void>(q);
}

template <class T>
Future<Void> quorum(std::vector<Future<T>> const& results, int n) {
	return quorum(&results.front(), results.size(), n);
}

															#line 10814 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via smartQuorum()
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SmartQuorumActor>
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SmartQuorumActorState {
															#line 10821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SmartQuorumActorState(std::vector<Future<T>> const& results,int const& required,double const& extraSeconds,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : results(results),
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   required(required),
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   extraSeconds(extraSeconds),
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 10834 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("smartQuorum", reinterpret_cast<unsigned long>(this));

	}
	~SmartQuorumActorState() 
	{
		fdb_probe_actor_destroy("smartQuorum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1070 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (results.empty() && required == 0)
															#line 10849 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1071 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 10853 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~SmartQuorumActorState();
				static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1072 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(results, required);
															#line 1072 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SmartQuorumActor*>(this)->actor_wait_state = 1;
															#line 1072 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 0, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 10868 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1074 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = quorum(results, (int)results.size());
															#line 1073 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10893 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(extraSeconds, taskID);
															#line 10897 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<SmartQuorumActor*>(this)->actor_wait_state = 2;
															#line 1074 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 1, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 1077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 2, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 10904 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1074 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = quorum(results, (int)results.size());
															#line 1073 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10915 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(extraSeconds, taskID);
															#line 10919 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<SmartQuorumActor*>(this)->actor_wait_state = 2;
															#line 1074 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 1, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 1077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 2, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 10926 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state > 0) static_cast<SmartQuorumActor*>(this)->actor_wait_state = 0;
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1075 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 10998 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
															#line 1075 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 11010 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
															#line 1078 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 11022 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
															#line 1078 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 11034 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state > 0) static_cast<SmartQuorumActor*>(this)->actor_wait_state = 0;
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 1, Void >::remove();
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> results;
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int required;
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double extraSeconds;
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 11147 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via smartQuorum()
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SmartQuorumActor final : public Actor<Void>, public ActorCallback< SmartQuorumActor<T>, 0, Void >, public ActorCallback< SmartQuorumActor<T>, 1, Void >, public ActorCallback< SmartQuorumActor<T>, 2, Void >, public FastAllocated<SmartQuorumActor<T>>, public SmartQuorumActorState<T, SmartQuorumActor<T>> {
															#line 11154 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SmartQuorumActor<T>>::operator new;
	using FastAllocated<SmartQuorumActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< SmartQuorumActor<T>, 0, Void >;
friend struct ActorCallback< SmartQuorumActor<T>, 1, Void >;
friend struct ActorCallback< SmartQuorumActor<T>, 2, Void >;
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SmartQuorumActor(std::vector<Future<T>> const& results,int const& required,double const& extraSeconds,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 11167 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SmartQuorumActorState<T, SmartQuorumActor<T>>(results, required, extraSeconds, taskID)
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("smartQuorum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SmartQuorumActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SmartQuorumActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> smartQuorum( std::vector<Future<T>> const& results, int const& required, double const& extraSeconds, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 1065 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SmartQuorumActor<T>(results, required, extraSeconds, taskID));
															#line 11198 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1082 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<Void> waitForAll(std::vector<Future<T>> const& results) {
	if (results.empty())
		return Void();
	return quorum(results, (int)results.size());
}

// Wait for all futures in results to be ready and then throw the first (in execution order) error
// if any of them resulted in an error.
template <class T>
Future<Void> waitForAllReadyThenThrow(std::vector<Future<T>> const& results) {
	Future<Void> f = waitForAll(results);
	Future<Void> fReady = waitForAllReady(results);
	return fReady + f;
}

template <class T>
Future<Void> waitForAny(std::vector<Future<T>> const& results) {
	if (results.empty())
		return Void();
	return quorum(results, 1);
}

															#line 11226 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> waitForMost( std::vector<Future<ErrorOr<Void>>> const& futures, int const& faultTolerance, Error const& e, double const& waitMultiplierForSlowFutures = 1.0 );

#line 1110 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<bool> shortCircuitAny( std::vector<Future<bool>> const& f );

#line 1112 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11236 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via getAll()
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class GetAllActor>
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class GetAllActorState {
															#line 11243 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	GetAllActorState(std::vector<Future<T>> const& input) 
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 11250 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("getAll", reinterpret_cast<unsigned long>(this));

	}
	~GetAllActorState() 
	{
		fdb_probe_actor_destroy("getAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1115 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (input.empty())
															#line 11265 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1116 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(std::vector<T>()); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 11269 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(std::vector<T>());
				this->~GetAllActorState();
				static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1117 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(input, input.size());
															#line 1117 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<GetAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11279 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAllActor*>(this)->actor_wait_state = 1;
															#line 1117 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllActor, 0, Void >*>(static_cast<GetAllActor*>(this)));
															#line 11284 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1120 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(input.size());
															#line 1121 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1122 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.push_back(input[i].get());
															#line 11313 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1123 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 11317 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1120 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(input.size());
															#line 1121 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1122 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.push_back(input[i].get());
															#line 11335 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1123 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 11339 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllActor*>(this)->actor_wait_state > 0) static_cast<GetAllActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllActor*>(this)->ActorCallback< GetAllActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> input;
															#line 11412 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via getAll()
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class GetAllActor final : public Actor<std::vector<T>>, public ActorCallback< GetAllActor<T>, 0, Void >, public FastAllocated<GetAllActor<T>>, public GetAllActorState<T, GetAllActor<T>> {
															#line 11419 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<GetAllActor<T>>::operator new;
	using FastAllocated<GetAllActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<std::vector<T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllActor<T>, 0, Void >;
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	GetAllActor(std::vector<Future<T>> const& input) 
															#line 11430 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::vector<T>>(),
		   GetAllActorState<T, GetAllActor<T>>(input)
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::vector<T>> getAll( std::vector<Future<T>> const& input ) {
															#line 1113 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::vector<T>>(new GetAllActor<T>(input));
															#line 11460 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1125 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11465 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via appendAll()
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class AppendAllActor>
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AppendAllActorState {
															#line 11472 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AppendAllActorState(std::vector<Future<std::vector<T>>> const& input) 
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 11479 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("appendAll", reinterpret_cast<unsigned long>(this));

	}
	~AppendAllActorState() 
	{
		fdb_probe_actor_destroy("appendAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1128 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(input, input.size());
															#line 1128 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<AppendAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11496 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AppendAllActor*>(this)->actor_wait_state = 1;
															#line 1128 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AppendAllActor, 0, Void >*>(static_cast<AppendAllActor*>(this)));
															#line 11501 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1131 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		size_t sz = 0;
															#line 1132 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for( const auto& f : input ) {
															#line 1133 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			sz += f.get().size();
															#line 11530 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1135 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(sz);
															#line 1137 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1138 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			auto const& r = input[i].get();
															#line 1139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.insert(output.end(), r.begin(), r.end());
															#line 11540 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1141 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AppendAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~AppendAllActorState(); static_cast<AppendAllActor*>(this)->destroy(); return 0; }
															#line 11544 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AppendAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1131 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		size_t sz = 0;
															#line 1132 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for( const auto& f : input ) {
															#line 1133 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			sz += f.get().size();
															#line 11562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1135 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(sz);
															#line 1137 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1138 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			auto const& r = input[i].get();
															#line 1139 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.insert(output.end(), r.begin(), r.end());
															#line 11572 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1141 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AppendAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~AppendAllActorState(); static_cast<AppendAllActor*>(this)->destroy(); return 0; }
															#line 11576 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AppendAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AppendAllActor*>(this)->actor_wait_state > 0) static_cast<AppendAllActor*>(this)->actor_wait_state = 0;
		static_cast<AppendAllActor*>(this)->ActorCallback< AppendAllActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AppendAllActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AppendAllActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AppendAllActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<std::vector<T>>> input;
															#line 11649 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via appendAll()
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AppendAllActor final : public Actor<std::vector<T>>, public ActorCallback< AppendAllActor<T>, 0, Void >, public FastAllocated<AppendAllActor<T>>, public AppendAllActorState<T, AppendAllActor<T>> {
															#line 11656 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AppendAllActor<T>>::operator new;
	using FastAllocated<AppendAllActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<std::vector<T>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< AppendAllActor<T>, 0, Void >;
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AppendAllActor(std::vector<Future<std::vector<T>>> const& input) 
															#line 11667 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::vector<T>>(),
		   AppendAllActorState<T, AppendAllActor<T>>(input)
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("appendAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AppendAllActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::vector<T>> appendAll( std::vector<Future<std::vector<T>>> const& input ) {
															#line 1126 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::vector<T>>(new AppendAllActor<T>(input));
															#line 11697 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1143 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11702 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via onEqual()
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class OnEqualActor>
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OnEqualActorState {
															#line 11709 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OnEqualActorState(Future<T> const& in,T const& equalTo) 
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   equalTo(equalTo)
															#line 11718 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("onEqual", reinterpret_cast<unsigned long>(this));

	}
	~OnEqualActorState() 
	{
		fdb_probe_actor_destroy("onEqual", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = in;
															#line 1146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11735 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnEqualActor*>(this)->actor_wait_state = 1;
															#line 1146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 0, T >*>(static_cast<OnEqualActor*>(this)));
															#line 11740 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnEqualActorState();
		static_cast<OnEqualActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& t,int loopDepth) 
	{
															#line 1147 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t == equalTo)
															#line 11763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1148 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<OnEqualActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnEqualActorState(); static_cast<OnEqualActor*>(this)->destroy(); return 0; }
															#line 11767 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<OnEqualActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnEqualActorState();
			static_cast<OnEqualActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11777 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnEqualActor*>(this)->actor_wait_state = 2;
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 1, Void >*>(static_cast<OnEqualActor*>(this)));
															#line 11782 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T && t,int loopDepth) 
	{
															#line 1147 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t == equalTo)
															#line 11791 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1148 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<OnEqualActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnEqualActorState(); static_cast<OnEqualActor*>(this)->destroy(); return 0; }
															#line 11795 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<OnEqualActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnEqualActorState();
			static_cast<OnEqualActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11805 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnEqualActor*>(this)->actor_wait_state = 2;
															#line 1149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 1, Void >*>(static_cast<OnEqualActor*>(this)));
															#line 11810 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnEqualActor*>(this)->actor_wait_state > 0) static_cast<OnEqualActor*>(this)->actor_wait_state = 0;
		static_cast<OnEqualActor*>(this)->ActorCallback< OnEqualActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnEqualActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1150 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 11882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1150 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 11890 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnEqualActor*>(this)->actor_wait_state > 0) static_cast<OnEqualActor*>(this)->actor_wait_state = 0;
		static_cast<OnEqualActor*>(this)->ActorCallback< OnEqualActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnEqualActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T equalTo;
															#line 11961 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via onEqual()
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OnEqualActor final : public Actor<Void>, public ActorCallback< OnEqualActor<T>, 0, T >, public ActorCallback< OnEqualActor<T>, 1, Void >, public FastAllocated<OnEqualActor<T>>, public OnEqualActorState<T, OnEqualActor<T>> {
															#line 11968 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<OnEqualActor<T>>::operator new;
	using FastAllocated<OnEqualActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< OnEqualActor<T>, 0, T >;
friend struct ActorCallback< OnEqualActor<T>, 1, Void >;
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OnEqualActor(Future<T> const& in,T const& equalTo) 
															#line 11980 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   OnEqualActorState<T, OnEqualActor<T>>(in, equalTo)
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onEqual");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnEqualActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnEqualActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> onEqual( Future<T> const& in, T const& equalTo ) {
															#line 1144 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new OnEqualActor<T>(in, equalTo));
															#line 12011 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1152 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12016 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via success()
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SuccessActor>
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SuccessActorState {
															#line 12023 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SuccessActorState(Future<T> const& of) 
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : of(of)
															#line 12030 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("success", reinterpret_cast<unsigned long>(this));

	}
	~SuccessActorState() 
	{
		fdb_probe_actor_destroy("success", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1155 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = of;
															#line 1155 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SuccessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12047 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SuccessActor*>(this)->actor_wait_state = 1;
															#line 1155 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SuccessActor, 0, T >*>(static_cast<SuccessActor*>(this)));
															#line 12052 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& t,int loopDepth) 
	{
															#line 1156 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 1157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SuccessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SuccessActorState(); static_cast<SuccessActor*>(this)->destroy(); return 0; }
															#line 12077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SuccessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && t,int loopDepth) 
	{
															#line 1156 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 1157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SuccessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SuccessActorState(); static_cast<SuccessActor*>(this)->destroy(); return 0; }
															#line 12091 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SuccessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SuccessActor*>(this)->actor_wait_state > 0) static_cast<SuccessActor*>(this)->actor_wait_state = 0;
		static_cast<SuccessActor*>(this)->ActorCallback< SuccessActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< SuccessActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SuccessActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SuccessActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> of;
															#line 12164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via success()
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SuccessActor final : public Actor<Void>, public ActorCallback< SuccessActor<T>, 0, T >, public FastAllocated<SuccessActor<T>>, public SuccessActorState<T, SuccessActor<T>> {
															#line 12171 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SuccessActor<T>>::operator new;
	using FastAllocated<SuccessActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< SuccessActor<T>, 0, T >;
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SuccessActor(Future<T> const& of) 
															#line 12182 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SuccessActorState<T, SuccessActor<T>>(of)
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("success");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SuccessActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> success( Future<T> const& of ) {
															#line 1153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SuccessActor<T>(of));
															#line 12212 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1159 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12217 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via ready()
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ReadyActor>
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReadyActorState {
															#line 12224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReadyActorState(Future<T> const& f) 
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 12231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 1163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12249 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadyActor*>(this)->actor_wait_state = 1;
															#line 1163 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadyActor, 0, T >*>(static_cast<ReadyActor*>(this)));
															#line 12254 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadyActorState();
		static_cast<ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1167 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadyActorState(); static_cast<ReadyActor*>(this)->destroy(); return 0; }
															#line 12283 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadyActorState();
		static_cast<ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 12308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 12317 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadyActor*>(this)->actor_wait_state > 0) static_cast<ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadyActor*>(this)->ActorCallback< ReadyActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ReadyActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadyActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadyActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 12400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via ready()
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReadyActor final : public Actor<Void>, public ActorCallback< ReadyActor<T>, 0, T >, public FastAllocated<ReadyActor<T>>, public ReadyActorState<T, ReadyActor<T>> {
															#line 12407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ReadyActor<T>>::operator new;
	using FastAllocated<ReadyActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadyActor<T>, 0, T >;
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReadyActor(Future<T> const& f) 
															#line 12418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ReadyActorState<T, ReadyActor<T>>(f)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadyActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> ready( Future<T> const& f ) {
															#line 1160 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ReadyActor<T>(f));
															#line 12448 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12453 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitAndForward()
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitAndForwardActor>
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitAndForwardActorState {
															#line 12460 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitAndForwardActorState(FutureStream<T> const& input) 
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 12467 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitAndForward", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndForwardActorState() 
	{
		fdb_probe_actor_destroy("waitAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 1172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitAndForwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<WaitAndForwardActor*>(this)->actor_wait_state = 1;
															#line 1172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitAndForwardActor, 0, T >*>(static_cast<WaitAndForwardActor*>(this)));
															#line 12489 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& output,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitAndForwardActor*>(this)->SAV<T>::futures) { (void)(output); this->~WaitAndForwardActorState(); static_cast<WaitAndForwardActor*>(this)->destroy(); return 0; }
															#line 12512 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitAndForwardActor*>(this)->SAV< T >::value()) T(output);
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && output,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitAndForwardActor*>(this)->SAV<T>::futures) { (void)(output); this->~WaitAndForwardActorState(); static_cast<WaitAndForwardActor*>(this)->destroy(); return 0; }
															#line 12524 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitAndForwardActor*>(this)->SAV< T >::value()) T(output);
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& output,int loopDepth) 
	{
		loopDepth = a_body1cont1(output, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && output,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(output), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndForwardActor*>(this)->actor_wait_state > 0) static_cast<WaitAndForwardActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndForwardActor*>(this)->ActorSingleCallback< WaitAndForwardActor, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitAndForwardActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitAndForwardActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitAndForwardActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 12597 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitAndForward()
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitAndForwardActor final : public Actor<T>, public ActorSingleCallback< WaitAndForwardActor<T>, 0, T >, public FastAllocated<WaitAndForwardActor<T>>, public WaitAndForwardActorState<T, WaitAndForwardActor<T>> {
															#line 12604 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitAndForwardActor<T>>::operator new;
	using FastAllocated<WaitAndForwardActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitAndForwardActor<T>, 0, T >;
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitAndForwardActor(FutureStream<T> const& input) 
															#line 12615 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitAndForwardActorState<T, WaitAndForwardActor<T>>(input)
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitAndForwardActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitAndForward( FutureStream<T> const& input ) {
															#line 1170 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitAndForwardActor<T>(input));
															#line 12645 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1175 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12650 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via reportErrorsExcept()
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ReportErrorsExceptActor>
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReportErrorsExceptActorState {
															#line 12657 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReportErrorsExceptActorState(Future<T> const& in,const char* const& context,UID const& id,std::set<int> const* const& pExceptErrors) 
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   context(context),
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   id(id),
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   pExceptErrors(pExceptErrors)
															#line 12670 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("reportErrorsExcept", reinterpret_cast<unsigned long>(this));

	}
	~ReportErrorsExceptActorState() 
	{
		fdb_probe_actor_destroy("reportErrorsExcept", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1179 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1179 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12688 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state = 1;
															#line 1179 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportErrorsExceptActor, 0, T >*>(static_cast<ReportErrorsExceptActor*>(this)));
															#line 12693 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1182 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() != error_code_actor_cancelled && (!pExceptErrors || !pExceptErrors->count(e.code())))
															#line 12723 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(SevError, context, id).error(e);
															#line 12727 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1184 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 12731 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReportErrorsExceptActor*>(this)->SAV<T>::futures) { (void)(t); this->~ReportErrorsExceptActorState(); static_cast<ReportErrorsExceptActor*>(this)->destroy(); return 0; }
															#line 12745 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReportErrorsExceptActor*>(this)->SAV< T >::value()) T(t);
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReportErrorsExceptActor*>(this)->SAV<T>::futures) { (void)(t); this->~ReportErrorsExceptActorState(); static_cast<ReportErrorsExceptActor*>(this)->destroy(); return 0; }
															#line 12757 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReportErrorsExceptActor*>(this)->SAV< T >::value()) T(t);
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state > 0) static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state = 0;
		static_cast<ReportErrorsExceptActor*>(this)->ActorCallback< ReportErrorsExceptActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ReportErrorsExceptActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportErrorsExceptActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportErrorsExceptActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* context;
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UID id;
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::set<int> const* pExceptErrors;
															#line 12836 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via reportErrorsExcept()
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReportErrorsExceptActor final : public Actor<T>, public ActorCallback< ReportErrorsExceptActor<T>, 0, T >, public FastAllocated<ReportErrorsExceptActor<T>>, public ReportErrorsExceptActorState<T, ReportErrorsExceptActor<T>> {
															#line 12843 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ReportErrorsExceptActor<T>>::operator new;
	using FastAllocated<ReportErrorsExceptActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportErrorsExceptActor<T>, 0, T >;
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReportErrorsExceptActor(Future<T> const& in,const char* const& context,UID const& id,std::set<int> const* const& pExceptErrors) 
															#line 12854 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ReportErrorsExceptActorState<T, ReportErrorsExceptActor<T>>(in, context, id, pExceptErrors)
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportErrorsExcept");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportErrorsExceptActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> reportErrorsExcept( Future<T> const& in, const char* const& context, UID const& id, std::set<int> const* const& pExceptErrors ) {
															#line 1176 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ReportErrorsExceptActor<T>(in, context, id, pExceptErrors));
															#line 12884 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1187 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<T> reportErrors(Future<T> const& in, const char* context, UID id = UID()) {
	return reportErrorsExcept(in, context, id, nullptr);
}

															#line 12894 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via require()
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class RequireActor>
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RequireActorState {
															#line 12901 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RequireActorState(Future<Optional<T>> const& in,int const& errorCode) 
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorCode(errorCode)
															#line 12910 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("require", reinterpret_cast<unsigned long>(this));

	}
	~RequireActorState() 
	{
		fdb_probe_actor_destroy("require", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Optional<T>> __when_expr_0 = in;
															#line 1195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RequireActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12927 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RequireActor*>(this)->actor_wait_state = 1;
															#line 1195 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireActor, 0, Optional<T> >*>(static_cast<RequireActor*>(this)));
															#line 12932 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireActorState();
		static_cast<RequireActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<T> const& o,int loopDepth) 
	{
															#line 1196 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (o.present())
															#line 12955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1197 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<RequireActor*>(this)->SAV<T>::futures) { (void)(o.get()); this->~RequireActorState(); static_cast<RequireActor*>(this)->destroy(); return 0; }
															#line 12959 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<RequireActor*>(this)->SAV< T >::value()) T(o.get());
			this->~RequireActorState();
			static_cast<RequireActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1199 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(Error(errorCode), loopDepth);
															#line 12969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<T> && o,int loopDepth) 
	{
															#line 1196 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (o.present())
															#line 12978 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1197 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<RequireActor*>(this)->SAV<T>::futures) { (void)(o.get()); this->~RequireActorState(); static_cast<RequireActor*>(this)->destroy(); return 0; }
															#line 12982 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<RequireActor*>(this)->SAV< T >::value()) T(o.get());
			this->~RequireActorState();
			static_cast<RequireActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1199 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(Error(errorCode), loopDepth);
															#line 12992 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}

		return loopDepth;
	}
	int a_body1when1(Optional<T> const& o,int loopDepth) 
	{
		loopDepth = a_body1cont1(o, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<T> && o,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(o), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireActor*>(this)->actor_wait_state > 0) static_cast<RequireActor*>(this)->actor_wait_state = 0;
		static_cast<RequireActor*>(this)->ActorCallback< RequireActor, 0, Optional<T> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireActor, 0, Optional<T> >*,Optional<T> const& value) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireActor, 0, Optional<T> >*,Optional<T> && value) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireActor, 0, Optional<T> >*,Error err) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Optional<T>> in;
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int errorCode;
															#line 13064 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via require()
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RequireActor final : public Actor<T>, public ActorCallback< RequireActor<T>, 0, Optional<T> >, public FastAllocated<RequireActor<T>>, public RequireActorState<T, RequireActor<T>> {
															#line 13071 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RequireActor<T>>::operator new;
	using FastAllocated<RequireActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireActor<T>, 0, Optional<T> >;
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RequireActor(Future<Optional<T>> const& in,int const& errorCode) 
															#line 13082 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   RequireActorState<T, RequireActor<T>>(in, errorCode)
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("require");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireActor<T>, 0, Optional<T> >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> require( Future<Optional<T>> const& in, int const& errorCode ) {
															#line 1193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new RequireActor<T>(in, errorCode));
															#line 13112 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1202 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13117 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitForFirst()
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitForFirstActor>
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForFirstActorState {
															#line 13124 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForFirstActorState(std::vector<Future<T>> const& items) 
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : items(items),
															#line 1205 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resultStream(),
															#line 1206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorStream(),
															#line 1208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   forCancellation(makeStream(items, resultStream, errorStream)),
															#line 1210 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resultFutureStream(resultStream.getFuture()),
															#line 1211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorFutureStream(errorStream.getFuture())
															#line 13141 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitForFirst", reinterpret_cast<unsigned long>(this));

	}
	~WaitForFirstActorState() 
	{
		fdb_probe_actor_destroy("waitForFirst", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1214 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = resultFutureStream;
															#line 1213 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitForFirstActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13158 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
															#line 1218 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<Error> __when_expr_1 = errorFutureStream;
															#line 13162 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.pop(), loopDepth); };
			static_cast<WaitForFirstActor*>(this)->actor_wait_state = 1;
															#line 1214 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitForFirstActor, 0, T >*>(static_cast<WaitForFirstActor*>(this)));
															#line 1218 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< WaitForFirstActor, 1, Error >*>(static_cast<WaitForFirstActor*>(this)));
															#line 13169 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
															#line 1215 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1216 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitForFirstActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitForFirstActorState(); static_cast<WaitForFirstActor*>(this)->destroy(); return 0; }
															#line 13194 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitForFirstActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
															#line 1215 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1216 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitForFirstActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitForFirstActorState(); static_cast<WaitForFirstActor*>(this)->destroy(); return 0; }
															#line 13208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitForFirstActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Error const& e,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1220 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 13222 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Error && e,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1220 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 13232 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForFirstActor*>(this)->actor_wait_state > 0) static_cast<WaitForFirstActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForFirstActor*>(this)->ActorSingleCallback< WaitForFirstActor, 0, T >::remove();
		static_cast<WaitForFirstActor*>(this)->ActorSingleCallback< WaitForFirstActor, 1, Error >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitForFirstActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error const& value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error && value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error err) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> items;
															#line 1205 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> resultStream;
															#line 1206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<Error> errorStream;
															#line 1208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> forCancellation;
															#line 1210 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> resultFutureStream;
															#line 1211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<Error> errorFutureStream;
															#line 13345 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitForFirst()
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForFirstActor final : public Actor<T>, public ActorSingleCallback< WaitForFirstActor<T>, 0, T >, public ActorSingleCallback< WaitForFirstActor<T>, 1, Error >, public FastAllocated<WaitForFirstActor<T>>, public WaitForFirstActorState<T, WaitForFirstActor<T>> {
															#line 13352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitForFirstActor<T>>::operator new;
	using FastAllocated<WaitForFirstActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitForFirstActor<T>, 0, T >;
friend struct ActorSingleCallback< WaitForFirstActor<T>, 1, Error >;
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForFirstActor(std::vector<Future<T>> const& items) 
															#line 13364 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitForFirstActorState<T, WaitForFirstActor<T>>(items)
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForFirst");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitForFirstActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitForFirst( std::vector<Future<T>> const& items ) {
															#line 1203 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitForFirstActor<T>(items));
															#line 13394 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13399 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tag()
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagActor>
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActorState {
															#line 13406 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActorState(Future<Void> const& future,T const& what) 
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 13415 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tag", reinterpret_cast<unsigned long>(this));

	}
	~TagActorState() 
	{
		fdb_probe_actor_destroy("tag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1227 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1227 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13432 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagActor*>(this)->actor_wait_state = 1;
															#line 1227 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagActor, 0, Void >*>(static_cast<TagActor*>(this)));
															#line 13437 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagActorState();
		static_cast<TagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1228 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor*>(this)->SAV<T>::futures) { (void)(what); this->~TagActorState(); static_cast<TagActor*>(this)->destroy(); return 0; }
															#line 13460 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor*>(this)->SAV< T >::value()) T(std::move(what)); // state_var_RVO
		this->~TagActorState();
		static_cast<TagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1228 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor*>(this)->SAV<T>::futures) { (void)(what); this->~TagActorState(); static_cast<TagActor*>(this)->destroy(); return 0; }
															#line 13472 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor*>(this)->SAV< T >::value()) T(std::move(what)); // state_var_RVO
		this->~TagActorState();
		static_cast<TagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagActor*>(this)->actor_wait_state > 0) static_cast<TagActor*>(this)->actor_wait_state = 0;
		static_cast<TagActor*>(this)->ActorCallback< TagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T what;
															#line 13547 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tag()
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor final : public Actor<T>, public ActorCallback< TagActor<T>, 0, Void >, public FastAllocated<TagActor<T>>, public TagActorState<T, TagActor<T>> {
															#line 13554 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagActor<T>>::operator new;
	using FastAllocated<TagActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TagActor<T>, 0, Void >;
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor(Future<Void> const& future,T const& what) 
															#line 13565 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TagActorState<T, TagActor<T>>(future, what)
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> tag( Future<Void> const& future, T const& what ) {
															#line 1225 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TagActor<T>(future, what));
															#line 13595 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1230 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13600 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tag()
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagActor1>
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor1State {
															#line 13607 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor1State(Future<Void> const& future,T const& what,PromiseStream<T> const& stream) 
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what),
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   stream(stream)
															#line 13618 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tag", reinterpret_cast<unsigned long>(this));

	}
	~TagActor1State() 
	{
		fdb_probe_actor_destroy("tag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1233 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1233 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13635 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagActor1*>(this)->actor_wait_state = 1;
															#line 1233 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagActor1, 0, Void >*>(static_cast<TagActor1*>(this)));
															#line 13640 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		stream.send(what);
															#line 1235 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagActor1State(); static_cast<TagActor1*>(this)->destroy(); return 0; }
															#line 13665 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		stream.send(what);
															#line 1235 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagActor1State(); static_cast<TagActor1*>(this)->destroy(); return 0; }
															#line 13679 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagActor1*>(this)->actor_wait_state > 0) static_cast<TagActor1*>(this)->actor_wait_state = 0;
		static_cast<TagActor1*>(this)->ActorCallback< TagActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T what;
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> stream;
															#line 13756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tag()
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor1 final : public Actor<Void>, public ActorCallback< TagActor1<T>, 0, Void >, public FastAllocated<TagActor1<T>>, public TagActor1State<T, TagActor1<T>> {
															#line 13763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagActor1<T>>::operator new;
	using FastAllocated<TagActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TagActor1<T>, 0, Void >;
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor1(Future<Void> const& future,T const& what,PromiseStream<T> const& stream) 
															#line 13774 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TagActor1State<T, TagActor1<T>>(future, what, stream)
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagActor1<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> tag( Future<Void> const& future, T const& what, PromiseStream<T> const& stream ) {
															#line 1231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TagActor1<T>(future, what, stream));
															#line 13804 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1237 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13809 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagError()
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagErrorActor>
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagErrorActorState {
															#line 13816 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagErrorActorState(Future<Void> const& future,Error const& e) 
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   e(e)
															#line 13825 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagError", reinterpret_cast<unsigned long>(this));

	}
	~TagErrorActorState() 
	{
		fdb_probe_actor_destroy("tagError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13842 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagErrorActor*>(this)->actor_wait_state = 1;
															#line 1240 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagErrorActor, 0, Void >*>(static_cast<TagErrorActor*>(this)));
															#line 13847 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagErrorActorState();
		static_cast<TagErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1241 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 13870 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1241 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 13878 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagErrorActor*>(this)->actor_wait_state > 0) static_cast<TagErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TagErrorActor*>(this)->ActorCallback< TagErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error e;
															#line 13949 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagError()
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagErrorActor final : public Actor<T>, public ActorCallback< TagErrorActor<T>, 0, Void >, public FastAllocated<TagErrorActor<T>>, public TagErrorActorState<T, TagErrorActor<T>> {
															#line 13956 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagErrorActor<T>>::operator new;
	using FastAllocated<TagErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TagErrorActor<T>, 0, Void >;
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagErrorActor(Future<Void> const& future,Error const& e) 
															#line 13967 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TagErrorActorState<T, TagErrorActor<T>>(future, e)
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagErrorActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> tagError( Future<Void> const& future, Error const& e ) {
															#line 1238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TagErrorActor<T>(future, e));
															#line 13997 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1243 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 14002 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via detach()
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DetachActor>
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DetachActorState {
															#line 14009 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DetachActorState(Future<T> const& f) 
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 14016 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("detach", reinterpret_cast<unsigned long>(this));

	}
	~DetachActorState() 
	{
		fdb_probe_actor_destroy("detach", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1246 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = f;
															#line 1246 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<DetachActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14033 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DetachActor*>(this)->actor_wait_state = 1;
															#line 1246 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DetachActor, 0, T >*>(static_cast<DetachActor*>(this)));
															#line 14038 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& x,int loopDepth) 
	{
															#line 1247 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DetachActor*>(this)->SAV<T>::futures) { (void)(x); this->~DetachActorState(); static_cast<DetachActor*>(this)->destroy(); return 0; }
															#line 14061 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DetachActor*>(this)->SAV< T >::value()) T(x);
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && x,int loopDepth) 
	{
															#line 1247 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DetachActor*>(this)->SAV<T>::futures) { (void)(x); this->~DetachActorState(); static_cast<DetachActor*>(this)->destroy(); return 0; }
															#line 14073 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DetachActor*>(this)->SAV< T >::value()) T(x);
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& x,int loopDepth) 
	{
		loopDepth = a_body1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && x,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DetachActor*>(this)->actor_wait_state > 0) static_cast<DetachActor*>(this)->actor_wait_state = 0;
		static_cast<DetachActor*>(this)->ActorCallback< DetachActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< DetachActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DetachActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DetachActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 14146 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via detach()
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DetachActor final : public Actor<T>, public ActorCallback< DetachActor<T>, 0, T >, public FastAllocated<DetachActor<T>>, public DetachActorState<T, DetachActor<T>> {
															#line 14153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DetachActor<T>>::operator new;
	using FastAllocated<DetachActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DetachActor<T>, 0, T >;
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DetachActor(Future<T> const& f) 
															#line 14164 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   DetachActorState<T, DetachActor<T>>(f)
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("detach");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DetachActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> detach( Future<T> const& f ) {
															#line 1244 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new DetachActor<T>(f));
															#line 14194 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1249 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// If the future is ready, yields and returns. Otherwise, returns when future is set.
template <class T>
Future<T> orYield(Future<T> f) {
	if (f.isReady()) {
		if (f.isError())
			return tagError<T>(yield(), f.getError());
		else
			return tag(yield(), f.get());
	} else
		return f;
}

Future<Void> orYield(Future<Void> f);

															#line 14213 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via chooseActor()
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ChooseActorActor>
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ChooseActorActorState {
															#line 14220 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ChooseActorActorState(Future<T> const& lhs,Future<T> const& rhs) 
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lhs(lhs),
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   rhs(rhs)
															#line 14229 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("chooseActor", reinterpret_cast<unsigned long>(this));

	}
	~ChooseActorActorState() 
	{
		fdb_probe_actor_destroy("chooseActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1267 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = lhs;
															#line 1266 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<ChooseActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14246 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1270 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_1 = rhs;
															#line 14250 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseActorActor*>(this)->actor_wait_state = 1;
															#line 1267 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseActorActor, 0, T >*>(static_cast<ChooseActorActor*>(this)));
															#line 1270 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseActorActor, 1, T >*>(static_cast<ChooseActorActor*>(this)));
															#line 14257 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 1268 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 14280 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 1268 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 14292 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(T const& t,int loopDepth) 
	{
															#line 1271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 14304 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(T && t,int loopDepth) 
	{
															#line 1271 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 14316 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseActorActor*>(this)->actor_wait_state > 0) static_cast<ChooseActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseActorActor*>(this)->ActorCallback< ChooseActorActor, 0, T >::remove();
		static_cast<ChooseActorActor*>(this)->ActorCallback< ChooseActorActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseActorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseActorActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> lhs;
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> rhs;
															#line 14425 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via chooseActor()
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ChooseActorActor final : public Actor<T>, public ActorCallback< ChooseActorActor<T>, 0, T >, public ActorCallback< ChooseActorActor<T>, 1, T >, public FastAllocated<ChooseActorActor<T>>, public ChooseActorActorState<T, ChooseActorActor<T>> {
															#line 14432 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ChooseActorActor<T>>::operator new;
	using FastAllocated<ChooseActorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseActorActor<T>, 0, T >;
friend struct ActorCallback< ChooseActorActor<T>, 1, T >;
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ChooseActorActor(Future<T> const& lhs,Future<T> const& rhs) 
															#line 14444 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ChooseActorActorState<T, ChooseActorActor<T>>(lhs, rhs)
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseActorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> chooseActor( Future<T> const& lhs, Future<T> const& rhs ) {
															#line 1264 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ChooseActorActor<T>(lhs, rhs));
															#line 14474 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1275 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// set && set -> set
// error && x -> error
// all others -> unset
inline Future<Void> operator&&(Future<Void> const& lhs, Future<Void> const& rhs) {
	if (lhs.isReady()) {
		if (lhs.isError())
			return lhs;
		else
			return rhs;
	}
	if (rhs.isReady()) {
		if (rhs.isError())
			return rhs;
		else
			return lhs;
	}

	Future<Void> x[] = { lhs, rhs };
	return quorum(x, 2, 2);
}

// error || unset -> error
// unset || unset -> unset
// all others -> set
inline Future<Void> operator||(Future<Void> const& lhs, Future<Void> const& rhs) {
	if (lhs.isReady()) {
		if (lhs.isError())
			return lhs;
		if (rhs.isReady())
			return rhs;
		return lhs;
	}

	return chooseActor(lhs, rhs);
}

															#line 14515 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via joinWith()
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class JoinWithActor>
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class JoinWithActorState {
															#line 14522 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	JoinWithActorState(Future<T> const& f,Future<Void> const& other) 
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   other(other)
															#line 14531 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("joinWith", reinterpret_cast<unsigned long>(this));

	}
	~JoinWithActorState() 
	{
		fdb_probe_actor_destroy("joinWith", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1314 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = other;
															#line 1314 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14548 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<JoinWithActor*>(this)->actor_wait_state = 1;
															#line 1314 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 0, Void >*>(static_cast<JoinWithActor*>(this)));
															#line 14553 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = f;
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14578 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinWithActor*>(this)->actor_wait_state = 2;
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 1, T >*>(static_cast<JoinWithActor*>(this)));
															#line 14583 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = f;
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14594 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinWithActor*>(this)->actor_wait_state = 2;
															#line 1315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 1, T >*>(static_cast<JoinWithActor*>(this)));
															#line 14599 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<JoinWithActor*>(this)->actor_wait_state > 0) static_cast<JoinWithActor*>(this)->actor_wait_state = 0;
		static_cast<JoinWithActor*>(this)->ActorCallback< JoinWithActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< JoinWithActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<JoinWithActor*>(this)->SAV<T>::futures) { (void)(t); this->~JoinWithActorState(); static_cast<JoinWithActor*>(this)->destroy(); return 0; }
															#line 14671 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<JoinWithActor*>(this)->SAV< T >::value()) T(t);
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<JoinWithActor*>(this)->SAV<T>::futures) { (void)(t); this->~JoinWithActorState(); static_cast<JoinWithActor*>(this)->destroy(); return 0; }
															#line 14683 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<JoinWithActor*>(this)->SAV< T >::value()) T(t);
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<JoinWithActor*>(this)->actor_wait_state > 0) static_cast<JoinWithActor*>(this)->actor_wait_state = 0;
		static_cast<JoinWithActor*>(this)->ActorCallback< JoinWithActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< JoinWithActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> other;
															#line 14758 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via joinWith()
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class JoinWithActor final : public Actor<T>, public ActorCallback< JoinWithActor<T>, 0, Void >, public ActorCallback< JoinWithActor<T>, 1, T >, public FastAllocated<JoinWithActor<T>>, public JoinWithActorState<T, JoinWithActor<T>> {
															#line 14765 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<JoinWithActor<T>>::operator new;
	using FastAllocated<JoinWithActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< JoinWithActor<T>, 0, Void >;
friend struct ActorCallback< JoinWithActor<T>, 1, T >;
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	JoinWithActor(Future<T> const& f,Future<Void> const& other) 
															#line 14777 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   JoinWithActorState<T, JoinWithActor<T>>(f, other)
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("joinWith");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< JoinWithActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< JoinWithActor<T>, 1, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> joinWith( Future<T> const& f, Future<Void> const& other ) {
															#line 1312 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new JoinWithActor<T>(f, other));
															#line 14808 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1318 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// wait <interval> then call what() in a loop forever
															#line 14814 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via recurring()
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class RecurringActor>
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringActorState {
															#line 14821 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringActorState(Func const& what,double const& interval,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   interval(interval),
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 14832 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("recurring", reinterpret_cast<unsigned long>(this));

	}
	~RecurringActorState() 
	{
		fdb_probe_actor_destroy("recurring", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1322 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 14847 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecurringActorState();
		static_cast<RecurringActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1323 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = delay(interval, taskID);
															#line 1322 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<RecurringActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RecurringActor*>(this)->actor_wait_state = 1;
															#line 1323 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecurringActor, 0, Void >*>(static_cast<RecurringActor*>(this)));
															#line 14884 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 14899 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 14908 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecurringActor*>(this)->actor_wait_state > 0) static_cast<RecurringActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringActor*>(this)->ActorCallback< RecurringActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecurringActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecurringActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double interval;
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 14970 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via recurring()
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringActor final : public Actor<Void>, public ActorCallback< RecurringActor<Func>, 0, Void >, public FastAllocated<RecurringActor<Func>>, public RecurringActorState<Func, RecurringActor<Func>> {
															#line 14977 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RecurringActor<Func>>::operator new;
	using FastAllocated<RecurringActor<Func>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< RecurringActor<Func>, 0, Void >;
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringActor(Func const& what,double const& interval,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 14988 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RecurringActorState<Func, RecurringActor<Func>>(what, interval, taskID)
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recurring");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecurringActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> recurring( Func const& what, double const& interval, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 1320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RecurringActor<Func>(what, interval, taskID));
															#line 15018 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1328 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Invoke actorFunc() forever in a loop
// At least wait<interval> between two actor functor invocations
															#line 15025 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via recurringAsync()
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F, class RecurringAsyncActor>
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringAsyncActorState {
															#line 15032 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringAsyncActorState(F const& actorFunc,double const& interval,bool const& absoluteIntervalDelay,double const& initialDelay,TaskPriority const& taskID = TaskPriority::DefaultDelay,bool const& jittered = false) 
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : actorFunc(actorFunc),
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   interval(interval),
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   absoluteIntervalDelay(absoluteIntervalDelay),
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   initialDelay(initialDelay),
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID),
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   jittered(jittered)
															#line 15049 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("recurringAsync", reinterpret_cast<unsigned long>(this));

	}
	~RecurringAsyncActorState() 
	{
		fdb_probe_actor_destroy("recurringAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1344 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = delay(initialDelay);
															#line 1344 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15066 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 1;
															#line 1344 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 0, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15071 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecurringAsyncActorState();
		static_cast<RecurringAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1346 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = Future<Void>();
															#line 1348 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 15096 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1346 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = Future<Void>();
															#line 1348 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 15107 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1349 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = actorFunc();
															#line 1351 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (absoluteIntervalDelay)
															#line 15188 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = val;
															#line 1352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15194 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 2;
															#line 1352 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 1, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15199 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1363 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (jittered)
															#line 15206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1364 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_4 = val && delayJittered(interval);
															#line 1364 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15212 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_4.get(), loopDepth); };
				static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 5;
															#line 1364 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 4, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15217 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 1366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_5 = val && delay(interval);
															#line 1366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15226 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_5.get(), loopDepth); };
				static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 6;
															#line 1366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 5, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1354 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (jittered)
															#line 15248 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delayJittered(interval);
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15254 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 3;
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 2, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15259 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15268 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 4;
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 3, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15273 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1354 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (jittered)
															#line 15283 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delayJittered(interval);
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15289 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 3;
															#line 1355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 2, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15294 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15303 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 4;
															#line 1357 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 3, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 15308 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double interval;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool absoluteIntervalDelay;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double initialDelay;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool jittered;
															#line 1346 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> val;
															#line 15703 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via recurringAsync()
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F>
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringAsyncActor final : public Actor<Void>, public ActorCallback< RecurringAsyncActor<F>, 0, Void >, public ActorCallback< RecurringAsyncActor<F>, 1, Void >, public ActorCallback< RecurringAsyncActor<F>, 2, Void >, public ActorCallback< RecurringAsyncActor<F>, 3, Void >, public ActorCallback< RecurringAsyncActor<F>, 4, Void >, public ActorCallback< RecurringAsyncActor<F>, 5, Void >, public FastAllocated<RecurringAsyncActor<F>>, public RecurringAsyncActorState<F, RecurringAsyncActor<F>> {
															#line 15710 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RecurringAsyncActor<F>>::operator new;
	using FastAllocated<RecurringAsyncActor<F>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< RecurringAsyncActor<F>, 0, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 1, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 2, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 3, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 4, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 5, Void >;
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringAsyncActor(F const& actorFunc,double const& interval,bool const& absoluteIntervalDelay,double const& initialDelay,TaskPriority const& taskID = TaskPriority::DefaultDelay,bool const& jittered = false) 
															#line 15726 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RecurringAsyncActorState<F, RecurringAsyncActor<F>>(actorFunc, interval, absoluteIntervalDelay, initialDelay, taskID, jittered)
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recurringAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F>
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> recurringAsync( F const& actorFunc, double const& interval, bool const& absoluteIntervalDelay, double const& initialDelay, TaskPriority const& taskID = TaskPriority::DefaultDelay, bool const& jittered = false ) {
															#line 1331 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RecurringAsyncActor<F>(actorFunc, interval, absoluteIntervalDelay, initialDelay, taskID, jittered));
															#line 15761 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1371 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 15766 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via brokenPromiseToNever()
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class BrokenPromiseToNeverActor>
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToNeverActorState {
															#line 15773 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToNeverActorState(Future<T> const& in) 
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in)
															#line 15780 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("brokenPromiseToNever", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToNeverActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToNever", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1375 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1375 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15798 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 1;
															#line 1375 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToNeverActor, 0, T >*>(static_cast<BrokenPromiseToNeverActor*>(this)));
															#line 15803 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1378 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() != error_code_broken_promise)
															#line 15833 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1379 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 15837 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1380 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = Never();
															#line 1380 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15843 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 2;
															#line 1380 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToNeverActor, 1, Void >*>(static_cast<BrokenPromiseToNeverActor*>(this)));
															#line 15848 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1376 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToNeverActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToNeverActorState(); static_cast<BrokenPromiseToNeverActor*>(this)->destroy(); return 0; }
															#line 15863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToNeverActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1376 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToNeverActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToNeverActorState(); static_cast<BrokenPromiseToNeverActor*>(this)->destroy(); return 0; }
															#line 15875 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToNeverActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToNeverActor*>(this)->ActorCallback< BrokenPromiseToNeverActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 1381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15950 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 1381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15958 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToNeverActor*>(this)->ActorCallback< BrokenPromiseToNeverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 16027 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via brokenPromiseToNever()
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToNeverActor final : public Actor<T>, public ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >, public ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >, public FastAllocated<BrokenPromiseToNeverActor<T>>, public BrokenPromiseToNeverActorState<T, BrokenPromiseToNeverActor<T>> {
															#line 16034 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<BrokenPromiseToNeverActor<T>>::operator new;
	using FastAllocated<BrokenPromiseToNeverActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >;
friend struct ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >;
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToNeverActor(Future<T> const& in) 
															#line 16046 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   BrokenPromiseToNeverActorState<T, BrokenPromiseToNeverActor<T>>(in)
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToNever");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> brokenPromiseToNever( Future<T> const& in ) {
															#line 1372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new BrokenPromiseToNeverActor<T>(in));
															#line 16077 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1384 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16082 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via brokenPromiseToMaybeDelivered()
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class BrokenPromiseToMaybeDeliveredActor>
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToMaybeDeliveredActorState {
															#line 16089 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToMaybeDeliveredActorState(Future<T> const& in) 
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in)
															#line 16096 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToMaybeDeliveredActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1388 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1388 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16114 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state = 1;
															#line 1388 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*>(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)));
															#line 16119 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1391 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 16149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1392 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(request_maybe_delivered(), loopDepth);
															#line 16153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1394 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 16157 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToMaybeDeliveredActorState(); static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->destroy(); return 0; }
															#line 16171 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToMaybeDeliveredActorState(); static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->destroy(); return 0; }
															#line 16183 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 16256 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via brokenPromiseToMaybeDelivered()
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToMaybeDeliveredActor final : public Actor<T>, public ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >, public FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>, public BrokenPromiseToMaybeDeliveredActorState<T, BrokenPromiseToMaybeDeliveredActor<T>> {
															#line 16263 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>::operator new;
	using FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >;
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToMaybeDeliveredActor(Future<T> const& in) 
															#line 16274 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   BrokenPromiseToMaybeDeliveredActorState<T, BrokenPromiseToMaybeDeliveredActor<T>>(in)
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToMaybeDelivered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> brokenPromiseToMaybeDelivered( Future<T> const& in ) {
															#line 1385 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new BrokenPromiseToMaybeDeliveredActor<T>(in));
															#line 16304 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1397 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16309 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForward()
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U, class TagAndForwardActor>
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActorState {
															#line 16316 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActorState(Promise<T>* const& pOutputPromise,U const& value,Future<Void> const& signal) 
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutputPromise(pOutputPromise),
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal),
															#line 1400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(std::move(*pOutputPromise))
															#line 16329 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardActorState() 
	{
		fdb_probe_actor_destroy("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1401 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1401 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 16346 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardActor*>(this)->actor_wait_state = 1;
															#line 1401 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardActor, 0, Void >*>(static_cast<TagAndForwardActor*>(this)));
															#line 16350 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1402 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.send(std::move(value));
															#line 16372 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1402 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.send(std::move(value));
															#line 16381 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardActor*>(this)->actor_wait_state > 0) static_cast<TagAndForwardActor*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardActor*>(this)->ActorCallback< TagAndForwardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardActor*>(this);
															#line 16453 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T>* pOutputPromise;
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	U value;
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 1400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> out;
															#line 16466 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForward()
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U>
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor final : public Actor<void>, public ActorCallback< TagAndForwardActor<T, U>, 0, Void >, public FastAllocated<TagAndForwardActor<T, U>>, public TagAndForwardActorState<T, U, TagAndForwardActor<T, U>> {
															#line 16473 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardActor<T, U>>::operator new;
	using FastAllocated<TagAndForwardActor<T, U>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardActor<T, U>, 0, Void >;
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor(Promise<T>* const& pOutputPromise,U const& value,Future<Void> const& signal) 
															#line 16484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardActorState<T, U, TagAndForwardActor<T, U>>(pOutputPromise, value, signal)
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U>
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForward( Promise<T>* const& pOutputPromise, U const& value, Future<Void> const& signal ) {
															#line 1398 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardActor<T, U>(pOutputPromise, value, signal);
															#line 16505 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1404 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16510 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForward()
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardActor1>
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor1State {
															#line 16517 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor1State(PromiseStream<T>* const& pOutput,T const& value,Future<Void> const& signal) 
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutput(pOutput),
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 16528 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardActor1State() 
	{
		fdb_probe_actor_destroy("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 16545 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardActor1*>(this)->actor_wait_state = 1;
															#line 1407 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardActor1, 0, Void >*>(static_cast<TagAndForwardActor1*>(this)));
															#line 16549 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1408 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->send(std::move(value));
															#line 16571 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1408 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->send(std::move(value));
															#line 16580 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardActor1*>(this)->actor_wait_state > 0) static_cast<TagAndForwardActor1*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardActor1*>(this)->ActorCallback< TagAndForwardActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardActor1*>(this);
															#line 16652 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T>* pOutput;
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T value;
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 16663 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForward()
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor1 final : public Actor<void>, public ActorCallback< TagAndForwardActor1<T>, 0, Void >, public FastAllocated<TagAndForwardActor1<T>>, public TagAndForwardActor1State<T, TagAndForwardActor1<T>> {
															#line 16670 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardActor1<T>>::operator new;
	using FastAllocated<TagAndForwardActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardActor1<T>, 0, Void >;
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor1(PromiseStream<T>* const& pOutput,T const& value,Future<Void> const& signal) 
															#line 16681 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardActor1State<T, TagAndForwardActor1<T>>(pOutput, value, signal)
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForward( PromiseStream<T>* const& pOutput, T const& value, Future<Void> const& signal ) {
															#line 1405 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardActor1<T>(pOutput, value, signal);
															#line 16702 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1410 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16707 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForwardError()
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardErrorActor>
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActorState {
															#line 16714 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActorState(Promise<T>* const& pOutputPromise,Error const& value,Future<Void> const& signal) 
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutputPromise(pOutputPromise),
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal),
															#line 1413 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(std::move(*pOutputPromise))
															#line 16727 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1414 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1414 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 16744 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 1414 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardErrorActor, 0, Void >*>(static_cast<TagAndForwardErrorActor*>(this)));
															#line 16748 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardErrorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.sendError(value);
															#line 16770 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.sendError(value);
															#line 16779 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardErrorActor*>(this)->ActorCallback< TagAndForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardErrorActor*>(this);
															#line 16851 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T>* pOutputPromise;
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error value;
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 1413 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> out;
															#line 16864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForwardError()
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor final : public Actor<void>, public ActorCallback< TagAndForwardErrorActor<T>, 0, Void >, public FastAllocated<TagAndForwardErrorActor<T>>, public TagAndForwardErrorActorState<T, TagAndForwardErrorActor<T>> {
															#line 16871 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardErrorActor<T>>::operator new;
	using FastAllocated<TagAndForwardErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardErrorActor<T>, 0, Void >;
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor(Promise<T>* const& pOutputPromise,Error const& value,Future<Void> const& signal) 
															#line 16882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardErrorActorState<T, TagAndForwardErrorActor<T>>(pOutputPromise, value, signal)
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForwardError( Promise<T>* const& pOutputPromise, Error const& value, Future<Void> const& signal ) {
															#line 1411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardErrorActor<T>(pOutputPromise, value, signal);
															#line 16903 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1417 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16908 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForwardError()
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardErrorActor1>
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor1State {
															#line 16915 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor1State(PromiseStream<T>* const& pOutput,Error const& value,Future<Void> const& signal) 
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutput(pOutput),
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 16926 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardErrorActor1State() 
	{
		fdb_probe_actor_destroy("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 16943 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state = 1;
															#line 1420 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardErrorActor1, 0, Void >*>(static_cast<TagAndForwardErrorActor1*>(this)));
															#line 16947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardErrorActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1421 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->sendError(value);
															#line 16969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1421 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->sendError(value);
															#line 16978 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state > 0) static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardErrorActor1*>(this)->ActorCallback< TagAndForwardErrorActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardErrorActor1*>(this);
															#line 17050 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T>* pOutput;
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error value;
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 17061 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForwardError()
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor1 final : public Actor<void>, public ActorCallback< TagAndForwardErrorActor1<T>, 0, Void >, public FastAllocated<TagAndForwardErrorActor1<T>>, public TagAndForwardErrorActor1State<T, TagAndForwardErrorActor1<T>> {
															#line 17068 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardErrorActor1<T>>::operator new;
	using FastAllocated<TagAndForwardErrorActor1<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardErrorActor1<T>, 0, Void >;
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor1(PromiseStream<T>* const& pOutput,Error const& value,Future<Void> const& signal) 
															#line 17079 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardErrorActor1State<T, TagAndForwardErrorActor1<T>>(pOutput, value, signal)
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForwardError( PromiseStream<T>* const& pOutput, Error const& value, Future<Void> const& signal ) {
															#line 1418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardErrorActor1<T>(pOutput, value, signal);
															#line 17100 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1423 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 17105 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitOrError()
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitOrErrorActor>
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitOrErrorActorState {
															#line 17112 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitOrErrorActorState(Future<T> const& f,Future<Void> const& errorSignal) 
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorSignal(errorSignal)
															#line 17121 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1427 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = f;
															#line 1426 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17138 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1430 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = errorSignal;
															#line 17142 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOrErrorActor*>(this)->actor_wait_state = 1;
															#line 1427 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitOrErrorActor, 0, T >*>(static_cast<WaitOrErrorActor*>(this)));
															#line 1430 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOrErrorActor, 1, Void >*>(static_cast<WaitOrErrorActor*>(this)));
															#line 17149 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitOrErrorActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitOrErrorActorState(); static_cast<WaitOrErrorActor*>(this)->destroy(); return 0; }
															#line 17172 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitOrErrorActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitOrErrorActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitOrErrorActorState(); static_cast<WaitOrErrorActor*>(this)->destroy(); return 0; }
															#line 17184 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitOrErrorActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1431 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(false);
															#line 1432 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 17198 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1431 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(false);
															#line 1432 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 17208 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOrErrorActor*>(this)->ActorCallback< WaitOrErrorActor, 0, T >::remove();
		static_cast<WaitOrErrorActor*>(this)->ActorCallback< WaitOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitOrErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> errorSignal;
															#line 17313 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitOrError()
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitOrErrorActor final : public Actor<T>, public ActorCallback< WaitOrErrorActor<T>, 0, T >, public ActorCallback< WaitOrErrorActor<T>, 1, Void >, public FastAllocated<WaitOrErrorActor<T>>, public WaitOrErrorActorState<T, WaitOrErrorActor<T>> {
															#line 17320 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitOrErrorActor<T>>::operator new;
	using FastAllocated<WaitOrErrorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitOrErrorActor<T>, 0, T >;
friend struct ActorCallback< WaitOrErrorActor<T>, 1, Void >;
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitOrErrorActor(Future<T> const& f,Future<Void> const& errorSignal) 
															#line 17332 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitOrErrorActorState<T, WaitOrErrorActor<T>>(f, errorSignal)
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitOrErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitOrError( Future<T> const& f, Future<Void> const& errorSignal ) {
															#line 1424 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitOrErrorActor<T>(f, errorSignal));
															#line 17362 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1436 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// A low-overhead FIFO mutex made with no internal queue structure (no list, deque, vector, etc)
// The lock is implemented as a Promise<Void>, which is returned to callers in a convenient wrapper
// called Lock.
//
// The default behavior is that if a Lock is droppped without error or release, existing and future
// waiters will see a broken_promise exception.
//
// If hangOnDroppedMutex is true, then if a Lock is dropped without error or release, existing and
// future waiters will never be signaled or see an error, equivalent to waiting on Never().
//
// Usage:
//   Lock lock = wait(mutex.take());
//   lock.release();  // Next waiter will get the lock, OR
//   lock.error(e);   // Next waiter will get e, future waiters will see broken_promise
//   lock = Lock();   // Or let Lock and any copies go out of scope.  All waiters will see broken_promise.
struct FlowMutex {
	FlowMutex(bool hangOnDroppedMutex = false) : hangOnDroppedMutex(hangOnDroppedMutex) { lastPromise.send(Void()); }

	bool available() const { return lastPromise.isSet(); }

	struct Lock {
		void release() { promise.send(Void()); }

		void error(Error e = broken_promise()) { promise.sendError(e); }

		// This is exposed in case the caller wants to use/copy it directly
		Promise<Void> promise;
	};

	Future<Lock> take() {
		Lock newLock;
		Future<Lock> f = lastPromise.isSet() ? newLock : tag(lastPromise.getFuture(), newLock);
		lastPromise = newLock.promise;
		if (hangOnDroppedMutex) {
			return brokenPromiseToNever(f);
		}
		return f;
	}

private:
	bool hangOnDroppedMutex;
	Promise<Void> lastPromise;
};

															#line 17411 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardErrors()
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V, class ForwardErrorsActor>
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardErrorsActorState {
															#line 17418 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardErrorsActorState(Future<T> const& f,PromiseStream<V> const& output) 
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 17427 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardErrors", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorsActorState() 
	{
		fdb_probe_actor_destroy("forwardErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 1484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ForwardErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17445 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorsActor*>(this)->actor_wait_state = 1;
															#line 1484 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorsActor, 0, T >*>(static_cast<ForwardErrorsActor*>(this)));
															#line 17450 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1487 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.sendError(e);
															#line 1488 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 17482 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 1485 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ForwardErrorsActor*>(this)->SAV<T>::futures) { (void)(val); this->~ForwardErrorsActorState(); static_cast<ForwardErrorsActor*>(this)->destroy(); return 0; }
															#line 17496 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ForwardErrorsActor*>(this)->SAV< T >::value()) T(val);
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 1485 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ForwardErrorsActor*>(this)->SAV<T>::futures) { (void)(val); this->~ForwardErrorsActorState(); static_cast<ForwardErrorsActor*>(this)->destroy(); return 0; }
															#line 17508 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ForwardErrorsActor*>(this)->SAV< T >::value()) T(val);
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorsActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorsActor*>(this)->ActorCallback< ForwardErrorsActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorsActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorsActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorsActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<V> output;
															#line 17583 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardErrors()
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V>
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardErrorsActor final : public Actor<T>, public ActorCallback< ForwardErrorsActor<T, V>, 0, T >, public FastAllocated<ForwardErrorsActor<T, V>>, public ForwardErrorsActorState<T, V, ForwardErrorsActor<T, V>> {
															#line 17590 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardErrorsActor<T, V>>::operator new;
	using FastAllocated<ForwardErrorsActor<T, V>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorsActor<T, V>, 0, T >;
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardErrorsActor(Future<T> const& f,PromiseStream<V> const& output) 
															#line 17601 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ForwardErrorsActorState<T, V, ForwardErrorsActor<T, V>>(f, output)
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorsActor<T, V>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V>
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> forwardErrors( Future<T> const& f, PromiseStream<V> const& output ) {
															#line 1481 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ForwardErrorsActor<T, V>(f, output));
															#line 17631 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1491 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

struct FlowLock : NonCopyable, public ReferenceCounted<FlowLock> {
	// FlowLock implements a nonblocking critical section: there can be only a limited number of clients executing code
	// between wait(take()) and release(). Not thread safe. take() returns only when the number of holders of the lock
	// is fewer than the number of permits, and release() makes the caller no longer a holder of the lock. release()
	// only runs waiting take()rs after the caller wait()s

	struct Releaser : NonCopyable {
		FlowLock* lock;
		int remaining;
		Releaser() : lock(0), remaining(0) {}
		Releaser(FlowLock& lock, int64_t amount = 1) : lock(&lock), remaining(amount) {}
		Releaser(Releaser&& r) noexcept : lock(r.lock), remaining(r.remaining) { r.remaining = 0; }
		void operator=(Releaser&& r) {
			if (remaining)
				lock->release(remaining);
			lock = r.lock;
			remaining = r.remaining;
			r.remaining = 0;
		}

		void release(int64_t amount = -1) {
			if (amount == -1 || amount > remaining)
				amount = remaining;

			if (remaining)
				lock->release(amount);
			remaining -= amount;
		}

		~Releaser() {
			if (remaining)
				lock->release(remaining);
		}
	};

	FlowLock() : permits(1), active(0) {}
	explicit FlowLock(int64_t permits) : permits(permits), active(0) {}

	Future<Void> take(TaskPriority taskID = TaskPriority::DefaultYield, int64_t amount = 1) {
		if (active + amount <= permits || active == 0) {
			active += amount;
			return safeYieldActor(this, taskID, amount);
		}
		return takeActor(this, taskID, amount);
	}
	void release(int64_t amount = 1) {
		ASSERT((active > 0 || amount == 0) && active - amount >= 0);
		active -= amount;

		while (!takers.empty()) {
			if (active + takers.begin()->second <= permits || active == 0) {
				std::pair<Promise<Void>, int64_t> next = std::move(*takers.begin());
				active += next.second;
				takers.pop_front();
				next.first.send(Void());
			} else {
				break;
			}
		}
	}

	Future<Void> releaseWhen(Future<Void> const& signal, int amount = 1) {
		return releaseWhenActor(this, signal, amount);
	}

	// returns when any permits are available, having taken as many as possible up to the given amount, and modifies
	// amount to the number of permits taken
	Future<Void> takeUpTo(int64_t& amount) { return takeMoreActor(this, &amount); }

	int64_t available() const { return permits - active; }
	int64_t activePermits() const { return active; }
	int waiters() const { return takers.size(); }

	// Try to send error to all current and future waiters
	// Only works if broken_on_destruct.canBeSet()
	void kill(Error e = broken_promise()) {
		if (broken_on_destruct.canBeSet()) {
			auto local = broken_on_destruct;
			// It could be the case that calling broken_on_destruct destroys this FlowLock
			local.sendError(e);
		}
	}

private:
	std::list<std::pair<Promise<Void>, int64_t>> takers;
	const int64_t permits;
	int64_t active;
	Promise<Void> broken_on_destruct;

																#line 17725 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via takeActor()
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class TakeActorActor>
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeActorActorState {
															#line 17731 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeActorActorState(FlowLock* const& lock,TaskPriority const& taskID,int64_t const& amount) 
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lock(lock),
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID),
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   amount(amount),
															#line 1582 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   it(lock->takers.emplace(lock->takers.end(), Promise<Void>(), amount))
															#line 17744 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("takeActor", reinterpret_cast<unsigned long>(this));

	}
	~TakeActorActorState() 
	{
		fdb_probe_actor_destroy("takeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1586 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = it->first.getFuture();
															#line 1586 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TakeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17762 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TakeActorActor*>(this)->actor_wait_state = 1;
															#line 1586 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeActorActor, 0, Void >*>(static_cast<TakeActorActor*>(this)));
															#line 17767 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TakeActorActorState();
		static_cast<TakeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 1595 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			double duration = BUGGIFY_WITH_PROB(.001) ? deterministicRandom()->random01() * FLOW_KNOBS->BUGGIFY_FLOW_LOCK_RELEASE_DELAY : 0.0;
															#line 1599 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(duration, taskID);
															#line 1598 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TakeActorActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 17801 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1601 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = lock->broken_on_destruct.getFuture();
															#line 17805 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TakeActorActor*>(this)->actor_wait_state = 2;
															#line 1599 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TakeActorActor, 1, Void >*>(static_cast<TakeActorActor*>(this)));
															#line 1601 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TakeActorActor, 2, Void >*>(static_cast<TakeActorActor*>(this)));
															#line 17812 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1588 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 17828 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1589 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				lock->takers.erase(it);
															#line 1590 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				lock->release(0);
															#line 17834 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1592 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 17838 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TakeActorActor*>(this)->actor_wait_state > 0) static_cast<TakeActorActor*>(this)->actor_wait_state = 0;
		static_cast<TakeActorActor*>(this)->ActorCallback< TakeActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TakeActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1605 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			CODE_PROBE(true, "If we get cancelled here, we are holding the lock but the caller doesn't know, so release it");
															#line 1607 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			lock->release(amount);
															#line 1608 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(__current_error, loopDepth);
															#line 17945 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1603 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TakeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TakeActorActorState(); static_cast<TakeActorActor*>(this)->destroy(); return 0; }
															#line 17959 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TakeActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TakeActorActorState();
		static_cast<TakeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TakeActorActor*>(this)->actor_wait_state > 0) static_cast<TakeActorActor*>(this)->actor_wait_state = 0;
		static_cast<TakeActorActor*>(this)->ActorCallback< TakeActorActor, 1, Void >::remove();
		static_cast<TakeActorActor*>(this)->ActorCallback< TakeActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TakeActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TakeActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TakeActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FlowLock* lock;
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int64_t amount;
															#line 1582 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::list<std::pair<Promise<Void>, int64_t>>::iterator it;
															#line 18096 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via takeActor()
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeActorActor final : public Actor<Void>, public ActorCallback< TakeActorActor, 0, Void >, public ActorCallback< TakeActorActor, 1, Void >, public ActorCallback< TakeActorActor, 2, Void >, public FastAllocated<TakeActorActor>, public TakeActorActorState<TakeActorActor> {
															#line 18101 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TakeActorActor>::operator new;
	using FastAllocated<TakeActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TakeActorActor, 0, Void >;
friend struct ActorCallback< TakeActorActor, 1, Void >;
friend struct ActorCallback< TakeActorActor, 2, Void >;
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeActorActor(FlowLock* const& lock,TaskPriority const& taskID,int64_t const& amount) 
															#line 18114 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TakeActorActorState<TakeActorActor>(lock, taskID, amount)
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("takeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TakeActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TakeActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> takeActor( FlowLock* const& lock, TaskPriority const& taskID, int64_t const& amount ) {
															#line 1581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TakeActorActor(lock, taskID, amount));
															#line 18142 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1611 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

																#line 18147 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via takeMoreActor()
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class TakeMoreActorActor>
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeMoreActorActorState {
															#line 18153 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeMoreActorActorState(FlowLock* const& lock,int64_t* const& amount) 
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lock(lock),
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   amount(amount)
															#line 18162 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("takeMoreActor", reinterpret_cast<unsigned long>(this));

	}
	~TakeMoreActorActorState() 
	{
		fdb_probe_actor_destroy("takeMoreActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1613 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = lock->take();
															#line 1613 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TakeMoreActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18179 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TakeMoreActorActor*>(this)->actor_wait_state = 1;
															#line 1613 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeMoreActorActor, 0, Void >*>(static_cast<TakeMoreActorActor*>(this)));
															#line 18184 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TakeMoreActorActorState();
		static_cast<TakeMoreActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1614 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		int64_t extra = std::min(lock->available(), *amount - 1);
															#line 1615 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lock->active += extra;
															#line 1616 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*amount = 1 + extra;
															#line 1617 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TakeMoreActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TakeMoreActorActorState(); static_cast<TakeMoreActorActor*>(this)->destroy(); return 0; }
															#line 18213 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TakeMoreActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TakeMoreActorActorState();
		static_cast<TakeMoreActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1614 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		int64_t extra = std::min(lock->available(), *amount - 1);
															#line 1615 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lock->active += extra;
															#line 1616 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*amount = 1 + extra;
															#line 1617 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TakeMoreActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TakeMoreActorActorState(); static_cast<TakeMoreActorActor*>(this)->destroy(); return 0; }
															#line 18231 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TakeMoreActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TakeMoreActorActorState();
		static_cast<TakeMoreActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TakeMoreActorActor*>(this)->actor_wait_state > 0) static_cast<TakeMoreActorActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoreActorActor*>(this)->ActorCallback< TakeMoreActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoreActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TakeMoreActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TakeMoreActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoreActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FlowLock* lock;
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int64_t* amount;
															#line 18306 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via takeMoreActor()
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeMoreActorActor final : public Actor<Void>, public ActorCallback< TakeMoreActorActor, 0, Void >, public FastAllocated<TakeMoreActorActor>, public TakeMoreActorActorState<TakeMoreActorActor> {
															#line 18311 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TakeMoreActorActor>::operator new;
	using FastAllocated<TakeMoreActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TakeMoreActorActor, 0, Void >;
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeMoreActorActor(FlowLock* const& lock,int64_t* const& amount) 
															#line 18322 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TakeMoreActorActorState<TakeMoreActorActor>(lock, amount)
	{
		fdb_probe_actor_enter("takeMoreActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("takeMoreActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("takeMoreActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TakeMoreActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> takeMoreActor( FlowLock* const& lock, int64_t* const& amount ) {
															#line 1612 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TakeMoreActorActor(lock, amount));
															#line 18349 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1619 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

																#line 18354 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via safeYieldActor()
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class SafeYieldActorActor>
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SafeYieldActorActorState {
															#line 18360 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SafeYieldActorActorState(FlowLock* const& lock,TaskPriority const& taskID,int64_t const& amount) 
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lock(lock),
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID),
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   amount(amount)
															#line 18371 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("safeYieldActor", reinterpret_cast<unsigned long>(this));

	}
	~SafeYieldActorActorState() 
	{
		fdb_probe_actor_destroy("safeYieldActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1623 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = yield(taskID);
															#line 1622 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<SafeYieldActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18389 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1624 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_1 = lock->broken_on_destruct.getFuture();
															#line 18393 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<SafeYieldActorActor*>(this)->actor_wait_state = 1;
															#line 1623 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SafeYieldActorActor, 0, Void >*>(static_cast<SafeYieldActorActor*>(this)));
															#line 1624 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SafeYieldActorActor, 1, Void >*>(static_cast<SafeYieldActorActor*>(this)));
															#line 18400 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SafeYieldActorActorState();
		static_cast<SafeYieldActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1628 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			lock->release(amount);
															#line 1629 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 18432 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1626 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SafeYieldActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SafeYieldActorActorState(); static_cast<SafeYieldActorActor*>(this)->destroy(); return 0; }
															#line 18446 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SafeYieldActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SafeYieldActorActorState();
		static_cast<SafeYieldActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SafeYieldActorActor*>(this)->actor_wait_state > 0) static_cast<SafeYieldActorActor*>(this)->actor_wait_state = 0;
		static_cast<SafeYieldActorActor*>(this)->ActorCallback< SafeYieldActorActor, 0, Void >::remove();
		static_cast<SafeYieldActorActor*>(this)->ActorCallback< SafeYieldActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SafeYieldActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SafeYieldActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SafeYieldActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SafeYieldActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SafeYieldActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SafeYieldActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FlowLock* lock;
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int64_t amount;
															#line 18581 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via safeYieldActor()
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SafeYieldActorActor final : public Actor<Void>, public ActorCallback< SafeYieldActorActor, 0, Void >, public ActorCallback< SafeYieldActorActor, 1, Void >, public FastAllocated<SafeYieldActorActor>, public SafeYieldActorActorState<SafeYieldActorActor> {
															#line 18586 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SafeYieldActorActor>::operator new;
	using FastAllocated<SafeYieldActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< SafeYieldActorActor, 0, Void >;
friend struct ActorCallback< SafeYieldActorActor, 1, Void >;
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SafeYieldActorActor(FlowLock* const& lock,TaskPriority const& taskID,int64_t const& amount) 
															#line 18598 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SafeYieldActorActorState<SafeYieldActorActor>(lock, taskID, amount)
	{
		fdb_probe_actor_enter("safeYieldActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("safeYieldActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("safeYieldActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SafeYieldActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> safeYieldActor( FlowLock* const& lock, TaskPriority const& taskID, int64_t const& amount ) {
															#line 1620 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SafeYieldActorActor(lock, taskID, amount));
															#line 18625 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1632 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

																#line 18630 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via releaseWhenActor()
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class ReleaseWhenActorActor>
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReleaseWhenActorActorState {
															#line 18636 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReleaseWhenActorActorState(FlowLock* const& self,Future<Void> const& signal,int64_t const& amount) 
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal),
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   amount(amount)
															#line 18647 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("releaseWhenActor", reinterpret_cast<unsigned long>(this));

	}
	~ReleaseWhenActorActorState() 
	{
		fdb_probe_actor_destroy("releaseWhenActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1634 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1634 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<ReleaseWhenActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18664 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReleaseWhenActorActor*>(this)->actor_wait_state = 1;
															#line 1634 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReleaseWhenActorActor, 0, Void >*>(static_cast<ReleaseWhenActorActor*>(this)));
															#line 18669 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReleaseWhenActorActorState();
		static_cast<ReleaseWhenActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1635 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->release(amount);
															#line 1636 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReleaseWhenActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseWhenActorActorState(); static_cast<ReleaseWhenActorActor*>(this)->destroy(); return 0; }
															#line 18694 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReleaseWhenActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseWhenActorActorState();
		static_cast<ReleaseWhenActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1635 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->release(amount);
															#line 1636 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReleaseWhenActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseWhenActorActorState(); static_cast<ReleaseWhenActorActor*>(this)->destroy(); return 0; }
															#line 18708 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReleaseWhenActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseWhenActorActorState();
		static_cast<ReleaseWhenActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReleaseWhenActorActor*>(this)->actor_wait_state > 0) static_cast<ReleaseWhenActorActor*>(this)->actor_wait_state = 0;
		static_cast<ReleaseWhenActorActor*>(this)->ActorCallback< ReleaseWhenActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReleaseWhenActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReleaseWhenActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReleaseWhenActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseWhenActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FlowLock* self;
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int64_t amount;
															#line 18785 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via releaseWhenActor()
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReleaseWhenActorActor final : public Actor<Void>, public ActorCallback< ReleaseWhenActorActor, 0, Void >, public FastAllocated<ReleaseWhenActorActor>, public ReleaseWhenActorActorState<ReleaseWhenActorActor> {
															#line 18790 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ReleaseWhenActorActor>::operator new;
	using FastAllocated<ReleaseWhenActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ReleaseWhenActorActor, 0, Void >;
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReleaseWhenActorActor(FlowLock* const& self,Future<Void> const& signal,int64_t const& amount) 
															#line 18801 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ReleaseWhenActorActorState<ReleaseWhenActorActor>(self, signal, amount)
	{
		fdb_probe_actor_enter("releaseWhenActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("releaseWhenActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("releaseWhenActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReleaseWhenActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> releaseWhenActor( FlowLock* const& self, Future<Void> const& signal, int64_t const& amount ) {
															#line 1633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ReleaseWhenActorActor(self, signal, amount));
															#line 18828 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1638 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

struct NotifiedInt {
	NotifiedInt(int64_t val = 0) : val(val) {}

	Future<Void> whenAtLeast(int64_t limit) {
		if (val >= limit)
			return Void();
		Promise<Void> p;
		waiting.emplace(limit, p);
		return p.getFuture();
	}

	int64_t get() const { return val; }

	void set(int64_t v) {
		ASSERT(v >= val);
		if (v != val) {
			val = v;

			std::vector<Promise<Void>> toSend;
			while (waiting.size() && v >= waiting.top().first) {
				Promise<Void> p = std::move(waiting.top().second);
				waiting.pop();
				toSend.push_back(p);
			}
			for (auto& p : toSend) {
				p.send(Void());
			}
		}
	}

	void operator=(int64_t v) { set(v); }

	NotifiedInt(NotifiedInt&& r) noexcept : waiting(std::move(r.waiting)), val(r.val) {}
	void operator=(NotifiedInt&& r) noexcept {
		waiting = std::move(r.waiting);
		val = r.val;
	}

private:
	typedef std::pair<int64_t, Promise<Void>> Item;
	struct ItemCompare {
		bool operator()(const Item& a, const Item& b) { return a.first > b.first; }
	};
	std::priority_queue<Item, std::vector<Item>, ItemCompare> waiting;
	int64_t val;
};

struct BoundedFlowLock : NonCopyable, public ReferenceCounted<BoundedFlowLock> {
	// BoundedFlowLock is different from a FlowLock in that it has a bound on how many locks can be taken from the
	// oldest outstanding lock. For instance, with a FlowLock that has two permits, if one permit is taken but never
	// released, the other permit can be reused an unlimited amount of times, but with a BoundedFlowLock, it can only be
	// reused a fixed number of times.

	struct Releaser : NonCopyable {
		BoundedFlowLock* lock;
		int64_t permitNumber;
		Releaser() : lock(nullptr), permitNumber(0) {}
		Releaser(BoundedFlowLock* lock, int64_t permitNumber) : lock(lock), permitNumber(permitNumber) {}
		Releaser(Releaser&& r) noexcept : lock(r.lock), permitNumber(r.permitNumber) { r.permitNumber = 0; }
		void operator=(Releaser&& r) {
			if (permitNumber)
				lock->release(permitNumber);
			lock = r.lock;
			permitNumber = r.permitNumber;
			r.permitNumber = 0;
		}

		void release() {
			if (permitNumber) {
				lock->release(permitNumber);
			}
			permitNumber = 0;
		}

		~Releaser() {
			if (permitNumber)
				lock->release(permitNumber);
		}
	};

	BoundedFlowLock() : minOutstanding(0), nextPermitNumber(0), unrestrictedPermits(1), boundedPermits(0) {}
	explicit BoundedFlowLock(int64_t unrestrictedPermits, int64_t boundedPermits)
	  : minOutstanding(0), nextPermitNumber(0), unrestrictedPermits(unrestrictedPermits),
	    boundedPermits(boundedPermits) {}

	Future<int64_t> take() { return takeActor(this); }
	void release(int64_t permitNumber) {
		outstanding.erase(permitNumber);
		updateMinOutstanding();
	}

private:
	IndexedSet<int64_t, int64_t> outstanding;
	NotifiedInt minOutstanding;
	int64_t nextPermitNumber;
	const int64_t unrestrictedPermits;
	const int64_t boundedPermits;

	void updateMinOutstanding() {
		auto it = outstanding.index(unrestrictedPermits - 1);
		if (it == outstanding.end()) {
			minOutstanding.set(nextPermitNumber);
		} else {
			minOutstanding.set(*it);
		}
	}

																#line 18941 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via takeActor()
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class TakeActorActor1>
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeActorActor1State {
															#line 18947 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeActorActor1State(BoundedFlowLock* const& lock) 
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lock(lock),
															#line 1748 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   permitNumber(++lock->nextPermitNumber)
															#line 18956 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("takeActor", reinterpret_cast<unsigned long>(this));

	}
	~TakeActorActor1State() 
	{
		fdb_probe_actor_destroy("takeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1749 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			lock->outstanding.insert(permitNumber, 1);
															#line 1750 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			lock->updateMinOutstanding();
															#line 1751 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = lock->minOutstanding.whenAtLeast(std::max<int64_t>(0, permitNumber - lock->boundedPermits));
															#line 1751 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TakeActorActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18977 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TakeActorActor1*>(this)->actor_wait_state = 1;
															#line 1751 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeActorActor1, 0, Void >*>(static_cast<TakeActorActor1*>(this)));
															#line 18982 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TakeActorActor1State();
		static_cast<TakeActorActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1752 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TakeActorActor1*>(this)->SAV<int64_t>::futures) { (void)(permitNumber); this->~TakeActorActor1State(); static_cast<TakeActorActor1*>(this)->destroy(); return 0; }
															#line 19005 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TakeActorActor1*>(this)->SAV< int64_t >::value()) int64_t(std::move(permitNumber)); // state_var_RVO
		this->~TakeActorActor1State();
		static_cast<TakeActorActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1752 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TakeActorActor1*>(this)->SAV<int64_t>::futures) { (void)(permitNumber); this->~TakeActorActor1State(); static_cast<TakeActorActor1*>(this)->destroy(); return 0; }
															#line 19017 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TakeActorActor1*>(this)->SAV< int64_t >::value()) int64_t(std::move(permitNumber)); // state_var_RVO
		this->~TakeActorActor1State();
		static_cast<TakeActorActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TakeActorActor1*>(this)->actor_wait_state > 0) static_cast<TakeActorActor1*>(this)->actor_wait_state = 0;
		static_cast<TakeActorActor1*>(this)->ActorCallback< TakeActorActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeActorActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TakeActorActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TakeActorActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BoundedFlowLock* lock;
															#line 1748 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int64_t permitNumber;
															#line 19092 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via takeActor()
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeActorActor1 final : public Actor<int64_t>, public ActorCallback< TakeActorActor1, 0, Void >, public FastAllocated<TakeActorActor1>, public TakeActorActor1State<TakeActorActor1> {
															#line 19097 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TakeActorActor1>::operator new;
	using FastAllocated<TakeActorActor1>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int64_t>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TakeActorActor1, 0, Void >;
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeActorActor1(BoundedFlowLock* const& lock) 
															#line 19108 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<int64_t>(),
		   TakeActorActor1State<TakeActorActor1>(lock)
	{
		fdb_probe_actor_enter("takeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("takeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("takeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TakeActorActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<int64_t> takeActor( BoundedFlowLock* const& lock ) {
															#line 1747 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<int64_t>(new TakeActorActor1(lock));
															#line 19135 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1754 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

															#line 19141 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via yieldPromiseStream()
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class YieldPromiseStreamActor>
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class YieldPromiseStreamActorState {
															#line 19148 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	YieldPromiseStreamActorState(FutureStream<T> const& input,PromiseStream<T> const& output,TaskPriority const& taskID = TaskPriority::DefaultYield) 
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 19159 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("yieldPromiseStream", reinterpret_cast<unsigned long>(this));

	}
	~YieldPromiseStreamActorState() 
	{
		fdb_probe_actor_destroy("yieldPromiseStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1760 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 19174 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~YieldPromiseStreamActorState();
		static_cast<YieldPromiseStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1761 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		FutureStream<T> __when_expr_0 = input;
															#line 1761 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19206 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state = 1;
															#line 1761 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< YieldPromiseStreamActor, 0, T >*>(static_cast<YieldPromiseStreamActor*>(this)));
															#line 19211 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(T const& f,int loopDepth) 
	{
															#line 1762 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(f);
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = yield(taskID);
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19224 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state = 2;
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< YieldPromiseStreamActor, 1, Void >*>(static_cast<YieldPromiseStreamActor*>(this)));
															#line 19229 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(T && f,int loopDepth) 
	{
															#line 1762 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(f);
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = yield(taskID);
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19242 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state = 2;
															#line 1763 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< YieldPromiseStreamActor, 1, Void >*>(static_cast<YieldPromiseStreamActor*>(this)));
															#line 19247 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state > 0) static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state = 0;
		static_cast<YieldPromiseStreamActor*>(this)->ActorSingleCallback< YieldPromiseStreamActor, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< YieldPromiseStreamActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< YieldPromiseStreamActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< YieldPromiseStreamActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state > 0) static_cast<YieldPromiseStreamActor*>(this)->actor_wait_state = 0;
		static_cast<YieldPromiseStreamActor*>(this)->ActorCallback< YieldPromiseStreamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< YieldPromiseStreamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< YieldPromiseStreamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< YieldPromiseStreamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 19396 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via yieldPromiseStream()
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class YieldPromiseStreamActor final : public Actor<Void>, public ActorSingleCallback< YieldPromiseStreamActor<T>, 0, T >, public ActorCallback< YieldPromiseStreamActor<T>, 1, Void >, public FastAllocated<YieldPromiseStreamActor<T>>, public YieldPromiseStreamActorState<T, YieldPromiseStreamActor<T>> {
															#line 19403 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<YieldPromiseStreamActor<T>>::operator new;
	using FastAllocated<YieldPromiseStreamActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< YieldPromiseStreamActor<T>, 0, T >;
friend struct ActorCallback< YieldPromiseStreamActor<T>, 1, Void >;
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	YieldPromiseStreamActor(FutureStream<T> const& input,PromiseStream<T> const& output,TaskPriority const& taskID = TaskPriority::DefaultYield) 
															#line 19415 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   YieldPromiseStreamActorState<T, YieldPromiseStreamActor<T>>(input, output, taskID)
	{
		fdb_probe_actor_enter("yieldPromiseStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("yieldPromiseStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("yieldPromiseStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< YieldPromiseStreamActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< YieldPromiseStreamActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> yieldPromiseStream( FutureStream<T> const& input, PromiseStream<T> const& output, TaskPriority const& taskID = TaskPriority::DefaultYield ) {
															#line 1756 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new YieldPromiseStreamActor<T>(input, output, taskID));
															#line 19446 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1766 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

struct YieldedFutureActor final : SAV<Void>,
                                  ActorCallback<YieldedFutureActor, 1, Void>,
                                  FastAllocated<YieldedFutureActor> {
	Error in_error_state;

	typedef ActorCallback<YieldedFutureActor, 1, Void> CB1;

	using FastAllocated<YieldedFutureActor>::operator new;
	using FastAllocated<YieldedFutureActor>::operator delete;

	YieldedFutureActor(Future<Void>&& f) : SAV<Void>(1, 1), in_error_state(Error::fromCode(UNSET_ERROR_CODE)) {
		f.addYieldedCallbackAndClear(static_cast<ActorCallback<YieldedFutureActor, 1, Void>*>(this));
	}

	void cancel() override {
		if (!SAV<Void>::canBeSet())
			return; // Cancel could be invoked *by* a callback within finish().  Otherwise it's guaranteed that we are
			        // waiting either on the original future or on a delay().
		ActorCallback<YieldedFutureActor, 1, Void>::remove();
		SAV<Void>::sendErrorAndDelPromiseRef(actor_cancelled());
	}

	void destroy() override { delete this; }

#ifdef ENABLE_SAMPLING
	LineageReference* lineageAddr() { return currentLineage; }
#endif

	void a_callback_fire(ActorCallback<YieldedFutureActor, 1, Void>*, Void) {
		if (int16_t(in_error_state.code()) == UNSET_ERROR_CODE) {
			in_error_state = Error::fromCode(SET_ERROR_CODE);
			if (check_yield())
				doYield();
			else
				finish();
		} else {
			// We hit this case when and only when the delay() created by a previous doYield() fires.  Then we want to
			// get at least one task done, regardless of what check_yield() would say.
			finish();
		}
	}
	void a_callback_error(ActorCallback<YieldedFutureActor, 1, Void>*, Error const& err) {
		ASSERT(int16_t(in_error_state.code()) == UNSET_ERROR_CODE);
		in_error_state = err;
		if (check_yield())
			doYield();
		else
			finish();
	}
	void finish() {
		ActorCallback<YieldedFutureActor, 1, Void>::remove();
		if (int16_t(in_error_state.code()) == SET_ERROR_CODE)
			SAV<Void>::sendAndDelPromiseRef(Void());
		else
			SAV<Void>::sendErrorAndDelPromiseRef(in_error_state);
	}
	void doYield() {
		// Since we are being fired, we are the first callback in the ring, and `prev` is the source future
		Callback<Void>* source = CB1::prev;
		ASSERT(source->next == static_cast<CB1*>(this));

		// Remove the source future from the ring.  All the remaining callbacks in the ring should be yielded, since
		// yielded callbacks are installed at the end
		CB1::prev = source->prev;
		CB1::prev->next = static_cast<CB1*>(this);

		// The source future's ring is now empty, since we have removed all the callbacks
		source->next = source->prev = source;
		source->unwait();

		// Link all the callbacks, including this one, into the ring of a delay future so that after a short time they
		// will be fired again
		delay(0, g_network->getCurrentTask()).addCallbackChainAndClear(static_cast<CB1*>(this));
	}
};

inline Future<Void> yieldedFuture(Future<Void> f) {
	if (f.isReady())
		return yield();
	else
		return Future<Void>(new YieldedFutureActor(std::move(f)));
}

// An AsyncMap that uses a yieldedFuture in its onChange method.
template <class K, class V>
class YieldedAsyncMap : public AsyncMap<K, V> {
public:
	Future<Void> onChange(K const& k) override { // throws broken_promise if this is destroyed
		auto& item = AsyncMap<K, V>::items[k];
		if (item.value == AsyncMap<K, V>::defaultValue)
			return destroyOnCancelYield(this, k, item.change.getFuture());
		return yieldedFuture(item.change.getFuture());
	}

																#line 19545 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via destroyOnCancelYield()
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class DestroyOnCancelYieldActor>
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelYieldActorState {
															#line 19551 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelYieldActorState(YieldedAsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   change(change)
															#line 19562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("destroyOnCancelYield", reinterpret_cast<unsigned long>(this));

	}
	~DestroyOnCancelYieldActorState() 
	{
		fdb_probe_actor_destroy("destroyOnCancelYield", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = yieldedFuture(change);
															#line 1863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<DestroyOnCancelYieldActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19580 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DestroyOnCancelYieldActor*>(this)->actor_wait_state = 1;
															#line 1863 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyOnCancelYieldActor, 0, Void >*>(static_cast<DestroyOnCancelYieldActor*>(this)));
															#line 19585 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DestroyOnCancelYieldActorState();
		static_cast<DestroyOnCancelYieldActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1866 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled && !self->destructing && change.getFutureReferenceCount() == 1 && change.getPromiseReferenceCount() == 1)
															#line 19615 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1868 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (EXPENSIVE_VALIDATION)
															#line 19619 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				{
															#line 1869 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					auto& p = self->items[key];
															#line 1870 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					ASSERT(p.change.getFuture() == change);
															#line 19625 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				}
															#line 1872 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				self->items.erase(key);
															#line 19629 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1874 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 19633 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelYieldActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelYieldActorState(); static_cast<DestroyOnCancelYieldActor*>(this)->destroy(); return 0; }
															#line 19647 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelYieldActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelYieldActorState();
		static_cast<DestroyOnCancelYieldActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelYieldActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelYieldActorState(); static_cast<DestroyOnCancelYieldActor*>(this)->destroy(); return 0; }
															#line 19659 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelYieldActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelYieldActorState();
		static_cast<DestroyOnCancelYieldActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyOnCancelYieldActor*>(this)->actor_wait_state > 0) static_cast<DestroyOnCancelYieldActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyOnCancelYieldActor*>(this)->ActorCallback< DestroyOnCancelYieldActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelYieldActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelYieldActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyOnCancelYieldActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	YieldedAsyncMap* self;
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	K key;
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> change;
															#line 19736 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via destroyOnCancelYield()
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelYieldActor final : public Actor<Void>, public ActorCallback< DestroyOnCancelYieldActor, 0, Void >, public FastAllocated<DestroyOnCancelYieldActor>, public DestroyOnCancelYieldActorState<DestroyOnCancelYieldActor> {
															#line 19741 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DestroyOnCancelYieldActor>::operator new;
	using FastAllocated<DestroyOnCancelYieldActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyOnCancelYieldActor, 0, Void >;
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelYieldActor(YieldedAsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 19752 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DestroyOnCancelYieldActorState<DestroyOnCancelYieldActor>(self, key, change)
	{
		fdb_probe_actor_enter("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroyOnCancelYield");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroyOnCancelYield", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DestroyOnCancelYieldActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> destroyOnCancelYield( YieldedAsyncMap* const& self, K const& key, Future<Void> const& change ) {
															#line 1861 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DestroyOnCancelYieldActor(self, key, change));
															#line 19779 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1877 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

															#line 19785 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via delayActionJittered()
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DelayActionJitteredActor>
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayActionJitteredActorState {
															#line 19792 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayActionJitteredActorState(Future<T> const& what,double const& time) 
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time)
															#line 19801 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("delayActionJittered", reinterpret_cast<unsigned long>(this));

	}
	~DelayActionJitteredActorState() 
	{
		fdb_probe_actor_destroy("delayActionJittered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = delayJittered(time);
															#line 1881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<DelayActionJitteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19818 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DelayActionJitteredActor*>(this)->actor_wait_state = 1;
															#line 1881 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayActionJitteredActor, 0, Void >*>(static_cast<DelayActionJitteredActor*>(this)));
															#line 19823 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayActionJitteredActorState();
		static_cast<DelayActionJitteredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = what;
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayActionJitteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19848 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayActionJitteredActor*>(this)->actor_wait_state = 2;
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayActionJitteredActor, 1, T >*>(static_cast<DelayActionJitteredActor*>(this)));
															#line 19853 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = what;
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayActionJitteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19864 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayActionJitteredActor*>(this)->actor_wait_state = 2;
															#line 1882 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayActionJitteredActor, 1, T >*>(static_cast<DelayActionJitteredActor*>(this)));
															#line 19869 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayActionJitteredActor*>(this)->actor_wait_state > 0) static_cast<DelayActionJitteredActor*>(this)->actor_wait_state = 0;
		static_cast<DelayActionJitteredActor*>(this)->ActorCallback< DelayActionJitteredActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayActionJitteredActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayActionJitteredActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayActionJitteredActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1883 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayActionJitteredActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayActionJitteredActorState(); static_cast<DelayActionJitteredActor*>(this)->destroy(); return 0; }
															#line 19941 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayActionJitteredActor*>(this)->SAV< T >::value()) T(t);
		this->~DelayActionJitteredActorState();
		static_cast<DelayActionJitteredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1883 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayActionJitteredActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayActionJitteredActorState(); static_cast<DelayActionJitteredActor*>(this)->destroy(); return 0; }
															#line 19953 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayActionJitteredActor*>(this)->SAV< T >::value()) T(t);
		this->~DelayActionJitteredActorState();
		static_cast<DelayActionJitteredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DelayActionJitteredActor*>(this)->actor_wait_state > 0) static_cast<DelayActionJitteredActor*>(this)->actor_wait_state = 0;
		static_cast<DelayActionJitteredActor*>(this)->ActorCallback< DelayActionJitteredActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< DelayActionJitteredActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayActionJitteredActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayActionJitteredActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 20028 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via delayActionJittered()
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayActionJitteredActor final : public Actor<T>, public ActorCallback< DelayActionJitteredActor<T>, 0, Void >, public ActorCallback< DelayActionJitteredActor<T>, 1, T >, public FastAllocated<DelayActionJitteredActor<T>>, public DelayActionJitteredActorState<T, DelayActionJitteredActor<T>> {
															#line 20035 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DelayActionJitteredActor<T>>::operator new;
	using FastAllocated<DelayActionJitteredActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayActionJitteredActor<T>, 0, Void >;
friend struct ActorCallback< DelayActionJitteredActor<T>, 1, T >;
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayActionJitteredActor(Future<T> const& what,double const& time) 
															#line 20047 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   DelayActionJitteredActorState<T, DelayActionJitteredActor<T>>(what, time)
	{
		fdb_probe_actor_enter("delayActionJittered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayActionJittered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayActionJittered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayActionJitteredActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DelayActionJitteredActor<T>, 1, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> delayActionJittered( Future<T> const& what, double const& time ) {
															#line 1879 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new DelayActionJitteredActor<T>(what, time));
															#line 20078 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1885 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

class AndFuture {
public:
	AndFuture() = default;
	AndFuture(AndFuture const& f) = default;
	AndFuture(AndFuture&& f) noexcept = default;
	AndFuture& operator=(AndFuture const& f) = default;
	AndFuture& operator=(AndFuture&& f) noexcept = default;

	AndFuture(Future<Void> const& f) : futureCount(1), futures{ f } {}

	AndFuture(Error const& e) : futureCount(1), futures{ Future<Void>(e) } {}

	operator Future<Void>() { return getFuture(); }

	Future<Void> getFuture() {
		if (futures.empty())
			return Void();

		if (futures.size() == 1)
			return futures[0];

		Future<Void> f = waitForAll(futures);
		futures = std::vector<Future<Void>>{ f };
		return f;
	}

	bool isReady() {
		for (int i = futures.size() - 1; i >= 0; --i) {
			if (!futures[i].isReady()) {
				return false;
			} else if (!futures[i].isError()) {
				swapAndPop(&futures, i);
			}
		}
		return true;
	}

	bool isError() const {
		for (int i = 0; i < futures.size(); i++)
			if (futures[i].isError())
				return true;
		return false;
	}

	void cleanup() {
		for (int i = 0; i < futures.size(); i++) {
			if (futures[i].isReady() && !futures[i].isError()) {
				swapAndPop(&futures, i--);
			}
		}
	}

	void add(Future<Void> const& f) {
		++futureCount;
		if (!f.isReady() || f.isError())
			futures.push_back(f);
	}

	void add(AndFuture f) { add(f.getFuture()); }

	// The total number of futures which have ever been added to this AndFuture
	int64_t getFutureCount() const { return futureCount; }

private:
	int64_t futureCount = 0;
	std::vector<Future<Void>> futures;
};

// Performs an unordered merge of a and b.
															#line 20152 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via unorderedMergeStreams()
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class UnorderedMergeStreamsActor>
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UnorderedMergeStreamsActorState {
															#line 20159 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UnorderedMergeStreamsActorState(FutureStream<T> const& a,FutureStream<T> const& b,PromiseStream<T> const& output) 
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : a(a),
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   b(b),
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 1957 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   aFuture(waitAndForward(a)),
															#line 1958 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   bFuture(waitAndForward(b)),
															#line 1959 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   aOpen(true),
															#line 1960 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   bOpen(true)
															#line 20178 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("unorderedMergeStreams", reinterpret_cast<unsigned long>(this));

	}
	~UnorderedMergeStreamsActorState() 
	{
		fdb_probe_actor_destroy("unorderedMergeStreams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1962 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 20193 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnorderedMergeStreamsActorState();
		static_cast<UnorderedMergeStreamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1998 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<UnorderedMergeStreamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnorderedMergeStreamsActorState(); static_cast<UnorderedMergeStreamsActor*>(this)->destroy(); return 0; }
															#line 20216 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<UnorderedMergeStreamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnorderedMergeStreamsActorState();
		static_cast<UnorderedMergeStreamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1965 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = aFuture;
															#line 1964 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<UnorderedMergeStreamsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 20238 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_1 = bFuture;
															#line 20242 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<UnorderedMergeStreamsActor*>(this)->actor_wait_state = 1;
															#line 1965 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnorderedMergeStreamsActor, 0, T >*>(static_cast<UnorderedMergeStreamsActor*>(this)));
															#line 1969 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnorderedMergeStreamsActor, 1, T >*>(static_cast<UnorderedMergeStreamsActor*>(this)));
															#line 20249 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1975 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() != error_code_end_of_stream)
															#line 20284 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1976 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				output.sendError(e);
															#line 20288 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1980 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			ASSERT(!aFuture.isError() || !bFuture.isError() || aFuture.getError().code() == bFuture.getError().code());
															#line 1982 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (aFuture.isError())
															#line 20295 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1983 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				aFuture = Never();
															#line 1984 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				aOpen = false;
															#line 20301 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1986 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (bFuture.isError())
															#line 20305 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1987 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				bFuture = Never();
															#line 1988 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				bOpen = false;
															#line 20311 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1991 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!aOpen && !bOpen)
															#line 20315 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1992 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				output.sendError(e);
															#line 20319 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& val,int loopDepth) 
	{
															#line 1966 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(val);
															#line 1967 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		aFuture = waitAndForward(a);
															#line 20344 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && val,int loopDepth) 
	{
															#line 1966 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(val);
															#line 1967 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		aFuture = waitAndForward(a);
															#line 20355 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(T const& val,int loopDepth) 
	{
															#line 1970 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(val);
															#line 1971 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		bFuture = waitAndForward(b);
															#line 20366 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(T && val,int loopDepth) 
	{
															#line 1970 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(val);
															#line 1971 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		bFuture = waitAndForward(b);
															#line 20377 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnorderedMergeStreamsActor*>(this)->actor_wait_state > 0) static_cast<UnorderedMergeStreamsActor*>(this)->actor_wait_state = 0;
		static_cast<UnorderedMergeStreamsActor*>(this)->ActorCallback< UnorderedMergeStreamsActor, 0, T >::remove();
		static_cast<UnorderedMergeStreamsActor*>(this)->ActorCallback< UnorderedMergeStreamsActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< UnorderedMergeStreamsActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnorderedMergeStreamsActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnorderedMergeStreamsActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnorderedMergeStreamsActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnorderedMergeStreamsActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnorderedMergeStreamsActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> a;
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> b;
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 1957 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> aFuture;
															#line 1958 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> bFuture;
															#line 1959 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool aOpen;
															#line 1960 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool bOpen;
															#line 20506 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via unorderedMergeStreams()
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UnorderedMergeStreamsActor final : public Actor<Void>, public ActorCallback< UnorderedMergeStreamsActor<T>, 0, T >, public ActorCallback< UnorderedMergeStreamsActor<T>, 1, T >, public FastAllocated<UnorderedMergeStreamsActor<T>>, public UnorderedMergeStreamsActorState<T, UnorderedMergeStreamsActor<T>> {
															#line 20513 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<UnorderedMergeStreamsActor<T>>::operator new;
	using FastAllocated<UnorderedMergeStreamsActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< UnorderedMergeStreamsActor<T>, 0, T >;
friend struct ActorCallback< UnorderedMergeStreamsActor<T>, 1, T >;
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UnorderedMergeStreamsActor(FutureStream<T> const& a,FutureStream<T> const& b,PromiseStream<T> const& output) 
															#line 20525 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   UnorderedMergeStreamsActorState<T, UnorderedMergeStreamsActor<T>>(a, b, output)
	{
		fdb_probe_actor_enter("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unorderedMergeStreams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unorderedMergeStreams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnorderedMergeStreamsActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> unorderedMergeStreams( FutureStream<T> const& a, FutureStream<T> const& b, PromiseStream<T> const& output ) {
															#line 1955 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new UnorderedMergeStreamsActor<T>(a, b, output));
															#line 20555 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 2000 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Returns the ordered merge of a and b, assuming that a and b are both already ordered (prefer a over b if keys are
// equal). T must be a class that implements compare()
															#line 20562 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via orderedMergeStreams()
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class OrderedMergeStreamsActor>
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OrderedMergeStreamsActorState {
															#line 20569 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OrderedMergeStreamsActorState(FutureStream<T> const& a,FutureStream<T> const& b,PromiseStream<T> const& output) 
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : a(a),
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   b(b),
															#line 2003 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 2005 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   savedKVa(),
															#line 2006 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   aOpen(),
															#line 2007 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   savedKVb(),
															#line 2008 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   bOpen()
															#line 20588 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("orderedMergeStreams", reinterpret_cast<unsigned long>(this));

	}
	~OrderedMergeStreamsActorState() 
	{
		fdb_probe_actor_destroy("orderedMergeStreams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2010 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			aOpen = bOpen = true;
															#line 2012 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 20605 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OrderedMergeStreamsActorState();
		static_cast<OrderedMergeStreamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2070 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<OrderedMergeStreamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OrderedMergeStreamsActorState(); static_cast<OrderedMergeStreamsActor*>(this)->destroy(); return 0; }
															#line 20628 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<OrderedMergeStreamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OrderedMergeStreamsActorState();
		static_cast<OrderedMergeStreamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2013 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (aOpen && !savedKVa.present())
															#line 20647 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
			try {
															#line 2015 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				FutureStream<T> __when_expr_0 = a;
															#line 2015 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<OrderedMergeStreamsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 20654 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
				static_cast<OrderedMergeStreamsActor*>(this)->actor_wait_state = 1;
															#line 2015 "/codebuild/output/src2004531956/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< OrderedMergeStreamsActor, 0, T >*>(static_cast<OrderedMergeStreamsActor*>(this)));
															#line 20659 "/codebuild/output/src