﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ssm-incidents/model/GetIncidentRecordResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::SSMIncidents::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetIncidentRecordResult::GetIncidentRecordResult()
{
}

GetIncidentRecordResult::GetIncidentRecordResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

GetIncidentRecordResult& GetIncidentRecordResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("incidentRecord"))
  {
    m_incidentRecord = jsonValue.GetObject("incidentRecord");

  }



  return *this;
}
