﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/securityhub/model/VulnerabilityFixAvailable.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SecurityHub
  {
    namespace Model
    {
      namespace VulnerabilityFixAvailableMapper
      {

        static const int YES_HASH = HashingUtils::HashString("YES");
        static const int NO_HASH = HashingUtils::HashString("NO");
        static const int PARTIAL_HASH = HashingUtils::HashString("PARTIAL");


        VulnerabilityFixAvailable GetVulnerabilityFixAvailableForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == YES_HASH)
          {
            return VulnerabilityFixAvailable::YES;
          }
          else if (hashCode == NO_HASH)
          {
            return VulnerabilityFixAvailable::NO;
          }
          else if (hashCode == PARTIAL_HASH)
          {
            return VulnerabilityFixAvailable::PARTIAL;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<VulnerabilityFixAvailable>(hashCode);
          }

          return VulnerabilityFixAvailable::NOT_SET;
        }

        Aws::String GetNameForVulnerabilityFixAvailable(VulnerabilityFixAvailable enumValue)
        {
          switch(enumValue)
          {
          case VulnerabilityFixAvailable::YES:
            return "YES";
          case VulnerabilityFixAvailable::NO:
            return "NO";
          case VulnerabilityFixAvailable::PARTIAL:
            return "PARTIAL";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace VulnerabilityFixAvailableMapper
    } // namespace Model
  } // namespace SecurityHub
} // namespace Aws
