﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/route53/model/ListCidrCollectionsResult.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>

#include <utility>

using namespace Aws::Route53::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

ListCidrCollectionsResult::ListCidrCollectionsResult()
{
}

ListCidrCollectionsResult::ListCidrCollectionsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  *this = result;
}

ListCidrCollectionsResult& ListCidrCollectionsResult::operator =(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if(!resultNode.IsNull())
  {
    XmlNode nextTokenNode = resultNode.FirstChild("NextToken");
    if(!nextTokenNode.IsNull())
    {
      m_nextToken = Aws::Utils::Xml::DecodeEscapedXmlText(nextTokenNode.GetText());
    }
    XmlNode cidrCollectionsNode = resultNode.FirstChild("CidrCollections");
    if(!cidrCollectionsNode.IsNull())
    {
      XmlNode cidrCollectionsMember = cidrCollectionsNode.FirstChild("member");
      while(!cidrCollectionsMember.IsNull())
      {
        m_cidrCollections.push_back(cidrCollectionsMember);
        cidrCollectionsMember = cidrCollectionsMember.NextNode("member");
      }

    }
  }

  return *this;
}
