﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backupstorage/model/ListObjectsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BackupStorage::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListObjectsRequest::ListObjectsRequest() : 
    m_storageJobIdHasBeenSet(false),
    m_startingObjectNameHasBeenSet(false),
    m_startingObjectPrefixHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_createdBeforeHasBeenSet(false),
    m_createdAfterHasBeenSet(false)
{
}

Aws::String ListObjectsRequest::SerializePayload() const
{
  return {};
}

void ListObjectsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_startingObjectNameHasBeenSet)
    {
      ss << m_startingObjectName;
      uri.AddQueryStringParameter("starting-object-name", ss.str());
      ss.str("");
    }

    if(m_startingObjectPrefixHasBeenSet)
    {
      ss << m_startingObjectPrefix;
      uri.AddQueryStringParameter("starting-object-prefix", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("max-results", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("next-token", ss.str());
      ss.str("");
    }

    if(m_createdBeforeHasBeenSet)
    {
      ss << m_createdBefore.ToGmtString(DateFormat::ISO_8601);
      uri.AddQueryStringParameter("created-before", ss.str());
      ss.str("");
    }

    if(m_createdAfterHasBeenSet)
    {
      ss << m_createdAfter.ToGmtString(DateFormat::ISO_8601);
      uri.AddQueryStringParameter("created-after", ss.str());
      ss.str("");
    }

}



