#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
/*
 * MiniCycle.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/serialize.h"
#include <cstring>

#include "flow/actorcompiler.h" // This must be the last #include.

struct MiniCycleWorkload : TestWorkload {
	static constexpr auto NAME = "MiniCycle";

	int actorCount, nodeCount;
	double testDuration, transactionsPerSecond, minExpectedTransactionsPerSecond, traceParentProbability;
	Key keyPrefix;

	FlowLock checkLock;
	PerfIntCounter transactions, retries, tooOldRetries, commitFailedRetries;
	PerfDoubleCounter totalLatency;

	MiniCycleWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), tooOldRetries("Retries.too_old"),
	    commitFailedRetries("Retries.commit_failed"), totalLatency("Latency") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		nodeCount = getOption(options, "nodeCount"_sr, transactionsPerSecond * clientCount);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, ""_sr).toString());
		traceParentProbability = getOption(options, "traceParentProbability "_sr, 0.01);
		minExpectedTransactionsPerSecond = transactionsPerSecond * getOption(options, "expectedRate"_sr, 0.7);
	}

	Future<Void> setup(Database const& cx) override {
		return bulkSetup(cx->clone(),
		                 this,
		                 cycleSize(clientId),
		                 Promise<double>(),
		                 false,
		                 0.0,
		                 1e12,
		                 std::vector<uint64_t>(),
		                 Promise<std::vector<std::pair<uint64_t, double>>>(),
		                 0,
		                 0.1,
		                 beginKey(clientId),
		                 endKey(clientId));
	}

	Future<Void> start(Database const& cx) override { return Void(); }
	Future<bool> check(Database const& cx) override { return _check(cx->clone(), this); }

																#line 78 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
template <class _checkActor>
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class _checkActorState {
															#line 84 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	_checkActorState(Database const& cx,MiniCycleWorkload* const& self) 
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		 : cx(cx),
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   self(self),
															#line 77 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   cycleClients()
															#line 95 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			for(int c = 0;c < self->clientCount;c++) {
															#line 79 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				cycleClients.push_back( timeout(self->cycleClient(cx->clone(), self, self->actorCount / self->transactionsPerSecond), self->testDuration, Void()));
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			}
															#line 84 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			end = delay(self->testDuration);
															#line 85 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			ok = true;
															#line 86 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			;
															#line 120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 100 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		int errors = 0;
															#line 101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		for(int c = 0;c < cycleClients.size();c++) {
															#line 102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			errors += cycleClients[c].isError();
															#line 147 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 103 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (errors || !ok)
															#line 151 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 104 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were check or cycle client errors.");
															#line 155 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		cycleClients.clear();
															#line 107 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		printf("Beginning full cycle check...");
															#line 108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<bool> __when_expr_2 = self->_checkCycle(cx->clone(), self, ok);
															#line 108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 165 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, bool >*>(static_cast<_checkActor*>(this)));
															#line 170 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<bool> __when_expr_0 = self->_checkCycle(cx->clone(), self, ok);
															#line 87 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 188 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 93 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Void> __when_expr_1 = end;
															#line 192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, bool >*>(static_cast<_checkActor*>(this)));
															#line 93 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 199 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& ret,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		ok = ret && ok;
															#line 90 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!ok)
															#line 229 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 233 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && ret,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		ok = ret && ok;
															#line 90 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!ok)
															#line 249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 253 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, bool >::remove();
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(bool const& ret,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 400 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && ret,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 412 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& ret,int loopDepth) 
	{
		loopDepth = a_body1cont3(ret, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && ret,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(ret), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Database cx;
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	MiniCycleWorkload* self;
															#line 77 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	std::vector<Future<Void>> cycleClients;
															#line 84 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Future<Void> end;
															#line 85 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	bool ok;
															#line 505 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, bool >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, bool >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 510 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11815052745042704640UL, 3636471015601130752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, bool >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, bool >;
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	_checkActor(Database const& cx,MiniCycleWorkload* const& self) 
															#line 529 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, MiniCycleWorkload* const& self ) {
															#line 76 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 562 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
}

#line 111 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"

																#line 567 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
// This generated class is to be used only via _checkCycle()
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
template <class _checkCycleActor>
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class _checkCycleActorState {
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	_checkCycleActorState(Database const& cx,MiniCycleWorkload* const& self,bool const& ok) 
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		 : cx(cx),
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   self(self),
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   ok(ok),
															#line 113 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   checkClients()
															#line 586 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_checkCycle", reinterpret_cast<unsigned long>(this));

	}
	~_checkCycleActorState() 
	{
		fdb_probe_actor_destroy("_checkCycle", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			for(int c = 0;c < self->clientCount;c++) {
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				checkClients.push_back(self->cycleCheckClient(cx->clone(), self, ok));
															#line 603 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			}
															#line 116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<bool> __when_expr_0 = allTrue(checkClients);
															#line 116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<_checkCycleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 609 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkCycleActor*>(this)->actor_wait_state = 1;
															#line 116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkCycleActor, 0, bool >*>(static_cast<_checkCycleActor*>(this)));
															#line 614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkCycleActorState();
		static_cast<_checkCycleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& ret,int loopDepth) 
	{
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		int errors = 0;
															#line 120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		for(int c = 0;c < checkClients.size();c++) {
															#line 121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			errors += checkClients[c].isError();
															#line 641 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 122 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (errors)
															#line 645 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 123 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were checker errors.");
															#line 649 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 124 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!static_cast<_checkCycleActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkCycleActorState(); static_cast<_checkCycleActor*>(this)->destroy(); return 0; }
															#line 653 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		new (&static_cast<_checkCycleActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkCycleActorState();
		static_cast<_checkCycleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && ret,int loopDepth) 
	{
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		int errors = 0;
															#line 120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		for(int c = 0;c < checkClients.size();c++) {
															#line 121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			errors += checkClients[c].isError();
															#line 669 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 122 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (errors)
															#line 673 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 123 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were checker errors.");
															#line 677 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 124 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!static_cast<_checkCycleActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkCycleActorState(); static_cast<_checkCycleActor*>(this)->destroy(); return 0; }
															#line 681 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		new (&static_cast<_checkCycleActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkCycleActorState();
		static_cast<_checkCycleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& ret,int loopDepth) 
	{
		loopDepth = a_body1cont1(ret, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && ret,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(ret), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkCycleActor*>(this)->actor_wait_state > 0) static_cast<_checkCycleActor*>(this)->actor_wait_state = 0;
		static_cast<_checkCycleActor*>(this)->ActorCallback< _checkCycleActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkCycleActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_checkCycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkCycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_checkCycle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkCycleActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_checkCycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkCycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_checkCycle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkCycleActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_checkCycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkCycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_checkCycle", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Database cx;
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	MiniCycleWorkload* self;
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	bool ok;
															#line 113 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	std::vector<Future<bool>> checkClients;
															#line 772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _checkCycle()
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class _checkCycleActor final : public Actor<bool>, public ActorCallback< _checkCycleActor, 0, bool >, public FastAllocated<_checkCycleActor>, public _checkCycleActorState<_checkCycleActor> {
															#line 777 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkCycleActor>::operator new;
	using FastAllocated<_checkCycleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4204001746120593920UL, 1276681239358532608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkCycleActor, 0, bool >;
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	_checkCycleActor(Database const& cx,MiniCycleWorkload* const& self,bool const& ok) 
															#line 794 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkCycleActorState<_checkCycleActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_checkCycle", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9996763056688071680UL, 8772320755699025152UL);
		ActorExecutionContextHelper __helper(static_cast<_checkCycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_checkCycle");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_checkCycle", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkCycleActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
[[nodiscard]] Future<bool> _checkCycle( Database const& cx, MiniCycleWorkload* const& self, bool const& ok ) {
															#line 112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	return Future<bool>(new _checkCycleActor(cx, self, ok));
															#line 826 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
}

#line 126 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(tooOldRetries.getMetric());
		m.push_back(commitFailedRetries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
		m.emplace_back("Read rows/simsec (approx)", transactions.getValue() * 3 / testDuration, Averaged::False);
		m.emplace_back("Write rows/simsec (approx)", transactions.getValue() * 4 / testDuration, Averaged::False);
	}

	Key keyForIndex(int n) { return key(n); }
	Key key(int n) { return doubleToTestKey(n, keyPrefix); }
	Value value(int n) { return doubleToTestKey(n, keyPrefix); }
	int fromValue(const ValueRef& v) { return testKeyToDouble(v, keyPrefix); }

	// cycleSize returns the length of each mini-cycle besides the last,
	// which is cycleSize + remainder nodes in length
	int cycleSize(int clientId) {
		// The remaining keys should go in the last cycle
		int rem = (clientId == clientCount - 1) ? nodeCount % clientCount : 0;
		return nodeCount / clientCount + rem;
	}
	// cycleOffset returns the node number at which clientId's mini-cycle begins
	int cycleOffset(int clientId) { return clientId * cycleSize(0); }
	int beginKey(int clientId) { return cycleOffset(clientId); }
	int endKey(int clientId) { return cycleSize(clientId) + cycleOffset(clientId); }

	Standalone<KeyValueRef> operator()(int n) {
		const uint64_t val = (n + 1) % endKey(clientId) ? n + 1 : beginKey(clientId);
		return KeyValueRef(key(n), value(val));
	}

	void badRead(const char* name, int r, Transaction& tr) {
		TraceEvent(SevError, "MiniCycleBadRead")
		    .detail(name, r)
		    .detail("Key", printable(key(r)))
		    .detail("Version", tr.getReadVersion().get())
		    .detailf("From", "%016llx", debug_lastLoadBalanceResultEndpointToken);
	}

																#line 871 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
// This generated class is to be used only via cycleClient()
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
template <class CycleClientActor>
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class CycleClientActorState {
															#line 877 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	CycleClientActorState(Database const& cx,MiniCycleWorkload* const& self,double const& delay) 
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		 : cx(cx),
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   self(self),
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   delay(delay),
															#line 168 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   lastTime(now())
															#line 890 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	~CycleClientActorState() 
	{
		fdb_probe_actor_destroy("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 170 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				;
															#line 906 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleClientActorState();
		static_cast<CycleClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent(SevError, "MiniCycleClient").error(e);
															#line 224 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 961 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 0, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tstart = now();
															#line 174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r = deterministicRandom()->randomInt(self->beginKey(self->clientId), self->endKey(self->clientId) - 1);
															#line 176 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr = Transaction(cx);
															#line 177 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (deterministicRandom()->random01() >= self->traceParentProbability)
															#line 981 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			span = Span("MiniCycleClient"_loc);
															#line 179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent("MiniCycleTracingTransaction", span.context.traceID).log();
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, Unversioned()));
															#line 989 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 183 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		;
															#line 993 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tstart = now();
															#line 174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r = deterministicRandom()->randomInt(self->beginKey(self->clientId), self->endKey(self->clientId) - 1);
															#line 176 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr = Transaction(cx);
															#line 177 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (deterministicRandom()->random01() >= self->traceParentProbability)
															#line 1008 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			span = Span("MiniCycleClient"_loc);
															#line 179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent("MiniCycleTracingTransaction", span.context.traceID).log();
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, Unversioned()));
															#line 1016 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 183 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		;
															#line 1020 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 219 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		++self->transactions;
															#line 220 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		self->totalLatency += now() - tstart;
															#line 1106 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(self->key(r));
															#line 186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1125 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 2;
															#line 186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 1, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 1130 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 217 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		++self->retries;
															#line 1158 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 1168 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			{
															#line 212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				++self->tooOldRetries;
															#line 1172 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			}
			else
			{
															#line 213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				if (e.code() == error_code_not_committed)
															#line 1178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
				{
															#line 214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
					++self->commitFailedRetries;
															#line 1182 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
				}
			}
															#line 215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1189 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 6;
															#line 215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 5, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 1194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v.present())
															#line 1209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 188 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 1213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 189 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1221 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 1226 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v.present())
															#line 1235 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 188 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 1239 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 189 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1247 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 190 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 1252 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> const& v2,int loopDepth) 
	{
															#line 191 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v2.present())
															#line 1336 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 193 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 1353 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> && v2,int loopDepth) 
	{
															#line 191 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v2.present())
															#line 1362 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 1366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 193 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1374 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 1379 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> const& v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(v2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> && v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(v2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> const& v3,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v3.present())
															#line 1463 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 196 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 1467 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 197 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		int r4 = self->fromValue(v3.get());
															#line 199 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.clear(self->key(r));
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 201 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 202 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 1488 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> && v3,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!v3.present())
															#line 1497 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		{
															#line 196 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 1501 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		}
															#line 197 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		int r4 = self->fromValue(v3.get());
															#line 199 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.clear(self->key(r));
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 201 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 202 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1517 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 1522 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> const& v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(v3, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> && v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(std::move(v3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Database cx;
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	MiniCycleWorkload* self;
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	double delay;
															#line 168 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	double lastTime;
															#line 173 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	double tstart;
															#line 174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	int r;
															#line 176 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Transaction tr;
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Span span;
															#line 189 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	int r2;
															#line 193 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	int r3;
															#line 1796 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cycleClient()
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class CycleClientActor final : public Actor<Void>, public ActorCallback< CycleClientActor, 0, Void >, public ActorCallback< CycleClientActor, 1, Optional<Value> >, public ActorCallback< CycleClientActor, 2, Optional<Value> >, public ActorCallback< CycleClientActor, 3, Optional<Value> >, public ActorCallback< CycleClientActor, 4, Void >, public ActorCallback< CycleClientActor, 5, Void >, public FastAllocated<CycleClientActor>, public CycleClientActorState<CycleClientActor> {
															#line 1801 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<CycleClientActor>::operator new;
	using FastAllocated<CycleClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8931048238958613760UL, 12924902342841129216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleClientActor, 0, Void >;
friend struct ActorCallback< CycleClientActor, 1, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 2, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 3, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 4, Void >;
friend struct ActorCallback< CycleClientActor, 5, Void >;
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	CycleClientActor(Database const& cx,MiniCycleWorkload* const& self,double const& delay) 
															#line 1823 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CycleClientActorState<CycleClientActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8966781505302877440UL, 11126568448771745280UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleClientActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CycleClientActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CycleClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CycleClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
[[nodiscard]] Future<Void> cycleClient( Database const& cx, MiniCycleWorkload* const& self, double const& delay ) {
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	return Future<Void>(new CycleClientActor(cx, self, delay));
															#line 1860 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
}

#line 227 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"

	void logTestData(const VectorRef<KeyValueRef>& data) {
		TraceEvent("TestFailureDetail").log();
		int index = 0;
		for (auto& entry : data) {
			TraceEvent("CurrentDataEntry")
			    .detail("Index", index)
			    .detail("Key", entry.key.toString())
			    .detail("Value", entry.value.toString());
			index++;
		}
	}

	bool cycleCheckData(const VectorRef<KeyValueRef>& data, Version v, int clientID) {
		if (data.size() != cycleSize(clientId)) {
			logTestData(data);
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Node count changed")
			    .detail("Before", cycleSize(clientId))
			    .detail("After", data.size())
			    .detail("Version", v)
			    .detail("KeyPrefix", keyPrefix.printable());
			TraceEvent(SevError, "TestFailureInfo")
			    .detail("DataSize", data.size())
			    .detail("CycleSize", cycleSize(clientId))
			    .detail("Workload", description());
			return false;
		}
		int i = beginKey(clientId);
		int iPrev = beginKey(clientId);
		double d;
		int c;
		for (c = 0; c < cycleSize(clientId); c++) {
			if (c && !(i - beginKey(clientId))) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "MiniCycle got shorter")
				    .detail("Before", cycleSize(clientId))
				    .detail("After", c)
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
			if (data[i - beginKey(clientId)].key != key(i)) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Key changed")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}

			d = testKeyToDouble(data[i - beginKey(clientId)].value, keyPrefix);
			iPrev = i;
			i = (int)d;
			if (i != d || i < beginKey(clientId) || i >= endKey(clientId)) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Invalid value")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
		}
		if (i - beginKey(clientId) != 0) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "MiniCycle got longer")
			    .detail("KeyPrefix", keyPrefix.printable())
			    .detail("Key", key(i))
			    .detail("Value", data[i - beginKey(clientId)].value)
			    .detail("Iteration", c)
			    .detail("CycleSize", cycleSize(clientId))
			    .detail("Int", i)
			    .detail("Double", d)
			    .detail("ValuePrev", data[iPrev - beginKey(clientId)].value)
			    .detail("KeyPrev", data[iPrev - beginKey(clientId)].key);
			logTestData(data);
			return false;
		}
		return true;
	}
																#line 1942 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
// This generated class is to be used only via cycleCheckClient()
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
template <class CycleCheckClientActor>
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class CycleCheckClientActorState {
															#line 1948 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	CycleCheckClientActorState(Database const& cx,MiniCycleWorkload* const& self,bool const& ok) 
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		 : cx(cx),
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   self(self),
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		   ok(ok)
															#line 1959 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cycleCheckClient", reinterpret_cast<unsigned long>(this));

	}
	~CycleCheckClientActorState() 
	{
		fdb_probe_actor_destroy("cycleCheckClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 306 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (self->transactions.getMetric().value() < self->testDuration * self->minExpectedTransactionsPerSecond)
															#line 1974 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			{
															#line 307 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				TraceEvent(SevWarnAlways, "TestFailure") .detail("Reason", "Rate below desired rate") .detail("File", __FILE__) .detail( "Details", format("%.2f", self->transactions.getMetric().value() / (self->transactionsPerSecond * self->testDuration))) .detail("TransactionsAchieved", self->transactions.getMetric().value()) .detail("MinTransactionsExpected", self->testDuration * self->minExpectedTransactionsPerSecond) .detail("TransactionGoal", self->transactionsPerSecond * self->testDuration);
															#line 317 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
				ok = false;
															#line 1980 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			}
															#line 321 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->checkLock.take();
															#line 321 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1986 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 1;
															#line 321 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleCheckClientActor, 0, Void >*>(static_cast<CycleCheckClientActor*>(this)));
															#line 1991 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleCheckClientActorState();
		static_cast<CycleCheckClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		releaser = FlowLock::Releaser(self->checkLock);
															#line 324 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr = Transaction(cx);
															#line 325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		retryCount = 0;
															#line 326 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		;
															#line 2020 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		releaser = FlowLock::Releaser(self->checkLock);
															#line 324 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		tr = Transaction(cx);
															#line 325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		retryCount = 0;
															#line 326 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		;
															#line 2035 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckClientActor*>(this)->ActorCallback< CycleCheckClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleCheckClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 341 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (!static_cast<CycleCheckClientActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~CycleCheckClientActorState(); static_cast<CycleCheckClientActor*>(this)->destroy(); return 0; }
															#line 2119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		new (&static_cast<CycleCheckClientActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~CycleCheckClientActorState();
		static_cast<CycleCheckClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<Version> __when_expr_1 = tr.getReadVersion();
															#line 328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2141 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 2;
															#line 328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleCheckClientActor, 1, Version >*>(static_cast<CycleCheckClientActor*>(this)));
															#line 2146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 336 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			retryCount++;
															#line 337 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			TraceEvent(retryCount > 20 ? SevWarnAlways : SevWarn, "MiniCycleCheckError").error(e);
															#line 338 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 338 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 4;
															#line 338 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleCheckClientActor, 3, Void >*>(static_cast<CycleCheckClientActor*>(this)));
															#line 2192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 329 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(firstGreaterOrEqual(doubleToTestKey(self->beginKey(self->clientId), self->keyPrefix)), firstGreaterOrEqual(doubleToTestKey(self->endKey(self->clientId), self->keyPrefix)), self->cycleSize(self->clientId) + 1);
															#line 329 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 3;
															#line 329 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleCheckClientActor, 2, RangeResult >*>(static_cast<CycleCheckClientActor*>(this)));
															#line 2214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& __v,int loopDepth) 
	{
															#line 328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		v = __v;
															#line 2223 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckClientActor*>(this)->ActorCallback< CycleCheckClientActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleCheckClientActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(RangeResult const& data,int loopDepth) 
	{
															#line 333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		ok = self->cycleCheckData(data, v, self->clientId) && ok;
															#line 2302 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(RangeResult && data,int loopDepth) 
	{
															#line 333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
		ok = self->cycleCheckData(data, v, self->clientId) && ok;
															#line 2311 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckClientActor*>(this)->ActorCallback< CycleCheckClientActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleCheckClientActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CycleCheckClientActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckClientActor*>(this)->ActorCallback< CycleCheckClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CycleCheckClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CycleCheckClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Database cx;
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	MiniCycleWorkload* self;
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	bool ok;
															#line 322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	FlowLock::Releaser releaser;
															#line 324 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Transaction tr;
															#line 325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	int retryCount;
															#line 328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	Version v;
															#line 2492 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cycleCheckClient()
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
class CycleCheckClientActor final : public Actor<bool>, public ActorCallback< CycleCheckClientActor, 0, Void >, public ActorCallback< CycleCheckClientActor, 1, Version >, public ActorCallback< CycleCheckClientActor, 2, RangeResult >, public ActorCallback< CycleCheckClientActor, 3, Void >, public FastAllocated<CycleCheckClientActor>, public CycleCheckClientActorState<CycleCheckClientActor> {
															#line 2497 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
public:
	using FastAllocated<CycleCheckClientActor>::operator new;
	using FastAllocated<CycleCheckClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2755841180626766080UL, 14799141358342914816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleCheckClientActor, 0, Void >;
friend struct ActorCallback< CycleCheckClientActor, 1, Version >;
friend struct ActorCallback< CycleCheckClientActor, 2, RangeResult >;
friend struct ActorCallback< CycleCheckClientActor, 3, Void >;
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	CycleCheckClientActor(Database const& cx,MiniCycleWorkload* const& self,bool const& ok) 
															#line 2517 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CycleCheckClientActorState<CycleCheckClientActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleCheckClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16340261661159417856UL, 17637160751564361984UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleCheckClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleCheckClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleCheckClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleCheckClientActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleCheckClientActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CycleCheckClientActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
[[nodiscard]] Future<bool> cycleCheckClient( Database const& cx, MiniCycleWorkload* const& self, bool const& ok ) {
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
	return Future<bool>(new CycleCheckClientActor(cx, self, ok));
															#line 2552 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MiniCycle.actor.g.cpp.py_gen"
}

#line 343 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/workloads/MiniCycle.actor.cpp"
};

WorkloadFactory<MiniCycleWorkload> MiniCycleWorkloadFactory;
