#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
/*
 * CoroFlowCoro.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/CoroFlow.h"
#include "flow/ActorCollection.h"
#include "Coro.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // has to be last include

// Old libcoroutine based implementation. Used on Windows until CI has
// boost context installed

Coro *current_coro = 0, *main_coro = 0;
Coro* swapCoro(Coro* n) {
	Coro* t = current_coro;
	current_coro = n;
	return t;
}

/*struct IThreadlike {
public:
    virtual void start() = 0;     // Call at most once!  Causes run() to be called on the 'thread'.
    virtual ~IThreadlike() {}     // Pre: start hasn't been called, or run() has returned
    virtual void unblock() = 0;   // Pre: block() has been called by run().  Causes block() to return.

protected:
    virtual void block() = 0;     // Call only from run().  Returns when unblock() is called elsewhere.
    virtual void run() = 0;       // To be overridden by client.  Returning causes the thread to block until it is
destroyed.
};*/

struct Coroutine /*: IThreadlike*/ {
	Coroutine() {
		coro = Coro_new();
		if (coro == nullptr)
			platform::outOfMemory();
	}

	~Coroutine() { Coro_free(coro); }

	void start() {
		int result = Coro_startCoro_(swapCoro(coro), coro, this, &entry);
		if (result == ENOMEM)
			platform::outOfMemory();
	}

	void unblock() {
		// Coro_switchTo_( swapCoro(coro), coro );
		blocked.send(Void());
	}

protected:
	void block() {
		// Coro_switchTo_( swapCoro(main_coro), main_coro );
		blocked = Promise<Void>();
		double before = now();
		CoroThreadPool::waitFor(blocked.getFuture());
		if (g_network->isSimulated() && g_simulator->getCurrentProcess()->rebooting)
			TraceEvent("CoroUnblocked").detail("After", now() - before);
	}

	virtual void run() = 0;

private:
	void wrapRun() {
		run();
		Coro_switchTo_(swapCoro(main_coro), main_coro);
		// block();
	}

	static void entry(void* _this) { ((Coroutine*)_this)->wrapRun(); }

	Coro* coro;
	Promise<Void> blocked;
};

template <class Threadlike, class Mutex, bool IS_CORO>
class WorkPool final : public IThreadPool, public ReferenceCounted<WorkPool<Threadlike, Mutex, IS_CORO>> {
	struct Worker;

	// Pool can survive the destruction of WorkPool while it waits for workers to terminate
	struct Pool : ReferenceCounted<Pool> {
		Mutex queueLock;
		Deque<PThreadAction> work;
		std::vector<Worker*> idle, workers;
		ActorCollection anyError, allStopped;
		Future<Void> m_holdRefUntilStopped;

		Pool() : anyError(false), allStopped(true) { m_holdRefUntilStopped = holdRefUntilStopped(this); }

		~Pool() {
			for (int c = 0; c < workers.size(); c++)
				delete workers[c];
		}

																	#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
// This generated class is to be used only via holdRefUntilStopped()
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
template <class HoldRefUntilStoppedActor>
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class HoldRefUntilStoppedActorState {
															#line 123 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	HoldRefUntilStoppedActorState(Pool* const& p) 
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		 : p(p)
															#line 130 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("holdRefUntilStopped", reinterpret_cast<unsigned long>(this));

	}
	~HoldRefUntilStoppedActorState() 
	{
		fdb_probe_actor_destroy("holdRefUntilStopped", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			p->addref();
															#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			StrictFuture<Void> __when_expr_0 = p->allStopped.getResult();
															#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			if (static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 149 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state = 1;
															#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldRefUntilStoppedActor, 0, Void >*>(static_cast<HoldRefUntilStoppedActor*>(this)));
															#line 154 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		p->delref();
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		if (!static_cast<HoldRefUntilStoppedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldRefUntilStoppedActorState(); static_cast<HoldRefUntilStoppedActor*>(this)->destroy(); return 0; }
															#line 179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		new (&static_cast<HoldRefUntilStoppedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		p->delref();
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		if (!static_cast<HoldRefUntilStoppedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldRefUntilStoppedActorState(); static_cast<HoldRefUntilStoppedActor*>(this)->destroy(); return 0; }
															#line 193 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		new (&static_cast<HoldRefUntilStoppedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state > 0) static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state = 0;
		static_cast<HoldRefUntilStoppedActor*>(this)->ActorCallback< HoldRefUntilStoppedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	Pool* p;
															#line 278 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
};
// This generated class is to be used only via holdRefUntilStopped()
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class HoldRefUntilStoppedActor final : public Actor<Void>, public ActorCallback< HoldRefUntilStoppedActor, 0, Void >, public FastAllocated<HoldRefUntilStoppedActor>, public HoldRefUntilStoppedActorState<HoldRefUntilStoppedActor> {
															#line 283 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
	using FastAllocated<HoldRefUntilStoppedActor>::operator new;
	using FastAllocated<HoldRefUntilStoppedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14537047366144524544UL, 1845212397313707264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldRefUntilStoppedActor, 0, Void >;
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	HoldRefUntilStoppedActor(Pool* const& p) 
															#line 300 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HoldRefUntilStoppedActorState<HoldRefUntilStoppedActor>(p),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10458263095740810496UL, 16562495286564435456UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdRefUntilStopped");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldRefUntilStoppedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
[[nodiscard]] Future<Void> holdRefUntilStopped( Pool* const& p ) {
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	return Future<Void>(new HoldRefUntilStoppedActor(p));
															#line 332 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
}

#line 121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	};

	struct Worker final : Threadlike {
		Pool* pool;
		IThreadPoolReceiver* userData;
		bool stop;
		ThreadReturnPromise<Void> stopped;
		ThreadReturnPromise<Void> error;

		Worker(Pool* pool, IThreadPoolReceiver* userData) : pool(pool), userData(userData), stop(false) {}

		void run() override {
			try {
				if (!stop)
					userData->init();

				while (!stop) {
					pool->queueLock.enter();
					if (pool->work.empty()) {
						pool->idle.push_back(this);
						pool->queueLock.leave();
						Threadlike::block();
					} else {
						PThreadAction a = pool->work.front();
						pool->work.pop_front();
						pool->queueLock.leave();
						(*a)(userData);
						if (IS_CORO)
							CoroThreadPool::waitFor(yield());
					}
				}

				TraceEvent("CoroStop").log();
				delete userData;
				stopped.send(Void());
				return;
			} catch (Error& e) {
				TraceEvent("WorkPoolError").errorUnsuppressed(e);
				error.sendError(e);
			} catch (...) {
				TraceEvent("WorkPoolError").log();
				error.sendError(unknown_error());
			}

			try {
				delete userData;
			} catch (...) {
				TraceEvent(SevError, "WorkPoolErrorShutdownError").log();
			}
			stopped.send(Void());
		}
	};

	Reference<Pool> pool;
	Future<Void> m_stopOnError; // must be last, because its cancellation calls stop()!
	Error error;

																#line 393 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
// This generated class is to be used only via stopOnError()
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
template <class StopOnErrorActor>
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class StopOnErrorActorState {
															#line 399 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	StopOnErrorActorState(WorkPool* const& w) 
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		 : w(w)
															#line 406 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("stopOnError", reinterpret_cast<unsigned long>(this));

	}
	~StopOnErrorActorState() 
	{
		fdb_probe_actor_destroy("stopOnError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				StrictFuture<Void> __when_expr_0 = w->getError();
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				if (static_cast<StopOnErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 424 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StopOnErrorActor*>(this)->actor_wait_state = 1;
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopOnErrorActor, 0, Void >*>(static_cast<StopOnErrorActor*>(this)));
															#line 429 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopOnErrorActorState();
		static_cast<StopOnErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		if (!static_cast<StopOnErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StopOnErrorActorState(); static_cast<StopOnErrorActor*>(this)->destroy(); return 0; }
															#line 458 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		new (&static_cast<StopOnErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StopOnErrorActorState();
		static_cast<StopOnErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			w->stop(e);
															#line 471 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		ASSERT(false);
															#line 486 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		ASSERT(false);
															#line 495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopOnErrorActor*>(this)->actor_wait_state > 0) static_cast<StopOnErrorActor*>(this)->actor_wait_state = 0;
		static_cast<StopOnErrorActor*>(this)->ActorCallback< StopOnErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StopOnErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopOnErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopOnErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	WorkPool* w;
															#line 590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
};
// This generated class is to be used only via stopOnError()
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class StopOnErrorActor final : public Actor<Void>, public ActorCallback< StopOnErrorActor, 0, Void >, public FastAllocated<StopOnErrorActor>, public StopOnErrorActorState<StopOnErrorActor> {
															#line 595 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
	using FastAllocated<StopOnErrorActor>::operator new;
	using FastAllocated<StopOnErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16726558100386638592UL, 3765002632636899072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StopOnErrorActor, 0, Void >;
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	StopOnErrorActor(WorkPool* const& w) 
															#line 612 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StopOnErrorActorState<StopOnErrorActor>(w),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17814525371531013120UL, 5797053966738890240UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopOnError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopOnErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
[[nodiscard]] Future<Void> stopOnError( WorkPool* const& w ) {
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	return Future<Void>(new StopOnErrorActor(w));
															#line 644 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
}

#line 187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"

	void checkError() {
		if (error.code() != invalid_error_code) {
			ASSERT(error.code() != error_code_success); // Calling post or addThread after stop is an error
			throw error;
		}
	}

public:
	WorkPool() : pool(new Pool) { m_stopOnError = stopOnError(this); }

	Future<Void> getError() const override { return pool->anyError.getResult(); }
	void addThread(IThreadPoolReceiver* userData, const char*) override {
		checkError();

		auto w = new Worker(pool.getPtr(), userData);
		pool->queueLock.enter();
		pool->workers.push_back(w);
		pool->queueLock.leave();
		pool->anyError.add(w->error.getFuture());
		pool->allStopped.add(w->stopped.getFuture());
		startWorker(w);
	}
																#line 671 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
// This generated class is to be used only via startWorker()
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
template <class StartWorkerActor>
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class StartWorkerActorState {
															#line 677 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	StartWorkerActorState(Worker* const& w) 
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		 : w(w)
															#line 684 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startWorker", reinterpret_cast<unsigned long>(this));

	}
	~StartWorkerActorState() 
	{
		fdb_probe_actor_destroy("startWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, g_network->getCurrentTask());
															#line 213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
			static_cast<StartWorkerActor*>(this)->actor_wait_state = 1;
															#line 213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartWorkerActor, 0, Void >*>(static_cast<StartWorkerActor*>(this)));
															#line 705 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<StartWorkerActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		w->start();
															#line 727 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		w->start();
															#line 736 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartWorkerActor*>(this)->actor_wait_state > 0) static_cast<StartWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<StartWorkerActor*>(this)->ActorCallback< StartWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		delete static_cast<StartWorkerActor*>(this);
															#line 820 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	Worker* w;
															#line 827 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startWorker()
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class StartWorkerActor final : public Actor<void>, public ActorCallback< StartWorkerActor, 0, Void >, public FastAllocated<StartWorkerActor>, public StartWorkerActorState<StartWorkerActor> {
															#line 832 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartWorkerActor>::operator new;
	using FastAllocated<StartWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10540460248820625920UL, 15220399174227913472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< StartWorkerActor, 0, Void >;
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	StartWorkerActor(Worker* const& w) 
															#line 849 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   StartWorkerActorState<StartWorkerActor>(w),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3882448018856564480UL, 10602434915089516544UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
static void startWorker( Worker* const& w ) {
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	new StartWorkerActor(w);
															#line 872 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
}

#line 216 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	void post(PThreadAction action) override {
		checkError();

		pool->queueLock.enter();
		pool->work.push_back(action);
		if (!pool->idle.empty()) {
			Worker* c = pool->idle.back();
			pool->idle.pop_back();
			pool->queueLock.leave();
			c->unblock();
		} else
			pool->queueLock.leave();
	}
	Future<Void> stop(Error const& e) override {
		if (error.code() == invalid_error_code) {
			error = e;
		}

		pool->queueLock.enter();
		TraceEvent("WorkPool_Stop")
		    .errorUnsuppressed(e)
		    .detail("Workers", pool->workers.size())
		    .detail("Idle", pool->idle.size())
		    .detail("Work", pool->work.size());

		for (uint32_t i = 0; i < pool->work.size(); i++)
			pool->work[i]->cancel(); // What if cancel() does something to this?
		pool->work.clear();
		for (int i = 0; i < pool->workers.size(); i++)
			pool->workers[i]->stop = true;

		std::vector<Worker*> idle;
		std::swap(idle, pool->idle);
		pool->queueLock.leave();

		for (int i = 0; i < idle.size(); i++)
			idle[i]->unblock();

		pool->allStopped.add(Void());

		return pool->allStopped.getResult();
	}
	bool isCoro() const override { return IS_CORO; }
	void addref() override { ReferenceCounted<WorkPool>::addref(); }
	void delref() override { ReferenceCounted<WorkPool>::delref(); }
};

typedef WorkPool<Coroutine, ThreadUnsafeSpinLock, true> CoroPool;

															#line 925 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via coroSwitcher()
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
template <class CoroSwitcherActor>
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class CoroSwitcherActorState {
															#line 932 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	CoroSwitcherActorState(Future<Void> const& what,TaskPriority const& taskID,Coro* const& coro) 
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		 : what(what),
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		   taskID(taskID),
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		   coro(coro)
															#line 943 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("coroSwitcher", reinterpret_cast<unsigned long>(this));

	}
	~CoroSwitcherActorState() 
	{
		fdb_probe_actor_destroy("coroSwitcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 268 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				StrictFuture<Void> __when_expr_0 = what;
															#line 268 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 961 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
				static_cast<CoroSwitcherActor*>(this)->actor_wait_state = 1;
															#line 268 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoroSwitcherActor, 0, Void >*>(static_cast<CoroSwitcherActor*>(this)));
															#line 965 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<CoroSwitcherActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, taskID);
															#line 273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 995 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		static_cast<CoroSwitcherActor*>(this)->actor_wait_state = 2;
															#line 273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoroSwitcherActor, 1, Void >*>(static_cast<CoroSwitcherActor*>(this)));
															#line 999 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoroSwitcherActor*>(this)->actor_wait_state > 0) static_cast<CoroSwitcherActor*>(this)->actor_wait_state = 0;
		static_cast<CoroSwitcherActor*>(this)->ActorCallback< CoroSwitcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoroSwitcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoroSwitcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoroSwitcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		Coro_switchTo_(swapCoro(coro), coro);
															#line 1121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		Coro_switchTo_(swapCoro(coro), coro);
															#line 1130 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoroSwitcherActor*>(this)->actor_wait_state > 0) static_cast<CoroSwitcherActor*>(this)->actor_wait_state = 0;
		static_cast<CoroSwitcherActor*>(this)->ActorCallback< CoroSwitcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoroSwitcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoroSwitcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoroSwitcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
		delete static_cast<CoroSwitcherActor*>(this);
															#line 1214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	Future<Void> what;
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	TaskPriority taskID;
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	Coro* coro;
															#line 1225 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
};
// This generated class is to be used only via coroSwitcher()
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
class CoroSwitcherActor final : public Actor<void>, public ActorCallback< CoroSwitcherActor, 0, Void >, public ActorCallback< CoroSwitcherActor, 1, Void >, public FastAllocated<CoroSwitcherActor>, public CoroSwitcherActorState<CoroSwitcherActor> {
															#line 1230 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
public:
	using FastAllocated<CoroSwitcherActor>::operator new;
	using FastAllocated<CoroSwitcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5043309467313030912UL, 3789544090674649344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< CoroSwitcherActor, 0, Void >;
friend struct ActorCallback< CoroSwitcherActor, 1, Void >;
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	CoroSwitcherActor(Future<Void> const& what,TaskPriority const& taskID,Coro* const& coro) 
															#line 1248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   CoroSwitcherActorState<CoroSwitcherActor>(what, taskID, coro),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coroSwitcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15439634019396282112UL, 13539545964856687872UL);
		ActorExecutionContextHelper __helper(static_cast<CoroSwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coroSwitcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coroSwitcher", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
void coroSwitcher( Future<Void> const& what, TaskPriority const& taskID, Coro* const& coro ) {
															#line 265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"
	new CoroSwitcherActor(what, taskID, coro);
															#line 1272 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlowCoro.actor.g.cpp.py_gen"
}

#line 276 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlowCoro.actor.cpp"

void CoroThreadPool::waitFor(Future<Void> what) {
	ASSERT(current_coro != main_coro);
	if (what.isReady())
		return;
	// double t = now();
	coroSwitcher(what, g_network->getCurrentTask(), current_coro);
	Coro_switchTo_(swapCoro(main_coro), main_coro);
	// if (g_network->isSimulated() && g_simulator->getCurrentProcess()->rebooting && now()!=t)
	//	TraceEvent("NonzeroWaitDuringReboot").detail("TaskID", currentTaskID).detail("Elapsed",
	// now()-t).backtrace("Coro");
	ASSERT(what.isReady());
}

// Right After INet2::run
void CoroThreadPool::init() {
	if (!current_coro) {
		current_coro = main_coro = Coro_new();
		if (main_coro == nullptr)
			platform::outOfMemory();

		Coro_initializeMainCoro(main_coro);
		// printf("Main thread: %d bytes stack presumed available\n", Coro_bytesLeftOnStack(current_coro));
	}
}

Reference<IThreadPool> CoroThreadPool::createThreadPool() {
	return Reference<IThreadPool>(new CoroPool);
}
