#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
/*
 * ConsistencyScan.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/JSONDoc.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/json_spirit/json_spirit_value.h"
#include "fdbclient/json_spirit/json_spirit_writer_options.h"
#include "fdbclient/json_spirit/json_spirit_writer_template.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/IRandom.h"
#include "flow/IndexedSet.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/Smoother.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/TagThrottle.actor.h"
#include "fdbclient/DataDistributionConfig.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/DeterministicRandom.h"
#include "flow/Trace.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define DEBUG_SCAN_PROGRESS false

struct ConsistencyScanStats {
	CounterCollection cc;
	Future<Void> logger;

	Counter logicalBytesScanned;
	Counter replicatedBytesRead;
	Counter requests;
	Counter failedRequests;
	Counter scanLoops;
	Counter inconsistencies;
	Counter databasePollSuccesses;
	Counter databasePollErrors;

	bool waitingBetweenRounds = false;
	int targetRate = 0;

	explicit ConsistencyScanStats(UID id, double interval)
	  : cc("ConsistencyScanStats", id.toString()), logicalBytesScanned("LogicalBytesScanned", cc),
	    replicatedBytesRead("ReplicatedBytesRead", cc), requests("Requests", cc), failedRequests("FailedRequests", cc),
	    scanLoops("ScanLoops", cc), inconsistencies("Inconsistencies", cc),
	    databasePollSuccesses("DatabasePollSuccesses", cc), databasePollErrors("DatabasePollErrors", cc) {
		specialCounter(cc, "WaitingBetweenRounds", [this]() { return this->waitingBetweenRounds; });
		specialCounter(cc, "TargetRate", [this]() { return this->targetRate; });
		logger = cc.traceCounters("ConsistencyScanMetrics", id, interval, "ConsistencyScanMetrics");
	}
};

// State that is explicitly not persisted anywhere for this consistency scan. Includes things like caches of system
// information and stats for trace logs
struct ConsistencyScanMemoryState : public ReferenceCounted<ConsistencyScanMemoryState> {
	UID csId{};
	AsyncVar<int64_t> databaseSize = -1;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
	ConsistencyScanStats stats;

	explicit ConsistencyScanMemoryState(Reference<AsyncVar<ServerDBInfo> const> dbInfo, UID csId)
	  : dbInfo(dbInfo), csId(csId), stats(csId, SERVER_KNOBS->WORKER_LOGGING_INTERVAL) {}
};

// TODO: test the test and write a canary key that the storage servers intentionally get wrong
// Get database KV bytes size from Status JSON at cluster.data.total_kv_size_bytes
															#line 94 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via pollDatabaseSize()
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class PollDatabaseSizeActor>
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class PollDatabaseSizeActorState {
															#line 101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	PollDatabaseSizeActorState(Reference<ConsistencyScanMemoryState> const& memState,double const& interval) 
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : memState(memState),
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   interval(interval)
															#line 110 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("pollDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	~PollDatabaseSizeActorState() 
	{
		fdb_probe_actor_destroy("pollDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 125 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PollDatabaseSizeActorState();
		static_cast<PollDatabaseSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 94 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 155 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(memState->dbInfo);
															#line 102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 172 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 98 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_0 = memState->dbInfo->onChange();
															#line 98 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 202 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 0, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 138 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 138 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 318 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 5;
															#line 138 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 4, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 323 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_PollDBSizeError", memState->csId).error(e);
															#line 132 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 335 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 133 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 339 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 135 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollErrors;
															#line 343 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 103 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ddWorkerInterf = Optional<WorkerInterface>();
															#line 105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 360 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 106 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < workers.size();i++) {
															#line 107 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (workers[i].interf.address() == memState->dbInfo->get().distributor.get().address())
															#line 366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ddWorkerInterf = workers[i].interf;
															#line 370 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					break;
				}
			}
		}
															#line 114 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(ddWorkerInterf.present(), "Consistency Scan found DD worker");
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(!ddWorkerInterf.present(), "Consistency Scan couldn't find DD worker");
															#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddWorkerInterf.present())
															#line 381 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollSuccesses;
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_2 = timeoutError( ddWorkerInterf.get().eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 5.0);
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 389 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 3;
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 394 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 103 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ddWorkerInterf = Optional<WorkerInterface>();
															#line 105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 410 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 106 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < workers.size();i++) {
															#line 107 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (workers[i].interf.address() == memState->dbInfo->get().distributor.get().address())
															#line 416 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ddWorkerInterf = workers[i].interf;
															#line 420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					break;
				}
			}
		}
															#line 114 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(ddWorkerInterf.present(), "Consistency Scan found DD worker");
															#line 115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(!ddWorkerInterf.present(), "Consistency Scan couldn't find DD worker");
															#line 117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddWorkerInterf.present())
															#line 431 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollSuccesses;
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_2 = timeoutError( ddWorkerInterf.get().eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 5.0);
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 439 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 3;
															#line 119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 444 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(TraceEventFields const& md,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->databaseSize.set(md.getInt64("TotalSizeBytes"));
															#line 122 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(true, "Consistency Scan got DB size from DD Worker");
															#line 124 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_DatabaseSize", memState->csId) .detail("EstimatedSize", memState->databaseSize.get());
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 547 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 3, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 552 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(TraceEventFields && md,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->databaseSize.set(md.getInt64("TotalSizeBytes"));
															#line 122 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(true, "Consistency Scan got DB size from DD Worker");
															#line 124 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_DatabaseSize", memState->csId) .detail("EstimatedSize", memState->databaseSize.get());
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 569 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 3, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 574 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TraceEventFields const& md,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(md, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TraceEventFields && md,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(md), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double interval;
															#line 103 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<WorkerInterface> ddWorkerInterf;
															#line 847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via pollDatabaseSize()
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class PollDatabaseSizeActor final : public Actor<Void>, public ActorCallback< PollDatabaseSizeActor, 0, Void >, public ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >, public ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >, public ActorCallback< PollDatabaseSizeActor, 3, Void >, public ActorCallback< PollDatabaseSizeActor, 4, Void >, public FastAllocated<PollDatabaseSizeActor>, public PollDatabaseSizeActorState<PollDatabaseSizeActor> {
															#line 852 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<PollDatabaseSizeActor>::operator new;
	using FastAllocated<PollDatabaseSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16442713210211609600UL, 4155743120965041408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PollDatabaseSizeActor, 0, Void >;
friend struct ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >;
friend struct ActorCallback< PollDatabaseSizeActor, 3, Void >;
friend struct ActorCallback< PollDatabaseSizeActor, 4, Void >;
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	PollDatabaseSizeActor(Reference<ConsistencyScanMemoryState> const& memState,double const& interval) 
															#line 873 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PollDatabaseSizeActorState<PollDatabaseSizeActor>(memState, interval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17215904904380674304UL, 9843564974192376576UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pollDatabaseSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> pollDatabaseSize( Reference<ConsistencyScanMemoryState> const& memState, double const& interval ) {
															#line 92 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new PollDatabaseSizeActor(memState, interval));
															#line 910 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 141 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 915 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via loadShardInterfaces()
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class LoadShardInterfacesActor>
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class LoadShardInterfacesActorState {
															#line 922 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	LoadShardInterfacesActorState(Reference<ConsistencyScanMemoryState> const& memState,Reference<ReadYourWritesTransaction> const& tr,Future<RangeResult> const& readShardBoundaries,Database const& db) 
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : memState(memState),
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   tr(tr),
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   readShardBoundaries(readShardBoundaries),
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   db(db)
															#line 935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadShardInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~LoadShardInterfacesActorState() 
	{
		fdb_probe_actor_destroy("loadShardInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 952 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 957 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadShardInterfacesActorState();
		static_cast<LoadShardInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 147 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 148 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = readShardBoundaries;
															#line 148 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 984 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 2;
															#line 148 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 989 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 998 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 149 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(shardBoundaries.size() == 2);
															#line 151 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		sourceStorageServers = std::vector<UID>();
															#line 152 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		destStorageServers = std::vector<UID>();
															#line 156 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shardBoundaries[0].value, sourceStorageServers, destStorageServers, true);
															#line 158 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerToTagMap = std::unordered_map<UID, Tag>();
															#line 159 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1087 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerToTagMap.reserve(UIDtoTagMap.size());
															#line 161 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& it : UIDtoTagMap ) {
															#line 162 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerToTagMap[decodeServerTagKey(it.key)] = decodeServerTagValue(it.value);
															#line 1095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (!destStorageServers.empty()) ? destStorageServers : sourceStorageServers;
															#line 169 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListEntries = std::vector<Future<Optional<Value>>>();
															#line 170 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListEntries.reserve(storageServers.size());
															#line 171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 172 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces.reserve(storageServers.size());
															#line 174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto id : storageServers ) {
															#line 175 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			serverListEntries.push_back(tr->get(serverListKeyFor(id)));
															#line 1112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_2 = getAll(serverListEntries);
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 1123 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& __shardBoundaries,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBoundaries = __shardBoundaries;
															#line 1132 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && __shardBoundaries,int loopDepth) 
	{
		shardBoundaries = std::move(__shardBoundaries);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : serverListValues ) {
															#line 180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(it.present());
															#line 181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerInterfaces.push_back(decodeServerListValue(it.get()));
															#line 1215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 184 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1219 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 185 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < storageServers.size();j++) {
															#line 186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				auto iter = storageServerToTagMap.find(storageServers[j]);
															#line 187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_WE_THINK(iter != storageServerToTagMap.end());
															#line 192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				db->addSSIdTagMapping(storageServerInterfaces[j].id(), iter->second);
															#line 1229 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 196 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<LoadShardInterfacesActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(storageServerInterfaces); this->~LoadShardInterfacesActorState(); static_cast<LoadShardInterfacesActor*>(this)->destroy(); return 0; }
															#line 1234 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<LoadShardInterfacesActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(std::move(storageServerInterfaces)); // state_var_RVO
		this->~LoadShardInterfacesActorState();
		static_cast<LoadShardInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListValues = __serverListValues;
															#line 1246 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<RangeResult> readShardBoundaries;
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 148 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult shardBoundaries;
															#line 151 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> sourceStorageServers;
															#line 152 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> destStorageServers;
															#line 158 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::unordered_map<UID, Tag> storageServerToTagMap;
															#line 167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> storageServers;
															#line 169 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<Optional<Value>>> serverListEntries;
															#line 171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 178 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1347 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadShardInterfaces()
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class LoadShardInterfacesActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< LoadShardInterfacesActor, 0, RangeResult >, public ActorCallback< LoadShardInterfacesActor, 1, RangeResult >, public ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >, public FastAllocated<LoadShardInterfacesActor>, public LoadShardInterfacesActorState<LoadShardInterfacesActor> {
															#line 1352 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<LoadShardInterfacesActor>::operator new;
	using FastAllocated<LoadShardInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(890516616056270336UL, 16342459576313295360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadShardInterfacesActor, 0, RangeResult >;
friend struct ActorCallback< LoadShardInterfacesActor, 1, RangeResult >;
friend struct ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >;
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	LoadShardInterfacesActor(Reference<ConsistencyScanMemoryState> const& memState,Reference<ReadYourWritesTransaction> const& tr,Future<RangeResult> const& readShardBoundaries,Database const& db) 
															#line 1371 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<std::vector<StorageServerInterface>>(),
		   LoadShardInterfacesActorState<LoadShardInterfacesActor>(memState, tr, readShardBoundaries, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9901703264626988544UL, 15103364680979116288UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadShardInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> loadShardInterfaces( Reference<ConsistencyScanMemoryState> const& memState, Reference<ReadYourWritesTransaction> const& tr, Future<RangeResult> const& readShardBoundaries, Database const& db ) {
															#line 142 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new LoadShardInterfacesActor(memState, tr, readShardBoundaries, db));
															#line 1406 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 198 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// returns error count
															#line 1412 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via consistencyCheckReadData()
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyCheckReadDataActor>
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyCheckReadDataActorState {
															#line 1419 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyCheckReadDataActorState(UID const& myId,Database const& cx,KeyRange const& range,Version const& version,std::vector<StorageServerInterface>* const& storageServerInterfaces,std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures,Optional<int>* const& firstValidServer,int64_t* const& totalReadAmount,Optional<Version> const& consistencyCheckStartVersion) 
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : myId(myId),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   cx(cx),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   range(range),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   version(version),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   storageServerInterfaces(storageServerInterfaces),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyValueFutures(keyValueFutures),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   firstValidServer(firstValidServer),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   totalReadAmount(totalReadAmount),
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   consistencyCheckStartVersion(consistencyCheckStartVersion)
															#line 1442 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consistencyCheckReadData", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckReadDataActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckReadData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(!range.empty());
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req = GetKeyValuesRequest();
															#line 211 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.begin = firstGreaterOrEqual(range.begin);
															#line 212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.end = firstGreaterOrEqual(range.end);
															#line 213 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.limit = 1e4;
															#line 214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.version = version;
															#line 216 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.tags = TagSet();
															#line 219 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))
															#line 1473 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 220 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 1477 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 221 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limit = deterministicRandom()->randomInt(2, 10);
															#line 1481 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 223 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 1485 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 224 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limitBytes /= deterministicRandom()->randomInt(2, 100);
															#line 225 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limitBytes = std::max<int>(1, req.limitBytes);
															#line 1491 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
															#line 231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ReadOptions readOptions;
															#line 232 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.cacheResult = CacheResult::False;
															#line 233 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.type = ReadType::LOW;
															#line 234 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.consistencyCheckStartVersion = consistencyCheckStartVersion;
															#line 236 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.options = readOptions;
															#line 238 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			DisabledTraceEvent("ConsistencyCheck_ReadDataStart", myId) .detail("Range", range) .detail("Version", version) .detail("Servers", storageServerInterfaces->size());
															#line 245 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			j = 0;
															#line 246 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 247 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				resetReply(req);
															#line 248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1514 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					cx->getLatestCommitVersion((*storageServerInterfaces)[j], req.version, req.ssLatestCommitVersions);
															#line 1518 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 251 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyValueFutures->push_back((*storageServerInterfaces)[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 1522 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 254 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(*keyValueFutures);
															#line 254 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1528 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state = 1;
															#line 254 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*>(static_cast<ConsistencyCheckReadDataActor*>(this)));
															#line 1533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool expectInjected = storageServerInterfaces->size() > 1 && g_network->isSimulated() && consistencyCheckStartVersion.present() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption && g_simulator->consistencyScanCorruptRequestKey.present() && g_simulator->consistencyScanCorruptor.present() && g_simulator->consistencyScanCorruptor.get().first == myId && range.contains(g_simulator->consistencyScanCorruptRequestKey.get());
															#line 262 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected)
															#line 1558 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 263 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarnAlways, "ConsistencyScanExpectingInjectedCorruption", myId) .detail("StorageServers", storageServerInterfaces->size()) .detail("ScanState", g_simulator->consistencyScanState) .detail("CorruptKey", g_simulator->consistencyScanCorruptRequestKey.get()) .detail("ReqRange", range) .detail("CCStartVersion", consistencyCheckStartVersion.present() ? consistencyCheckStartVersion.get() : invalidVersion);
															#line 1562 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool allSucceeded = true;
															#line 274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool foundInjected = false;
															#line 275 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 276 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = (*keyValueFutures)[j].get();
															#line 279 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 1574 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				current = rangeResult.get();
															#line 281 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				DisabledTraceEvent("ConsistencyCheck_GetKeyValuesStream", myId) .detail("DataSize", current.data.size()) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id());
															#line 284 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				*totalReadAmount += current.data.expectedSize();
															#line 287 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!firstValidServer->present())
															#line 1584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 288 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					DisabledTraceEvent("ConsistencyCheck_FirstValidServer", myId).detail("Iter", j);
															#line 289 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*firstValidServer = j;
															#line 1590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 292 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply reference = (*keyValueFutures)[firstValidServer->get()].get().get();
															#line 294 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 1598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 296 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (g_network->isSimulated())
															#line 1602 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 297 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int invalidIndex = -1;
															#line 298 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							fmt::print("MISMATCH AT VERSION {0}\n", req.version);
															#line 299 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", j, (*storageServerInterfaces)[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 306 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 310 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 1616 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 313 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1620 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
							}
															#line 316 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", firstValidServer->get(), (*storageServerInterfaces)[firstValidServer->get()].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 323 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 327 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 1631 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 330 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1635 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
							}
															#line 333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 1640 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
															#line 338 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentUniques = 0;
															#line 340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceUniques = 0;
															#line 342 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int valueMismatches = 0;
															#line 344 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int matchingKVPairs = 0;
															#line 346 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef currentUniqueKey;
															#line 348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 350 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef valueMismatchKey;
															#line 353 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentI = 0;
															#line 354 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceI = 0;
															#line 355 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 356 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (currentI >= current.data.size())
															#line 1664 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							{
															#line 357 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 358 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniques++;
															#line 359 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceI++;
															#line 1672 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							}
							else
							{
															#line 360 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 1678 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 361 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 362 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniques++;
															#line 363 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentI++;
															#line 1686 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
								else
								{
															#line 365 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 368 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 1696 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 369 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 1700 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 370 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											matchingKVPairs++;
															#line 1704 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
										else
										{
															#line 372 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 373 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatches++;
															#line 1712 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
															#line 376 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										currentI++;
															#line 377 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										referenceI++;
															#line 1718 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									}
									else
									{
															#line 378 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 1724 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 379 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 380 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniques++;
															#line 381 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentI++;
															#line 1732 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
										else
										{
															#line 383 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 384 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniques++;
															#line 385 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceI++;
															#line 1742 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
									}
								}
							}
						}
															#line 390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isTss = (*storageServerInterfaces)[j].isTss() || (*storageServerInterfaces)[firstValidServer->get()].isTss();
															#line 392 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isExpectedTSSMismatch = g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations && isTss;
															#line 401 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isFailed = g_network->isSimulated() && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->failed || g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->failed) && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->locality.dcId() != g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->locality.dcId());
															#line 410 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isTss && !isFailed && expectInjected)
															#line 1756 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 412 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(g_simulator->consistencyScanInjectedCorruptionType.present());
															#line 413 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::FlipMoreFlag)
															#line 1762 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							{
															#line 416 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								expectInjected = (current.more != reference.more && currentUniques == 0 && referenceUniques == 0 && valueMismatches == 0);
															#line 1766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							}
							else
							{
															#line 418 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::AddToEmpty)
															#line 1772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									expectInjected = (current.more == reference.more && current.data.size() + reference.data.size() == 1);
															#line 422 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (expectInjected)
															#line 1778 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 423 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										KeyValueRef& kv = current.data.empty() ? reference.data[0] : current.data[0];
															#line 424 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = kv.key == g_simulator->consistencyScanCorruptRequestKey.get() && kv.value == "consistencyCheckCorruptValue"_sr;
															#line 1784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									}
								}
								else
								{
															#line 427 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::RemoveLastRow)
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 429 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = (current.more == reference.more && valueMismatches == 0 && currentUniques + referenceUniques == 1 && std::abs(current.data.size() - reference.data.size()) == 1);
															#line 432 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (expectInjected)
															#line 1797 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 434 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											for(int i = 0;i < current.data.size() && i < reference.data.size();i++) {
															#line 435 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												if (current.data[i] != reference.data[i])
															#line 1803 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
												{
															#line 436 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
													expectInjected = false;
															#line 1807 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
													break;
												}
											}
										}
									}
									else
									{
															#line 441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::ChangeFirstValue)
															#line 1817 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 443 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											expectInjected = (current.more == reference.more && valueMismatches == 1 && currentUniques == 0 && referenceUniques == 0 && valueMismatchKey == current.data[0].key && std::abs(current.data[0].value.size() - reference.data[0].value.size()) == 1);
															#line 447 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											if (expectInjected)
															#line 1823 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
											{
															#line 449 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value shorter = current.data[0].value < reference.data[0].value ? current.data[0].value : reference.data[0].value;
															#line 452 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value longer = current.data[0].value < reference.data[0].value ? reference.data[0].value : current.data[0].value;
															#line 454 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												expectInjected = (shorter == longer.substr(0, shorter.size()));
															#line 1831 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
											}
										}
										else
										{
															#line 457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											ASSERT(false);
															#line 1838 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
									}
								}
							}
						}
															#line 461 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent(isExpectedTSSMismatch || isFailed || expectInjected ? SevWarn : SevError, "ConsistencyCheck_DataInconsistent", myId) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id()) .detail(format("StorageServer%d", firstValidServer->get()).c_str(), (*storageServerInterfaces)[firstValidServer->get()].id()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer->get()).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer->get()).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail(format("Server%dHasMore", j).c_str(), current.more) .detail(format("Server%dHasMore", firstValidServer->get()).c_str(), reference.more) .detail("IsTSS", isTss) .detail("IsInjected", expectInjected);
															#line 482 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (expectInjected)
															#line 1848 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							foundInjected = true;
															#line 484 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							CODE_PROBE(true, "consistency check detected injected corruption");
															#line 486 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent(SevWarnAlways, "ConsistencyScanFoundInjectedCorruption", myId) .detail("CorruptionType", g_simulator->consistencyScanInjectedCorruptionType.get()) .detail("Version", req.version);
															#line 489 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 1858 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
															#line 494 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isExpectedTSSMismatch)
															#line 1862 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int issues = currentUniques + referenceUniques + valueMismatches + ((current.more == reference.more) ? 0 : 1);
															#line 497 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(issues > 0);
															#line 498 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(issues); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 1870 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(issues);
							this->~ConsistencyCheckReadDataActorState();
							static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 501 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (isFailed)
															#line 1878 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 502 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1882 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
				}
			}
			else
			{
															#line 507 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				allSucceeded = false;
															#line 1891 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 511 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected && !foundInjected)
															#line 1896 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 512 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (allSucceeded)
															#line 1900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 514 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevError, "ConsistencyCheck_ShouldHaveFoundInjectedCorruption", myId);
															#line 1904 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 516 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "consistency check potentially missed injected corruption due to failures", probe::decoration::rare);
															#line 519 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheck_MissedCorruptionDueToFailures");
															#line 520 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 1914 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 525 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		DisabledTraceEvent("ConsistencyCheck_ReadDataDone", myId) .detail("Range", range) .detail("Version", version) .detail("FirstValidServer", firstValidServer->present() ? firstValidServer->get() : -1);
															#line 530 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(0); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 1921 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(0);
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool expectInjected = storageServerInterfaces->size() > 1 && g_network->isSimulated() && consistencyCheckStartVersion.present() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption && g_simulator->consistencyScanCorruptRequestKey.present() && g_simulator->consistencyScanCorruptor.present() && g_simulator->consistencyScanCorruptor.get().first == myId && range.contains(g_simulator->consistencyScanCorruptRequestKey.get());
															#line 262 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected)
															#line 1935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 263 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarnAlways, "ConsistencyScanExpectingInjectedCorruption", myId) .detail("StorageServers", storageServerInterfaces->size()) .detail("ScanState", g_simulator->consistencyScanState) .detail("CorruptKey", g_simulator->consistencyScanCorruptRequestKey.get()) .detail("ReqRange", range) .detail("CCStartVersion", consistencyCheckStartVersion.present() ? consistencyCheckStartVersion.get() : invalidVersion);
															#line 1939 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool allSucceeded = true;
															#line 274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool foundInjected = false;
															#line 275 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 276 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = (*keyValueFutures)[j].get();
															#line 279 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 1951 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				current = rangeResult.get();
															#line 281 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				DisabledTraceEvent("ConsistencyCheck_GetKeyValuesStream", myId) .detail("DataSize", current.data.size()) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id());
															#line 284 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				*totalReadAmount += current.data.expectedSize();
															#line 287 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!firstValidServer->present())
															#line 1961 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 288 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					DisabledTraceEvent("ConsistencyCheck_FirstValidServer", myId).detail("Iter", j);
															#line 289 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*firstValidServer = j;
															#line 1967 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 292 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply reference = (*keyValueFutures)[firstValidServer->get()].get().get();
															#line 294 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 1975 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 296 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (g_network->isSimulated())
															#line 1979 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 297 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int invalidIndex = -1;
															#line 298 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							fmt::print("MISMATCH AT VERSION {0}\n", req.version);
															#line 299 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", j, (*storageServerInterfaces)[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 305 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 306 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 310 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 1993 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 313 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1997 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
							}
															#line 316 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", firstValidServer->get(), (*storageServerInterfaces)[firstValidServer->get()].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 323 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 327 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 2008 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 330 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 2012 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
							}
															#line 333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 2017 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
															#line 338 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentUniques = 0;
															#line 340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceUniques = 0;
															#line 342 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int valueMismatches = 0;
															#line 344 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int matchingKVPairs = 0;
															#line 346 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef currentUniqueKey;
															#line 348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 350 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef valueMismatchKey;
															#line 353 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentI = 0;
															#line 354 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceI = 0;
															#line 355 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 356 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (currentI >= current.data.size())
															#line 2041 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							{
															#line 357 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 358 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniques++;
															#line 359 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceI++;
															#line 2049 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							}
							else
							{
															#line 360 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 2055 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 361 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 362 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniques++;
															#line 363 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentI++;
															#line 2063 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								}
								else
								{
															#line 365 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 368 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 2073 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 369 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 2077 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 370 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											matchingKVPairs++;
															#line 2081 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
										else
										{
															#line 372 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 373 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatches++;
															#line 2089 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
															#line 376 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										currentI++;
															#line 377 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										referenceI++;
															#line 2095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									}
									else
									{
															#line 378 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 2101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 379 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 380 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniques++;
															#line 381 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentI++;
															#line 2109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
										else
										{
															#line 383 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 384 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniques++;
															#line 385 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceI++;
															#line 2119 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
									}
								}
							}
						}
															#line 390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isTss = (*storageServerInterfaces)[j].isTss() || (*storageServerInterfaces)[firstValidServer->get()].isTss();
															#line 392 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isExpectedTSSMismatch = g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations && isTss;
															#line 401 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isFailed = g_network->isSimulated() && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->failed || g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->failed) && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->locality.dcId() != g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->locality.dcId());
															#line 410 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isTss && !isFailed && expectInjected)
															#line 2133 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 412 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(g_simulator->consistencyScanInjectedCorruptionType.present());
															#line 413 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::FlipMoreFlag)
															#line 2139 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							{
															#line 416 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								expectInjected = (current.more != reference.more && currentUniques == 0 && referenceUniques == 0 && valueMismatches == 0);
															#line 2143 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							}
							else
							{
															#line 418 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::AddToEmpty)
															#line 2149 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
								{
															#line 420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									expectInjected = (current.more == reference.more && current.data.size() + reference.data.size() == 1);
															#line 422 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (expectInjected)
															#line 2155 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 423 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										KeyValueRef& kv = current.data.empty() ? reference.data[0] : current.data[0];
															#line 424 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = kv.key == g_simulator->consistencyScanCorruptRequestKey.get() && kv.value == "consistencyCheckCorruptValue"_sr;
															#line 2161 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									}
								}
								else
								{
															#line 427 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::RemoveLastRow)
															#line 2168 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
									{
															#line 429 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = (current.more == reference.more && valueMismatches == 0 && currentUniques + referenceUniques == 1 && std::abs(current.data.size() - reference.data.size()) == 1);
															#line 432 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (expectInjected)
															#line 2174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 434 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											for(int i = 0;i < current.data.size() && i < reference.data.size();i++) {
															#line 435 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												if (current.data[i] != reference.data[i])
															#line 2180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
												{
															#line 436 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
													expectInjected = false;
															#line 2184 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
													break;
												}
											}
										}
									}
									else
									{
															#line 441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::ChangeFirstValue)
															#line 2194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										{
															#line 443 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											expectInjected = (current.more == reference.more && valueMismatches == 1 && currentUniques == 0 && referenceUniques == 0 && valueMismatchKey == current.data[0].key && std::abs(current.data[0].value.size() - reference.data[0].value.size()) == 1);
															#line 447 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											if (expectInjected)
															#line 2200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
											{
															#line 449 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value shorter = current.data[0].value < reference.data[0].value ? current.data[0].value : reference.data[0].value;
															#line 452 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value longer = current.data[0].value < reference.data[0].value ? reference.data[0].value : current.data[0].value;
															#line 454 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												expectInjected = (shorter == longer.substr(0, shorter.size()));
															#line 2208 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
											}
										}
										else
										{
															#line 457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											ASSERT(false);
															#line 2215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
										}
									}
								}
							}
						}
															#line 461 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent(isExpectedTSSMismatch || isFailed || expectInjected ? SevWarn : SevError, "ConsistencyCheck_DataInconsistent", myId) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id()) .detail(format("StorageServer%d", firstValidServer->get()).c_str(), (*storageServerInterfaces)[firstValidServer->get()].id()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer->get()).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer->get()).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail(format("Server%dHasMore", j).c_str(), current.more) .detail(format("Server%dHasMore", firstValidServer->get()).c_str(), reference.more) .detail("IsTSS", isTss) .detail("IsInjected", expectInjected);
															#line 482 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (expectInjected)
															#line 2225 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							foundInjected = true;
															#line 484 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							CODE_PROBE(true, "consistency check detected injected corruption");
															#line 486 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent(SevWarnAlways, "ConsistencyScanFoundInjectedCorruption", myId) .detail("CorruptionType", g_simulator->consistencyScanInjectedCorruptionType.get()) .detail("Version", req.version);
															#line 489 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 2235 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
															#line 494 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isExpectedTSSMismatch)
															#line 2239 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int issues = currentUniques + referenceUniques + valueMismatches + ((current.more == reference.more) ? 0 : 1);
															#line 497 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(issues > 0);
															#line 498 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(issues); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 2247 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
							new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(issues);
							this->~ConsistencyCheckReadDataActorState();
							static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 501 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (isFailed)
															#line 2255 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 502 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 2259 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
				}
			}
			else
			{
															#line 507 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				allSucceeded = false;
															#line 2268 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 511 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected && !foundInjected)
															#line 2273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 512 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (allSucceeded)
															#line 2277 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 514 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevError, "ConsistencyCheck_ShouldHaveFoundInjectedCorruption", myId);
															#line 2281 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 516 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "consistency check potentially missed injected corruption due to failures", probe::decoration::rare);
															#line 519 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheck_MissedCorruptionDueToFailures");
															#line 520 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 2291 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 525 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		DisabledTraceEvent("ConsistencyCheck_ReadDataDone", myId) .detail("Range", range) .detail("Version", version) .detail("FirstValidServer", firstValidServer->present() ? firstValidServer->get() : -1);
															#line 530 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(0); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 2298 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(0);
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckReadDataActor*>(this)->ActorCallback< ConsistencyCheckReadDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	UID myId;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange range;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Version version;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface>* storageServerInterfaces;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>>* keyValueFutures;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int>* firstValidServer;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t* totalReadAmount;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Version> consistencyCheckStartVersion;
															#line 210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyValuesRequest req;
															#line 245 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int j;
															#line 280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyValuesReply current;
															#line 2405 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consistencyCheckReadData()
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyCheckReadDataActor final : public Actor<int>, public ActorCallback< ConsistencyCheckReadDataActor, 0, Void >, public FastAllocated<ConsistencyCheckReadDataActor>, public ConsistencyCheckReadDataActorState<ConsistencyCheckReadDataActor> {
															#line 2410 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsistencyCheckReadDataActor>::operator new;
	using FastAllocated<ConsistencyCheckReadDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5563105102867185920UL, 14377613779892248320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckReadDataActor, 0, Void >;
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyCheckReadDataActor(UID const& myId,Database const& cx,KeyRange const& range,Version const& version,std::vector<StorageServerInterface>* const& storageServerInterfaces,std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures,Optional<int>* const& firstValidServer,int64_t* const& totalReadAmount,Optional<Version> const& consistencyCheckStartVersion) 
															#line 2427 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   ConsistencyCheckReadDataActorState<ConsistencyCheckReadDataActor>(myId, cx, range, version, storageServerInterfaces, keyValueFutures, firstValidServer, totalReadAmount, consistencyCheckStartVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10588760710414007808UL, 16874555229171532544UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckReadData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<int> consistencyCheckReadData( UID const& myId, Database const& cx, KeyRange const& range, Version const& version, std::vector<StorageServerInterface>* const& storageServerInterfaces, std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures, Optional<int>* const& firstValidServer, int64_t* const& totalReadAmount, Optional<Version> const& consistencyCheckStartVersion ) {
															#line 200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<int>(new ConsistencyCheckReadDataActor(myId, cx, range, version, storageServerInterfaces, keyValueFutures, firstValidServer, totalReadAmount, consistencyCheckStartVersion));
															#line 2460 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 532 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 2465 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via consistencyScanCore()
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyScanCoreActor>
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanCoreActorState {
															#line 2472 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanCoreActorState(Database const& db,Reference<ConsistencyScanMemoryState> const& memState,ConsistencyScanState const& cs) 
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : db(db),
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(memState),
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   cs(cs)
															#line 2483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consistencyScanCore", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyScanCoreActorState() 
	{
		fdb_probe_actor_destroy("consistencyScanCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 536 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScanCoreStart").log();
															#line 538 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(db);
															#line 539 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB = SystemDBWriteLockedNow(db.getReference());
															#line 543 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			pollSize = pollDatabaseSize(memState, g_network->isSimulated() ? 15 : 900);
															#line 545 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateLimit = 0;
															#line 546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateControl = Reference<IRateControl>();
															#line 548 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Running Consistency Scan");
															#line 551 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 2512 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyScanCoreActorState();
		static_cast<ConsistencyScanCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		config = ConsistencyScanState::Config();
															#line 554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		configVersion = Optional<Versionstamp>();
															#line 556 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime = ConsistencyScanState::LifetimeStats();
															#line 557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 559 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2550 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 560 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressLoopStart", memState->csId);
															#line 2554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 564 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 565 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 2560 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 640 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2569 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 641 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressEnabled", memState->csId);
															#line 2573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 645 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->databaseSize.get() < 0)
															#line 2577 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 646 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_6 = memState->databaseSize.onChange();
															#line 646 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2583 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 7;
															#line 646 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 6, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2588 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 567 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 572 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(config, cs.config().getD(tr));
															#line 572 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 1;
															#line 572 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 0, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2619 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_MainLoopError", memState->csId).error(e);
															#line 636 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 636 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2658 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 6;
															#line 636 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 5, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2663 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(configVersion, cs.trigger.get(tr));
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2680 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 2;
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 1, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2685 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(configVersion, cs.trigger.get(tr));
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2696 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 2;
															#line 573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 1, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2785 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 576 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotConfig", memState->csId) .detail("Enabled", config.enabled);
															#line 2789 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 583 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 2793 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(statsLifetime, cs.lifetimeStats().getD(tr)) && store(statsCurrentRound, cs.currentRoundStats().getD(tr));
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2799 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 3;
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 2, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2804 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2818 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 576 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotConfig", memState->csId) .detail("Enabled", config.enabled);
															#line 2822 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 583 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 2826 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(statsLifetime, cs.lifetimeStats().getD(tr)) && store(statsCurrentRound, cs.currentRoundStats().getD(tr));
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2832 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 3;
															#line 584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 2, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2837 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.roundStatsHistory().erase( tr, 0, std::max<Version>(0, tr->getReadVersion().get() - (CLIENT_KNOBS->CORE_VERSIONSPERSECOND * 60 * 60 * 24 * config.roundHistoryDays)));
															#line 621 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		watch = config.enabled ? Void() : cs.trigger.watch(tr);
															#line 622 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 622 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2932 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 4;
															#line 622 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 3, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2937 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.complete || (statsCurrentRound.startVersion != 0 && statsCurrentRound.startVersion < config.minStartVersion))
															#line 2946 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 593 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!statsCurrentRound.complete)
															#line 2950 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 596 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endTime = now();
															#line 2956 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.roundStatsHistory().set(tr, statsCurrentRound.startVersion, statsCurrentRound);
															#line 599 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 2962 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 604 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.startVersion == 0)
															#line 2966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 605 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startVersion = tr->getReadVersion().get();
															#line 606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startTime = now();
															#line 607 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 608 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 2976 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.complete || (statsCurrentRound.startVersion != 0 && statsCurrentRound.startVersion < config.minStartVersion))
															#line 2986 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 593 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!statsCurrentRound.complete)
															#line 2990 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 596 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endTime = now();
															#line 2996 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.roundStatsHistory().set(tr, statsCurrentRound.startVersion, statsCurrentRound);
															#line 599 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 3002 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 604 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.startVersion == 0)
															#line 3006 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 605 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startVersion = tr->getReadVersion().get();
															#line 606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startTime = now();
															#line 607 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 608 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 3016 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 624 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 3101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 628 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3107 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 629 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressDisabledWatching", memState->csId);
															#line 3111 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch;
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 5;
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 4, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3122 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 624 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 3131 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 628 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3137 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 629 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressDisabledWatching", memState->csId);
															#line 3141 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch;
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3147 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 5;
															#line 632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 4, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3152 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 3236 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11cont1(Void && _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 3245 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont11cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 649 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3429 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotDBSize", memState->csId);
															#line 3433 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 653 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		restartMainLoop = false;
															#line 654 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		delayBeforeMainLoopRestart = Void();
															#line 657 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 3441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 658 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3550 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 659 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopStart", memState->csId);
															#line 3554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 662 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int configuredRate;
															#line 665 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - statsCurrentRound.startTime > config.targetRoundTimeSeconds)
															#line 3560 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 666 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan needs to catch up");
															#line 667 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configuredRate = config.maxReadByteRate;
															#line 3566 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		else
		{
															#line 672 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double replicationFactor = (statsCurrentRound.logicalBytesScanned == 0) ? 3 : ((double)statsCurrentRound.replicatedBytesRead / statsCurrentRound.logicalBytesScanned);
															#line 676 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double bytesPerSecTarget = memState->databaseSize.get() * replicationFactor / (config.targetRoundTimeSeconds > 0 ? config.targetRoundTimeSeconds : 1);
															#line 679 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			bytesPerSecTarget = std::min(bytesPerSecTarget, 1e8);
															#line 680 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configuredRate = std::min<int>(config.maxReadByteRate, bytesPerSecTarget);
															#line 3578 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 683 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		configuredRate = std::max<int>(100e3, configuredRate);
															#line 688 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (readRateLimit != configuredRate)
															#line 3584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 689 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateLimit = configuredRate;
															#line 690 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan changing rate");
															#line 691 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3592 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 692 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyScan_ChangeRate", memState->csId).detail("RateBytes", readRateLimit);
															#line 3596 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 694 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateControl = Reference<IRateControl>(new SpeedLimit(readRateLimit, 1));
															#line 695 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.targetRate = configuredRate;
															#line 3602 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers = 0;
															#line 705 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		savedCurrentRoundState = statsCurrentRound;
															#line 707 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 708 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 3612 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 1033 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 1034 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.lastEndKey != savedCurrentRoundState.lastEndKey || statsCurrentRound.complete)
															#line 3636 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1035 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3640 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1036 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaving", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 3644 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1039 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 1040 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 3650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 1075 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "consistency scan loop no progress");
															#line 1076 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3659 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1077 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopNoProgress", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 3663 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1cont3loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.scanLoops;
															#line 711 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = savedCurrentRoundState;
															#line 712 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 715 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBoundaries = RangeResult();
															#line 716 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 718 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			csVersion = Optional<Versionstamp>();
															#line 720 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configRange = Optional<ConsistencyScanState::RangeConfigMap::RangeValue>();
															#line 722 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3696 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 723 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadingState", memState->csId);
															#line 3700 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 726 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetRangeLimits limits;
															#line 727 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			limits.minRows = 2;
															#line 728 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			limits.rows = 2;
															#line 729 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			Future<RangeResult> readShardBoundaries = tr->getRange(lastLessOrEqual(statsCurrentRound.lastEndKey.withPrefix(keyServersPrefix)), firstGreaterThan(allKeys.end.withPrefix(keyServersPrefix)), limits, Snapshot::True);
															#line 734 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_7 = store(shardBoundaries, readShardBoundaries) && store(storageServerInterfaces, loadShardInterfaces(memState, tr, readShardBoundaries, db)) && store(csVersion, cs.trigger.get(tr)) && store(configRange, cs.rangeConfig().getRangeForKey(tr, statsCurrentRound.lastEndKey));
															#line 734 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3714 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 8;
															#line 734 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 7, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3719 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1014 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_ScanLoopError", memState->csId).errorUnsuppressed(e);
															#line 1015 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_future_version || e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_process_behind)
															#line 3756 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1018 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 3760 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
				try {
															#line 1022 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 1022 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 3770 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
					static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 11;
															#line 1022 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 10, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3775 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 739 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3797 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 740 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadedState", memState->csId);
															#line 3801 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 745 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion != configVersion)
															#line 3805 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 746 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3809 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 747 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch", memState->csId);
															#line 3813 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 749 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 3817 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 753 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		beginKey = shardBoundaries[0].key.removePrefix(keyServersPrefix);
															#line 754 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey < statsCurrentRound.lastEndKey)
															#line 3824 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 755 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = statsCurrentRound.lastEndKey;
															#line 3828 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 757 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		targetRange = KeyRangeRef(beginKey, shardBoundaries[1].key.removePrefix(keyServersPrefix));
															#line 760 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool scanRange = true;
															#line 761 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.lastProgressVersion = tr->getReadVersion().get();
															#line 766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (configRange.present())
															#line 3838 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 767 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			auto val = configRange->value;
															#line 772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!val.included.orDefault(true) || val.skip.orDefault(false))
															#line 3844 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 778 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (val.skip.orDefault(false))
															#line 3848 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 779 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++statsCurrentRound.skippedRanges;
															#line 3852 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 783 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = configRange->range.begin;
															#line 784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				scanRange = false;
															#line 3858 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 790 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (configRange->range.end < targetRange.end)
															#line 3864 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(targetRange.begin, configRange->range.end);
															#line 3868 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
		}
															#line 797 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 798 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		failedRequest = Optional<Error>();
															#line 800 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (scanRange)
															#line 3878 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 802 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled && g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get() && (deterministicRandom()->random01() < 0.1 || targetRange.end == allKeys.end))
															#line 3882 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 807 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (storageServerInterfaces.size() > 1)
															#line 3886 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 809 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key corruptKey = targetRange.begin;
															#line 810 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (deterministicRandom()->coinflip() && targetRange.end.size() > 0)
															#line 3892 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 811 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						Key corruptKey2 = targetRange.end.substr(0, targetRange.end.size() - 1);
															#line 812 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (corruptKey2 > corruptKey)
															#line 3898 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 813 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							corruptKey = corruptKey2;
															#line 3902 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
															#line 816 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptRequestKey = corruptKey;
															#line 817 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					std::pair<UID, NetworkAddress> meCorruptor = { memState->csId, g_network->getLocalAddress() };
															#line 819 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptor = meCorruptor;
															#line 820 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_InjectCorruption);
															#line 823 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent( SevWarnAlways, "ConsistencyScanProgressScanRangeInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin) .detail("CorruptKey", corruptKey) .detail("Storages", storageServerInterfaces.size());
															#line 3915 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 830 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "skipping consistency scan corruption check because only 1 replica");
															#line 831 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 834 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarnAlways, "ConsistencyScanProgressScanRangeSkipInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin);
															#line 3925 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
															#line 840 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3930 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 841 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeStart", memState->csId) .detail("StartKey", targetRange.begin);
															#line 3934 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead = 0;
															#line 849 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead = 0;
															#line 851 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			errors = 0;
															#line 865 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 3944 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 739 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3958 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 740 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadedState", memState->csId);
															#line 3962 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 745 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion != configVersion)
															#line 3966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 746 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3970 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 747 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch", memState->csId);
															#line 3974 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 749 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 3978 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 753 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		beginKey = shardBoundaries[0].key.removePrefix(keyServersPrefix);
															#line 754 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey < statsCurrentRound.lastEndKey)
															#line 3985 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 755 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = statsCurrentRound.lastEndKey;
															#line 3989 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 757 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		targetRange = KeyRangeRef(beginKey, shardBoundaries[1].key.removePrefix(keyServersPrefix));
															#line 760 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool scanRange = true;
															#line 761 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.lastProgressVersion = tr->getReadVersion().get();
															#line 766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (configRange.present())
															#line 3999 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 767 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			auto val = configRange->value;
															#line 772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!val.included.orDefault(true) || val.skip.orDefault(false))
															#line 4005 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 778 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (val.skip.orDefault(false))
															#line 4009 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 779 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++statsCurrentRound.skippedRanges;
															#line 4013 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 783 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = configRange->range.begin;
															#line 784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				scanRange = false;
															#line 4019 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 790 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (configRange->range.end < targetRange.end)
															#line 4025 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(targetRange.begin, configRange->range.end);
															#line 4029 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
		}
															#line 797 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 798 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		failedRequest = Optional<Error>();
															#line 800 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (scanRange)
															#line 4039 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 802 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled && g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get() && (deterministicRandom()->random01() < 0.1 || targetRange.end == allKeys.end))
															#line 4043 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 807 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (storageServerInterfaces.size() > 1)
															#line 4047 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 809 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key corruptKey = targetRange.begin;
															#line 810 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (deterministicRandom()->coinflip() && targetRange.end.size() > 0)
															#line 4053 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 811 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						Key corruptKey2 = targetRange.end.substr(0, targetRange.end.size() - 1);
															#line 812 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (corruptKey2 > corruptKey)
															#line 4059 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 813 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							corruptKey = corruptKey2;
															#line 4063 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
															#line 816 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptRequestKey = corruptKey;
															#line 817 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					std::pair<UID, NetworkAddress> meCorruptor = { memState->csId, g_network->getLocalAddress() };
															#line 819 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptor = meCorruptor;
															#line 820 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_InjectCorruption);
															#line 823 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent( SevWarnAlways, "ConsistencyScanProgressScanRangeInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin) .detail("CorruptKey", corruptKey) .detail("Storages", storageServerInterfaces.size());
															#line 4076 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 830 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "skipping consistency scan corruption check because only 1 replica");
															#line 831 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 834 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarnAlways, "ConsistencyScanProgressScanRangeSkipInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin);
															#line 4086 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
															#line 840 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 4091 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 841 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeStart", memState->csId) .detail("StartKey", targetRange.begin);
															#line 4095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead = 0;
															#line 849 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead = 0;
															#line 851 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			errors = 0;
															#line 865 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 4105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 989 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (noMoreRecords)
															#line 4194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 990 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan completed a round");
															#line 992 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 993 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.endTime = now();
															#line 994 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastEndKey = Key();
															#line 995 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.complete = true;
															#line 997 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 4208 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 998 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressRoundComplete", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned);
															#line 4212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1004 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 1005 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			delayBeforeMainLoopRestart = delay(std::max<double>( config.minRoundTimeSeconds - (statsCurrentRound.endTime - statsCurrentRound.startTime), 0.0));
															#line 4218 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont14(int loopDepth) 
	{
															#line 969 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.errorCount += errors;
															#line 970 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.errorCount += errors;
															#line 972 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.logicalBytesScanned += logicalBytesRead;
															#line 973 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.replicatedBytesRead += replicatedBytesRead;
															#line 975 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.logicalBytesScanned += logicalBytesRead;
															#line 976 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.replicatedBytesRead += replicatedBytesRead;
															#line 978 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.logicalBytesScanned += logicalBytesRead;
															#line 979 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.replicatedBytesRead += replicatedBytesRead;
															#line 981 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 4244 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 982 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeEnd", memState->csId) .detail("BytesRead", logicalBytesRead) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 4248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 866 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 867 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 868 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.requests += storageServerInterfaces.size();
															#line 869 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		replicatedBytesReadThisLoop = 0;
															#line 870 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(memState->csId, db, targetRange, tr->getReadVersion().get(), &storageServerInterfaces, &keyValueFutures, &firstValidServer, &replicatedBytesReadThisLoop, statsCurrentRound.startVersion);
															#line 870 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4275 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 9;
															#line 870 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 8, int >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(int const& newErrors,int loopDepth) 
	{
															#line 879 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		errors += newErrors;
															#line 880 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.inconsistencies += newErrors;
															#line 883 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 884 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 885 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.present())
															#line 4310 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 886 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				failedRequest = rangeResult.getError();
															#line 4314 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				break;
			}
			else
			{
															#line 888 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (rangeResult.get().error.present())
															#line 4321 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 889 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					failedRequest = rangeResult.get().error.get();
															#line 4325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					break;
				}
			}
		}
															#line 895 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers += replicatedBytesReadThisLoop;
															#line 896 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!failedRequest.present() && !newErrors)
															#line 4334 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 897 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(firstValidServer.present());
															#line 898 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetKeyValuesReply rangeResult = keyValueFutures[firstValidServer.get()].get().get();
															#line 899 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead += rangeResult.data.expectedSize();
															#line 900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.more)
															#line 4346 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 902 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = targetRange.end;
															#line 903 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 4352 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 906 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 908 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(result.size() > 0);
															#line 909 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = keyAfter(result.back().key);
															#line 910 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				targetRange = KeyRangeRef(statsCurrentRound.lastEndKey, targetRange.end);
															#line 911 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (targetRange.empty())
															#line 4367 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 912 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = targetRange.end == allKeys.end;
															#line 4371 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
		else
		{
															#line 916 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!failedRequest.present() && newErrors)
															#line 4380 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 919 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Key nextKey = statsCurrentRound.lastEndKey;
															#line 920 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 921 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply rangeResult = keyValueFutures[i].get().get();
															#line 922 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (i == firstValidServer.get())
															#line 4390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 923 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						logicalBytesRead += rangeResult.data.expectedSize();
															#line 4394 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 925 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key storageNextKey = (rangeResult.more && rangeResult.data.size() > 0) ? keyAfter(rangeResult.data.back().key) : targetRange.end;
															#line 928 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (storageNextKey > nextKey)
															#line 4400 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 929 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						nextKey = storageNextKey;
															#line 4404 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
															#line 932 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 933 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = nextKey;
															#line 934 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (nextKey == targetRange.end)
															#line 4413 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = nextKey == allKeys.end;
															#line 4417 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(nextKey, targetRange.end);
															#line 4424 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 942 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(failedRequest.get().code() == error_code_transaction_too_old, "consistency scan loop shard too large for one transaction");
															#line 944 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (failedRequest.get().code() != error_code_transaction_too_old)
															#line 4433 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 945 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_FailedRequest", memState->csId) .errorUnsuppressed(failedRequest.get()) .suppressFor(5.0);
															#line 948 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++memState->stats.failedRequests;
															#line 4439 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 951 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(failedRequest.get().code() != error_code_operation_cancelled);
															#line 954 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 4445 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 962 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double ratio = SERVER_KNOBS->CONSISTENCY_SCAN_ACTIVE_THROTTLE_RATIO;
															#line 963 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ratio = std::max(0.0, std::min(1.0, ratio));
															#line 964 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int sleepBytes = (int)(totalReadBytesFromStorageServers * ratio);
															#line 965 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers -= sleepBytes;
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_9 = readRateControl->getAllowance(sleepBytes);
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4461 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 10;
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 9, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4466 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(int && newErrors,int loopDepth) 
	{
															#line 879 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		errors += newErrors;
															#line 880 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.inconsistencies += newErrors;
															#line 883 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 884 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 885 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.present())
															#line 4483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 886 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				failedRequest = rangeResult.getError();
															#line 4487 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				break;
			}
			else
			{
															#line 888 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (rangeResult.get().error.present())
															#line 4494 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 889 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					failedRequest = rangeResult.get().error.get();
															#line 4498 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					break;
				}
			}
		}
															#line 895 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers += replicatedBytesReadThisLoop;
															#line 896 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!failedRequest.present() && !newErrors)
															#line 4507 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 897 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(firstValidServer.present());
															#line 898 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetKeyValuesReply rangeResult = keyValueFutures[firstValidServer.get()].get().get();
															#line 899 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead += rangeResult.data.expectedSize();
															#line 900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.more)
															#line 4519 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 902 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = targetRange.end;
															#line 903 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 4525 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 906 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 908 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(result.size() > 0);
															#line 909 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = keyAfter(result.back().key);
															#line 910 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				targetRange = KeyRangeRef(statsCurrentRound.lastEndKey, targetRange.end);
															#line 911 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (targetRange.empty())
															#line 4540 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 912 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = targetRange.end == allKeys.end;
															#line 4544 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
		else
		{
															#line 916 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!failedRequest.present() && newErrors)
															#line 4553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 919 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Key nextKey = statsCurrentRound.lastEndKey;
															#line 920 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 921 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply rangeResult = keyValueFutures[i].get().get();
															#line 922 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (i == firstValidServer.get())
															#line 4563 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 923 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						logicalBytesRead += rangeResult.data.expectedSize();
															#line 4567 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 925 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key storageNextKey = (rangeResult.more && rangeResult.data.size() > 0) ? keyAfter(rangeResult.data.back().key) : targetRange.end;
															#line 928 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (storageNextKey > nextKey)
															#line 4573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 929 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						nextKey = storageNextKey;
															#line 4577 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
															#line 932 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 933 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = nextKey;
															#line 934 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (nextKey == targetRange.end)
															#line 4586 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = nextKey == allKeys.end;
															#line 4590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(nextKey, targetRange.end);
															#line 4597 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 942 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(failedRequest.get().code() == error_code_transaction_too_old, "consistency scan loop shard too large for one transaction");
															#line 944 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (failedRequest.get().code() != error_code_transaction_too_old)
															#line 4606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 945 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_FailedRequest", memState->csId) .errorUnsuppressed(failedRequest.get()) .suppressFor(5.0);
															#line 948 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++memState->stats.failedRequests;
															#line 4612 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 951 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(failedRequest.get().code() != error_code_operation_cancelled);
															#line 954 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 4618 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 962 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double ratio = SERVER_KNOBS->CONSISTENCY_SCAN_ACTIVE_THROTTLE_RATIO;
															#line 963 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ratio = std::max(0.0, std::min(1.0, ratio));
															#line 964 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int sleepBytes = (int)(totalReadBytesFromStorageServers * ratio);
															#line 965 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers -= sleepBytes;
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_9 = readRateControl->getAllowance(sleepBytes);
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4634 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 10;
															#line 966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 9, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4639 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(int const& newErrors,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(newErrors, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(int && newErrors,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(std::move(newErrors), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 1024 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevError, "ConsistencyScan_UnexpectedError", memState->csId).error(e2);
															#line 1025 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			return a_body1Catch1(e2, std::max(0, loopDepth - 3));
															#line 4825 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7(int loopDepth) 
	{
															#line 1083 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_14 = readRateControl->getAllowance(totalReadBytesFromStorageServers);
															#line 1083 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4941 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 15;
															#line 1083 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 14, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4946 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 4968 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1042 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaveStart", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 4972 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		try {
															#line 1046 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 1047 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Optional<Versionstamp>> __when_expr_11 = cs.trigger.get(tr);
															#line 1047 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4981 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 12;
															#line 1047 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4986 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1066 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5021 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1067 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaveError", memState->csId) .errorUnsuppressed(e) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5025 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1071 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tr->onError(e);
															#line 1071 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 5031 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(__when_expr_13.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 14;
															#line 1071 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 13, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5036 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3(Optional<Versionstamp> const& csVersion2,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion2 != configVersion)
															#line 5051 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1049 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5055 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1050 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch2", memState->csId);
															#line 5059 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1052 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 5063 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1055 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 1056 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.lifetimeStats().set(tr, statsLifetime);
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr->commit();
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5074 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 13;
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 12, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5079 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3(Optional<Versionstamp> && csVersion2,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion2 != configVersion)
															#line 5088 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1049 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5092 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1050 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch2", memState->csId);
															#line 5096 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1052 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 5100 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1055 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 1056 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.lifetimeStats().set(tr, statsLifetime);
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr->commit();
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5111 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 13;
															#line 1058 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 12, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1when1(Optional<Versionstamp> const& csVersion2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont3(csVersion2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1when1(Optional<Versionstamp> && csVersion2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont3(std::move(csVersion2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Optional<Versionstamp> const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Optional<Versionstamp> && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1059 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5200 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1060 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopDurable", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1059 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1060 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopDurable", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5218 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1loopBody1cont3loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 1085 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1086 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressRateLimited", memState->csId);
															#line 5394 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1089 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (restartMainLoop)
															#line 5398 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1090 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5402 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1091 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressWait", memState->csId);
															#line 5406 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1093 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.waitingBetweenRounds = true;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_15 = delayBeforeMainLoopRestart;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5414 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont12when1(__when_expr_15.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 16;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 15, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5419 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 1085 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5433 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1086 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressRateLimited", memState->csId);
															#line 5437 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1089 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (restartMainLoop)
															#line 5441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1090 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5445 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1091 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressWait", memState->csId);
															#line 5449 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1093 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.waitingBetweenRounds = true;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_15 = delayBeforeMainLoopRestart;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont12when1(__when_expr_15.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 16;
															#line 1094 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 15, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5462 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont3loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont3loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1loopBody1cont3loopBody1cont12cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12cont3(Void const& _,int loopDepth) 
	{
															#line 1095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.waitingBetweenRounds = false;
															#line 5557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12cont3(Void && _,int loopDepth) 
	{
															#line 1095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.waitingBetweenRounds = false;
															#line 5566 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont3loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont3loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState cs;
															#line 538 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 539 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<SystemTransactionGenerator<DatabaseContext>> systemDB;
															#line 543 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> pollSize;
															#line 545 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t readRateLimit;
															#line 546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<IRateControl> readRateControl;
															#line 553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::Config config;
															#line 554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Versionstamp> configVersion;
															#line 556 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::LifetimeStats statsLifetime;
															#line 557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::RoundStats statsCurrentRound;
															#line 621 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> watch;
															#line 653 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool restartMainLoop;
															#line 654 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> delayBeforeMainLoopRestart;
															#line 701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int totalReadBytesFromStorageServers;
															#line 705 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::RoundStats savedCurrentRoundState;
															#line 715 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult shardBoundaries;
															#line 716 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 718 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Versionstamp> csVersion;
															#line 720 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<ConsistencyScanState::RangeConfigMap::RangeValue> configRange;
															#line 753 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key beginKey;
															#line 757 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange targetRange;
															#line 797 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool noMoreRecords;
															#line 798 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Error> failedRequest;
															#line 847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t replicatedBytesRead;
															#line 849 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t logicalBytesRead;
															#line 851 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int errors;
															#line 866 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 867 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int> firstValidServer;
															#line 869 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t replicatedBytesReadThisLoop;
															#line 5708 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consistencyScanCore()
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanCoreActor final : public Actor<Void>, public ActorCallback< ConsistencyScanCoreActor, 0, Void >, public ActorCallback< ConsistencyScanCoreActor, 1, Void >, public ActorCallback< ConsistencyScanCoreActor, 2, Void >, public ActorCallback< ConsistencyScanCoreActor, 3, Void >, public ActorCallback< ConsistencyScanCoreActor, 4, Void >, public ActorCallback< ConsistencyScanCoreActor, 5, Void >, public ActorCallback< ConsistencyScanCoreActor, 6, Void >, public ActorCallback< ConsistencyScanCoreActor, 7, Void >, public ActorCallback< ConsistencyScanCoreActor, 8, int >, public ActorCallback< ConsistencyScanCoreActor, 9, Void >, public ActorCallback< ConsistencyScanCoreActor, 10, Void >, public ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >, public ActorCallback< ConsistencyScanCoreActor, 12, Void >, public ActorCallback< ConsistencyScanCoreActor, 13, Void >, public ActorCallback< ConsistencyScanCoreActor, 14, Void >, public ActorCallback< ConsistencyScanCoreActor, 15, Void >, public FastAllocated<ConsistencyScanCoreActor>, public ConsistencyScanCoreActorState<ConsistencyScanCoreActor> {
															#line 5713 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsistencyScanCoreActor>::operator new;
	using FastAllocated<ConsistencyScanCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(189939555600114432UL, 5787193519609528064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyScanCoreActor, 0, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 1, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 2, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 3, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 4, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 5, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 6, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 7, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 8, int >;
friend struct ActorCallback< ConsistencyScanCoreActor, 9, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 10, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >;
friend struct ActorCallback< ConsistencyScanCoreActor, 12, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 13, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 14, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 15, Void >;
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanCoreActor(Database const& db,Reference<ConsistencyScanMemoryState> const& memState,ConsistencyScanState const& cs) 
															#line 5745 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConsistencyScanCoreActorState<ConsistencyScanCoreActor>(db, memState, cs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6734742563649243904UL, 7957931058348816896UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyScanCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 15, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> consistencyScanCore( Database const& db, Reference<ConsistencyScanMemoryState> const& memState, ConsistencyScanState const& cs ) {
															#line 533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new ConsistencyScanCoreActor(db, memState, cs));
															#line 5793 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 5798 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sometimesRandomlyClearStatsInSim()
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class SometimesRandomlyClearStatsInSimActor>
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class SometimesRandomlyClearStatsInSimActorState {
															#line 5805 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	SometimesRandomlyClearStatsInSimActorState(Database const& db,Reference<ConsistencyScanMemoryState> const& memState) 
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : db(db),
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(memState)
															#line 5814 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this));

	}
	~SometimesRandomlyClearStatsInSimActorState() 
	{
		fdb_probe_actor_destroy("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1103 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(db);
															#line 1106 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs = ConsistencyScanState();
															#line 1108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.1) && !g_simulator->speedUpSimulation)
															#line 5835 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyScan_RandomStatClearWaiting", memState->csId).log();
															#line 1110 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->randomInt(1, 60));
															#line 1110 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5843 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 1;
															#line 1110 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 5848 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SometimesRandomlyClearStatsInSimActorState();
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SometimesRandomlyClearStatsInSimActorState(); static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->destroy(); return 0; }
															#line 5876 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SometimesRandomlyClearStatsInSimActorState();
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatClearing", memState->csId).log();
															#line 1113 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 5890 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatClearing", memState->csId).log();
															#line 1113 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 5901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1124 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatCleared", memState->csId).log();
															#line 5985 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 1116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cs.clearStats(tr);
															#line 1116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6006 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 2;
															#line 1116 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6011 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6048 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 4;
															#line 1120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6053 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6070 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 3;
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6075 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6086 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 3;
															#line 1117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6091 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 1105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1106 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState cs;
															#line 6353 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sometimesRandomlyClearStatsInSim()
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class SometimesRandomlyClearStatsInSimActor final : public Actor<Void>, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >, public FastAllocated<SometimesRandomlyClearStatsInSimActor>, public SometimesRandomlyClearStatsInSimActorState<SometimesRandomlyClearStatsInSimActor> {
															#line 6358 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<SometimesRandomlyClearStatsInSimActor>::operator new;
	using FastAllocated<SometimesRandomlyClearStatsInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16685057062801169920UL, 5698459082890854400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >;
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	SometimesRandomlyClearStatsInSimActor(Database const& db,Reference<ConsistencyScanMemoryState> const& memState) 
															#line 6378 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SometimesRandomlyClearStatsInSimActorState<SometimesRandomlyClearStatsInSimActor>(db, memState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7172944077987118336UL, 10458069167030924544UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sometimesRandomlyClearStatsInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> sometimesRandomlyClearStatsInSim( Database const& db, Reference<ConsistencyScanMemoryState> const& memState ) {
															#line 1102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new SometimesRandomlyClearStatsInSimActor(db, memState));
															#line 6414 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1129 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

void resetSimCorruptionCheckOnDeath(Reference<ConsistencyScanMemoryState> memState) {
	if (!g_network->isSimulated()) {
		return;
	}
	if (g_simulator->consistencyScanCorruptor.present() &&
	    g_simulator->consistencyScanCorruptor.get().first == memState->csId) {
		TraceEvent("ConsistencyScan_ResetCorruptionOnDeath");
		CODE_PROBE(
		    true, "Consistency Scan skipped corruption check because scan died in the middle", probe::decoration::rare);
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption,
		                                        ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
	}
}

															#line 6433 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via consistencyScan()
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyScanActor>
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanActorState {
															#line 6440 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanActorState(ConsistencyScanInterface const& csInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : csInterf(csInterf),
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   dbInfo(dbInfo),
															#line 1145 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   db(openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True)),
															#line 1146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   actors(),
															#line 1147 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(makeReference<ConsistencyScanMemoryState>(dbInfo, csInterf.id()))
															#line 6455 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("consistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1150 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_Start", csInterf.id()).log();
															#line 1151 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			actors.add(traceRole(Role::CONSISTENCYSCAN, csInterf.id()));
															#line 1152 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			actors.add(waitFailureServer(csInterf.waitFailure.getFuture()));
															#line 1153 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			core = consistencyScanCore(db, memState, ConsistencyScanState());
															#line 1155 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated())
															#line 6478 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1156 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				actors.add(sometimesRandomlyClearStatsInSim(db, memState));
															#line 1161 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (g_simulator->consistencyScanCorruptor.present() && csInterf.id() != g_simulator->consistencyScanCorruptor.get().first && g_simulator->getProcessByAddress(g_simulator->consistencyScanCorruptor.get().second)->failed && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption)
															#line 6484 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1165 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_ResetCorruptionOnPreviousScanDeath");
															#line 1167 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 6490 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
															#line 1172 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6526 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 1192 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetSimCorruptionCheckOnDeath(memState);
															#line 1193 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_Error", csInterf.id()).errorUnsuppressed(err);
															#line 1194 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 6546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1175 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_0 = core;
															#line 1174 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6569 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto __when_expr_1 = csInterf.haltConsistencyScan.getFuture();
															#line 6573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<HaltConsistencyScanRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<HaltConsistencyScanRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 1186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = actors.getResult();
															#line 6578 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 1175 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanActor, 0, Void >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 1179 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 1186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanActor, 2, Void >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 6587 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 6602 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 6611 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(HaltConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		resetSimCorruptionCheckOnDeath(memState);
															#line 1181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.reply.send(Void());
															#line 1182 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		core = Void();
															#line 1183 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_Halted", csInterf.id()).detail("ReqID", req.requesterID);
															#line 1184 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyScanActorState(); static_cast<ConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 6628 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(HaltConsistencyScanRequest && req,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		resetSimCorruptionCheckOnDeath(memState);
															#line 1181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.reply.send(Void());
															#line 1182 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		core = Void();
															#line 1183 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_Halted", csInterf.id()).detail("ReqID", req.requesterID);
															#line 1184 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyScanActorState(); static_cast<ConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 6648 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 1188 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 6662 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1187 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 1188 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 6672 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanActor*>(this)->ActorCallback< ConsistencyScanActor, 0, Void >::remove();
		static_cast<ConsistencyScanActor*>(this)->ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >::remove();
		static_cast<ConsistencyScanActor*>(this)->ActorCallback< ConsistencyScanActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyScanActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,HaltConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,HaltConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyScanActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanInterface csInterf;
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1145 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 1146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ActorCollection actors;
															#line 1147 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 1153 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> core;
															#line 6867 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consistencyScan()
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanActor final : public Actor<Void>, public ActorCallback< ConsistencyScanActor, 0, Void >, public ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >, public ActorCallback< ConsistencyScanActor, 2, Void >, public FastAllocated<ConsistencyScanActor>, public ConsistencyScanActorState<ConsistencyScanActor> {
															#line 6872 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsistencyScanActor>::operator new;
	using FastAllocated<ConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(580083223057308672UL, 10414207882238659328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyScanActor, 0, Void >;
friend struct ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >;
friend struct ActorCallback< ConsistencyScanActor, 2, Void >;
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanActor(ConsistencyScanInterface const& csInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6891 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConsistencyScanActorState<ConsistencyScanActor>(csInterf, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(866477116270183168UL, 7948926982827793408UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyScanActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> consistencyScan( ConsistencyScanInterface const& csInterf, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1144 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new ConsistencyScanActor(csInterf, dbInfo));
															#line 6924 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1198 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

///////////////////////////////////////////////////////
// Everything below this line is not relevant to the ConsistencyScan Role anymore.
// It is only used by workloads/ConsistencyCheck

// Gets a version at which to read from the storage servers
															#line 6934 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersion()
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetVersionActor>
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetVersionActorState {
															#line 6941 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetVersionActorState(Database const& cx) 
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx)
															#line 6948 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1205 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6963 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1206 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr = Transaction(cx);
															#line 1207 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 6995 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		try {
															#line 1209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 1209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7001 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 1209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Version >*>(static_cast<GetVersionActor*>(this)));
															#line 7006 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7030 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 1212 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 7035 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 1210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 7050 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 1210 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 7062 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1206 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 7236 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersion()
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetVersionActor final : public Actor<Version>, public ActorCallback< GetVersionActor, 0, Version >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 7241 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17108382880004414720UL, 13204454988290243840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Version >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetVersionActor(Database const& cx) 
															#line 7259 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetVersionActorState<GetVersionActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Version> getVersion( Database const& cx ) {
															#line 1204 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Version>(new GetVersionActor(cx));
															#line 7293 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1216 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

void testFailure(std::string message, bool performQuiescentChecks, bool* success, bool isError) {
	*success = false;
	TraceEvent failEvent(isError ? SevError : SevWarn, "TestFailure");
	if (performQuiescentChecks)
		failEvent.detail("Workload", "QuiescentCheck");
	else
		failEvent.detail("Workload", "ConsistencyCheck");

	failEvent.detail("Reason", "Consistency check: " + message);
}

// Get a list of storage servers(persisting keys within range "kr") from the master and compares them with the
// TLogs. If this is a quiescent check, then each commit proxy needs to respond, otherwise only one needs to
// respond. Returns false if there is a failure (in this case, keyServersPromise will never be set)
															#line 7312 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyServers()
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetKeyServersActor>
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyServersActorState {
															#line 7319 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyServersActorState(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,bool const& performQuiescentChecks,bool const& failureIsError,bool* const& success) 
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServersPromise(keyServersPromise),
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   kr(kr),
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   failureIsError(failureIsError),
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1238 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServers(),
															#line 1241 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServerLocationFutures(),
															#line 1242 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   begin(kr.begin),
															#line 1243 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   end(kr.end),
															#line 1244 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   limitKeyServers(BUGGIFY ? 1 : 100),
															#line 1245 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   span(SpanContext(deterministicRandom()->randomUniqueID(), deterministicRandom()->randomUInt64()), "WL:ConsistencyCheck"_loc)
															#line 7348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyServersActorState() 
	{
		fdb_probe_actor_destroy("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 7363 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1298 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServersPromise.send(keyServers);
															#line 1299 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7388 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(begin < end))
															#line 7407 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Reference<CommitProxyInfo>> __when_expr_0 = cx->getCommitProxiesFuture(UseProvisionalProxies::False);
															#line 1249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7415 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 1;
															#line 1249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1251 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServerLocationFutures.clear();
															#line 1252 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < commitProxyInfo->size();i++) {
															#line 1253 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyServerLocationFutures.push_back( commitProxyInfo->get(i, &CommitProxyInterface::getKeyServersLocations) .getReplyUnlessFailedFor( GetKeyServerLocationsRequest( span.context, begin, end, limitKeyServers, false, latestVersion, Arena()), 2, 0));
															#line 7446 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1261 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServersInsertedForThisIteration = false;
															#line 1263 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyServerLocationFutures);
															#line 1262 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7454 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1290 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = cx->onProxiesChanged();
															#line 7458 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 2;
															#line 1263 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 1, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 1290 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 2, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7465 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> const& __commitProxyInfo,int loopDepth) 
	{
															#line 1249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		commitProxyInfo = __commitProxyInfo;
															#line 7474 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> && __commitProxyInfo,int loopDepth) 
	{
		commitProxyInfo = std::move(__commitProxyInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1293 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyServersInsertedForThisIteration)
															#line 7553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1294 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 1294 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7559 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetKeyServersActor*>(this)->actor_wait_state = 3;
															#line 1294 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 3, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7564 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < keyServerLocationFutures.size();i++) {
															#line 1266 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyServerLocationsReply> shards = keyServerLocationFutures[i].get();
															#line 1270 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && !shards.present())
															#line 7582 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1271 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyUnavailable") .error(shards.getError()) .detail("CommitProxyID", commitProxyInfo->getId(i));
															#line 1274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Commit proxy unavailable", performQuiescentChecks, success, failureIsError);
															#line 1275 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7590 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetKeyServersActorState();
				static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (shards.present() && !keyServersInsertedForThisIteration)
															#line 7598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1281 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServers.insert(keyServers.end(), shards.get().results.begin(), shards.get().results.end());
															#line 1282 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServersInsertedForThisIteration = true;
															#line 1283 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				begin = shards.get().results.back().first.end;
															#line 1285 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!performQuiescentChecks)
															#line 7608 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
					break;
				}
			}
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1265 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < keyServerLocationFutures.size();i++) {
															#line 1266 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyServerLocationsReply> shards = keyServerLocationFutures[i].get();
															#line 1270 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && !shards.present())
															#line 7626 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1271 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyUnavailable") .error(shards.getError()) .detail("CommitProxyID", commitProxyInfo->getId(i));
															#line 1274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Commit proxy unavailable", performQuiescentChecks, success, failureIsError);
															#line 1275 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7634 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetKeyServersActorState();
				static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1280 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (shards.present() && !keyServersInsertedForThisIteration)
															#line 7642 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1281 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServers.insert(keyServers.end(), shards.get().results.begin(), shards.get().results.end());
															#line 1282 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServersInsertedForThisIteration = true;
															#line 1283 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				begin = shards.get().results.back().first.end;
															#line 1285 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!performQuiescentChecks)
															#line 7652 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
					break;
				}
			}
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 1, Void >::remove();
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServersPromise;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef kr;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool failureIsError;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1238 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 1241 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyServerLocationsReply>>> keyServerLocationFutures;
															#line 1242 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key begin;
															#line 1243 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key end;
															#line 1244 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int limitKeyServers;
															#line 1245 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Span span;
															#line 1249 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<CommitProxyInfo> commitProxyInfo;
															#line 1261 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool keyServersInsertedForThisIteration;
															#line 7916 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyServers()
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyServersActor final : public Actor<bool>, public ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >, public ActorCallback< GetKeyServersActor, 1, Void >, public ActorCallback< GetKeyServersActor, 2, Void >, public ActorCallback< GetKeyServersActor, 3, Void >, public FastAllocated<GetKeyServersActor>, public GetKeyServersActorState<GetKeyServersActor> {
															#line 7921 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyServersActor>::operator new;
	using FastAllocated<GetKeyServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3344005597475607552UL, 16336403323550194688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >;
friend struct ActorCallback< GetKeyServersActor, 1, Void >;
friend struct ActorCallback< GetKeyServersActor, 2, Void >;
friend struct ActorCallback< GetKeyServersActor, 3, Void >;
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyServersActor(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,bool const& performQuiescentChecks,bool const& failureIsError,bool* const& success) 
															#line 7941 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   GetKeyServersActorState<GetKeyServersActor>(cx, keyServersPromise, kr, performQuiescentChecks, failureIsError, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2154856847302521088UL, 16578737356717173248UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyServersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyServersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<bool> getKeyServers( Database const& cx, Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise, KeyRangeRef const& kr, bool const& performQuiescentChecks, bool const& failureIsError, bool* const& success ) {
															#line 1231 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<bool>(new GetKeyServersActor(cx, keyServersPromise, kr, performQuiescentChecks, failureIsError, success));
															#line 7976 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1301 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Retrieves the locations of all shards in the database
// Returns false if there is a failure (in this case, keyLocationPromise will never be set)
															#line 7983 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyLocations()
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetKeyLocationsActor>
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyLocationsActorState {
															#line 7990 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyLocationsActorState(Database const& cx,std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards,Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise,bool const& performQuiescentChecks,bool* const& success) 
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shards(shards),
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocationPromise(keyLocationPromise),
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1309 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocations(),
															#line 1310 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   beginKey(allKeys.begin.withPrefix(keyServersPrefix)),
															#line 1311 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   endKey(allKeys.end.withPrefix(keyServersPrefix)),
															#line 1312 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   i(0),
															#line 1313 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   onErrorTr(cx)
															#line 8015 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyLocations", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocationsActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1317 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 8030 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocationsActorState();
		static_cast<GetKeyLocationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1404 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyLocationPromise.send(keyLocations);
															#line 1405 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8055 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetKeyLocationsActorState();
		static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1317 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(i < shards.size()))
															#line 8074 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1318 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 8080 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1317 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		i++;
															#line 8102 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1318 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(beginKey < std::min<KeyRef>(shards[i].first.end, endKey)))
															#line 8118 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 1320 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getVersion(cx);
															#line 1320 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 1;
															#line 1320 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 0, Version >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8132 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1397 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			err = e;
															#line 1398 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onErrorTr.onError(err);
															#line 1398 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8171 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 3;
															#line 1398 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 2, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8176 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Version const& version,int loopDepth) 
	{
															#line 1322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		GetKeyValuesRequest req;
															#line 1323 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 1324 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 1325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 1326 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 1327 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.version = version;
															#line 1328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.tags = TagSet();
															#line 1331 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1332 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 1333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetReply(req);
															#line 1334 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 8211 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1335 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 8215 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1337 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 8219 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyValueFutures);
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8225 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 2;
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 1, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8230 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Version && version,int loopDepth) 
	{
															#line 1322 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		GetKeyValuesRequest req;
															#line 1323 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 1324 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 1325 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 1326 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 1327 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.version = version;
															#line 1328 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.tags = TagSet();
															#line 1331 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1332 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 1333 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetReply(req);
															#line 1334 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 8259 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1335 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 8263 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1337 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 8267 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyValueFutures);
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8273 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 2;
															#line 1340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 1, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8278 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1342 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1345 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 1346 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 1348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 8368 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1350 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 8372 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1351 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					return a_body1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 8376 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1355 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 8383 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1356 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					firstValidStorageServer = j;
															#line 8387 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1360 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 8393 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1362 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent("ConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 1365 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Key servers inconsistent", performQuiescentChecks, success, true);
															#line 1366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8401 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetKeyLocationsActorState();
						static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 1370 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 1371 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		RangeResult currentLocations = krmDecodeRanges( keyServersPrefix, KeyRangeRef(beginKey.removePrefix(keyServersPrefix), std::min<KeyRef>(shards[i].first.end, endKey).removePrefix(keyServersPrefix)), RangeResultRef(keyValueResponse.data, keyValueResponse.more));
															#line 1377 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (keyValueResponse.data.size() && beginKey == keyValueResponse.data[0].key)
															#line 8416 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1378 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations[0]);
															#line 8420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1381 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (currentLocations.size() > 2)
															#line 8424 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1382 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.append_deep(keyLocations.arena(), &currentLocations[1], currentLocations.size() - 2);
															#line 8428 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1386 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(currentLocations.size() > 1);
															#line 1387 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyValueResponse.more)
															#line 8434 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1388 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = shards[i].first.end;
															#line 8438 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = keyValueResponse.data.end()[-1].key;
															#line 8444 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1394 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey >= endKey)
															#line 8448 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1395 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations.end()[-1]);
															#line 8452 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1342 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1345 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 1346 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 1348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 8468 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1350 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 8472 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1351 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					return a_body1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 8476 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1355 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 8483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1356 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					firstValidStorageServer = j;
															#line 8487 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1360 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 8493 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1362 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent("ConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 1365 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Key servers inconsistent", performQuiescentChecks, success, true);
															#line 1366 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8501 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetKeyLocationsActorState();
						static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 1370 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 1371 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		RangeResult currentLocations = krmDecodeRanges( keyServersPrefix, KeyRangeRef(beginKey.removePrefix(keyServersPrefix), std::min<KeyRef>(shards[i].first.end, endKey).removePrefix(keyServersPrefix)), RangeResultRef(keyValueResponse.data, keyValueResponse.more));
															#line 1377 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (keyValueResponse.data.size() && beginKey == keyValueResponse.data[0].key)
															#line 8516 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1378 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations[0]);
															#line 8520 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1381 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (currentLocations.size() > 2)
															#line 8524 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1382 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.append_deep(keyLocations.arena(), &currentLocations[1], currentLocations.size() - 2);
															#line 8528 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1386 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(currentLocations.size() > 1);
															#line 1387 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyValueResponse.more)
															#line 8534 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1388 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = shards[i].first.end;
															#line 8538 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = keyValueResponse.data.end()[-1].key;
															#line 8544 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1394 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey >= endKey)
															#line 8548 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1395 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations.end()[-1]);
															#line 8552 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont20(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1399 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 8650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1399 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 8659 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> shards;
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> keyLocationPromise;
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1309 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> keyLocations;
															#line 1310 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key beginKey;
															#line 1311 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key endKey;
															#line 1312 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int i;
															#line 1313 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction onErrorTr;
															#line 1331 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 1397 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Error err;
															#line 8763 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyLocations()
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyLocationsActor final : public Actor<bool>, public ActorCallback< GetKeyLocationsActor, 0, Version >, public ActorCallback< GetKeyLocationsActor, 1, Void >, public ActorCallback< GetKeyLocationsActor, 2, Void >, public FastAllocated<GetKeyLocationsActor>, public GetKeyLocationsActorState<GetKeyLocationsActor> {
															#line 8768 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyLocationsActor>::operator new;
	using FastAllocated<GetKeyLocationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(188487346099058432UL, 3979736672950396416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocationsActor, 0, Version >;
friend struct ActorCallback< GetKeyLocationsActor, 1, Void >;
friend struct ActorCallback< GetKeyLocationsActor, 2, Void >;
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyLocationsActor(Database const& cx,std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards,Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise,bool const& performQuiescentChecks,bool* const& success) 
															#line 8787 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   GetKeyLocationsActorState<GetKeyLocationsActor>(cx, shards, keyLocationPromise, performQuiescentChecks, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1792919416808650752UL, 9988447959741147648UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<bool> getKeyLocations( Database const& cx, std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards, Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise, bool const& performQuiescentChecks, bool* const& success ) {
															#line 1304 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<bool>(new GetKeyLocationsActor(cx, shards, keyLocationPromise, performQuiescentChecks, success));
															#line 8822 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1407 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Retrieves a vector of the storage servers' estimates for the size of a particular shard
// If a storage server can't be reached, its estimate will be -1
// If there is an error, then the returned vector will have 0 size
															#line 8830 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getStorageSizeEstimate()
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetStorageSizeEstimateActor>
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetStorageSizeEstimateActorState {
															#line 8837 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetStorageSizeEstimateActorState(std::vector<StorageServerInterface> const& storageServers,KeyRangeRef const& shard) 
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : storageServers(storageServers),
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shard(shard),
															#line 1414 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   estimatedBytes(),
															#line 1415 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   metrics(),
															#line 1417 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   req()
															#line 8852 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageSizeEstimateActorState() 
	{
		fdb_probe_actor_destroy("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1418 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.keys = shard;
															#line 1419 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.max.bytes = -1;
															#line 1420 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.min.bytes = 0;
															#line 1422 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			metricFutures = std::vector<Future<ErrorOr<StorageMetrics>>>();
															#line 8873 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			try {
															#line 1426 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServers.size();i++) {
															#line 1427 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					resetReply(req);
															#line 1428 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					metricFutures.push_back(storageServers[i].waitMetrics.getReplyUnlessFailedFor(req, 2, 0));
															#line 8881 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
															#line 1432 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(metricFutures);
															#line 1432 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8887 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state = 1;
															#line 1432 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageSizeEstimateActor, 0, Void >*>(static_cast<GetStorageSizeEstimateActor*>(this)));
															#line 8892 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageSizeEstimateActorState();
		static_cast<GetStorageSizeEstimateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1480 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetStorageSizeEstimateActor*>(this)->SAV<std::pair<std::vector<int64_t>, StorageMetrics>>::futures) { (void)(std::make_pair(estimatedBytes, metrics)); this->~GetStorageSizeEstimateActorState(); static_cast<GetStorageSizeEstimateActor*>(this)->destroy(); return 0; }
															#line 8921 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageSizeEstimateActor*>(this)->SAV< std::pair<std::vector<int64_t>, StorageMetrics> >::value()) std::pair<std::vector<int64_t>, StorageMetrics>(std::make_pair(estimatedBytes, metrics));
		this->~GetStorageSizeEstimateActorState();
		static_cast<GetStorageSizeEstimateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1473 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_ErrorFetchingMetrics") .error(e) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end));
															#line 1477 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			estimatedBytes.clear();
															#line 8936 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1437 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServers.size();i++) {
															#line 1438 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<StorageMetrics> reply = metricFutures[i].get();
															#line 1441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present())
															#line 8957 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1442 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedToFetchMetrics") .error(reply.getError()) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end)) .detail("StorageServer", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() ? "True" : "False");
															#line 1448 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				estimatedBytes.push_back(-1);
															#line 8963 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1452 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (reply.present())
															#line 8969 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1453 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					int64_t numBytes = reply.get().bytes;
															#line 1454 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					estimatedBytes.push_back(numBytes);
															#line 1455 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (firstValidStorageServer < 0)
															#line 8977 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1456 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstValidStorageServer = i;
															#line 1457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						metrics = reply.get();
															#line 8983 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1458 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (estimatedBytes[firstValidStorageServer] != numBytes)
															#line 8989 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 1459 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent("ConsistencyCheck_InconsistentStorageMetrics") .detail("ByteEstimate1", estimatedBytes[firstValidStorageServer]) .detail("ByteEstimate2", numBytes) .detail("Begin", shard.begin) .detail("End", shard.end) .detail("StorageServer1", storageServers[firstValidStorageServer].id()) .detail("StorageServer2", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() || storageServers[firstValidStorageServer].isTss() ? "True" : "False");
															#line 8993 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1437 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServers.size();i++) {
															#line 1438 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<StorageMetrics> reply = metricFutures[i].get();
															#line 1441 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present())
															#line 9013 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1442 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedToFetchMetrics") .error(reply.getError()) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end)) .detail("StorageServer", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() ? "True" : "False");
															#line 1448 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				estimatedBytes.push_back(-1);
															#line 9019 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1452 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (reply.present())
															#line 9025 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1453 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					int64_t numBytes = reply.get().bytes;
															#line 1454 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					estimatedBytes.push_back(numBytes);
															#line 1455 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (firstValidStorageServer < 0)
															#line 9033 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1456 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstValidStorageServer = i;
															#line 1457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						metrics = reply.get();
															#line 9039 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1458 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (estimatedBytes[firstValidStorageServer] != numBytes)
															#line 9045 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						{
															#line 1459 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent("ConsistencyCheck_InconsistentStorageMetrics") .detail("ByteEstimate1", estimatedBytes[firstValidStorageServer]) .detail("ByteEstimate2", numBytes) .detail("Begin", shard.begin) .detail("End", shard.end) .detail("StorageServer1", storageServers[firstValidStorageServer].id()) .detail("StorageServer2", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() || storageServers[firstValidStorageServer].isTss() ? "True" : "False");
															#line 9049 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state > 0) static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageSizeEstimateActor*>(this)->ActorCallback< GetStorageSizeEstimateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef shard;
															#line 1414 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int64_t> estimatedBytes;
															#line 1415 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	StorageMetrics metrics;
															#line 1417 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	WaitMetricsRequest req;
															#line 1422 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<StorageMetrics>>> metricFutures;
															#line 9159 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getStorageSizeEstimate()
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetStorageSizeEstimateActor final : public Actor<std::pair<std::vector<int64_t>, StorageMetrics>>, public ActorCallback< GetStorageSizeEstimateActor, 0, Void >, public FastAllocated<GetStorageSizeEstimateActor>, public GetStorageSizeEstimateActorState<GetStorageSizeEstimateActor> {
															#line 9164 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetStorageSizeEstimateActor>::operator new;
	using FastAllocated<GetStorageSizeEstimateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10951719571706040320UL, 10152055966273582592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<int64_t>, StorageMetrics>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageSizeEstimateActor, 0, Void >;
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetStorageSizeEstimateActor(std::vector<StorageServerInterface> const& storageServers,KeyRangeRef const& shard) 
															#line 9181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<std::pair<std::vector<int64_t>, StorageMetrics>>(),
		   GetStorageSizeEstimateActorState<GetStorageSizeEstimateActor>(storageServers, shard),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18403363700833208064UL, 9238915563245270528UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageSizeEstimate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageSizeEstimateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<std::pair<std::vector<int64_t>, StorageMetrics>> getStorageSizeEstimate( std::vector<StorageServerInterface> const& storageServers, KeyRangeRef const& shard ) {
															#line 1411 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<std::pair<std::vector<int64_t>, StorageMetrics>>(new GetStorageSizeEstimateActor(storageServers, shard));
															#line 9214 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1482 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 9219 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getDatabaseSize()
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetDatabaseSizeActor>
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetDatabaseSizeActorState {
															#line 9226 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetDatabaseSizeActorState(Database const& cx) 
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx)
															#line 9233 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDatabaseSizeActorState() 
	{
		fdb_probe_actor_destroy("getDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1485 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1487 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = Transaction(cx);
															#line 1488 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1489 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 9254 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1491 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<StorageMetrics> __when_expr_0 = tr.getDatabase()->getStorageMetrics(KeyRangeRef(allKeys.begin, keyServersPrefix), 100000);
															#line 1491 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9287 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 1;
															#line 1491 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*>(static_cast<GetDatabaseSizeActor*>(this)));
															#line 9292 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9316 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 2;
															#line 1495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDatabaseSizeActor, 1, Void >*>(static_cast<GetDatabaseSizeActor*>(this)));
															#line 9321 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics const& metrics,int loopDepth) 
	{
															#line 1493 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetDatabaseSizeActor*>(this)->SAV<int64_t>::futures) { (void)(metrics.bytes); this->~GetDatabaseSizeActorState(); static_cast<GetDatabaseSizeActor*>(this)->destroy(); return 0; }
															#line 9336 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetDatabaseSizeActor*>(this)->SAV< int64_t >::value()) int64_t(metrics.bytes);
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics && metrics,int loopDepth) 
	{
															#line 1493 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetDatabaseSizeActor*>(this)->SAV<int64_t>::futures) { (void)(metrics.bytes); this->~GetDatabaseSizeActorState(); static_cast<GetDatabaseSizeActor*>(this)->destroy(); return 0; }
															#line 9348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<GetDatabaseSizeActor*>(this)->SAV< int64_t >::value()) int64_t(metrics.bytes);
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics const& metrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics && metrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatabaseSizeActor*>(this)->ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,StorageMetrics const& value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,StorageMetrics && value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,Error err) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatabaseSizeActor*>(this)->ActorCallback< GetDatabaseSizeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1487 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 9522 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getDatabaseSize()
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetDatabaseSizeActor final : public Actor<int64_t>, public ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >, public ActorCallback< GetDatabaseSizeActor, 1, Void >, public FastAllocated<GetDatabaseSizeActor>, public GetDatabaseSizeActorState<GetDatabaseSizeActor> {
															#line 9527 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetDatabaseSizeActor>::operator new;
	using FastAllocated<GetDatabaseSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9690281590958212864UL, 10317916121884151296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >;
friend struct ActorCallback< GetDatabaseSizeActor, 1, Void >;
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetDatabaseSizeActor(Database const& cx) 
															#line 9545 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<int64_t>(),
		   GetDatabaseSizeActorState<GetDatabaseSizeActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11762275571184728832UL, 3589382968507849216UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDatabaseSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDatabaseSizeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<int64_t> getDatabaseSize( Database const& cx ) {
															#line 1483 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<int64_t>(new GetDatabaseSizeActor(cx));
															#line 9579 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 1499 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Checks that the data in each shard is the same on each storage server that it resides on.  Also performs some
// sanity checks on the sizes of shards and storage servers. Returns false if there is a failure
// TODO: Future optimization: Use streaming reads
															#line 9587 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkDataConsistency()
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class CheckDataConsistencyActor>
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class CheckDataConsistencyActorState {
															#line 9594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	CheckDataConsistencyActorState(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,bool const& performQuiescentChecks,bool const& performTSSCheck,bool const& firstClient,bool const& failureIsError,int const& clientId,int const& clientCount,bool const& distributed,bool const& shuffleShards,int const& shardSampleFactor,int64_t const& sharedRandomNumber,int64_t const& repetitions,int64_t* const& bytesReadInPrevRound,int const& restart,int64_t const& maxRate,int64_t const& targetInterval,bool* const& success) 
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocations(keyLocations),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   configuration(configuration),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   tssMapping(tssMapping),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performTSSCheck(performTSSCheck),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   firstClient(firstClient),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   failureIsError(failureIsError),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   clientId(clientId),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   clientCount(clientCount),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   distributed(distributed),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shuffleShards(shuffleShards),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shardSampleFactor(shardSampleFactor),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   sharedRandomNumber(sharedRandomNumber),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   repetitions(repetitions),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   bytesReadInPrevRound(bytesReadInPrevRound),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   restart(restart),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   maxRate(maxRate),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   targetInterval(targetInterval),
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1525 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   storageServerSizes(),
															#line 1531 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   effectiveClientCount(distributed ? clientCount : 1),
															#line 1532 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   i(clientId * (shardSampleFactor + 1)),
															#line 1533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   rateLimitForThisRound(*bytesReadInPrevRound == 0 ? maxRate : std::min(maxRate, static_cast<int64_t>(ceil(*bytesReadInPrevRound / (float)targetInterval))))
															#line 9647 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkDataConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkDataConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1537 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimitForThisRound") .detail("RateLimit", rateLimitForThisRound) .detail("BytesReadInPrevRound", *bytesReadInPrevRound) .detail("TargetInterval", targetInterval) .detail("MaxRate", maxRate);
															#line 1542 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= maxRate);
															#line 1543 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1544 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1545 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			bytesReadInthisRound = 0;
															#line 1546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterCumulatedWaitTime = 0;
															#line 1547 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = false;
															#line 1549 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			dbSize = 100e12;
															#line 1550 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ssCount = 1e6;
															#line 1551 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated())
															#line 9680 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<int64_t> __when_expr_0 = getDatabaseSize(cx);
															#line 1553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9686 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 1;
															#line 1553 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 0, int64_t >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9691 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataConsistencyActorState();
		static_cast<CheckDataConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1564 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ranges = std::vector<KeyRangeRef>();
															#line 1566 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 1567 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 1568 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ranges.push_back(range);
															#line 9725 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1571 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardOrder = std::vector<int>();
															#line 1572 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardOrder.reserve(ranges.size());
															#line 1573 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int k = 0;k < ranges.size();k++) {
															#line 1574 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardOrder.push_back(k);
															#line 9735 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1575 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (shuffleShards)
															#line 9739 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1576 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			DeterministicRandom sharedRandom(sharedRandomNumber + repetitions);
															#line 1577 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sharedRandom.randomShuffle(shardOrder);
															#line 9745 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Reference<DDConfiguration::RangeConfigMapSnapshot>> __when_expr_2 = DDConfiguration().userRangeConfig().getSnapshot( SystemDBWriteLockedNow(cx.getReference()), allKeys.begin, allKeys.end);
															#line 1580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9751 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 3;
															#line 1580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9756 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t const& _dbSize,int loopDepth) 
	{
															#line 1554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dbSize = _dbSize;
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9769 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9774 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && _dbSize,int loopDepth) 
	{
															#line 1554 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dbSize = _dbSize;
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9787 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1555 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9792 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& _dbSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(_dbSize, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && _dbSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_dbSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(std::vector<StorageServerInterface> const& storageServers,int loopDepth) 
	{
															#line 1556 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ssCount = 0;
															#line 1557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : storageServers ) {
															#line 1558 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!it.isTss())
															#line 9880 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1559 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				++ssCount;
															#line 9884 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::vector<StorageServerInterface> && storageServers,int loopDepth) 
	{
															#line 1556 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ssCount = 0;
															#line 1557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : storageServers ) {
															#line 1558 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!it.isTss())
															#line 9899 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1559 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				++ssCount;
															#line 9903 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<StorageServerInterface> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<StorageServerInterface> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1583 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		customReplicatedShards = 0;
															#line 1584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		underReplicatedShards = 0;
															#line 1585 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedShard = 0;
															#line 1586 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedReadShard = 0;
															#line 1588 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 9997 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> const& __userRangeConfig,int loopDepth) 
	{
															#line 1580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		userRangeConfig = __userRangeConfig;
															#line 10006 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> && __userRangeConfig,int loopDepth) 
	{
		userRangeConfig = std::move(__userRangeConfig);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 2091 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards > SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS)
															#line 10085 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2092 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheck_TooManyShardsOnLargeTeams") .detail("ShardsOnLargeTeams", customReplicatedShards) .detail("Limit", SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS);
															#line 2095 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Too many shards on large teams", performQuiescentChecks, success, failureIsError);
															#line 2096 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10093 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2099 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards < SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS && underReplicatedShards > 0)
															#line 10101 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2100 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheck_TooFewShardsOnLargeTeams") .detail("ShardsOnLargeTeams", customReplicatedShards) .detail("Limit", SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS) .detail("UnderReplicated", underReplicatedShards);
															#line 2104 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Too few shards on large teams", performQuiescentChecks, success, failureIsError);
															#line 2105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2108 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards == SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS && underReplicatedShards > 0)
															#line 10117 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2109 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Reached max shard on large team limit");
															#line 10121 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 2112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		*bytesReadInPrevRound = bytesReadInthisRound;
															#line 2113 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10127 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataConsistencyActorState();
		static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 1588 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(i < ranges.size()))
															#line 10146 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1589 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shard = shardOrder[i];
															#line 1591 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		range = ranges[shard];
															#line 1592 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		sourceStorageServers = std::vector<UID>();
															#line 1593 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		destStorageServers = std::vector<UID>();
															#line 1594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr = Transaction(cx);
															#line 1595 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1596 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInRange = 0;
															#line 1598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10168 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 4;
															#line 1598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10173 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
															#line 1599 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1600 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyLocations[shard].value, sourceStorageServers, destStorageServers, false);
															#line 1603 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		isRelocating = destStorageServers.size() > 0;
															#line 1605 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardCheckStartTime = now();
															#line 1606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard = 0;
															#line 1607 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard = 0;
															#line 1609 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int desiredReplicas = configuration.storageTeamSize;
															#line 1610 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddLargeTeamEnabled())
															#line 10209 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1613 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto it : userRangeConfig->intersectingRanges(range.begin, range.end) ) {
															#line 1614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				KeyRangeRef configuredRange(it->range().begin, it->range().end);
															#line 1616 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "Checked custom replication configuration.");
															#line 1617 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CheckCustomReplica") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end) .detail("CustomConfig", it->value()) .detail("UsableRegions", configuration.usableRegions) .detail("First", firstClient) .detail("Perform", performQuiescentChecks);
															#line 1632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!configuredRange.contains(range))
															#line 10221 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1633 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheck_BoundaryMissing") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end);
															#line 1638 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("Custom shard boundary violated", performQuiescentChecks, success, failureIsError);
															#line 1639 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10229 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1642 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				desiredReplicas = std::max(desiredReplicas, it->value().replicationFactor.orDefault(0));
															#line 10237 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 1646 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int expectedReplicas = std::min(desiredReplicas, ssCount);
															#line 1648 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && configuration.usableRegions == 1 && expectedReplicas > configuration.storageTeamSize)
															#line 10244 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() < expectedReplicas)
															#line 10248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1651 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				underReplicatedShards++;
															#line 1652 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_UnderReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10254 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1662 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() > configuration.storageTeamSize)
															#line 10258 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1663 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				customReplicatedShards++;
															#line 1664 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CustomReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10264 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 1678 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && ((configuration.usableRegions == 1 && (sourceStorageServers.size() > expectedReplicas || sourceStorageServers.size() < configuration.storageTeamSize)) || sourceStorageServers.size() < configuration.usableRegions * configuration.storageTeamSize || sourceStorageServers.size() > configuration.usableRegions * expectedReplicas))
															#line 10269 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1683 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidTeamSize") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 1693 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int k = 0;
															#line 1694 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& id : sourceStorageServers ) {
															#line 1695 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("IncorrectSizeTeamInfo").detail("ServerUID", id).detail("TeamIndex", k++);
															#line 10279 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1697 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Invalid team size", performQuiescentChecks, success, failureIsError);
															#line 1698 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10285 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 1702 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1704 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 10297 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult && UIDtoTagMap,int loopDepth) 
	{
															#line 1599 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1600 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyLocations[shard].value, sourceStorageServers, destStorageServers, false);
															#line 1603 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		isRelocating = destStorageServers.size() > 0;
															#line 1605 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardCheckStartTime = now();
															#line 1606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard = 0;
															#line 1607 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard = 0;
															#line 1609 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int desiredReplicas = configuration.storageTeamSize;
															#line 1610 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddLargeTeamEnabled())
															#line 10320 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1613 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto it : userRangeConfig->intersectingRanges(range.begin, range.end) ) {
															#line 1614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				KeyRangeRef configuredRange(it->range().begin, it->range().end);
															#line 1616 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "Checked custom replication configuration.");
															#line 1617 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CheckCustomReplica") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end) .detail("CustomConfig", it->value()) .detail("UsableRegions", configuration.usableRegions) .detail("First", firstClient) .detail("Perform", performQuiescentChecks);
															#line 1632 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!configuredRange.contains(range))
															#line 10332 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1633 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheck_BoundaryMissing") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end);
															#line 1638 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("Custom shard boundary violated", performQuiescentChecks, success, failureIsError);
															#line 1639 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10340 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1642 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				desiredReplicas = std::max(desiredReplicas, it->value().replicationFactor.orDefault(0));
															#line 10348 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 1646 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int expectedReplicas = std::min(desiredReplicas, ssCount);
															#line 1648 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && configuration.usableRegions == 1 && expectedReplicas > configuration.storageTeamSize)
															#line 10355 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() < expectedReplicas)
															#line 10359 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1651 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				underReplicatedShards++;
															#line 1652 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_UnderReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10365 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1662 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() > configuration.storageTeamSize)
															#line 10369 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1663 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				customReplicatedShards++;
															#line 1664 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CustomReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10375 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 1678 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && ((configuration.usableRegions == 1 && (sourceStorageServers.size() > expectedReplicas || sourceStorageServers.size() < configuration.storageTeamSize)) || sourceStorageServers.size() < configuration.usableRegions * configuration.storageTeamSize || sourceStorageServers.size() > configuration.usableRegions * expectedReplicas))
															#line 10380 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1683 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidTeamSize") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 1693 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int k = 0;
															#line 1694 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& id : sourceStorageServers ) {
															#line 1695 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("IncorrectSizeTeamInfo").detail("ServerUID", id).detail("TeamIndex", k++);
															#line 10390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1697 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Invalid team size", performQuiescentChecks, success, failureIsError);
															#line 1698 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10396 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 1702 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1704 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 10408 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(UIDtoTagMap, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult && UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(UIDtoTagMap), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7loopBody1cont3(int loopDepth) 
	{
															#line 1728 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!isRelocating && performTSSCheck)
															#line 10492 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1729 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int initialSize = storageServers.size();
															#line 1730 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < initialSize;i++) {
															#line 1731 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				auto tssPair = tssMapping.find(storageServers[i]);
															#line 1732 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (tssPair != tssMapping.end())
															#line 10502 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1733 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "TSS checked in consistency check");
															#line 1734 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					storageServers.push_back(tssPair->second.id());
															#line 1735 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					storageServerInterfaces.push_back(tssPair->second);
															#line 10510 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1740 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::pair<std::vector<int64_t>, StorageMetrics>> __when_expr_6 = getStorageSizeEstimate(storageServerInterfaces, range);
															#line 1740 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10518 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 7;
															#line 1740 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10523 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1706 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1707 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			serverListEntries.reserve(storageServers.size());
															#line 1708 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int s = 0;s < storageServers.size();s++) {
															#line 1709 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				serverListEntries.push_back(tr.get(serverListKeyFor(storageServers[s])));
															#line 10546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
															#line 1710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_4 = getAll(serverListEntries);
															#line 1710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10552 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont7loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7loopBody1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 5;
															#line 1710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10557 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont7loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1723 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 1723 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 6;
															#line 1723 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 5, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10599 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 1711 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1712 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (serverListValues[s].present())
															#line 10616 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1713 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerInterfaces.push_back(decodeServerListValue(serverListValues[s].get()));
															#line 10620 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1714 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks)
															#line 10626 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1715 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("/FF/serverList changing in a quiescent database", performQuiescentChecks, success, failureIsError);
															#line 10630 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				}
			}
		}
		return a_body1cont7loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListValues = __serverListValues;
															#line 10642 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7loopBody1cont12(std::pair<std::vector<int64_t>, StorageMetrics> const& estimatedBytesAndMetrics,int loopDepth) 
	{
															#line 1742 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimatedBytes = estimatedBytesAndMetrics.first;
															#line 1743 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimated = estimatedBytesAndMetrics.second;
															#line 1746 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int64_t maxShardSize = getMaxShardSize(dbSize);
															#line 1747 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBounds = getShardSizeBounds(range, maxShardSize);
															#line 1749 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient)
															#line 10816 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1751 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && estimatedBytes.size() == 0)
															#line 10820 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1752 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Error fetching storage metrics", performQuiescentChecks, success, failureIsError);
															#line 10824 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1755 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (distributed && firstClient)
															#line 10830 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1756 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					for(int j = 0;j < storageServers.size();j++) {
															#line 1757 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						storageServerSizes[storageServers[j]] += std::max(estimatedBytes[j], (int64_t)0);
															#line 10836 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1762 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!firstClient || shard % (effectiveClientCount * shardSampleFactor) == 0)
															#line 10843 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1763 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys = 0;
															#line 1764 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBytes = 0;
															#line 1765 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledBytes = 0;
															#line 1766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitBytes = 0;
															#line 1767 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			firstKeySampledBytes = 0;
															#line 1768 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeys = 0;
															#line 1769 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeysWithProb = 0;
															#line 1770 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardVariance = 0;
															#line 1771 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 1772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = Key();
															#line 1773 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = Key();
															#line 1774 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			totalReadAmount = 0;
															#line 1775 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = range;
															#line 1776 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			onErrorTr = Transaction(cx);
															#line 1779 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 10875 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7loopBody1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12(std::pair<std::vector<int64_t>, StorageMetrics> && estimatedBytesAndMetrics,int loopDepth) 
	{
															#line 1742 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimatedBytes = estimatedBytesAndMetrics.first;
															#line 1743 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimated = estimatedBytesAndMetrics.second;
															#line 1746 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int64_t maxShardSize = getMaxShardSize(dbSize);
															#line 1747 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBounds = getShardSizeBounds(range, maxShardSize);
															#line 1749 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient)
															#line 10897 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1751 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && estimatedBytes.size() == 0)
															#line 10901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1752 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Error fetching storage metrics", performQuiescentChecks, success, failureIsError);
															#line 10905 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1755 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (distributed && firstClient)
															#line 10911 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1756 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					for(int j = 0;j < storageServers.size();j++) {
															#line 1757 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						storageServerSizes[storageServers[j]] += std::max(estimatedBytes[j], (int64_t)0);
															#line 10917 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1762 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!firstClient || shard % (effectiveClientCount * shardSampleFactor) == 0)
															#line 10924 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1763 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys = 0;
															#line 1764 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBytes = 0;
															#line 1765 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledBytes = 0;
															#line 1766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitBytes = 0;
															#line 1767 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			firstKeySampledBytes = 0;
															#line 1768 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeys = 0;
															#line 1769 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeysWithProb = 0;
															#line 1770 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardVariance = 0;
															#line 1771 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 1772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = Key();
															#line 1773 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = Key();
															#line 1774 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			totalReadAmount = 0;
															#line 1775 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = range;
															#line 1776 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			onErrorTr = Transaction(cx);
															#line 1779 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 10956 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7loopBody1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3when1(std::pair<std::vector<int64_t>, StorageMetrics> const& estimatedBytesAndMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12(estimatedBytesAndMetrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3when1(std::pair<std::vector<int64_t>, StorageMetrics> && estimatedBytesAndMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12(std::move(estimatedBytesAndMetrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,std::pair<std::vector<int64_t>, StorageMetrics> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,std::pair<std::vector<int64_t>, StorageMetrics> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7loopBody1cont12cont1(int loopDepth) 
	{
															#line 2060 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (bytesReadInRange > 0)
															#line 11045 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2061 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			numCheckedReadShard++;
															#line 2062 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_ReadRange") .suppressFor(1.0) .detail("Range", range) .detail("BytesRead", bytesReadInRange);
															#line 11051 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 2067 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedShard++;
															#line 2069 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_ShardComplete") .suppressFor(1.0) .detail("Index", i) .detail("BytesReadInthisRound", bytesReadInthisRound) .detail("NumCheckedReadShard", numCheckedReadShard) .detail("NumCheckedShard", numCheckedShard) .detail("Range", range) .detail("BytesRead", bytesReadInRange) .detail("ShardCheckTime", now() - shardCheckStartTime) .detail("DataConsistencyCheckTime", dataConsistencyCheckTimeForThisShard) .detail("RateLimitTime", rateLimiterWaitTimeForThisShard) .detail("CumulatedRateLimitTime", rateLimiterCumulatedWaitTime) .detail("DecideToRunAtMaxRate", decideToRunAtMaxRate) .detail("ClientId", clientId) .detail("ClientCount", clientCount) .detail("FirstClient", firstClient) .detail("Distributed", distributed) .detail("PerformTSSCheck", performTSSCheck) .detail("ShardSampleFactor", shardSampleFactor) .detail("EffectiveClientCount", effectiveClientCount);
															#line 1588 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		i++;
															#line 11059 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7(int loopDepth) 
	{
															#line 1946 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		canSplit = canSplit && sampledBytes - splitBytes >= shardBounds.min.bytes && sampledBytes > splitBytes;
															#line 1951 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!distributed)
															#line 11070 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1952 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < storageServers.size();j++) {
															#line 1953 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerSizes[storageServers[j]] += shardBytes;
															#line 11076 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			}
		}
															#line 1956 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (performQuiescentChecks)
															#line 11081 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1957 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < estimatedBytes.size();j++) {
															#line 1958 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (estimatedBytes[j] >= 0 && estimatedBytes[j] != sampledBytes)
															#line 11087 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1959 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyCheck_IncorrectEstimate") .detail("EstimatedBytes", estimatedBytes[j]) .detail("CorrectSampledBytes", sampledBytes) .detail("StorageServer", storageServers[j]) .detail("Range", range) .detail("IsTSS", storageServerInterfaces[j].isTss() ? "True" : "False");
															#line 1966 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!storageServerInterfaces[j].isTss())
															#line 11093 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1967 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Storage servers had incorrect sampled estimate", performQuiescentChecks, success, failureIsError);
															#line 11097 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
					break;
				}
				else
				{
															#line 1974 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (estimatedBytes[j] < 0 && ((g_network->isSimulated() && g_simulator->tssMode <= ISimulator::TSSMode::EnabledNormal) || !storageServerInterfaces[j].isTss()))
															#line 11105 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
						break;
					}
				}
			}
		}
															#line 1985 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double stdDev = sqrt(shardVariance);
															#line 1987 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double failErrorNumStdDev = 7;
															#line 1988 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int estimateError = abs(shardBytes - sampledBytes);
															#line 1992 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (sampledKeysWithProb > 30 && estimateError > failErrorNumStdDev * stdDev)
															#line 11120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1993 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double numStdDev = estimateError / sqrt(shardVariance);
															#line 1994 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InaccurateShardEstimate") .detail("Min", shardBounds.min.bytes) .detail("Max", shardBounds.max.bytes) .detail("Estimate", sampledBytes) .detail("Actual", shardBytes) .detail("NumStdDev", numStdDev) .detail("Variance", shardVariance) .detail("StdDev", stdDev) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("NumKeys", shardKeys) .detail("NumSampledKeys", sampledKeys) .detail("NumSampledKeysWithProb", sampledKeysWithProb);
															#line 2008 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure(format("Shard size is more than %f std dev from estimate", failErrorNumStdDev), performQuiescentChecks, success, failureIsError);
															#line 11128 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 2014 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_CheckSplits").detail("Range", range).detail("CanSplit", canSplit);
															#line 2018 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (canSplit && sampledKeys > 5 && performQuiescentChecks)
															#line 11134 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2019 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StorageMetrics splitMetrics;
															#line 2020 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytes = shardBounds.max.bytes / 2;
															#line 2021 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytesWrittenPerKSecond = range.begin >= keyServersKeys.begin ? splitMetrics.infinity : SERVER_KNOBS->SHARD_SPLIT_BYTES_PER_KSEC;
															#line 2024 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.iosPerKSecond = splitMetrics.infinity;
															#line 2025 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytesReadPerKSecond = splitMetrics.infinity;
															#line 2027 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_12 = cx->splitStorageMetrics(range, splitMetrics, estimated);
															#line 2027 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11150 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont12cont7when1(__when_expr_12.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 13;
															#line 2027 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11155 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1(int loopDepth) 
	{
		try {
															#line 1781 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = lastStartSampleKey;
															#line 1784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_7 = getVersion(cx);
															#line 1784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11181 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 8;
															#line 1784 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 7, Version >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11186 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont7loopBody1cont12cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopBody1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			err = e;
															#line 1936 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_wrong_shard_server)
															#line 11223 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_10 = delay(1.0);
															#line 1938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11229 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont12loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 11;
															#line 1938 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 10, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11234 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1940 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_11 = onErrorTr.onError(err);
															#line 1940 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11243 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont12loopBody1Catch1when2(__when_expr_11.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 12;
															#line 1940 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 11, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11248 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 1786 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1787 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 1788 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckBeginTime = now();
															#line 1790 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadAmount = 0;
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(UID(), cx, readRange, version, &storageServerInterfaces, &keyValueFutures, &firstValidServer, &totalReadAmount, {});
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11274 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 9;
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 8, int >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11279 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 1786 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1787 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 1788 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckBeginTime = now();
															#line 1790 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadAmount = 0;
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(UID(), cx, readRange, version, &storageServerInterfaces, &keyValueFutures, &firstValidServer, &totalReadAmount, {});
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11298 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 9;
															#line 1791 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 8, int >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11303 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 7, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont7loopBody1cont12loopBody1cont3(int const& failures,int loopDepth) 
	{
															#line 1800 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (failures > 0)
															#line 11387 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1801 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Data inconsistent", performQuiescentChecks, success, true);
															#line 11391 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1803 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard += (now() - dataConsistencyCheckBeginTime);
															#line 1806 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 1807 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 1808 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!isRelocating && (!rangeResult.present() || rangeResult.get().error.present()))
															#line 11401 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1809 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Error e = rangeResult.isError() ? rangeResult.getError() : rangeResult.get().error.get();
															#line 1811 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageServerUnavailable") .errorUnsuppressed(e) .suppressFor(1.0) .detail("StorageServer", storageServers[i]) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ReadBegin", printable(readRange.begin)) .detail("ReadEnd", printable(readRange.end)) .detail("Address", storageServerInterfaces[i].address()) .detail("UID", storageServerInterfaces[i].id()) .detail("Quiesced", performQuiescentChecks) .detail("GetKeyValuesToken", storageServerInterfaces[i].getKeyValues.getEndpoint().token) .detail("IsTSS", storageServerInterfaces[i].isTss() ? "True" : "False");
															#line 1826 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (e.code() == error_code_request_maybe_delivered)
															#line 11409 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1828 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*success = false;
															#line 1829 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11415 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1832 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks && !storageServerInterfaces[i].isTss())
															#line 11423 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1833 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure( "Storage server unavailable", performQuiescentChecks, success, failureIsError);
															#line 1835 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11429 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1840 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present())
															#line 11439 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			data = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1845 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int k = 0;k < data.size();k++) {
															#line 1846 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ByteSampleInfo sampleInfo = isKeyValueInSample(data[k]);
															#line 1847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardBytes += sampleInfo.size;
															#line 1850 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_GE(sampleInfo.probability, 0);
															#line 1851 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_LE(sampleInfo.probability, 1);
															#line 1855 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardVariance += sampleInfo.probability * (1 - sampleInfo.probability) * pow((double)sampleInfo.sampledSize, 2);
															#line 1858 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (sampleInfo.inSample)
															#line 11457 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1859 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledBytes += sampleInfo.sampledSize;
															#line 1860 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!canSplit && sampledBytes >= shardBounds.min.bytes && data[k].key.size() <= CLIENT_KNOBS->SPLIT_KEY_SIZE_LIMIT && sampledBytes <= shardBounds.max.bytes * CLIENT_KNOBS->STORAGE_METRICS_UNFAIR_SPLIT_LIMIT / 2)
															#line 11463 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1864 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						canSplit = true;
															#line 1865 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						splitBytes = sampledBytes;
															#line 11469 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 1876 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (k == 0)
															#line 11473 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1877 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstKeySampledBytes += sampleInfo.sampledSize;
															#line 11477 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 1879 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledKeys++;
															#line 1885 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ASSERT_GT(sampleInfo.probability, 0);
															#line 1886 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (sampleInfo.probability < 1)
															#line 11485 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1887 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						sampledKeysWithProb++;
															#line 11489 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1893 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys += data.size();
															#line 11495 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1896 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 11499 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1897 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimit") .detail("RateLimitForThisRound", rateLimitForThisRound) .detail("TotalAmountRead", totalReadAmount);
															#line 1900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterBeforeWaitTime = now();
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_9 = rateLimiter->getAllowance(totalReadAmount);
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11509 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 10;
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 9, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11514 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3(int && failures,int loopDepth) 
	{
															#line 1800 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (failures > 0)
															#line 11528 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1801 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Data inconsistent", performQuiescentChecks, success, true);
															#line 11532 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1803 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard += (now() - dataConsistencyCheckBeginTime);
															#line 1806 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 1807 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 1808 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!isRelocating && (!rangeResult.present() || rangeResult.get().error.present()))
															#line 11542 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
															#line 1809 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Error e = rangeResult.isError() ? rangeResult.getError() : rangeResult.get().error.get();
															#line 1811 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageServerUnavailable") .errorUnsuppressed(e) .suppressFor(1.0) .detail("StorageServer", storageServers[i]) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ReadBegin", printable(readRange.begin)) .detail("ReadEnd", printable(readRange.end)) .detail("Address", storageServerInterfaces[i].address()) .detail("UID", storageServerInterfaces[i].id()) .detail("Quiesced", performQuiescentChecks) .detail("GetKeyValuesToken", storageServerInterfaces[i].getKeyValues.getEndpoint().token) .detail("IsTSS", storageServerInterfaces[i].isTss() ? "True" : "False");
															#line 1826 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (e.code() == error_code_request_maybe_delivered)
															#line 11550 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1828 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*success = false;
															#line 1829 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11556 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1832 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks && !storageServerInterfaces[i].isTss())
															#line 11564 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1833 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure( "Storage server unavailable", performQuiescentChecks, success, failureIsError);
															#line 1835 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11570 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1840 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present())
															#line 11580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			data = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1845 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int k = 0;k < data.size();k++) {
															#line 1846 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ByteSampleInfo sampleInfo = isKeyValueInSample(data[k]);
															#line 1847 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardBytes += sampleInfo.size;
															#line 1850 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_GE(sampleInfo.probability, 0);
															#line 1851 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_LE(sampleInfo.probability, 1);
															#line 1855 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardVariance += sampleInfo.probability * (1 - sampleInfo.probability) * pow((double)sampleInfo.sampledSize, 2);
															#line 1858 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (sampleInfo.inSample)
															#line 11598 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
				{
															#line 1859 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledBytes += sampleInfo.sampledSize;
															#line 1860 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!canSplit && sampledBytes >= shardBounds.min.bytes && data[k].key.size() <= CLIENT_KNOBS->SPLIT_KEY_SIZE_LIMIT && sampledBytes <= shardBounds.max.bytes * CLIENT_KNOBS->STORAGE_METRICS_UNFAIR_SPLIT_LIMIT / 2)
															#line 11604 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1864 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						canSplit = true;
															#line 1865 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						splitBytes = sampledBytes;
															#line 11610 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 1876 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (k == 0)
															#line 11614 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1877 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstKeySampledBytes += sampleInfo.sampledSize;
															#line 11618 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
															#line 1879 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledKeys++;
															#line 1885 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ASSERT_GT(sampleInfo.probability, 0);
															#line 1886 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (sampleInfo.probability < 1)
															#line 11626 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					{
															#line 1887 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						sampledKeysWithProb++;
															#line 11630 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1893 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys += data.size();
															#line 11636 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
															#line 1896 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 11640 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1897 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimit") .detail("RateLimitForThisRound", rateLimitForThisRound) .detail("TotalAmountRead", totalReadAmount);
															#line 1900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterBeforeWaitTime = now();
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_9 = rateLimiter->getAllowance(totalReadAmount);
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11650 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 10;
															#line 1901 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 9, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11655 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2when1(int const& failures,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont3(failures, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2when1(int && failures,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont3(std::move(failures), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont7loopBody1cont12loopBody1cont4(int loopDepth) 
	{
															#line 1916 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInRange += totalReadAmount;
															#line 1917 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInthisRound += totalReadAmount;
															#line 1918 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_BytesRead") .detail("BytesReadInRange", bytesReadInRange) .detail("BytesReadInthisRound", bytesReadInthisRound);
															#line 1923 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present() && keyValueFutures[firstValidServer.get()].get().get().more)
															#line 11750 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1924 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1925 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(result.size() > 0);
															#line 1926 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(result[result.size() - 1].key != allKeys.end);
															#line 1927 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = KeyRangeRef(keyAfter(result[result.size() - 1].key), range.end);
															#line 1928 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = lastSampleKey;
															#line 1929 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (readRange.empty())
															#line 11764 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			{
				return a_body1cont7loopBody1cont12break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		else
		{
			return a_body1cont7loopBody1cont12break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont16(Void const& _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double rateLimiterCurrentWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 1903 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard += rateLimiterCurrentWaitTime;
															#line 1904 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterCumulatedWaitTime += rateLimiterCurrentWaitTime;
															#line 1905 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_AmountRead").detail("TotalAmountRead", totalReadAmount);
															#line 1907 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * targetInterval && rateLimitForThisRound != maxRate)
															#line 11789 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1908 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimitForThisRound = maxRate;
															#line 1909 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1910 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1911 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 1913 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = true;
															#line 11801 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont16(Void && _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double rateLimiterCurrentWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 1903 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard += rateLimiterCurrentWaitTime;
															#line 1904 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterCumulatedWaitTime += rateLimiterCurrentWaitTime;
															#line 1905 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_AmountRead").detail("TotalAmountRead", totalReadAmount);
															#line 1907 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * targetInterval && rateLimitForThisRound != maxRate)
															#line 11819 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 1908 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimitForThisRound = maxRate;
															#line 1909 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1910 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1911 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 1913 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = true;
															#line 11831 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont7loopBody1cont12loopBody1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1942 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryDataConsistency").error(err);
															#line 11929 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont7loopBody1cont12cont8(int loopDepth) 
	{
															#line 2039 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (canSplit && sampledKeys > 5 && performQuiescentChecks && !range.begin.startsWith(keyServersPrefix) && (sampledBytes < shardBounds.min.bytes - 3 * shardBounds.permittedError.bytes || sampledBytes - firstKeySampledBytes > shardBounds.max.bytes + 3 * shardBounds.permittedError.bytes))
															#line 12112 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2042 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidShardSize") .detail("Min", shardBounds.min.bytes) .detail("Max", shardBounds.max.bytes) .detail("Size", shardBytes) .detail("EstimatedSize", sampledBytes) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ShardCount", ranges.size()) .detail("SampledKeys", sampledKeys);
															#line 2051 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure(format("Shard size in quiescent database is too %s", (sampledBytes < shardBounds.min.bytes) ? "small" : "large"), performQuiescentChecks, success, failureIsError);
															#line 2056 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 12120 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont18(Standalone<VectorRef<KeyRef>> const& splits,int loopDepth) 
	{
															#line 2028 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (splits.size() <= 2)
															#line 12134 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2031 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_DiscardSplits").detail("Range", range);
															#line 2032 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 12140 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont18(Standalone<VectorRef<KeyRef>> && splits,int loopDepth) 
	{
															#line 2028 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (splits.size() <= 2)
															#line 12150 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		{
															#line 2031 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_DiscardSplits").detail("Range", range);
															#line 2032 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 12156 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7when1(Standalone<VectorRef<KeyRef>> const& splits,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12cont18(splits, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7when1(Standalone<VectorRef<KeyRef>> && splits,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12cont18(std::move(splits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont7loopBody1cont12cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont7loopBody1cont12cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	VectorRef<KeyValueRef> keyLocations;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performTSSCheck;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool firstClient;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool failureIsError;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int clientId;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int clientCount;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool distributed;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool shuffleShards;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardSampleFactor;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t sharedRandomNumber;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t repetitions;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t* bytesReadInPrevRound;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int restart;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t maxRate;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t targetInterval;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1525 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::map<UID, int64_t> storageServerSizes;
															#line 1531 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int effectiveClientCount;
															#line 1532 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int i;
															#line 1533 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t rateLimitForThisRound;
															#line 1543 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 1544 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterStartTime;
															#line 1545 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t bytesReadInthisRound;
															#line 1546 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterCumulatedWaitTime;
															#line 1547 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool decideToRunAtMaxRate;
															#line 1549 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dbSize;
															#line 1550 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int ssCount;
															#line 1564 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<KeyRangeRef> ranges;
															#line 1571 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int> shardOrder;
															#line 1580 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<DDConfiguration::RangeConfigMapSnapshot> userRangeConfig;
															#line 1583 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int customReplicatedShards;
															#line 1584 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int underReplicatedShards;
															#line 1585 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t numCheckedShard;
															#line 1586 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t numCheckedReadShard;
															#line 1589 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shard;
															#line 1591 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef range;
															#line 1592 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> sourceStorageServers;
															#line 1593 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> destStorageServers;
															#line 1594 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 1596 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int bytesReadInRange;
															#line 1603 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool isRelocating;
															#line 1605 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double shardCheckStartTime;
															#line 1606 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterWaitTimeForThisShard;
															#line 1607 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dataConsistencyCheckTimeForThisShard;
															#line 1701 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> storageServers;
															#line 1702 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 1710 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1742 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int64_t> estimatedBytes;
															#line 1743 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	StorageMetrics estimated;
															#line 1747 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ShardSizeBounds shardBounds;
															#line 1763 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardKeys;
															#line 1764 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardBytes;
															#line 1765 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledBytes;
															#line 1766 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int splitBytes;
															#line 1767 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int firstKeySampledBytes;
															#line 1768 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledKeys;
															#line 1769 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledKeysWithProb;
															#line 1770 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double shardVariance;
															#line 1771 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool canSplit;
															#line 1772 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key lastSampleKey;
															#line 1773 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key lastStartSampleKey;
															#line 1774 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t totalReadAmount;
															#line 1775 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange readRange;
															#line 1776 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction onErrorTr;
															#line 1786 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 1787 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int> firstValidServer;
															#line 1788 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dataConsistencyCheckBeginTime;
															#line 1841 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 1900 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterBeforeWaitTime;
															#line 1935 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Error err;
															#line 12385 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkDataConsistency()
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class CheckDataConsistencyActor final : public Actor<Void>, public ActorCallback< CheckDataConsistencyActor, 0, int64_t >, public ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >, public ActorCallback< CheckDataConsistencyActor, 3, RangeResult >, public ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >, public ActorCallback< CheckDataConsistencyActor, 5, Void >, public ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >, public ActorCallback< CheckDataConsistencyActor, 7, Version >, public ActorCallback< CheckDataConsistencyActor, 8, int >, public ActorCallback< CheckDataConsistencyActor, 9, Void >, public ActorCallback< CheckDataConsistencyActor, 10, Void >, public ActorCallback< CheckDataConsistencyActor, 11, Void >, public ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >, public FastAllocated<CheckDataConsistencyActor>, public CheckDataConsistencyActorState<CheckDataConsistencyActor> {
															#line 12390 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckDataConsistencyActor>::operator new;
	using FastAllocated<CheckDataConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4622620717675101696UL, 10225813058847883776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataConsistencyActor, 0, int64_t >;
friend struct ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >;
friend struct ActorCallback< CheckDataConsistencyActor, 3, RangeResult >;
friend struct ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >;
friend struct ActorCallback< CheckDataConsistencyActor, 5, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >;
friend struct ActorCallback< CheckDataConsistencyActor, 7, Version >;
friend struct ActorCallback< CheckDataConsistencyActor, 8, int >;
friend struct ActorCallback< CheckDataConsistencyActor, 9, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 10, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 11, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >;
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	CheckDataConsistencyActor(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,bool const& performQuiescentChecks,bool const& performTSSCheck,bool const& firstClient,bool const& failureIsError,int const& clientId,int const& clientCount,bool const& distributed,bool const& shuffleShards,int const& shardSampleFactor,int64_t const& sharedRandomNumber,int64_t const& repetitions,int64_t* const& bytesReadInPrevRound,int const& restart,int64_t const& maxRate,int64_t const& targetInterval,bool* const& success) 
															#line 12419 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckDataConsistencyActorState<CheckDataConsistencyActor>(cx, keyLocations, configuration, tssMapping, performQuiescentChecks, performTSSCheck, firstClient, failureIsError, clientId, clientCount, distributed, shuffleShards, shardSampleFactor, sharedRandomNumber, repetitions, bytesReadInPrevRound, restart, maxRate, targetInterval, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16017061053802719488UL, 16942108968284409088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 7, Version >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> checkDataConsistency( Database const& cx, VectorRef<KeyValueRef> const& keyLocations, DatabaseConfiguration const& configuration, std::map<UID, StorageServerInterface> const& tssMapping, bool const& performQuiescentChecks, bool const& performTSSCheck, bool const& firstClient, bool const& failureIsError, int const& clientId, int const& clientCount, bool const& distributed, bool const& shuffleShards, int const& shardSampleFactor, int64_t const& sharedRandomNumber, int64_t const& repetitions, int64_t* const& bytesReadInPrevRound, int const& restart, int64_t const& maxRate, int64_t const& targetInterval, bool* const& success ) {
															#line 1503 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new CheckDataConsistencyActor(cx, keyLocations, configuration, tssMapping, performQuiescentChecks, performTSSCheck, firstClient, failureIsError, clientId, clientCount, distributed, shuffleShards, shardSampleFactor, sharedRandomNumber, repetitions, bytesReadInPrevRound, restart, maxRate, targetInterval, success));
															#line 12464 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/build_output/fdbserver/ConsistencyScan.actor.g.cpp.py_gen"
}

#line 2115 "/codebuild/output/src3684807024/src/github.com/apple/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
